/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl.admin.commands;

import org.jbpm.services.task.commands.UserGroupCallbackTaskCommand;
import org.jbpm.services.task.exception.PermissionDeniedException;
import org.kie.api.runtime.Context;
import org.kie.api.task.model.Task;
import org.kie.internal.task.api.TaskContext;
import org.kie.internal.task.api.TaskDeadlinesService;
import org.kie.internal.task.api.TaskPersistenceContext;
import org.kie.internal.task.api.model.Deadline;
import org.kie.internal.task.api.model.Deadlines;
import org.kie.internal.task.api.model.InternalTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CancelTaskDeadlineCommand
extends UserGroupCallbackTaskCommand<Void> {
    private static final long serialVersionUID = -1856489382099976731L;
    private static final Logger logger = LoggerFactory.getLogger(CancelTaskDeadlineCommand.class);
    private Long deadlineId;

    public CancelTaskDeadlineCommand(String userId, long taskId, Long deadlineId) {
        this.setUserId(userId);
        this.setTaskId(taskId);
        this.deadlineId = deadlineId;
    }

    public Void execute(Context cntxt) {
        org.jbpm.services.task.commands.TaskContext context = (org.jbpm.services.task.commands.TaskContext)cntxt;
        Task task = context.getTaskQueryService().getTaskInstanceById(this.taskId.longValue());
        if (!this.isBusinessAdmin(this.userId, task.getPeopleAssignments().getBusinessAdministrators(), (TaskContext)context)) {
            throw new PermissionDeniedException("User " + this.userId + " is not business admin of task " + this.taskId);
        }
        logger.debug("About to cancel deadline {} on a task {}", (Object)this.deadlineId, (Object)task);
        Deadlines deadlines = ((InternalTask)task).getDeadlines();
        TaskDeadlinesService.DeadlineType type = TaskDeadlinesService.DeadlineType.START;
        Deadline deadline = deadlines.getStartDeadlines().stream().filter(d -> this.deadlineId.equals(d.getId())).findFirst().orElse(null);
        if (deadline == null) {
            deadline = deadlines.getEndDeadlines().stream().filter(d -> this.deadlineId.equals(d.getId())).findFirst().orElse(null);
            type = TaskDeadlinesService.DeadlineType.END;
        }
        TaskPersistenceContext persistenceContext = context.getPersistenceContext();
        TaskDeadlinesService deadlinesService = context.getTaskDeadlinesService();
        deadlinesService.unschedule(this.taskId.longValue(), deadline, type);
        persistenceContext.removeDeadline(deadline);
        return null;
    }
}

