/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl.admin;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.appformer.maven.support.AFReleaseId;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.kie.services.impl.admin.ProcessInstanceMigrationServiceImpl;
import org.jbpm.kie.services.test.KModuleDeploymentServiceTest;
import org.jbpm.kie.test.util.AbstractKieServicesBaseTest;
import org.jbpm.services.api.admin.MigrationEntry;
import org.jbpm.services.api.admin.MigrationReport;
import org.jbpm.services.api.admin.ProcessInstanceMigrationService;
import org.jbpm.services.api.model.DeploymentUnit;
import org.jbpm.services.api.model.ProcessInstanceDesc;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.query.QueryFilter;
import org.kie.scanner.KieMavenRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessInstanceMigrationServiceImplTest
extends AbstractKieServicesBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(KModuleDeploymentServiceTest.class);
    protected static final String MIGRATION_ARTIFACT_ID = "test-migration";
    protected static final String MIGRATION_GROUP_ID = "org.jbpm.test";
    protected static final String MIGRATION_VERSION_V1 = "1.0.0";
    protected static final String MIGRATION_VERSION_V2 = "2.0.0";
    private List<DeploymentUnit> units = new ArrayList<DeploymentUnit>();
    private KModuleDeploymentUnit deploymentUnitV1;
    private KModuleDeploymentUnit deploymentUnitV2;
    protected ProcessInstanceMigrationService migrationService;
    private static final String ADDTASKAFTERACTIVE_ID_V1 = "process-migration-testv1.AddTaskAfterActive";
    private static final String ADDTASKAFTERACTIVE_ID_V2 = "process-migration-testv2.AddTaskAfterActive";
    private static final String REMOVEACTIVETASK_ID_V1 = "process-migration-testv1.RemoveActiveTask";
    private static final String REMOVEACTIVETASK_ID_V2 = "process-migration-testv2.RemoveActiveTask";
    private static final String RECREATEACTIVETASK_ID_V1 = "process-migration-testv1.RecreateActiveTask";
    private static final String RECREATEACTIVETASK_ID_V2 = "process-migration-testv2.RecreateActiveTask";

    @Before
    public void prepare() {
        this.configureServices();
        logger.debug("Preparing kjar");
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId(MIGRATION_GROUP_ID, MIGRATION_ARTIFACT_ID, MIGRATION_VERSION_V1);
        ArrayList<String> processes = new ArrayList<String>();
        processes.add("migration/v1/AddTaskAfterActive-v1.bpmn2");
        processes.add("migration/v1/RemoveActiveTask-v1.bpmn2");
        processes.add("migration/v1/RecreateActiveTask-v1.bpmn2");
        InternalKieModule kJar1 = this.createKieJar(ks, releaseId, processes);
        File pom = new File("target/migration-v1", "pom.xml");
        pom.getParentFile().mkdir();
        try {
            FileOutputStream fs = new FileOutputStream(pom);
            fs.write(this.getPom(releaseId, new ReleaseId[0]).getBytes());
            fs.close();
        }
        catch (Exception fs) {
            // empty catch block
        }
        KieMavenRepository repository = KieMavenRepository.getKieMavenRepository();
        repository.installArtifact((AFReleaseId)releaseId, kJar1, pom);
        ReleaseId releaseId2 = ks.newReleaseId(MIGRATION_GROUP_ID, MIGRATION_ARTIFACT_ID, MIGRATION_VERSION_V2);
        processes = new ArrayList();
        processes.add("migration/v2/AddTaskAfterActive-v2.bpmn2");
        processes.add("migration/v2/RemoveActiveTask-v2.bpmn2");
        processes.add("migration/v2/RecreateActiveTask-v2.bpmn2");
        InternalKieModule kJar2 = this.createKieJar(ks, releaseId2, processes);
        File pom2 = new File("target/migration-v2", "pom.xml");
        pom2.getParentFile().mkdirs();
        try {
            FileOutputStream fs = new FileOutputStream(pom2);
            fs.write(this.getPom(releaseId2, new ReleaseId[0]).getBytes());
            fs.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        repository = KieMavenRepository.getKieMavenRepository();
        repository.installArtifact((AFReleaseId)releaseId2, kJar2, pom2);
        this.migrationService = new ProcessInstanceMigrationServiceImpl();
        this.deploymentUnitV1 = new KModuleDeploymentUnit(MIGRATION_GROUP_ID, MIGRATION_ARTIFACT_ID, MIGRATION_VERSION_V1);
        this.deploymentService.deploy((DeploymentUnit)this.deploymentUnitV1);
        this.units.add((DeploymentUnit)this.deploymentUnitV1);
        this.deploymentUnitV2 = new KModuleDeploymentUnit(MIGRATION_GROUP_ID, MIGRATION_ARTIFACT_ID, MIGRATION_VERSION_V2);
        this.deploymentService.deploy((DeploymentUnit)this.deploymentUnitV2);
        this.units.add((DeploymentUnit)this.deploymentUnitV2);
    }

    @After
    public void cleanup() {
        ProcessInstanceMigrationServiceImplTest.cleanupSingletonSessionId();
        if (this.units != null && !this.units.isEmpty()) {
            for (DeploymentUnit unit : this.units) {
                try {
                    this.deploymentService.undeploy(unit);
                }
                catch (Exception exception) {}
            }
            this.units.clear();
        }
        this.close();
    }

    public void setMigrationService(ProcessInstanceMigrationService migrationService) {
        this.migrationService = migrationService;
    }

    @Test
    public void testMigrateSingleProcessInstance() {
        long processInstanceId = this.processService.startProcess(this.deploymentUnitV1.getIdentifier(), ADDTASKAFTERACTIVE_ID_V1);
        Assert.assertNotNull((Object)processInstanceId);
        MigrationReport report = this.migrationService.migrate(this.deploymentUnitV1.getIdentifier(), Long.valueOf(processInstanceId), this.deploymentUnitV2.getIdentifier(), ADDTASKAFTERACTIVE_ID_V2);
        Assert.assertNotNull((Object)report);
        Assert.assertTrue((boolean)report.isSuccessful());
        this.assertMigratedProcessInstance(ADDTASKAFTERACTIVE_ID_V2, processInstanceId, 1);
        this.assertMigratedTaskAndComplete(ADDTASKAFTERACTIVE_ID_V2, processInstanceId, "Active Task");
        this.assertMigratedTaskAndComplete(ADDTASKAFTERACTIVE_ID_V2, processInstanceId, "Added Task");
        this.assertMigratedProcessInstance(ADDTASKAFTERACTIVE_ID_V2, processInstanceId, 2);
    }

    @Test
    public void testMigrateMultipleProcessInstances() {
        ArrayList<Long> ids = new ArrayList<Long>();
        for (int i = 0; i < 5; ++i) {
            long processInstanceId = this.processService.startProcess(this.deploymentUnitV1.getIdentifier(), ADDTASKAFTERACTIVE_ID_V1);
            Assert.assertNotNull((Object)processInstanceId);
            ids.add(processInstanceId);
        }
        List reports = this.migrationService.migrate(this.deploymentUnitV1.getIdentifier(), ids, this.deploymentUnitV2.getIdentifier(), ADDTASKAFTERACTIVE_ID_V2);
        Assert.assertNotNull((Object)reports);
        Iterator reportsIt = reports.iterator();
        for (Long processInstanceId : ids) {
            MigrationReport report = (MigrationReport)reportsIt.next();
            Assert.assertTrue((boolean)report.isSuccessful());
            this.assertMigratedProcessInstance(ADDTASKAFTERACTIVE_ID_V2, processInstanceId, 1);
            this.assertMigratedTaskAndComplete(ADDTASKAFTERACTIVE_ID_V2, processInstanceId, "Active Task");
            this.assertMigratedTaskAndComplete(ADDTASKAFTERACTIVE_ID_V2, processInstanceId, "Added Task");
            this.assertMigratedProcessInstance(ADDTASKAFTERACTIVE_ID_V2, processInstanceId, 2);
        }
    }

    @Test
    public void testMigrateSingleProcessInstanceWithNodeMapping() {
        String activeNodeId = "_ECEDD1CE-7380-418C-B7A6-AF8ECB90B820";
        String nextNodeId = "_9EF3CAE0-D978-4E96-9C00-8A80082EB68E";
        HashMap<String, String> nodeMapping = new HashMap<String, String>();
        nodeMapping.put(activeNodeId, nextNodeId);
        long processInstanceId = this.processService.startProcess(this.deploymentUnitV1.getIdentifier(), REMOVEACTIVETASK_ID_V1);
        Assert.assertNotNull((Object)processInstanceId);
        MigrationReport report = this.migrationService.migrate(this.deploymentUnitV1.getIdentifier(), Long.valueOf(processInstanceId), this.deploymentUnitV2.getIdentifier(), REMOVEACTIVETASK_ID_V2, nodeMapping);
        Assert.assertNotNull((Object)report);
        Assert.assertTrue((boolean)report.isSuccessful());
        this.assertMigratedProcessInstance(REMOVEACTIVETASK_ID_V2, processInstanceId, 1);
        this.assertMigratedTaskAndComplete(REMOVEACTIVETASK_ID_V2, processInstanceId, "Mapped Task");
        this.assertMigratedProcessInstance(REMOVEACTIVETASK_ID_V2, processInstanceId, 2);
    }

    @Test
    public void testMigrateMultipleProcessInstancesWithNodeMapping() {
        ArrayList<Long> ids = new ArrayList<Long>();
        for (int i = 0; i < 5; ++i) {
            long processInstanceId = this.processService.startProcess(this.deploymentUnitV1.getIdentifier(), REMOVEACTIVETASK_ID_V1);
            Assert.assertNotNull((Object)processInstanceId);
            ids.add(processInstanceId);
        }
        String activeNodeId = "_ECEDD1CE-7380-418C-B7A6-AF8ECB90B820";
        String nextNodeId = "_9EF3CAE0-D978-4E96-9C00-8A80082EB68E";
        HashMap<String, String> nodeMapping = new HashMap<String, String>();
        nodeMapping.put(activeNodeId, nextNodeId);
        List reports = this.migrationService.migrate(this.deploymentUnitV1.getIdentifier(), ids, this.deploymentUnitV2.getIdentifier(), REMOVEACTIVETASK_ID_V2, nodeMapping);
        Assert.assertNotNull((Object)reports);
        Iterator reportsIt = reports.iterator();
        for (Long processInstanceId : ids) {
            MigrationReport report = (MigrationReport)reportsIt.next();
            Assert.assertTrue((boolean)report.isSuccessful());
            this.assertMigratedProcessInstance(REMOVEACTIVETASK_ID_V2, processInstanceId, 1);
            this.assertMigratedTaskAndComplete(REMOVEACTIVETASK_ID_V2, processInstanceId, "Mapped Task");
            this.assertMigratedProcessInstance(REMOVEACTIVETASK_ID_V2, processInstanceId, 2);
        }
    }

    @Test
    public void testMigrateSingleProcessInstanceWithoutNodeMappingWithNodeOrderChange() {
        long processInstanceId = this.processService.startProcess(this.deploymentUnitV1.getIdentifier(), RECREATEACTIVETASK_ID_V1);
        Assert.assertNotNull((Object)processInstanceId);
        MigrationReport report = this.migrationService.migrate(this.deploymentUnitV1.getIdentifier(), Long.valueOf(processInstanceId), this.deploymentUnitV2.getIdentifier(), RECREATEACTIVETASK_ID_V2);
        Assert.assertNotNull((Object)report);
        Assert.assertFalse((boolean)report.isSuccessful());
        MigrationEntry error = report.getEntries().stream().filter(e -> e.getType().equals("ERROR")).findFirst().get();
        Assert.assertNotNull((Object)error);
        Assert.assertEquals((Object)"Node with id _54C7BD3A-0BE4-4C87-9689-C492B8469D2D was not found in new process definition", (Object)error.getMessage());
    }

    protected void assertMigratedTaskAndComplete(String processId, Long processInstanceId, String taskName) {
        List tasks = this.runtimeDataService.getTasksByStatusByProcessInstanceId(processInstanceId, Arrays.asList(Status.Reserved), new QueryFilter());
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        TaskSummary task = (TaskSummary)tasks.get(0);
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)processId, (Object)task.getProcessId());
        Assert.assertEquals((Object)this.deploymentUnitV2.getIdentifier(), (Object)task.getDeploymentId());
        Assert.assertEquals((Object)taskName, (Object)task.getName());
        this.userTaskService.completeAutoProgress(task.getId(), "john", null);
    }

    protected void assertMigratedProcessInstance(String processId, long processInstanceId, int status) {
        ProcessInstanceDesc instance = this.runtimeDataService.getProcessInstanceById(processInstanceId);
        Assert.assertNotNull((Object)instance);
        Assert.assertEquals((Object)processId, (Object)instance.getProcessId());
        Assert.assertEquals((Object)this.deploymentUnitV2.getIdentifier(), (Object)instance.getDeploymentId());
        Assert.assertEquals((long)status, (long)instance.getState().intValue());
    }
}

