/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl.audit;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.drools.core.event.ProcessStartedEventImpl;
import org.jbpm.kie.services.impl.audit.ServicesAwareAuditEventBuilder;
import org.jbpm.kie.services.test.ProcessServiceImplTest;
import org.jbpm.kie.test.util.AbstractKieServicesBaseTest;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.jbpm.process.instance.context.variable.VariableScopeInstance;
import org.jbpm.process.instance.impl.ProcessInstanceImpl;
import org.jbpm.workflow.core.WorkflowProcess;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.runtime.KieRuntime;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.internal.identity.IdentityProvider;
import org.kie.internal.process.CorrelationKey;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=MockitoJUnitRunner.class)
public class ServicesAwareAuditEventBuilderTest
extends AbstractKieServicesBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(ProcessServiceImplTest.class);
    private Map<String, Object> processMetadata = new HashMap<String, Object>();
    private ServicesAwareAuditEventBuilder builder;
    @Mock
    ProcessInstanceImpl processInstance;
    @Mock
    KieSession kieRuntime;
    @Mock
    WorkflowProcess process;
    @Mock
    CorrelationKey correlationKey;
    @Mock
    VariableScopeInstance variableScope;

    public void setUp() throws Exception {
        super.setUp();
        this.processMetadata.put("CorrelationKey", this.correlationKey);
        this.builder = new ServicesAwareAuditEventBuilder();
        this.builder.setIdentityProvider((IdentityProvider)this.identityProvider);
        this.setUpMocks();
    }

    private void setUpMocks() {
        Mockito.when((Object)this.kieRuntime.getIdentifier()).thenReturn((Object)2L);
        Mockito.when((Object)this.processInstance.getId()).thenReturn((Object)1L);
        Mockito.when((Object)this.processInstance.getDescription()).thenReturn((Object)"Some test Process");
        Mockito.when((Object)this.processInstance.getSlaCompliance()).thenReturn((Object)0);
        Mockito.when((Object)this.processInstance.getSlaDueDate()).thenReturn(null);
        Mockito.when((Object)this.processInstance.getMetaData()).thenReturn(this.processMetadata);
        Mockito.when((Object)this.processInstance.getProcess()).thenReturn((Object)this.process);
        Mockito.when((Object)this.process.getProcessType()).thenReturn((Object)1);
        Mockito.when((Object)this.process.getName()).thenReturn((Object)"test-process");
        Mockito.when((Object)this.process.getVersion()).thenReturn((Object)"1.0.0");
        Mockito.when((Object)this.processInstance.getContextInstance((String)Mockito.eq((Object)"VariableScope"))).thenReturn((Object)this.variableScope);
        Mockito.when((Object)this.variableScope.getVariables()).thenReturn(this.processMetadata);
        Mockito.when((Object)this.correlationKey.toExternalForm()).thenReturn((Object)"1");
    }

    @Test
    public void testBuildProcessStartedEvent() {
        ProcessStartedEventImpl pse = new ProcessStartedEventImpl((ProcessInstance)this.processInstance, (KieRuntime)this.kieRuntime);
        ProcessInstanceLog log = (ProcessInstanceLog)this.builder.buildEvent((ProcessStartedEvent)pse);
        Assert.assertEquals((Object)"testUser", (Object)log.getIdentity());
    }

    @Test
    public void testBuildProcessStartedEventWithInitiatorAndNoUserAuthBypass() {
        this.processMetadata.put("initiator", "john");
        ProcessStartedEventImpl pse = new ProcessStartedEventImpl((ProcessInstance)this.processInstance, (KieRuntime)this.kieRuntime);
        ProcessInstanceLog log = (ProcessInstanceLog)this.builder.buildEvent((ProcessStartedEvent)pse);
        Assert.assertEquals((Object)"testUser", (Object)log.getIdentity());
    }

    @Test
    public void testBuildProcessStartedEventWithInitiatorAndUserAuthBypassEnabled() {
        this.processMetadata.put("initiator", "john");
        this.enableSetInitiator(this.builder);
        ProcessStartedEventImpl pse = new ProcessStartedEventImpl((ProcessInstance)this.processInstance, (KieRuntime)this.kieRuntime);
        ProcessInstanceLog log = (ProcessInstanceLog)this.builder.buildEvent((ProcessStartedEvent)pse);
        Assert.assertEquals((Object)"john", (Object)log.getIdentity());
    }

    @Test
    public void testBuildProcessStartedEventWithUserAuthBypassEnabledButNoInitiator() {
        this.enableSetInitiator(this.builder);
        ProcessStartedEventImpl pse = new ProcessStartedEventImpl((ProcessInstance)this.processInstance, (KieRuntime)this.kieRuntime);
        ProcessInstanceLog log = (ProcessInstanceLog)this.builder.buildEvent((ProcessStartedEvent)pse);
        Assert.assertEquals((Object)"testUser", (Object)log.getIdentity());
    }

    private void enableSetInitiator(ServicesAwareAuditEventBuilder builder) {
        try {
            Field allowSetInitiatorField = builder.getClass().getDeclaredField("allowSetInitiator");
            allowSetInitiatorField.setAccessible(true);
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(allowSetInitiatorField, allowSetInitiatorField.getModifiers() & 0xFFFFFFEF);
            allowSetInitiatorField.set(builder, Boolean.TRUE);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException ex) {
            throw new RuntimeException(ex);
        }
    }
}

