/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl.form;

import java.util.Collections;
import org.jbpm.kie.services.impl.form.FormProvider;
import org.jbpm.kie.services.impl.form.FormProviderServiceImpl;
import org.jbpm.services.api.DefinitionService;
import org.jbpm.services.api.RuntimeDataService;
import org.jbpm.services.api.model.ProcessDefinition;
import org.jbpm.services.task.commands.GetUserTaskCommand;
import org.jbpm.services.task.impl.model.TaskDataImpl;
import org.jbpm.services.task.impl.model.TaskImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.command.Command;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.TaskData;
import org.kie.internal.identity.IdentityProvider;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class FormProviderServiceImplTest {
    @Mock
    TaskService taskService;
    @Mock
    RuntimeDataService dataService;
    @Mock
    FormProvider formProvider;
    @Mock
    IdentityProvider identityProvider;
    @Mock
    DefinitionService bpmn2Service;
    @InjectMocks
    FormProviderServiceImpl formProviderService;

    @Before
    public void init() {
        this.formProviderService.setProviders(Collections.singleton(this.formProvider));
        this.formProviderService.setIdentityProvider(this.identityProvider);
        Mockito.when((Object)this.identityProvider.getName()).thenReturn((Object)"admin");
    }

    @Test
    public void testGetFormDisplayTaskWithoutProcess() {
        long taskId = 1L;
        TaskImpl task = new TaskImpl();
        task.setId(Long.valueOf(taskId));
        task.setName("TaskName");
        task.setTaskData((TaskData)new TaskDataImpl());
        Mockito.when((Object)this.taskService.execute((Command)Mockito.any(GetUserTaskCommand.class))).thenReturn((Object)task);
        String form = this.formProviderService.getFormDisplayTask(1L);
        Assert.assertEquals((Object)"", (Object)form);
        ((RuntimeDataService)Mockito.verify((Object)this.dataService, (VerificationMode)Mockito.never())).getProcessesByDeploymentIdProcessId(Matchers.anyString(), Matchers.anyString());
        ((FormProvider)Mockito.verify((Object)this.formProvider)).render((String)Mockito.eq((Object)task.getName()), (Task)Mockito.eq((Object)task), (ProcessDefinition)Mockito.isNull(ProcessDefinition.class), Mockito.anyMap());
    }

    @Test
    public void testGetFormDisplayTask() {
        long taskId = 1L;
        TaskImpl task = new TaskImpl();
        task.setId(Long.valueOf(taskId));
        task.setName("TaskName");
        TaskDataImpl taskData = new TaskDataImpl();
        String deploymentId = "org.jbpm";
        taskData.setDeploymentId("org.jbpm");
        String processId = "org.jbpm.evaluation";
        taskData.setProcessId("org.jbpm.evaluation");
        task.setTaskData((TaskData)taskData);
        Mockito.when((Object)this.taskService.execute((Command)Mockito.any(GetUserTaskCommand.class))).thenReturn((Object)task);
        ProcessDefinition processDefinition = (ProcessDefinition)Mockito.mock(ProcessDefinition.class);
        Mockito.when((Object)this.dataService.getProcessesByDeploymentIdProcessId("org.jbpm", "org.jbpm.evaluation")).thenReturn((Object)processDefinition);
        String form = this.formProviderService.getFormDisplayTask(1L);
        Assert.assertEquals((Object)"", (Object)form);
        ((RuntimeDataService)Mockito.verify((Object)this.dataService)).getProcessesByDeploymentIdProcessId("org.jbpm", "org.jbpm.evaluation");
        ((FormProvider)Mockito.verify((Object)this.formProvider)).render((String)Mockito.eq((Object)task.getName()), (Task)Mockito.eq((Object)task), (ProcessDefinition)Mockito.eq((Object)processDefinition), Mockito.anyMap());
    }
}

