/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl.query;

import java.util.ArrayList;
import java.util.Collections;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.CoreFunctionType;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.dashbuilder.dataset.filter.LogicalExprFilter;
import org.dashbuilder.dataset.filter.LogicalExprType;
import org.jbpm.kie.services.impl.query.CoreFunctionQueryParamBuilder;
import org.jbpm.services.api.query.model.QueryParam;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class CoreFunctionQueryParamBuilderTest {
    CoreFunctionQueryParamBuilder coreFunctionQueryParamBuilder;

    @Before
    public void init() {
    }

    @Test
    public void testLogicalExprPassedAsQueryParam() {
        ArrayList<String> values = new ArrayList<String>();
        values.add("value1");
        values.add("value2");
        ColumnFilter filter1 = FilterFactory.likeTo((String)"PROCESSNAME", (String)"%processName%");
        ColumnFilter filter2 = FilterFactory.likeTo((String)"PROCESSID", (String)"%processName%");
        ArrayList<ColumnFilter> terms = new ArrayList<ColumnFilter>();
        terms.add(filter1);
        terms.add(filter2);
        QueryParam queryParam = new QueryParam("", LogicalExprType.OR.toString(), terms);
        ArrayList<QueryParam> queryParams = new ArrayList<QueryParam>();
        queryParams.add(queryParam);
        this.coreFunctionQueryParamBuilder = new CoreFunctionQueryParamBuilder(new QueryParam[]{queryParam});
        Object builded = this.coreFunctionQueryParamBuilder.build();
        Assert.assertTrue((boolean)(builded instanceof LogicalExprFilter));
        Assert.assertEquals((Object)"(PROCESSNAME like %processName%, true OR PROCESSID like %processName%, true)", (Object)builded.toString());
    }

    @Test
    public void testTreeQueryParam() {
        QueryParam likeParamName = new QueryParam("PROCESSNAME", CoreFunctionType.LIKE_TO.toString(), Collections.singletonList("%processName%"));
        QueryParam likeParamId = new QueryParam("PROCESSID", CoreFunctionType.LIKE_TO.toString(), Collections.singletonList("%processName%"));
        ArrayList<QueryParam> terms = new ArrayList<QueryParam>();
        terms.add(likeParamName);
        terms.add(likeParamId);
        QueryParam queryParamOR = new QueryParam("", LogicalExprType.OR.toString(), terms);
        QueryParam likeParamIdentity = new QueryParam("USER_IDENTITY", CoreFunctionType.EQUALS_TO.toString(), Collections.singletonList("1234"));
        ArrayList<QueryParam> queryParamsAndTerms = new ArrayList<QueryParam>();
        queryParamsAndTerms.add(likeParamIdentity);
        queryParamsAndTerms.add(queryParamOR);
        QueryParam queryParam = new QueryParam("", LogicalExprType.AND.toString(), queryParamsAndTerms);
        this.coreFunctionQueryParamBuilder = new CoreFunctionQueryParamBuilder(new QueryParam[]{queryParam});
        Object builded = this.coreFunctionQueryParamBuilder.build();
        Assert.assertTrue((boolean)(builded instanceof LogicalExprFilter));
        Assert.assertEquals((Object)"(USER_IDENTITY = 1234 AND (PROCESSNAME like %processName% OR PROCESSID like %processName%))", (Object)builded.toString());
    }
}

