/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl.query.preprocessor;

import java.util.ArrayList;
import java.util.Arrays;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.jbpm.kie.services.impl.query.preprocessor.DeploymentIdsPreprocessor;
import org.jbpm.kie.services.impl.security.DeploymentRolesManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.internal.identity.IdentityProvider;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DeploymentIdsPreprocessorTest {
    private static String COL_ID = "DEPLOYMENTID";
    private static String FAIL_COL_ID = "TASKID";
    @Mock
    IdentityProvider identityProvider;
    @Mock
    DeploymentRolesManager deploymentRolesManager;
    DataSetLookup dataSetLookup;
    DeploymentIdsPreprocessor preprocessor;

    @Before
    public void init() {
        this.preprocessor = new DeploymentIdsPreprocessor(this.deploymentRolesManager, this.identityProvider, COL_ID, FAIL_COL_ID);
    }

    @Test
    public void testQueryWithUserAvailableDeployments() {
        this.dataSetLookup = (DataSetLookup)Mockito.spy((Object)new DataSetLookup());
        String deploymentId1 = "deployment1";
        String deploymentId2 = "deployment2";
        Mockito.when((Object)this.deploymentRolesManager.getDeploymentsForUser(this.identityProvider)).thenReturn(Arrays.asList(deploymentId1, deploymentId2));
        this.preprocessor.preprocess(this.dataSetLookup);
        Assert.assertEquals((Object)"DEPLOYMENTID in deployment1, deployment2", (Object)((ColumnFilter)this.dataSetLookup.getFirstFilterOp().getColumnFilterList().get(0)).toString());
    }

    @Test
    public void testQueryWithoutUserAvailableDeployments() {
        this.dataSetLookup = (DataSetLookup)Mockito.spy((Object)new DataSetLookup());
        Mockito.when((Object)this.deploymentRolesManager.getDeploymentsForUser(this.identityProvider)).thenReturn(new ArrayList());
        this.preprocessor.preprocess(this.dataSetLookup);
        Assert.assertEquals((Object)"TASKID = -1", (Object)((ColumnFilter)this.dataSetLookup.getFirstFilterOp().getColumnFilterList().get(0)).toString());
    }
}

