/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl.query.preprocessor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.DataSetMetadata;
import org.dashbuilder.dataset.DataSetOp;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.CoreFunctionFilter;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.jbpm.kie.services.impl.query.CoreFunctionQueryParamBuilder;
import org.jbpm.kie.services.impl.query.preprocessor.UserAndGroupsTasksPreprocessor;
import org.jbpm.services.api.query.model.QueryParam;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.task.UserGroupCallback;
import org.kie.internal.identity.IdentityProvider;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class UserAndGroupsTasksPreprocessorTest {
    DataSetLookup dataSetLookup;
    private static String COL_ID = "POTOWNER";
    @Mock
    IdentityProvider identityProvider;
    @Mock
    UserGroupCallback userGroupCallback;
    @Mock
    DataSetMetadata metaData;
    @InjectMocks
    UserAndGroupsTasksPreprocessor userAndGroupsTasksPreprocessor;

    @Before
    public void init() {
        this.dataSetLookup = new DataSetLookup();
        this.userAndGroupsTasksPreprocessor = new UserAndGroupsTasksPreprocessor(this.identityProvider, this.userGroupCallback, COL_ID, this.metaData);
    }

    @Test
    public void testSetUser() {
        String role1 = "role1";
        String role2 = "role2";
        String userId = "userId";
        Mockito.when((Object)this.userGroupCallback.getGroupsForUser(userId)).thenReturn(Arrays.asList(role1, role2));
        Mockito.when((Object)this.identityProvider.getName()).thenReturn((Object)userId);
        this.userAndGroupsTasksPreprocessor.preprocess(this.dataSetLookup);
        Assert.assertEquals((Object)("(POTOWNER in " + role1 + ", " + role2 + ", " + userId + ")"), (Object)((ColumnFilter)this.dataSetLookup.getFirstFilterOp().getColumnFilterList().get(0)).toString());
    }

    @Test
    public void testSetUserWithoutRoles() {
        String userId = "userId";
        Mockito.when((Object)this.userGroupCallback.getGroupsForUser(userId)).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.identityProvider.getName()).thenReturn((Object)userId);
        this.userAndGroupsTasksPreprocessor.preprocess(this.dataSetLookup);
        Assert.assertEquals((Object)("(POTOWNER in " + userId + ")"), (Object)((ColumnFilter)this.dataSetLookup.getFirstFilterOp().getColumnFilterList().get(0)).toString());
    }

    @Test
    public void testNullGroups() {
        String userId = "userId";
        Mockito.when((Object)this.userGroupCallback.getGroupsForUser(userId)).thenReturn(null);
        Mockito.when((Object)this.identityProvider.getName()).thenReturn((Object)userId);
        this.userAndGroupsTasksPreprocessor.preprocess(this.dataSetLookup);
        Assert.assertEquals((Object)("(POTOWNER in " + userId + ")"), (Object)((ColumnFilter)this.dataSetLookup.getFirstFilterOp().getColumnFilterList().get(0)).toString());
    }

    @Test
    public void testPotOwnerFilterNoIdentityProvider() {
        String userId = "userId";
        Mockito.when((Object)this.userGroupCallback.getGroupsForUser(userId)).thenReturn(null);
        Mockito.when((Object)this.identityProvider.getName()).thenReturn((Object)userId);
        String potOwner = "potOwner";
        Mockito.when((Object)this.userGroupCallback.getGroupsForUser(potOwner)).thenReturn(Arrays.asList("role1", "role2"));
        ArrayList<String> potOwners = new ArrayList<String>();
        potOwners.add(potOwner);
        QueryParam queryParam = new QueryParam(COL_ID, "IN", potOwners);
        ArrayList<QueryParam> queryParams = new ArrayList<QueryParam>();
        queryParams.add(queryParam);
        CoreFunctionQueryParamBuilder coreFunctionQueryParamBuilder = new CoreFunctionQueryParamBuilder(new QueryParam[]{queryParam});
        CoreFunctionFilter columnFilter = (CoreFunctionFilter)coreFunctionQueryParamBuilder.build();
        DataSetFilter filter = new DataSetFilter();
        filter.addFilterColumn(new ColumnFilter[]{columnFilter});
        this.dataSetLookup.addOperation(new DataSetOp[]{filter});
        this.userAndGroupsTasksPreprocessor.preprocess(this.dataSetLookup);
        Assert.assertEquals((Object)("(POTOWNER in role1, role2, " + potOwner + ")"), (Object)((ColumnFilter)this.dataSetLookup.getFirstFilterOp().getColumnFilterList().get(0)).toString());
    }

    @Test
    public void testPotOwnerFilterComplexExpression() {
        String userId = "userId";
        Mockito.when((Object)this.userGroupCallback.getGroupsForUser(userId)).thenReturn(null);
        Mockito.when((Object)this.identityProvider.getName()).thenReturn((Object)userId);
        String potOwner = "potOwner";
        Mockito.when((Object)this.userGroupCallback.getGroupsForUser(potOwner)).thenReturn(Arrays.asList("role1", "role2"));
        ArrayList<String> potOwners = new ArrayList<String>();
        potOwners.add(potOwner);
        QueryParam queryParam = new QueryParam(COL_ID, "IN", potOwners);
        QueryParam queryParamTerm1 = new QueryParam("MY_COLUMN", "EQUALS_TO", Arrays.asList("1234"));
        QueryParam queryParamTerm2 = new QueryParam("MY_COLUMN", "NOT_IN", Arrays.asList(1, 2, 3, 4));
        QueryParam queryParamOR = new QueryParam(null, "OR", Arrays.asList(queryParamTerm1, queryParamTerm2, queryParam));
        CoreFunctionQueryParamBuilder coreFunctionQueryParamBuilder = new CoreFunctionQueryParamBuilder(new QueryParam[]{queryParamOR});
        ColumnFilter columnFilter = (ColumnFilter)coreFunctionQueryParamBuilder.build();
        DataSetFilter filter = new DataSetFilter();
        filter.addFilterColumn(new ColumnFilter[]{columnFilter});
        this.dataSetLookup.addOperation(new DataSetOp[]{filter});
        this.userAndGroupsTasksPreprocessor.preprocess(this.dataSetLookup);
        List filters = this.dataSetLookup.getFirstFilterOp().getColumnFilterList();
        Assert.assertEquals((long)filters.size(), (long)2L);
        Assert.assertEquals((Object)"(MY_COLUMN = 1234 OR MY_COLUMN not_in 1, 2, 3, 4)", (Object)((ColumnFilter)filters.get(0)).toString());
        Assert.assertEquals((Object)("(POTOWNER in role1, role2, " + potOwner + ")"), (Object)((ColumnFilter)filters.get(1)).toString());
    }

    @Test
    public void testPotOwnerFilterWithEmptyPotOwnerList() {
        String userId = "userId";
        Mockito.when((Object)this.userGroupCallback.getGroupsForUser(userId)).thenReturn(null);
        Mockito.when((Object)this.identityProvider.getName()).thenReturn((Object)userId);
        ArrayList potOwners = new ArrayList();
        QueryParam queryParam = new QueryParam(COL_ID, "IN", potOwners);
        ArrayList<QueryParam> queryParams = new ArrayList<QueryParam>();
        queryParams.add(queryParam);
        CoreFunctionQueryParamBuilder coreFunctionQueryParamBuilder = new CoreFunctionQueryParamBuilder(new QueryParam[]{queryParam});
        CoreFunctionFilter columnFilter = (CoreFunctionFilter)coreFunctionQueryParamBuilder.build();
        DataSetFilter filter = new DataSetFilter();
        filter.addFilterColumn(new ColumnFilter[]{columnFilter});
        this.dataSetLookup.addOperation(new DataSetOp[]{filter});
        this.userAndGroupsTasksPreprocessor.preprocess(this.dataSetLookup);
        Assert.assertEquals((Object)("(POTOWNER in " + userId + ")"), (Object)((ColumnFilter)this.dataSetLookup.getFirstFilterOp().getColumnFilterList().get(0)).toString());
    }

    @Test
    public void testPotOwnerFilterNoIdentityProviderAndNullGroups() {
        String userId = "userId";
        Mockito.when((Object)this.userGroupCallback.getGroupsForUser(userId)).thenReturn(null);
        Mockito.when((Object)this.identityProvider.getName()).thenReturn((Object)userId);
        String potOwner = "potOwner";
        Mockito.when((Object)this.userGroupCallback.getGroupsForUser(potOwner)).thenReturn(null);
        ArrayList<String> potOwners = new ArrayList<String>();
        potOwners.add(potOwner);
        QueryParam queryParam = new QueryParam(COL_ID, "IN", potOwners);
        ArrayList<QueryParam> queryParams = new ArrayList<QueryParam>();
        queryParams.add(queryParam);
        CoreFunctionQueryParamBuilder coreFunctionQueryParamBuilder = new CoreFunctionQueryParamBuilder(new QueryParam[]{queryParam});
        CoreFunctionFilter columnFilter = (CoreFunctionFilter)coreFunctionQueryParamBuilder.build();
        DataSetFilter filter = new DataSetFilter();
        filter.addFilterColumn(new ColumnFilter[]{columnFilter});
        this.dataSetLookup.addOperation(new DataSetOp[]{filter});
        this.userAndGroupsTasksPreprocessor.preprocess(this.dataSetLookup);
        Assert.assertEquals((Object)("(POTOWNER in " + potOwner + ")"), (Object)((ColumnFilter)this.dataSetLookup.getFirstFilterOp().getColumnFilterList().get(0)).toString());
    }
}

