/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.test;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.appformer.maven.support.AFReleaseId;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.kie.test.util.AbstractKieServicesBaseTest;
import org.jbpm.services.api.ProcessInstanceNotFoundException;
import org.jbpm.services.api.model.DeploymentUnit;
import org.jbpm.services.api.model.ProcessInstanceWithVarsDesc;
import org.jbpm.services.api.model.UserTaskInstanceDesc;
import org.jbpm.services.api.model.UserTaskInstanceWithPotOwnerDesc;
import org.jbpm.services.api.query.model.QueryParam;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.query.QueryContext;
import org.kie.internal.task.api.TaskVariable;
import org.kie.scanner.KieMavenRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class AdvanceRuntimeDataServiceImplTest
extends AbstractKieServicesBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(AdvanceRuntimeDataServiceImplTest.class);
    private List<DeploymentUnit> units = new ArrayList<DeploymentUnit>();
    private List<Long> processIds;
    private KModuleDeploymentUnit deploymentUnit = null;
    private org.kie.internal.query.QueryContext queryContext;

    @Parameterized.Parameters(name="Pagination {0}")
    public static Iterable<? extends Object> data() {
        return Arrays.asList(0, 2);
    }

    public AdvanceRuntimeDataServiceImplTest(Integer count) {
        this.queryContext = new org.kie.internal.query.QueryContext(Integer.valueOf(0), count);
    }

    @Before
    public void prepare() {
        int i;
        this.configureServices();
        logger.debug("Preparing kjar");
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.jbpm.test", "test-module", "1.0.0");
        ArrayList<String> processes = new ArrayList<String>();
        processes.add("repo/processes/general/SingleHumanTaskWithVarsA.bpmn2");
        processes.add("repo/processes/general/SingleHumanTaskWithVarsB.bpmn2");
        InternalKieModule kJar1 = this.createKieJar(ks, releaseId, processes);
        File pom = new File("target/kmodule", "pom.xml");
        pom.getParentFile().mkdir();
        try (FileOutputStream fs2 = new FileOutputStream(pom);){
            fs2.write(this.getPom(releaseId, new ReleaseId[0]).getBytes());
        }
        catch (Exception fs2) {
            // empty catch block
        }
        KieMavenRepository repository = KieMavenRepository.getKieMavenRepository();
        repository.deployArtifact((AFReleaseId)releaseId, kJar1, pom);
        Assert.assertNotNull((Object)this.deploymentService);
        this.deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)this.deploymentUnit);
        this.units.add((DeploymentUnit)this.deploymentUnit);
        Assert.assertNotNull((Object)this.processService);
        this.processIds = new ArrayList<Long>();
        for (i = 0; i < 10; ++i) {
            HashMap<String, Object> inputsA1 = new HashMap<String, Object>();
            inputsA1.put("var_a", "a" + i % 3);
            inputsA1.put("var_b", i % 3);
            this.processIds.add(this.processService.startProcess(this.deploymentUnit.getIdentifier(), "test.test_A", inputsA1));
        }
        for (i = 0; i < 10; ++i) {
            HashMap<String, Object> inputsB1 = new HashMap<String, Object>();
            inputsB1.put("var_a", "b" + i % 3);
            inputsB1.put("var_b", i % 3);
            this.processIds.add(this.processService.startProcess(this.deploymentUnit.getIdentifier(), "test.test_B", inputsB1));
        }
    }

    @After
    public void cleanup() {
        for (Long processInstanceId : this.processIds) {
            try {
                this.processService.abortProcessInstance(processInstanceId);
                ProcessInstance pi = this.processService.getProcessInstance(processInstanceId);
                Assert.assertNull((Object)pi);
            }
            catch (ProcessInstanceNotFoundException processInstanceNotFoundException) {}
        }
        AdvanceRuntimeDataServiceImplTest.cleanupSingletonSessionId();
        if (this.units != null && !this.units.isEmpty()) {
            for (DeploymentUnit unit : this.units) {
                try {
                    this.deploymentService.undeploy(unit);
                }
                catch (Exception exception) {}
            }
            this.units.clear();
        }
        this.close();
    }

    @Test
    public void testQueryProcessByVariables() {
        List variables = QueryParam.list((QueryParam[])new QueryParam[]{QueryParam.equalsTo((String)"var_a", (Comparable[])new Comparable[]{"a1"}), QueryParam.equalsTo((String)"var_b", (Comparable[])new Comparable[]{"1"})});
        List attributes = QueryParam.list((QueryParam[])new QueryParam[]{QueryParam.equalsTo((String)"PROCESS_DEFINITION_ID", (Comparable[])new Comparable[]{"test.test_A"})});
        List data = this.advanceVariableDataService.queryProcessByVariables(attributes, variables, (QueryContext)this.queryContext);
        if (this.queryContext.getCount() > 0) {
            Assert.assertThat((Object)data.size(), (Matcher)CoreMatchers.is((Object)this.queryContext.getCount()));
        }
        for (ProcessInstanceWithVarsDesc p : data) {
            Assert.assertEquals((Object)"a1", p.getVariables().get("var_a"));
            Assert.assertEquals((Object)"1", p.getVariables().get("var_b"));
            Assert.assertEquals((Object)"test.test_A", (Object)p.getProcessId());
        }
    }

    @Test
    public void testQueryInOperator() {
        List variables = QueryParam.list((QueryParam[])new QueryParam[]{QueryParam.in((String)"var_a", (Object[])new Object[]{"a1", "a2"})});
        List attributes = QueryParam.list((QueryParam[])new QueryParam[]{QueryParam.equalsTo((String)"PROCESS_DEFINITION_ID", (Comparable[])new Comparable[]{"test.test_A"})});
        List data = this.advanceVariableDataService.queryProcessByVariables(attributes, variables, (QueryContext)this.queryContext);
        if (this.queryContext.getCount() > 0) {
            Assert.assertThat((Object)data.size(), (Matcher)CoreMatchers.is((Object)this.queryContext.getCount()));
        }
        List<String> values = Arrays.asList("a1", "a2");
        for (ProcessInstanceWithVarsDesc p : data) {
            Assert.assertTrue((boolean)values.contains(p.getVariables().get("var_a")));
            Assert.assertEquals((Object)"test.test_A", (Object)p.getProcessId());
        }
    }

    @Test
    public void testQueryLikeToOperator() {
        List variables = QueryParam.list((QueryParam[])new QueryParam[]{QueryParam.likeTo((String)"var_a", (boolean)false, (Comparable)((Object)"a%"))});
        List attributes = QueryParam.list((QueryParam[])new QueryParam[]{QueryParam.likeTo((String)"PROCESS_DEFINITION_ID", (boolean)false, (Comparable)((Object)"%test_A%"))});
        List data = this.advanceVariableDataService.queryProcessByVariables(attributes, variables, (QueryContext)this.queryContext);
        if (this.queryContext.getCount() > 0) {
            Assert.assertThat((Object)data.size(), (Matcher)CoreMatchers.is((Object)this.queryContext.getCount()));
        }
        for (ProcessInstanceWithVarsDesc p : data) {
            Assert.assertTrue((boolean)((String)p.getVariables().get("var_a")).startsWith("a"));
            Assert.assertEquals((Object)"test.test_A", (Object)p.getProcessId());
        }
    }

    @Test
    public void testQueryIsNotNullOperator() {
        List attributes = QueryParam.list((QueryParam[])new QueryParam[]{QueryParam.isNotNull((String)"TASK_OWNER")});
        List data = this.advanceVariableDataService.queryUserTasksByVariables(attributes, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), (QueryContext)this.queryContext);
        Assert.assertThat((Object)data.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void testQueryIsNullOperator() {
        List attributes = QueryParam.list((QueryParam[])new QueryParam[]{QueryParam.isNull((String)"TASK_OWNER")});
        List data = this.advanceVariableDataService.queryUserTasksByVariables(attributes, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), (QueryContext)this.queryContext);
        if (this.queryContext.getCount() > 0) {
            Assert.assertThat((Object)data.size(), (Matcher)CoreMatchers.is((Object)this.queryContext.getCount()));
        }
        for (UserTaskInstanceWithPotOwnerDesc p : data) {
            Assert.assertNull((Object)p.getActualOwner());
        }
    }

    @Test
    public void testQueryNotInOperator() {
        List variables = QueryParam.list((QueryParam[])new QueryParam[]{QueryParam.notIn((String)"var_a", (Object[])new Object[]{"a1", "a2"})});
        List attributes = QueryParam.list((QueryParam[])new QueryParam[]{QueryParam.equalsTo((String)"PROCESS_DEFINITION_ID", (Comparable[])new Comparable[]{"test.test_A"})});
        List data = this.advanceVariableDataService.queryProcessByVariables(attributes, variables, (QueryContext)this.queryContext);
        if (this.queryContext.getCount() > 0) {
            Assert.assertThat((Object)data.size(), (Matcher)CoreMatchers.is((Object)this.queryContext.getCount()));
        }
        List<String> values = Arrays.asList("a1", "a2");
        for (ProcessInstanceWithVarsDesc p : data) {
            Assert.assertTrue((!values.contains(p.getVariables().get("var_a")) ? 1 : 0) != 0);
            Assert.assertEquals((Object)"test.test_A", (Object)p.getProcessId());
        }
    }

    @Test
    public void testQueryNotEqualsOperator() {
        List attributes = QueryParam.list((QueryParam[])new QueryParam[]{QueryParam.notEqualsTo((String)"PROCESS_DEFINITION_ID", (Comparable[])new Comparable[]{"test.test_A"})});
        List data = this.advanceVariableDataService.queryProcessByVariables(attributes, Collections.emptyList(), (QueryContext)this.queryContext);
        if (this.queryContext.getCount() > 0) {
            Assert.assertThat((Object)data.size(), (Matcher)CoreMatchers.is((Object)this.queryContext.getCount()));
        }
        for (ProcessInstanceWithVarsDesc p : data) {
            Assert.assertNotEquals((Object)"test.test_A", (Object)p.getProcessId());
        }
    }

    @Test
    public void testQueryProcessByAttributes() {
        List attributes = QueryParam.list((QueryParam[])new QueryParam[]{QueryParam.equalsTo((String)"PROCESS_DEFINITION_ID", (Comparable[])new Comparable[]{"test.test_A"}), QueryParam.equalsTo((String)"PROCESS_CORRELATION_KEY", (Comparable[])new Comparable[]{"1"})});
        List data = this.advanceVariableDataService.queryProcessByVariables(attributes, Collections.emptyList(), (QueryContext)this.queryContext);
        Assert.assertThat((Object)data.size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testQueryTaskByVariables() {
        List variables = QueryParam.list((QueryParam[])new QueryParam[]{QueryParam.equalsTo((String)"task_in_a1", (Comparable[])new Comparable[]{"a0"})});
        List attributes = QueryParam.list((QueryParam[])new QueryParam[]{QueryParam.equalsTo((String)"PROCESS_DEPLOYMENT_ID", (Comparable[])new Comparable[]{"org.jbpm.test:test-module:1.0.0"})});
        List potOwners = Collections.emptyList();
        List data = this.advanceVariableDataService.queryUserTasksByVariables(attributes, variables, Collections.emptyList(), potOwners, (QueryContext)this.queryContext);
        if (this.queryContext.getCount() > 0) {
            Assert.assertThat((Object)data.size(), (Matcher)CoreMatchers.is((Object)this.queryContext.getCount()));
        }
        for (UserTaskInstanceWithPotOwnerDesc p : data) {
            Assert.assertEquals((Object)"a0", p.getInputdata().get("task_in_a1"));
            Assert.assertEquals((Object)"org.jbpm.test:test-module:1.0.0", (Object)p.getDeploymentId());
        }
    }

    @Test
    public void testQueryTaskNotEqualsByVariables() {
        List attributes = QueryParam.list((QueryParam[])new QueryParam[]{QueryParam.notEqualsTo((String)"PROCESS_DEFINITION_ID", (Comparable[])new Comparable[]{"test.test_A"})});
        List potOwners = Collections.emptyList();
        List data = this.advanceVariableDataService.queryUserTasksByVariables(attributes, Collections.emptyList(), Collections.emptyList(), potOwners, (QueryContext)this.queryContext);
        if (this.queryContext.getCount() > 0) {
            Assert.assertThat((Object)data.size(), (Matcher)CoreMatchers.is((Object)this.queryContext.getCount()));
        }
        for (UserTaskInstanceWithPotOwnerDesc p : data) {
            Assert.assertNotEquals((Object)"test.test_A", (Object)p.getProcessId());
        }
    }

    @Test
    public void testQueryTaskByVariablesWithOwners() {
        List<String> potOwners = Collections.singletonList("katy");
        List data = this.advanceVariableDataService.queryUserTasksByVariables(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), potOwners, (QueryContext)this.queryContext);
        if (this.queryContext.getCount() > 0) {
            Assert.assertThat((Object)data.size(), (Matcher)CoreMatchers.is((Object)this.queryContext.getCount()));
        }
        for (UserTaskInstanceWithPotOwnerDesc p : data) {
            Assert.assertTrue((boolean)p.getPotentialOwners().contains("katy"));
        }
    }

    @Test
    public void testQueryTaskByVariablesWithAllOwners() {
        List<String> potOwners = Arrays.asList("katy", "nobody");
        List data = this.advanceVariableDataService.queryUserTasksByVariables(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), potOwners, (QueryContext)this.queryContext);
        Assert.assertEquals((long)0L, (long)data.size());
    }

    @Test
    public void testQueryTaskByVariablesWithByProcessVar() {
        List processVariables = QueryParam.list((QueryParam[])new QueryParam[]{QueryParam.equalsTo((String)"var_a", (Comparable[])new Comparable[]{"a1"})});
        List potOwners = Collections.emptyList();
        List data = this.advanceVariableDataService.queryUserTasksByVariables(Collections.emptyList(), Collections.emptyList(), processVariables, potOwners, (QueryContext)this.queryContext);
        if (this.queryContext.getCount() > 0) {
            Assert.assertThat((Object)data.size(), (Matcher)CoreMatchers.is((Object)this.queryContext.getCount()));
        } else {
            Assert.assertThat((Object)data.size(), (Matcher)CoreMatchers.is((Object)3));
        }
    }

    @Test
    public void testQueryTaskByAttributes() {
        List attributes = QueryParam.list((QueryParam[])new QueryParam[]{QueryParam.equalsTo((String)"PROCESS_DEFINITION_ID", (Comparable[])new Comparable[]{"test.test_A"}), QueryParam.equalsTo((String)"PROCESS_CORRELATION_KEY", (Comparable[])new Comparable[]{"1"}), QueryParam.equalsTo((String)"TASK_NAME", (Comparable[])new Comparable[]{"Task"})});
        List data = this.advanceVariableDataService.queryUserTasksByVariables(attributes, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), (QueryContext)this.queryContext);
        Assert.assertThat((Object)data.size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testQueryTaskByAttributesOwner() {
        List attributes = QueryParam.list((QueryParam[])new QueryParam[]{QueryParam.equalsTo((String)"TASK_OWNER", (Comparable[])new Comparable[]{"Error"})});
        List data = this.advanceVariableDataService.queryUserTasksByVariables(attributes, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), (QueryContext)this.queryContext);
        Assert.assertThat((Object)data.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void testQueryTaskByStatus() {
        long[] taskIds;
        List attributes = QueryParam.list((QueryParam[])new QueryParam[]{QueryParam.in((String)"TASK_STATUS", Arrays.asList("Ready"))});
        List data = this.advanceVariableDataService.queryUserTasksByVariables(attributes, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), (QueryContext)this.queryContext);
        if (this.queryContext.getCount() > 0) {
            Assert.assertThat((Object)data.size(), (Matcher)CoreMatchers.is((Object)this.queryContext.getCount()));
        } else {
            Assert.assertThat((Object)data.size(), (Matcher)CoreMatchers.is((Object)20));
        }
        for (long taskId : taskIds = data.stream().mapToLong(UserTaskInstanceDesc::getTaskId).toArray()) {
            UserTaskInstanceDesc task = this.runtimeDataService.getTaskById(Long.valueOf(taskId));
            Assert.assertThat((Object)task.getStatus(), (Matcher)CoreMatchers.is((Object)"Ready"));
        }
    }

    @Test
    public void testQueryTaskByNotStatus() {
        List attributes = QueryParam.list((QueryParam[])new QueryParam[]{QueryParam.in((String)"TASK_STATUS", Arrays.asList("Created"))});
        List data = this.advanceVariableDataService.queryUserTasksByVariables(attributes, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), (QueryContext)this.queryContext);
        Assert.assertThat((Object)data.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void testQueryAllNull() {
        List data = this.advanceVariableDataService.queryUserTasksByVariables(null, null, null, null, (QueryContext)this.queryContext);
        if (this.queryContext.getCount() > 0) {
            Assert.assertThat((Object)data.size(), (Matcher)CoreMatchers.is((Object)this.queryContext.getCount()));
        } else {
            Assert.assertThat((Object)data.size(), (Matcher)CoreMatchers.is((Object)20));
        }
    }

    @Test
    public void testQueryTaskByVariablesWithMultipleExpressionsPerVariable() {
        List processVariables = QueryParam.list((QueryParam[])new QueryParam[]{QueryParam.notEqualsTo((String)"var_a", (Comparable[])new Comparable[]{"a1"}), QueryParam.isNotNull((String)"var_a")});
        List variables = QueryParam.list((QueryParam[])new QueryParam[]{QueryParam.notEqualsTo((String)"task_in_a1", (Comparable[])new Comparable[]{"a0"}), QueryParam.isNotNull((String)"task_in_a1")});
        List potOwners = Collections.emptyList();
        List data = this.advanceVariableDataService.queryUserTasksByVariables(Collections.emptyList(), variables, processVariables, potOwners, (QueryContext)this.queryContext);
        if (this.queryContext.getCount() > 0) {
            Assert.assertThat((Object)data.size(), (Matcher)CoreMatchers.is((Object)this.queryContext.getCount()));
        } else {
            Assert.assertThat((Object)data.size(), (Matcher)CoreMatchers.is((Object)3));
        }
        for (UserTaskInstanceWithPotOwnerDesc userTask : data) {
            Assert.assertThat(userTask.getProcessVariables().get("var_a"), (Matcher)CoreMatchers.notNullValue());
            Assert.assertThat(userTask.getProcessVariables().get("var_a"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Object)"a1")));
            Assert.assertThat(userTask.getInputdata().get("task_in_a1"), (Matcher)CoreMatchers.notNullValue());
            Assert.assertThat(userTask.getInputdata().get("task_in_a1"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Object)"a0")));
        }
    }

    @Test
    public void testQueryTaskByVariablesWithInputOutput() {
        List processVariables = QueryParam.list((QueryParam[])new QueryParam[]{QueryParam.notEqualsTo((String)"var_a", (Comparable[])new Comparable[]{"a1"}), QueryParam.isNotNull((String)"var_a")});
        List variablesOuput = QueryParam.list((QueryParam[])new QueryParam[]{QueryParam.notEqualsTo((String)"task_in_a1", (Comparable[])new Comparable[]{"a0"}), QueryParam.isNotNull((String)"task_in_a1"), QueryParam.type((String)"task_in_a1", (Comparable)Integer.valueOf(TaskVariable.VariableType.OUTPUT.ordinal()))});
        List dataOutput = this.advanceVariableDataService.queryUserTasksByVariables(Collections.emptyList(), variablesOuput, processVariables, Collections.emptyList(), (QueryContext)this.queryContext);
        Assert.assertThat((Object)dataOutput.size(), (Matcher)CoreMatchers.is((Object)0));
        List variablesInput = QueryParam.list((QueryParam[])new QueryParam[]{QueryParam.notEqualsTo((String)"task_in_a1", (Comparable[])new Comparable[]{"a0"}), QueryParam.isNotNull((String)"task_in_a1"), QueryParam.type((String)"task_in_a1", (Comparable)Integer.valueOf(TaskVariable.VariableType.INPUT.ordinal()))});
        List dataInput = this.advanceVariableDataService.queryUserTasksByVariables(Collections.emptyList(), variablesInput, processVariables, Collections.emptyList(), (QueryContext)this.queryContext);
        for (UserTaskInstanceWithPotOwnerDesc userTask : dataInput) {
            Long taskId = userTask.getTaskId();
            String user = (String)userTask.getPotentialOwners().get(0);
            this.userTaskService.start(taskId, user);
            Map inputs = this.userTaskService.getTaskInputContentByTaskId(taskId);
            HashMap<String, String> output = new HashMap<String, String>(inputs);
            output.put("task_out_a1", "3");
            this.userTaskService.saveContentFromUser(taskId, user, output);
            this.userTaskService.complete(taskId, user, output);
        }
        processVariables = QueryParam.list((QueryParam[])new QueryParam[]{QueryParam.notEqualsTo((String)"var_b", (Comparable[])new Comparable[]{"2"}), QueryParam.isNotNull((String)"var_b")});
        variablesOuput = QueryParam.list((QueryParam[])new QueryParam[]{QueryParam.equalsTo((String)"task_out_a1", (Comparable[])new Comparable[]{"3"}), QueryParam.type((String)"task_out_a1", (Comparable)Integer.valueOf(TaskVariable.VariableType.OUTPUT.ordinal()))});
        dataOutput = this.advanceVariableDataService.queryUserTasksByVariables(Collections.emptyList(), variablesOuput, processVariables, Collections.emptyList(), (QueryContext)this.queryContext);
        if (this.queryContext.getCount() > 0) {
            Assert.assertThat((Object)dataOutput.size(), (Matcher)CoreMatchers.is((Object)this.queryContext.getCount()));
        } else {
            Assert.assertThat((Object)dataOutput.size(), (Matcher)CoreMatchers.is((Object)3));
        }
        for (UserTaskInstanceWithPotOwnerDesc userTask : dataOutput) {
            Assert.assertThat(userTask.getProcessVariables().get("var_b"), (Matcher)CoreMatchers.is((Object)"3"));
        }
    }
}

