/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.test;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.appformer.maven.support.AFReleaseId;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.kie.test.util.AbstractKieServicesBaseTest;
import org.jbpm.services.api.ProcessInstanceNotFoundException;
import org.jbpm.services.api.model.DeploymentUnit;
import org.jbpm.services.api.model.ProcessInstanceDesc;
import org.jbpm.services.api.model.ProcessInstanceWithVarsDesc;
import org.jbpm.services.api.model.UserTaskInstanceDesc;
import org.jbpm.services.api.model.UserTaskInstanceWithPotOwnerDesc;
import org.jbpm.services.api.query.model.QueryParam;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.query.QueryContext;
import org.kie.internal.task.api.TaskVariable;
import org.kie.scanner.KieMavenRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdvanceRuntimeDataServiceImplWithVariableChangesTest
extends AbstractKieServicesBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(AdvanceRuntimeDataServiceImplWithVariableChangesTest.class);
    private List<DeploymentUnit> units = new ArrayList<DeploymentUnit>();
    private List<Long> processIds;
    private KModuleDeploymentUnit deploymentUnit = null;

    @Before
    public void prepare() {
        this.configureServices();
        logger.debug("Preparing kjar");
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.jbpm.test", "test-module", "1.0.0");
        ArrayList<String> processes = new ArrayList<String>();
        processes.add("repo/processes/general/SingleHumanTaskWithVarsA.bpmn2");
        processes.add("repo/processes/general/SingleHumanTaskWithVarsB.bpmn2");
        processes.add("repo/processes/general/SingleHumanTaskWithVarsC.bpmn2");
        InternalKieModule kJar1 = this.createKieJar(ks, releaseId, processes);
        File pom = new File("target/kmodule", "pom.xml");
        pom.getParentFile().mkdir();
        try (FileOutputStream fs2 = new FileOutputStream(pom);){
            fs2.write(this.getPom(releaseId, new ReleaseId[0]).getBytes());
        }
        catch (Exception fs2) {
            // empty catch block
        }
        KieMavenRepository repository = KieMavenRepository.getKieMavenRepository();
        repository.deployArtifact((AFReleaseId)releaseId, kJar1, pom);
        Assert.assertNotNull((Object)this.deploymentService);
        this.deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)this.deploymentUnit);
        this.units.add((DeploymentUnit)this.deploymentUnit);
        Assert.assertNotNull((Object)this.processService);
        this.processIds = new ArrayList<Long>();
        HashMap<String, String> inputsA1 = new HashMap<String, String>();
        inputsA1.put("var_a", "myvalue");
        inputsA1.put("var_b", "othervalue");
        this.processIds.add(this.processService.startProcess(this.deploymentUnit.getIdentifier(), "test.test_A", inputsA1));
        HashMap<String, String> inputsB1 = new HashMap<String, String>();
        inputsB1.put("var_a", "somethingelse");
        inputsB1.put("var_b", "b_var");
        this.processIds.add(this.processService.startProcess(this.deploymentUnit.getIdentifier(), "test.test_B", inputsB1));
        HashMap<String, String> inputsC1 = new HashMap<String, String>();
        inputsC1.put("var_c", "somethingelse");
        inputsC1.put("var_b", "b_var");
        this.processIds.add(this.processService.startProcess(this.deploymentUnit.getIdentifier(), "test.test_C", inputsC1));
    }

    @After
    public void cleanup() {
        for (Long processInstanceId : this.processIds) {
            try {
                this.processService.abortProcessInstance(processInstanceId);
                ProcessInstance pi = this.processService.getProcessInstance(processInstanceId);
                Assert.assertNull((Object)pi);
            }
            catch (ProcessInstanceNotFoundException processInstanceNotFoundException) {}
        }
        AdvanceRuntimeDataServiceImplWithVariableChangesTest.cleanupSingletonSessionId();
        if (this.units != null && !this.units.isEmpty()) {
            for (DeploymentUnit unit : this.units) {
                try {
                    this.deploymentService.undeploy(unit);
                }
                catch (Exception exception) {}
            }
            this.units.clear();
        }
        this.close();
    }

    @Test
    public void testQueryProcessTaskByVariablesWithOwners() {
        List userTasks = this.advanceVariableDataService.queryUserTasksByVariables(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), (QueryContext)new org.kie.internal.query.QueryContext(Integer.valueOf(0), Integer.valueOf(0)));
        for (UserTaskInstanceWithPotOwnerDesc userTask : userTasks) {
            Long taskId = userTask.getTaskId();
            String user = (String)userTask.getPotentialOwners().get(0);
            this.userTaskService.start(taskId, user);
            Map inputs = this.userTaskService.getTaskInputContentByTaskId(taskId);
            HashMap<String, String> output = new HashMap<String, String>(inputs);
            output.put("task_out_a1", "3");
            this.userTaskService.complete(taskId, user, output);
        }
        List attributes = QueryParam.list((QueryParam[])new QueryParam[]{QueryParam.equalsTo((String)"TASK_NAME", (Comparable[])new Comparable[]{"CustomTask"})});
        List processVariables = QueryParam.list((QueryParam[])new QueryParam[]{QueryParam.equalsTo((String)"var_b", (Comparable[])new Comparable[]{"3"})});
        List taskVariables = QueryParam.list((QueryParam[])new QueryParam[]{QueryParam.equalsTo((String)"task_in_a1", (Comparable[])new Comparable[]{"somethingelse"}), QueryParam.type((String)"task_in_a2", (Comparable)Integer.valueOf(TaskVariable.VariableType.INPUT.ordinal()))});
        List<String> potOwners = Collections.singletonList("kieserver");
        List data = this.advanceVariableDataService.queryProcessByVariablesAndTask(attributes, processVariables, taskVariables, potOwners, (QueryContext)new org.kie.internal.query.QueryContext(Integer.valueOf(0), Integer.valueOf(0)));
        Assert.assertThat((Object)data.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat(((ProcessInstanceWithVarsDesc)data.get(0)).getVariables().get("var_b"), (Matcher)CoreMatchers.is((Object)"3"));
        List taksIds = data.stream().map(ProcessInstanceDesc::getId).map(id -> this.runtimeDataService.getTasksByProcessInstanceId(id)).flatMap(Collection::stream).collect(Collectors.toList());
        for (Long taskId : taksIds) {
            UserTaskInstanceDesc userTask = this.runtimeDataService.getTaskById(taskId);
            Assert.assertThat((Object)userTask.getName(), (Matcher)CoreMatchers.is((Object)"CustomTask"));
        }
    }
}

