/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.test;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.appformer.maven.support.AFReleaseId;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.jbpm.kie.services.api.DeploymentIdResolver;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.kie.test.objects.OtherPerson;
import org.jbpm.kie.test.objects.Person;
import org.jbpm.kie.test.objects.Thing;
import org.jbpm.kie.test.util.AbstractKieServicesBaseTest;
import org.jbpm.process.instance.impl.demo.SystemOutWorkItemHandler;
import org.jbpm.services.api.model.DeploymentUnit;
import org.jbpm.services.api.model.ProcessDefinition;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.audit.AuditService;
import org.kie.api.runtime.manager.audit.VariableInstanceLog;
import org.kie.api.runtime.process.CaseAssignment;
import org.kie.api.runtime.process.CaseData;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.scanner.KieMavenRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BPMN2DataServicesReferencesTest
extends AbstractKieServicesBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(DeploymentIdResolver.class);
    private List<DeploymentUnit> units = new ArrayList<DeploymentUnit>();
    private DeploymentUnit deploymentUnit;
    private String deploymentId;
    private boolean loadBusinesRuleProcesses = true;
    private static final String PROC_ID_BUSINESS_RULE = "org.jbpm.kie.test.references.business";
    private static final String RULE_BUSINESS_RULE_PROCESS = "org.jbpm.kie.test.references.rules";
    private boolean loadCallActivityProcesses = true;
    private static final String PROC_ID_CALL_ACTIVITY = "org.jbpm.kie.test.references.parent";
    private static final String PROC_ID_CALL_ACTIVITY_BY_NAME = "org.jbpm.kie.test.references.parent.name";
    private static final String PROC_ID_ACTIVITY_CALLED = "org.jbpm.kie.test.references.subprocess";
    private boolean loadGlobalImportProcesses = true;
    private static final String PROC_ID_GLOBAL = "org.jbpm.kie.test.references.global";
    private static final String PROC_ID_IMPORT = "org.jbpm.kie.test.references.import";
    private boolean loadJavaMvelScriptProcesses = true;
    private static final String PROC_ID_JAVA_SCRIPT_QUALIFIED_CLASS = "org.jbpm.kie.test.references.qualified.java";
    private static final String PROC_ID_JAVA_THING_SCRIPT_QUALIFIED_CLASS = "org.jbpm.kie.test.references.qualified.java.thing";
    private static final String PROC_ID_MVEL_SCRIPT_QUALIFIED_CLASS = "org.jbpm.kie.test.references.qualified.mvel";
    private static final String PROC_ID_RULE_SCRIPT_QUALIFIED_CLASS = "org.jbpm.kie.test.references.qualified.drools";
    private boolean loadSignalGlobalInfoProcess = true;
    private static final String PROC_ID_SIGNAL = "org.jbpm.signal";
    private Set<Long> procInstIds = new HashSet<Long>();

    @Before
    public void prepare() {
        this.configureServices();
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.jbpm.test", "test-module", "1.0.0");
        ArrayList<String> resources = new ArrayList<String>();
        if (this.loadGlobalImportProcesses) {
            resources.add("repo/processes/references/importWithScriptTask.bpmn2");
            resources.add("repo/processes/references/globalBasedOnEntryExitScriptProcess.bpmn2");
        }
        if (this.loadCallActivityProcesses) {
            resources.add("repo/processes/references/callActivityByNameParent.bpmn2");
            resources.add("repo/processes/references/callActivityParent.bpmn2");
            resources.add("repo/processes/references/callActivitySubProcess.bpmn2");
        }
        if (this.loadBusinesRuleProcesses) {
            resources.add("repo/processes/references/businessRuleTask.bpmn2");
            resources.add("repo/processes/references/businessRuleTask.drl");
        }
        if (this.loadJavaMvelScriptProcesses) {
            resources.add("repo/processes/references/javaScriptTaskWithQualifiedClass.bpmn2");
            resources.add("repo/processes/references/javaScriptTaskWithQualifiedClassItemDefinition.bpmn2");
            resources.add("repo/processes/references/mvelScriptTaskWithQualifiedClass.bpmn2");
            resources.add("repo/processes/references/rulesScriptTaskWithQualifiedClass.bpmn2");
        }
        if (this.loadSignalGlobalInfoProcess) {
            resources.add("repo/processes/general/signal.bpmn");
        }
        InternalKieModule kJar1 = this.createKieJar(ks, releaseId, resources);
        File pom = new File("target/kmodule", "pom.xml");
        pom.getParentFile().mkdir();
        FileOutputStream fs = null;
        try {
            fs = new FileOutputStream(pom);
            fs.write(this.getPom(releaseId, new ReleaseId[0]).getBytes());
        }
        catch (Exception e) {
            Assert.fail((String)("Unable to write pom.xml to filesystem: " + e.getMessage()));
        }
        try {
            fs.close();
        }
        catch (Exception e) {
            logger.info("Unable to close fileystem used to write pom.xml");
        }
        KieMavenRepository repository = KieMavenRepository.getKieMavenRepository();
        repository.deployArtifact((AFReleaseId)releaseId, kJar1, pom);
        Assert.assertNotNull((Object)this.deploymentService);
        this.deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy(this.deploymentUnit);
        this.units.add(this.deploymentUnit);
        this.deploymentId = this.deploymentUnit.getIdentifier();
        this.procInstIds.clear();
    }

    @After
    public void cleanup() {
        for (long procInstId : this.procInstIds) {
            try {
                this.processService.abortProcessInstance(Long.valueOf(procInstId));
            }
            catch (Exception exception) {}
        }
        BPMN2DataServicesReferencesTest.cleanupSingletonSessionId();
        if (this.units != null && !this.units.isEmpty()) {
            for (DeploymentUnit unit : this.units) {
                this.deploymentService.undeploy(unit);
            }
            this.units.clear();
        }
        this.close();
    }

    @SafeVarargs
    private final long startProcess(String deploymentId, String processId, Map<String, Object> ... params) {
        Long procInstId = params != null && params.length > 0 ? this.processService.startProcess(deploymentId, processId, params[0]) : this.processService.startProcess(deploymentId, processId);
        this.procInstIds.add(procInstId);
        return procInstId;
    }

    @Test
    public void testImport() throws IOException {
        Assume.assumeTrue((String)"Skip import/global tests", (boolean)this.loadGlobalImportProcesses);
        String processId = PROC_ID_IMPORT;
        ProcessDefinition procDef = this.bpmn2Service.getProcessDefinition(this.deploymentId, processId);
        Assert.assertNotNull((Object)procDef);
        Person person = new Person();
        person.setName("Max Rockatansky");
        person.setId(1979L);
        person.setTime(3L);
        HashMap<String, Person> params = new HashMap<String, Person>();
        params.put("person", person);
        Long procId = this.startProcess(this.deploymentId, processId, params);
        ProcessInstance procInst = this.processService.getProcessInstance(procId);
        Assert.assertNull((Object)procInst);
        Collection refClasses = this.bpmn2Service.getJavaClasses(this.deploymentId, processId);
        Assert.assertNotNull((String)"Null set of referenced classes", (Object)refClasses);
        Assert.assertFalse((String)"Empty set of referenced classes", (boolean)refClasses.isEmpty());
        Assert.assertEquals((String)"Number referenced classes", (long)3L, (long)refClasses.size());
        Object[] expected = new String[]{Person.class.getCanonicalName(), CaseAssignment.class.getCanonicalName(), CaseData.class.getCanonicalName()};
        Assert.assertArrayEquals((String)"Imported class in process", (Object[])expected, (Object[])refClasses.toArray(new String[refClasses.size()]));
    }

    @Test
    public void testGlobal() throws IOException {
        Assume.assumeTrue((String)"Skip import/global tests", (boolean)this.loadGlobalImportProcesses);
        String processId = PROC_ID_GLOBAL;
        ProcessDefinition procDef = this.bpmn2Service.getProcessDefinition(this.deploymentId, processId);
        Assert.assertNotNull((Object)procDef);
        Person person = new Person();
        person.setName("Max Rockatansky");
        person.setId(1979L);
        person.setTime(3L);
        KieSession ksession = this.deploymentService.getRuntimeManager(this.deploymentId).getRuntimeEngine(null).getKieSession();
        ksession.setGlobal("person", (Object)person);
        ksession.getWorkItemManager().registerWorkItemHandler("MyTask", (WorkItemHandler)new SystemOutWorkItemHandler());
        Long procId = this.startProcess(this.deploymentId, processId, new Map[0]);
        ProcessInstance procInst = this.processService.getProcessInstance(procId);
        Assert.assertNull((Object)procInst);
        String log = person.getLog();
        Assert.assertFalse((String)"Empty log", (log == null || log.trim().isEmpty() ? 1 : 0) != 0);
        Assert.assertEquals((String)"Empty log", (long)log.split(":").length, (long)4L);
        Collection refClasses = this.bpmn2Service.getJavaClasses(this.deploymentId, processId);
        Assert.assertNotNull((String)"Null set of referenced classes", (Object)refClasses);
        Assert.assertFalse((String)"Empty set of referenced classes", (boolean)refClasses.isEmpty());
        Assert.assertEquals((String)"Number referenced classes", (long)3L, (long)refClasses.size());
        Object[] expected = new String[]{Person.class.getCanonicalName(), CaseAssignment.class.getCanonicalName(), CaseData.class.getCanonicalName()};
        Assert.assertArrayEquals((String)"Imported class in process", (Object[])expected, (Object[])refClasses.toArray(new String[refClasses.size()]));
    }

    @Test
    public void testCallActivityByName() throws IOException {
        Assume.assumeTrue((String)"Skip call activity tests", (boolean)this.loadCallActivityProcesses);
        String processId = PROC_ID_CALL_ACTIVITY_BY_NAME;
        ProcessDefinition procDef = this.bpmn2Service.getProcessDefinition(this.deploymentId, processId);
        Assert.assertNotNull((Object)procDef);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "oldValue");
        Long procId = this.startProcess(this.deploymentId, processId, params);
        ProcessInstance procInst = this.processService.getProcessInstance(procId);
        Assert.assertNull((Object)procInst);
        AuditService auditService = this.deploymentService.getRuntimeManager(this.deploymentId).getRuntimeEngine(null).getAuditService();
        List logs = auditService.findVariableInstances(procId.longValue());
        boolean foundY = false;
        for (VariableInstanceLog log : logs) {
            if (!log.getVariableId().equals("y") || !log.getValue().equals("new value")) continue;
            foundY = true;
        }
        Assert.assertTrue((String)"Parent process did not call sub process", (boolean)foundY);
        Collection refProcesses = this.bpmn2Service.getReusableSubProcesses(this.deploymentId, processId);
        Assert.assertNotNull((String)"Null set of referenced processes", (Object)refProcesses);
        Assert.assertFalse((String)"Empty set of referenced processes", (boolean)refProcesses.isEmpty());
        Assert.assertEquals((String)"Number referenced processes", (long)1L, (long)refProcesses.size());
        Assert.assertEquals((String)"Imported class in processes", (Object)PROC_ID_ACTIVITY_CALLED, refProcesses.iterator().next());
    }

    @Test
    public void testCallActivity() throws IOException {
        Assume.assumeTrue((String)"Skip call activity tests", (boolean)this.loadCallActivityProcesses);
        String processId = PROC_ID_CALL_ACTIVITY;
        ProcessDefinition procDef = this.bpmn2Service.getProcessDefinition(this.deploymentId, processId);
        Assert.assertNotNull((Object)procDef);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "oldValue");
        Long procId = this.startProcess(this.deploymentId, processId, params);
        ProcessInstance procInst = this.processService.getProcessInstance(procId);
        Assert.assertNull((Object)procInst);
        AuditService auditService = this.deploymentService.getRuntimeManager(this.deploymentId).getRuntimeEngine(null).getAuditService();
        List logs = auditService.findVariableInstances(procId.longValue());
        boolean foundY = false;
        for (VariableInstanceLog log : logs) {
            if (!log.getVariableId().equals("y") || !log.getValue().equals("new value")) continue;
            foundY = true;
        }
        Assert.assertTrue((String)"Parent process did not call sub process", (boolean)foundY);
        Collection refProcesses = this.bpmn2Service.getReusableSubProcesses(this.deploymentId, processId);
        Assert.assertNotNull((String)"Null set of referenced processes", (Object)refProcesses);
        Assert.assertFalse((String)"Empty set of referenced processes", (boolean)refProcesses.isEmpty());
        Assert.assertEquals((String)"Number referenced processes", (long)1L, (long)refProcesses.size());
        Assert.assertEquals((String)"Imported class in processes", (Object)PROC_ID_ACTIVITY_CALLED, refProcesses.iterator().next());
    }

    @Test
    public void testBusinessRuleTask() throws IOException {
        Assume.assumeTrue((String)"Skip business rule tests", (boolean)this.loadBusinesRuleProcesses);
        String processId = PROC_ID_BUSINESS_RULE;
        ProcessDefinition procDef = this.bpmn2Service.getProcessDefinition(this.deploymentId, processId);
        Assert.assertNotNull((Object)procDef);
        Person person = new Person();
        person.setName("Max Rockatansky");
        person.setId(1979L);
        person.setTime(3L);
        KieSession ksession = this.deploymentService.getRuntimeManager(this.deploymentId).getRuntimeEngine(null).getKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Long procId = this.startProcess(this.deploymentId, processId, new Map[0]);
        String ruleOutput = "Executed";
        Assert.assertEquals((String)"Global did not contain output from rule!", (long)1L, (long)list.size());
        Assert.assertEquals((String)"Global did not contain correct output of rule!", (Object)ruleOutput, list.get(0));
        ProcessInstance procInst = this.processService.getProcessInstance(procId);
        Assert.assertNull((String)"Process instance did not complete!", (Object)procInst);
        Collection refRules = this.bpmn2Service.getRuleSets(this.deploymentId, processId);
        Assert.assertNotNull((String)"Null set of imported rules", (Object)refRules);
        Assert.assertFalse((String)"Empty set of imported rules", (boolean)refRules.isEmpty());
        Assert.assertEquals((String)"Number imported rules", (long)1L, (long)refRules.size());
        Assert.assertEquals((String)"Name of imported ruleset", (Object)RULE_BUSINESS_RULE_PROCESS, refRules.iterator().next());
        refRules = procDef.getReferencedRules();
        Assert.assertNotNull((String)"Null set of imported rules", (Object)refRules);
        Assert.assertFalse((String)"Empty set of imported rules", (boolean)refRules.isEmpty());
        Assert.assertEquals((String)"Number imported rules", (long)1L, (long)refRules.size());
        Assert.assertEquals((String)"Name of imported ruleset", (Object)RULE_BUSINESS_RULE_PROCESS, refRules.iterator().next());
    }

    @Test
    public void testJavaScriptWithQualifiedClass() throws IOException {
        this.runScriptTest(PROC_ID_JAVA_SCRIPT_QUALIFIED_CLASS);
    }

    @Test
    public void testJavaThingScriptWithQualifiedClass() throws IOException {
        this.runScriptTest(PROC_ID_JAVA_THING_SCRIPT_QUALIFIED_CLASS);
    }

    @Test
    public void testMvelScriptWithQualifiedClass() throws IOException {
        this.runScriptTest(PROC_ID_MVEL_SCRIPT_QUALIFIED_CLASS);
    }

    private void runScriptTest(String processId) {
        Assume.assumeTrue((String)"Skip script/expr tests", (boolean)this.loadJavaMvelScriptProcesses);
        ProcessDefinition procDef = this.bpmn2Service.getProcessDefinition(this.deploymentId, processId);
        Assert.assertNotNull((Object)procDef);
        Person person = new Person();
        person.setName("Max Rockatansky");
        person.setId(1979L);
        person.setTime(3L);
        HashMap<String, Person> params = new HashMap<String, Person>(1);
        params.put("person", person);
        Long procId = this.startProcess(this.deploymentId, processId, params);
        Assert.assertNull((String)"Process instance did not complete", (Object)this.processService.getProcessInstance(procId));
        Assert.assertTrue((String)"Script did not modify variable!", (boolean)person.getLog().startsWith("Hello"));
        Collection javaClasses = this.bpmn2Service.getJavaClasses(this.deploymentId, processId);
        Assert.assertNotNull((String)"Null set of java classes", (Object)javaClasses);
        Assert.assertFalse((String)"Empty set of java classes", (boolean)javaClasses.isEmpty());
        Assert.assertEquals((String)"Number java classes", (long)6L, (long)javaClasses.size());
        String[] expected = new String[]{"java.lang.Object", Person.class.getCanonicalName(), OtherPerson.class.getCanonicalName(), Thing.class.getCanonicalName(), CaseAssignment.class.getCanonicalName(), CaseData.class.getCanonicalName()};
        HashSet<String> expectedClasses = new HashSet<String>(Arrays.asList(expected));
        for (String className : javaClasses) {
            Assert.assertTrue((String)("Class name is not qualified: " + className), (boolean)className.contains("."));
            Assert.assertTrue((String)("Unexpected class: " + className), (boolean)expectedClasses.remove(className));
        }
        if (!expectedClasses.isEmpty()) {
            Assert.fail((String)("Expected class not found to be referenced: " + (String)expectedClasses.iterator().next()));
        }
    }

    @Test
    @Ignore
    public void testDroolsScriptWithQualifiedClass() throws Exception {
        Assume.assumeTrue((String)"Skip script/expr tests", (boolean)this.loadJavaMvelScriptProcesses);
        String processId = PROC_ID_RULE_SCRIPT_QUALIFIED_CLASS;
        ProcessDefinition procDef = this.bpmn2Service.getProcessDefinition(this.deploymentId, processId);
        Assert.assertNotNull((Object)procDef);
        Person person = new Person();
        person.setName("Max");
        person.setId(1979L);
        person.setTime(3L);
        KieSession ksession = this.deploymentService.getRuntimeManager(this.deploymentId).getRuntimeEngine(null).getKieSession();
        ksession.insert((Object)person);
        ksession.insert((Object)new Thing());
        ksession.insert((Object)new OtherPerson(person));
        ksession.insert((Object)person.getName());
        ksession.insert((Object)person.getId());
        Long procId = this.startProcess(this.deploymentId, processId, new Map[0]);
        Assert.assertNull((String)"Process instance did not complete:", (Object)this.processService.getProcessInstance(procId));
        Collection javaClasses = this.bpmn2Service.getJavaClasses(this.deploymentId, processId);
        Assert.assertNotNull((String)"Null set of java classes", (Object)javaClasses);
        Assert.assertFalse((String)"Empty set of java classes", (boolean)javaClasses.isEmpty());
        Assert.assertEquals((String)"Number java classes", (long)4L, (long)javaClasses.size());
        String[] expected = new String[]{"java.lang.Object", Person.class.getCanonicalName(), OtherPerson.class.getCanonicalName(), Thing.class.getCanonicalName()};
        HashSet<String> expectedClasses = new HashSet<String>(Arrays.asList(expected));
        for (String className : javaClasses) {
            Assert.assertTrue((String)("Class name is not qualified: " + className), (boolean)className.contains("."));
            Assert.assertTrue((String)("Unexpected class: " + className), (boolean)expectedClasses.remove(className));
        }
        if (!expectedClasses.isEmpty()) {
            Assert.fail((String)("Expected class not found to be referenced: " + (String)expectedClasses.iterator().next()));
        }
    }

    @Test
    public void testSignalsAndGlobals() throws IOException {
        Assume.assumeTrue((String)"Skip signal/global tests", (boolean)this.loadSignalGlobalInfoProcess);
        String processId = PROC_ID_SIGNAL;
        KieSession ksession = this.deploymentService.getRuntimeManager(this.deploymentId).getRuntimeEngine(null).getKieSession();
        ksession.setGlobal("person", (Object)new Person());
        long procInstId = this.startProcess(this.deploymentId, processId, new Map[0]);
        ProcessDefinition procDef = this.bpmn2Service.getProcessDefinition(this.deploymentId, processId);
        Assert.assertNotNull((Object)procDef);
        Assert.assertNotNull((String)"Null signals list", (Object)procDef.getSignals());
        Assert.assertFalse((String)"Empty signals list", (boolean)procDef.getSignals().isEmpty());
        Assert.assertEquals((String)"Unexpected signal", (Object)"MySignal", procDef.getSignals().iterator().next());
        Collection globalNames = procDef.getGlobals();
        Assert.assertNotNull((String)"Null globals list", (Object)globalNames);
        Assert.assertFalse((String)"Empty globals list", (boolean)globalNames.isEmpty());
        Assert.assertEquals((String)"globals list size", (long)2L, (long)globalNames.size());
        for (String globalName : globalNames) {
            Assert.assertTrue((String)("Unexpected global: " + globalName), ("person".equals(globalName) || "name".equals(globalName) ? 1 : 0) != 0);
        }
        this.processService.abortProcessInstance(Long.valueOf(procInstId));
    }
}

