/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.test;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.appformer.maven.support.AFReleaseId;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.kie.test.util.AbstractKieServicesBaseTest;
import org.jbpm.services.api.DeploymentNotFoundException;
import org.jbpm.services.api.ProcessDefinitionNotFoundException;
import org.jbpm.services.api.model.DeploymentUnit;
import org.jbpm.services.api.model.ProcessDefinition;
import org.jbpm.services.api.model.TimerDesc;
import org.jbpm.services.api.model.UserTaskDefinition;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.scanner.KieMavenRepository;

public class BPMN2DataServicesTest
extends AbstractKieServicesBaseTest {
    private List<DeploymentUnit> units = new ArrayList<DeploymentUnit>();

    @Before
    public void prepare() {
        this.configureServices();
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.jbpm.test", "test-module", "1.0.0");
        ArrayList<String> processes = new ArrayList<String>();
        processes.add("repo/processes/hr/hiring.bpmn2");
        processes.add("repo/processes/general/customtask.bpmn");
        processes.add("repo/processes/general/humanTask.bpmn");
        processes.add("repo/processes/general/import.bpmn");
        processes.add("repo/processes/general/callactivity.bpmn");
        processes.add("repo/processes/general/BPMN2-UserTask.bpmn2");
        processes.add("repo/processes/itemrefissue/itemrefissue.bpmn");
        processes.add("repo/processes/general/ObjectVariableProcess.bpmn2");
        processes.add("repo/processes/general/timer-process.bpmn2");
        InternalKieModule kJar1 = this.createKieJar(ks, releaseId, processes);
        File pom = new File("target/kmodule", "pom.xml");
        pom.getParentFile().mkdir();
        try {
            FileOutputStream fs = new FileOutputStream(pom);
            fs.write(this.getPom(releaseId, new ReleaseId[0]).getBytes());
            fs.close();
        }
        catch (Exception fs) {
            // empty catch block
        }
        KieMavenRepository repository = KieMavenRepository.getKieMavenRepository();
        repository.deployArtifact((AFReleaseId)releaseId, kJar1, pom);
    }

    @After
    public void cleanup() {
        BPMN2DataServicesTest.cleanupSingletonSessionId();
        if (this.units != null && !this.units.isEmpty()) {
            for (DeploymentUnit unit : this.units) {
                this.deploymentService.undeploy(unit);
            }
            this.units.clear();
        }
        this.close();
    }

    @Test
    public void testHumanTaskProcess() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        String processId = "org.jbpm.writedocument";
        ProcessDefinition procDef = this.bpmn2Service.getProcessDefinition(deploymentUnit.getIdentifier(), processId);
        Assert.assertNotNull((Object)procDef);
        Assert.assertEquals((Object)procDef.getId(), (Object)"org.jbpm.writedocument");
        Assert.assertEquals((Object)procDef.getName(), (Object)"humanTaskSample");
        Assert.assertEquals((Object)procDef.getKnowledgeType(), (Object)"PROCESS");
        Assert.assertEquals((Object)procDef.getPackageName(), (Object)"defaultPackage");
        Assert.assertEquals((Object)procDef.getType(), (Object)"RuleFlow");
        Assert.assertEquals((Object)procDef.getVersion(), (Object)"3");
        Assert.assertFalse((boolean)procDef.getNodes().isEmpty());
        Assert.assertEquals((long)8L, (long)procDef.getNodes().size());
        Assert.assertTrue((boolean)procDef.getTimers().isEmpty());
        Map processData = this.bpmn2Service.getProcessVariables(deploymentUnit.getIdentifier(), processId);
        Assert.assertEquals((Object)"String", processData.get("approval_document"));
        Assert.assertEquals((Object)"String", processData.get("approval_translatedDocument"));
        Assert.assertEquals((Object)"String", processData.get("approval_reviewComment"));
        Assert.assertEquals((long)3L, (long)processData.keySet().size());
        Collection userTasks = this.bpmn2Service.getTasksDefinitions(deploymentUnit.getIdentifier(), processId);
        Assert.assertNotNull((Object)userTasks);
        Assert.assertEquals((long)3L, (long)userTasks.size());
        HashMap<String, UserTaskDefinition> tasksByName = new HashMap<String, UserTaskDefinition>();
        for (UserTaskDefinition userTask : userTasks) {
            tasksByName.put(userTask.getName(), userTask);
        }
        Assert.assertTrue((boolean)tasksByName.containsKey("Write a Document"));
        Assert.assertTrue((boolean)tasksByName.containsKey("Translate Document"));
        Assert.assertTrue((boolean)tasksByName.containsKey("Review Document"));
        UserTaskDefinition task = (UserTaskDefinition)tasksByName.get("Write a Document");
        Assert.assertEquals((Object)true, (Object)task.isSkippable());
        Assert.assertEquals((Object)"Write a Document", (Object)task.getName());
        Assert.assertEquals((long)9L, (long)task.getPriority().intValue());
        Assert.assertEquals((Object)"Write a Document", (Object)task.getComment());
        Assert.assertEquals((Object)"Write a Document", (Object)task.getFormName());
        Assert.assertEquals((Object)"2", (Object)task.getId());
        task = (UserTaskDefinition)tasksByName.get("Translate Document");
        Assert.assertEquals((Object)true, (Object)task.isSkippable());
        Assert.assertEquals((Object)"Translate Document", (Object)task.getName());
        Assert.assertEquals((long)0L, (long)task.getPriority().intValue());
        Assert.assertEquals((Object)"", (Object)task.getComment());
        Assert.assertEquals((Object)"Translate Document", (Object)task.getFormName());
        Assert.assertEquals((Object)"4", (Object)task.getId());
        task = (UserTaskDefinition)tasksByName.get("Review Document");
        Assert.assertEquals((Object)false, (Object)task.isSkippable());
        Assert.assertEquals((Object)"Review Document", (Object)task.getName());
        Assert.assertEquals((long)0L, (long)task.getPriority().intValue());
        Assert.assertEquals((Object)"", (Object)task.getComment());
        Assert.assertEquals((Object)"Review Document", (Object)task.getFormName());
        Assert.assertEquals((Object)"5", (Object)task.getId());
        Map taskInputMappings = this.bpmn2Service.getTaskInputMappings(deploymentUnit.getIdentifier(), processId, "Write a Document");
        Assert.assertEquals((long)4L, (long)taskInputMappings.keySet().size());
        Map taskOutputMappings = this.bpmn2Service.getTaskOutputMappings(deploymentUnit.getIdentifier(), processId, "Write a Document");
        Assert.assertEquals((long)1L, (long)taskOutputMappings.keySet().size());
        Map associatedEntities = this.bpmn2Service.getAssociatedEntities(deploymentUnit.getIdentifier(), processId);
        Assert.assertEquals((long)3L, (long)associatedEntities.keySet().size());
    }

    @Test
    public void testTimerProcess() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        String processId = "timerprocess";
        ProcessDefinition procDef = this.bpmn2Service.getProcessDefinition(deploymentUnit.getIdentifier(), processId);
        Assert.assertNotNull((Object)procDef);
        Assert.assertEquals((Object)"timerprocess", (Object)procDef.getId());
        Assert.assertEquals((Object)"IntermediateCatchEvent Process", (Object)procDef.getName());
        Assert.assertEquals((Object)"PROCESS", (Object)procDef.getKnowledgeType());
        Assert.assertEquals((Object)"org.drools.bpmn2", (Object)procDef.getPackageName());
        Assert.assertEquals((Object)"RuleFlow", (Object)procDef.getType());
        Assert.assertEquals((Object)"", (Object)procDef.getVersion());
        Assert.assertFalse((boolean)procDef.getNodes().isEmpty());
        Assert.assertEquals((long)4L, (long)procDef.getNodes().size());
        Assert.assertFalse((boolean)procDef.getTimers().isEmpty());
        Assert.assertEquals((long)1L, (long)procDef.getTimers().size());
        TimerDesc timer = (TimerDesc)procDef.getTimers().iterator().next();
        Assert.assertEquals((long)0L, (long)timer.getId());
        Assert.assertEquals((long)2L, (long)timer.getNodeId());
        Assert.assertEquals((Object)"timer", (Object)timer.getNodeName());
        Assert.assertEquals((Object)"_3", (Object)timer.getUniqueId());
    }

    @Test
    public void testHiringProcessData() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        String processId = "hiring";
        Collection processTasks = this.bpmn2Service.getTasksDefinitions(deploymentUnit.getIdentifier(), processId);
        Assert.assertEquals((long)4L, (long)processTasks.size());
        Map processData = this.bpmn2Service.getProcessVariables(deploymentUnit.getIdentifier(), processId);
        Assert.assertEquals((long)9L, (long)processData.keySet().size());
        Map taskInputMappings = this.bpmn2Service.getTaskInputMappings(deploymentUnit.getIdentifier(), processId, "HR Interview");
        Assert.assertEquals((long)4L, (long)taskInputMappings.keySet().size());
        Assert.assertEquals((Object)"java.lang.String", taskInputMappings.get("TaskName"));
        Assert.assertEquals((Object)"Object", taskInputMappings.get("GroupId"));
        Assert.assertEquals((Object)"Object", taskInputMappings.get("Comment"));
        Assert.assertEquals((Object)"String", taskInputMappings.get("in_name"));
        Map taskOutputMappings = this.bpmn2Service.getTaskOutputMappings(deploymentUnit.getIdentifier(), processId, "HR Interview");
        Assert.assertEquals((long)4L, (long)taskOutputMappings.keySet().size());
        Assert.assertEquals((Object)"String", taskOutputMappings.get("out_name"));
        Assert.assertEquals((Object)"Integer", taskOutputMappings.get("out_age"));
        Assert.assertEquals((Object)"String", taskOutputMappings.get("out_mail"));
        Assert.assertEquals((Object)"Integer", taskOutputMappings.get("out_score"));
        Map associatedEntities = this.bpmn2Service.getAssociatedEntities(deploymentUnit.getIdentifier(), processId);
        Assert.assertEquals((long)4L, (long)associatedEntities.keySet().size());
        Map allServiceTasks = this.bpmn2Service.getServiceTasks(deploymentUnit.getIdentifier(), processId);
        Assert.assertEquals((long)2L, (long)allServiceTasks.keySet().size());
    }

    @Test
    public void testFindReusableSubProcesses() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        String theString = "ParentProcess";
        Assert.assertNotNull((Object)theString);
        Collection reusableProcesses = this.bpmn2Service.getReusableSubProcesses(deploymentUnit.getIdentifier(), theString);
        Assert.assertNotNull((Object)reusableProcesses);
        Assert.assertEquals((long)1L, (long)reusableProcesses.size());
        Assert.assertEquals((Object)"org.jbpm.signal", reusableProcesses.iterator().next());
    }

    @Test
    public void itemRefIssue() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        String processId = "itemrefissue";
        Map processData = this.bpmn2Service.getProcessVariables(deploymentUnit.getIdentifier(), processId);
        Assert.assertNotNull((Object)processData);
    }

    @Test
    public void testHumanTaskProcessNoIO() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        String processId = "UserTask";
        Collection processTasks = this.bpmn2Service.getTasksDefinitions(deploymentUnit.getIdentifier(), processId);
        Assert.assertEquals((long)1L, (long)processTasks.size());
        Map processData = this.bpmn2Service.getProcessVariables(deploymentUnit.getIdentifier(), processId);
        Assert.assertEquals((long)0L, (long)processData.keySet().size());
        Map taskInputMappings = this.bpmn2Service.getTaskInputMappings(deploymentUnit.getIdentifier(), processId, "Hello");
        Assert.assertEquals((long)0L, (long)taskInputMappings.keySet().size());
        Map taskOutputMappings = this.bpmn2Service.getTaskOutputMappings(deploymentUnit.getIdentifier(), processId, "Hello");
        Assert.assertEquals((long)0L, (long)taskOutputMappings.keySet().size());
        Map associatedEntities = this.bpmn2Service.getAssociatedEntities(deploymentUnit.getIdentifier(), processId);
        Assert.assertEquals((long)1L, (long)associatedEntities.keySet().size());
    }

    @Test
    public void testHumanTaskProcessBeforeAndAfterUndeploy() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        String processId = "org.jbpm.writedocument";
        ProcessDefinition procDef = this.bpmn2Service.getProcessDefinition(deploymentUnit.getIdentifier(), processId);
        Assert.assertNotNull((Object)procDef);
        Assert.assertEquals((Object)procDef.getId(), (Object)"org.jbpm.writedocument");
        Assert.assertEquals((Object)procDef.getName(), (Object)"humanTaskSample");
        Assert.assertEquals((Object)procDef.getKnowledgeType(), (Object)"PROCESS");
        Assert.assertEquals((Object)procDef.getPackageName(), (Object)"defaultPackage");
        Assert.assertEquals((Object)procDef.getType(), (Object)"RuleFlow");
        Assert.assertEquals((Object)procDef.getVersion(), (Object)"3");
        Assert.assertFalse((boolean)procDef.getNodes().isEmpty());
        Assert.assertEquals((long)8L, (long)procDef.getNodes().size());
        Assert.assertTrue((boolean)procDef.getTimers().isEmpty());
        this.deploymentService.undeploy((DeploymentUnit)deploymentUnit);
        this.units.remove(deploymentUnit);
        try {
            this.bpmn2Service.getProcessDefinition(deploymentUnit.getIdentifier(), processId);
            Assert.fail((String)"DeploymentNotFoundException was not thrown");
        }
        catch (DeploymentNotFoundException deploymentNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testObjectVariable() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        String processId = "ObjectVariableProcess";
        ProcessDefinition procDef = this.bpmn2Service.getProcessDefinition(deploymentUnit.getIdentifier(), processId);
        Assert.assertNotNull((Object)procDef);
        Assert.assertEquals((Object)procDef.getId(), (Object)"ObjectVariableProcess");
        Assert.assertEquals((Object)procDef.getName(), (Object)"ObjectVariableProcess");
        Assert.assertEquals((Object)procDef.getKnowledgeType(), (Object)"PROCESS");
        Assert.assertEquals((Object)procDef.getPackageName(), (Object)"defaultPackage");
        Assert.assertEquals((Object)procDef.getType(), (Object)"RuleFlow");
        Assert.assertEquals((Object)procDef.getVersion(), (Object)"1");
        Assert.assertFalse((boolean)procDef.getNodes().isEmpty());
        Assert.assertEquals((long)3L, (long)procDef.getNodes().size());
        Assert.assertTrue((boolean)procDef.getTimers().isEmpty());
        Map processData = this.bpmn2Service.getProcessVariables(deploymentUnit.getIdentifier(), processId);
        Assert.assertEquals((Object)"String", processData.get("type"));
        Assert.assertEquals((Object)"Object", processData.get("myobject"));
        Assert.assertEquals((long)2L, (long)processData.keySet().size());
    }

    @Test(expected=DeploymentNotFoundException.class)
    public void testGetProcessDefinitionUndeployedDeploymentUnit() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        this.deploymentService.undeploy((DeploymentUnit)deploymentUnit);
        this.units.remove(deploymentUnit);
        this.bpmn2Service.getProcessDefinition(deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
    }

    @Test(expected=DeploymentNotFoundException.class)
    public void testGetProcessDefinitionInvalidDeploymenId() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        this.bpmn2Service.getProcessDefinition("invalidid", "org.jbpm.writedocument");
    }

    @Test(expected=ProcessDefinitionNotFoundException.class)
    public void testGetProcessDefinitionInvalidProcessId() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        this.bpmn2Service.getProcessDefinition(deploymentUnit.getIdentifier(), "org.jbpm.invalidId");
    }
}

