/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.test;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.appformer.maven.support.AFReleaseId;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.kie.test.util.AbstractKieServicesBaseTest;
import org.jbpm.services.api.model.DeploymentUnit;
import org.jbpm.services.api.model.NodeInstanceDesc;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.query.QueryContext;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.query.QueryFilter;
import org.kie.scanner.KieMavenRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventSubProcessServiceImplTest
extends AbstractKieServicesBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(EventSubProcessServiceImplTest.class);
    private List<DeploymentUnit> units = new ArrayList<DeploymentUnit>();

    @Before
    public void prepare() {
        this.configureServices();
        logger.debug("Preparing kjar");
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.jbpm.test", "test-module", "1.0.0");
        ArrayList<String> processes = new ArrayList<String>();
        processes.add("repo/processes/general/BPMN2-EventSubprocessSignal.bpmn2");
        InternalKieModule kJar1 = this.createKieJar(ks, releaseId, processes);
        File pom = new File("target/kmodule", "pom.xml");
        pom.getParentFile().mkdir();
        try {
            FileOutputStream fs = new FileOutputStream(pom);
            fs.write(this.getPom(releaseId, new ReleaseId[0]).getBytes());
            fs.close();
        }
        catch (Exception fs) {
            // empty catch block
        }
        KieMavenRepository repository = KieMavenRepository.getKieMavenRepository();
        repository.deployArtifact((AFReleaseId)releaseId, kJar1, pom);
    }

    @After
    public void cleanup() {
        EventSubProcessServiceImplTest.cleanupSingletonSessionId();
        if (this.units != null && !this.units.isEmpty()) {
            for (DeploymentUnit unit : this.units) {
                try {
                    this.deploymentService.undeploy(unit);
                }
                catch (Exception exception) {}
            }
            this.units.clear();
        }
        this.close();
    }

    @Test
    public void testStartProcessWithEventSubprocessAndGetWorkItems() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        boolean isDeployed = this.deploymentService.isDeployed(deploymentUnit.getIdentifier());
        Assert.assertTrue((boolean)isDeployed);
        Assert.assertNotNull((Object)this.processService);
        long processInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), "Telesure.Telesure");
        Assert.assertNotNull((Object)processInstanceId);
        ProcessInstance pi = this.processService.getProcessInstance(Long.valueOf(processInstanceId));
        Assert.assertNotNull((Object)pi);
        Collection activeNodes = this.runtimeDataService.getProcessInstanceHistoryActive(processInstanceId, new QueryContext());
        Assert.assertNotNull((Object)activeNodes);
        Assert.assertEquals((long)1L, (long)activeNodes.size());
        Assert.assertEquals((Object)"customer", (Object)((NodeInstanceDesc)activeNodes.iterator().next()).getName());
        List wis = this.processService.getWorkItemByProcessInstance(Long.valueOf(processInstanceId));
        Assert.assertNotNull((Object)wis);
        Assert.assertEquals((long)1L, (long)wis.size());
        Assert.assertEquals((Object)"Human Task", (Object)((WorkItem)wis.get(0)).getName());
        Assert.assertEquals((Object)"customer", (Object)((WorkItem)wis.get(0)).getParameter("NodeName"));
        List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
        Assert.assertEquals((long)1L, (long)tasks.size());
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("towing", true);
        params.put("taxi", true);
        params.put("emergency", false);
        this.userTaskService.completeAutoProgress(((TaskSummary)tasks.get(0)).getId(), "john", params);
        activeNodes = this.runtimeDataService.getProcessInstanceHistoryActive(processInstanceId, new QueryContext());
        Assert.assertNotNull((Object)activeNodes);
        Assert.assertEquals((long)2L, (long)activeNodes.size());
        Iterator it = activeNodes.iterator();
        Assert.assertEquals((Object)"taxiUser", (Object)((NodeInstanceDesc)it.next()).getName());
        Assert.assertEquals((Object)"towingUser", (Object)((NodeInstanceDesc)it.next()).getName());
        wis = this.processService.getWorkItemByProcessInstance(Long.valueOf(processInstanceId));
        Assert.assertNotNull((Object)wis);
        Assert.assertEquals((long)2L, (long)wis.size());
        Assert.assertEquals((Object)"Human Task", (Object)((WorkItem)wis.get(0)).getName());
        Assert.assertEquals((Object)"taxiUser", (Object)((WorkItem)wis.get(0)).getParameter("NodeName"));
        Assert.assertEquals((Object)"Human Task", (Object)((WorkItem)wis.get(1)).getName());
        Assert.assertEquals((Object)"towingUser", (Object)((WorkItem)wis.get(1)).getParameter("NodeName"));
        this.processService.abortProcessInstance(Long.valueOf(processInstanceId));
        pi = this.processService.getProcessInstance(Long.valueOf(processInstanceId));
        Assert.assertNull((Object)pi);
    }
}

