/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.test;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.jbpm.kie.services.impl.CustomIdKModuleDeploymentUnit;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.kie.test.util.AbstractKieServicesBaseTest;
import org.jbpm.services.api.model.DeployedUnit;
import org.jbpm.services.api.model.DeploymentUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.query.QueryContext;
import org.kie.internal.runtime.manager.context.EmptyContext;

public class KModuleDeploymentServiceNoMavenTest
extends AbstractKieServicesBaseTest {
    private String artifactId = "not-existing";
    private String groupId = "org.jbpm.test";
    private String version = "9.9.9";
    private List<DeploymentUnit> units = new ArrayList<DeploymentUnit>();

    @Before
    public void prepare() {
        this.configureServices();
    }

    @After
    public void cleanup() {
        KModuleDeploymentServiceNoMavenTest.cleanupSingletonSessionId();
        if (this.units != null && !this.units.isEmpty()) {
            for (DeploymentUnit unit : this.units) {
                this.deploymentService.undeploy(unit);
            }
            this.units.clear();
        }
        this.close();
    }

    @Test
    public void testDeploymentOfProcesses() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit(this.groupId, this.artifactId, this.version, "KBase-test", "ksession-test");
        KieContainer kieContainer = KieServices.Factory.get().newKieClasspathContainer();
        deploymentUnit.setKieContainer(kieContainer);
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        Assert.assertNotNull((Object)deploymentUnit.getDeploymentDescriptor());
        DeployedUnit deployed = this.deploymentService.getDeployedUnit(deploymentUnit.getIdentifier());
        Assert.assertNotNull((Object)deployed);
        Assert.assertNotNull((Object)deployed.getDeploymentUnit());
        Assert.assertNotNull((Object)deployed.getRuntimeManager());
        Assert.assertEquals((Object)(this.groupId + ":" + this.artifactId + ":" + this.version + ":KBase-test:ksession-test"), (Object)deployed.getDeploymentUnit().getIdentifier());
        Assert.assertNotNull((Object)this.runtimeDataService);
        Collection processes = this.runtimeDataService.getProcesses(new QueryContext());
        Assert.assertNotNull((Object)processes);
        Assert.assertEquals((long)1L, (long)processes.size());
        processes = this.runtimeDataService.getProcessesByDeploymentId(deploymentUnit.getIdentifier(), new QueryContext());
        Assert.assertNotNull((Object)processes);
        Assert.assertEquals((long)1L, (long)processes.size());
        RuntimeManager manager = this.deploymentService.getRuntimeManager(deploymentUnit.getIdentifier());
        Assert.assertNotNull((Object)manager);
        RuntimeEngine engine = manager.getRuntimeEngine(EmptyContext.get());
        Assert.assertNotNull((Object)engine);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", "test");
        ProcessInstance processInstance = engine.getKieSession().startProcess("Import", params);
        Assert.assertEquals((long)2L, (long)processInstance.getState());
    }

    @Test
    public void testDeploymentOfProcessesCustomId() {
        Assert.assertNotNull((Object)this.deploymentService);
        CustomIdKModuleDeploymentUnit deploymentUnit = new CustomIdKModuleDeploymentUnit("test", this.groupId, this.artifactId, this.version, "KBase-test", "ksession-test");
        KieContainer kieContainer = KieServices.Factory.get().newKieClasspathContainer();
        deploymentUnit.setKieContainer(kieContainer);
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        Assert.assertNotNull((Object)deploymentUnit.getDeploymentDescriptor());
        DeployedUnit deployed = this.deploymentService.getDeployedUnit(deploymentUnit.getIdentifier());
        Assert.assertNotNull((Object)deployed);
        Assert.assertNotNull((Object)deployed.getDeploymentUnit());
        Assert.assertNotNull((Object)deployed.getRuntimeManager());
        Assert.assertEquals((Object)"test", (Object)deployed.getDeploymentUnit().getIdentifier());
        Assert.assertNotNull((Object)this.runtimeDataService);
        Collection processes = this.runtimeDataService.getProcesses(new QueryContext());
        Assert.assertNotNull((Object)processes);
        Assert.assertEquals((long)1L, (long)processes.size());
        processes = this.runtimeDataService.getProcessesByDeploymentId(deploymentUnit.getIdentifier(), new QueryContext());
        Assert.assertNotNull((Object)processes);
        Assert.assertEquals((long)1L, (long)processes.size());
        RuntimeManager manager = this.deploymentService.getRuntimeManager(deploymentUnit.getIdentifier());
        Assert.assertNotNull((Object)manager);
        RuntimeEngine engine = manager.getRuntimeEngine(EmptyContext.get());
        Assert.assertNotNull((Object)engine);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", "test");
        ProcessInstance processInstance = engine.getKieSession().startProcess("Import", params);
        Assert.assertEquals((long)2L, (long)processInstance.getState());
    }
}

