/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.test;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.drools.core.command.runtime.process.GetProcessInstanceCommand;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.services.api.ProcessInstanceNotFoundException;
import org.jbpm.services.api.model.DeploymentUnit;
import org.jbpm.test.services.AbstractKieServicesTest;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.command.Command;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItem;
import org.kie.internal.KieInternalServices;
import org.kie.internal.process.CorrelationKey;
import org.kie.internal.runtime.conf.RuntimeStrategy;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;

public class ProcessServiceImplPerProcessInstanceTest
extends AbstractKieServicesTest {
    protected static final String ARTIFACT_ID = "test-module";
    protected static final String GROUP_ID = "org.jbpm.test";
    protected static final String VERSION = "1.0.0";
    private static final String PROCESS_ID_HUMAN_TASK = "org.jbpm.writedocument";
    private static final String PROCESS_ID_SIGNAL = "org.jbpm.signal";

    protected DeploymentUnit createDeploymentUnit(String groupId, String artifactid, String version) throws Exception {
        DeploymentUnit unit = super.createDeploymentUnit(groupId, artifactid, version);
        ((KModuleDeploymentUnit)unit).setStrategy(RuntimeStrategy.PER_PROCESS_INSTANCE);
        return unit;
    }

    protected List<String> getProcessDefinitionFiles() {
        ArrayList<String> processes = new ArrayList<String>();
        processes.add("repo/processes/general/customtask.bpmn");
        processes.add("repo/processes/general/humanTask.bpmn");
        processes.add("repo/processes/general/import.bpmn");
        processes.add("repo/processes/general/signal.bpmn");
        return processes;
    }

    public DeploymentUnit prepareDeploymentUnit() throws Exception {
        return this.createAndDeployUnit(GROUP_ID, ARTIFACT_ID, VERSION);
    }

    @Test
    public void testAbortAlreadyAbortedProcess() {
        long processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), PROCESS_ID_HUMAN_TASK);
        Assert.assertNotNull((Object)processInstanceId);
        this.processService.abortProcessInstance(Long.valueOf(processInstanceId));
        try {
            this.processService.abortProcessInstance(Long.valueOf(processInstanceId));
            Assert.fail((String)"Aborting of already aborted process instance should throw ProcessInstanceNotFoundException.");
        }
        catch (ProcessInstanceNotFoundException processInstanceNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testSignalProcessInstanceAbortedProcess() {
        long processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), PROCESS_ID_SIGNAL);
        Assert.assertNotNull((Object)processInstanceId);
        this.processService.abortProcessInstance(Long.valueOf(processInstanceId));
        try {
            this.processService.signalProcessInstance(Long.valueOf(processInstanceId), "MySignal", null);
            Assert.fail((String)"Signalling of already aborted process instance should throw ProcessInstanceNotFoundException.");
        }
        catch (ProcessInstanceNotFoundException processInstanceNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testGetProcessInstanceAbortedProcess() {
        long processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), PROCESS_ID_SIGNAL);
        Assert.assertNotNull((Object)processInstanceId);
        this.processService.abortProcessInstance(Long.valueOf(processInstanceId));
        try {
            this.processService.getProcessInstance(Long.valueOf(processInstanceId));
            Assert.fail((String)"Getting of already aborted process instance should throw ProcessInstanceNotFoundException.");
        }
        catch (ProcessInstanceNotFoundException processInstanceNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testGetProcessInstanceWithCorrelationKeyAbortedProcess() {
        CorrelationKey key = KieInternalServices.Factory.get().newCorrelationKeyFactory().newCorrelationKey("my business key");
        long processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), PROCESS_ID_SIGNAL, key);
        Assert.assertNotNull((Object)processInstanceId);
        this.processService.abortProcessInstance(Long.valueOf(processInstanceId));
        ProcessInstance processInstance = this.processService.getProcessInstance(key);
        Assert.assertNull((Object)processInstance);
    }

    @Test
    public void testSetProcessVariableAbortedProcess() {
        long processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), PROCESS_ID_HUMAN_TASK);
        Assert.assertNotNull((Object)processInstanceId);
        this.processService.abortProcessInstance(Long.valueOf(processInstanceId));
        try {
            this.processService.setProcessVariable(Long.valueOf(processInstanceId), "approval_reviewComment", (Object)"updated review comment");
            Assert.fail((String)"Setting process variable of already aborted process instance should throw ProcessInstanceNotFoundException.");
        }
        catch (ProcessInstanceNotFoundException processInstanceNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testSetProcessVariablesAbortedProcess() {
        long processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), PROCESS_ID_HUMAN_TASK);
        Assert.assertNotNull((Object)processInstanceId);
        this.processService.abortProcessInstance(Long.valueOf(processInstanceId));
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("approval_document", "updated document");
            params.put("approval_reviewComment", "final review");
            this.processService.setProcessVariables(Long.valueOf(processInstanceId), params);
            Assert.fail((String)"Setting process variables of already aborted process instance should throw ProcessInstanceNotFoundException.");
        }
        catch (ProcessInstanceNotFoundException processInstanceNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testGetProcessInstanceVariableAbortedProcess() {
        long processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), PROCESS_ID_HUMAN_TASK);
        Assert.assertNotNull((Object)processInstanceId);
        this.processService.abortProcessInstance(Long.valueOf(processInstanceId));
        try {
            this.processService.getProcessInstanceVariable(Long.valueOf(processInstanceId), "approval_document");
            Assert.fail((String)"Getting process variable of already aborted process instance should throw ProcessInstanceNotFoundException.");
        }
        catch (ProcessInstanceNotFoundException processInstanceNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testGetProcessInstanceVariablesAbortedProcess() {
        long processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), PROCESS_ID_HUMAN_TASK);
        Assert.assertNotNull((Object)processInstanceId);
        this.processService.abortProcessInstance(Long.valueOf(processInstanceId));
        try {
            this.processService.getProcessInstanceVariables(Long.valueOf(processInstanceId));
            Assert.fail((String)"Getting process variables of already aborted process instance should throw ProcessInstanceNotFoundException.");
        }
        catch (ProcessInstanceNotFoundException processInstanceNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testGetAvailableSignalsAbortedProcess() {
        long processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), PROCESS_ID_SIGNAL);
        Assert.assertNotNull((Object)processInstanceId);
        this.processService.abortProcessInstance(Long.valueOf(processInstanceId));
        try {
            this.processService.getAvailableSignals(Long.valueOf(processInstanceId));
            Assert.fail((String)"Getting available signals of already aborted process instance should throw ProcessInstanceNotFoundException.");
        }
        catch (ProcessInstanceNotFoundException processInstanceNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testGetWorkItemByProcessInstanceAbortedProcess() {
        long processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), PROCESS_ID_HUMAN_TASK);
        Assert.assertNotNull((Object)processInstanceId);
        this.processService.abortProcessInstance(Long.valueOf(processInstanceId));
        try {
            this.processService.getWorkItemByProcessInstance(Long.valueOf(processInstanceId));
            Assert.fail((String)"Getting work items of already aborted process instance should throw ProcessInstanceNotFoundException.");
        }
        catch (ProcessInstanceNotFoundException processInstanceNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testCompleteWorkItemAbortedProcess() {
        long processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), PROCESS_ID_HUMAN_TASK);
        Assert.assertNotNull((Object)processInstanceId);
        List workItems = this.processService.getWorkItemByProcessInstance(Long.valueOf(processInstanceId));
        Assert.assertEquals((long)1L, (long)workItems.size());
        this.processService.abortProcessInstance(Long.valueOf(processInstanceId));
        try {
            this.processService.completeWorkItem(Long.valueOf(((WorkItem)workItems.get(0)).getId()), null);
            Assert.fail((String)"Completing work item of already aborted process instance should throw ProcessInstanceNotFoundException.");
        }
        catch (ProcessInstanceNotFoundException processInstanceNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testAbortWorkItemAbortedProcess() {
        long processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), PROCESS_ID_HUMAN_TASK);
        Assert.assertNotNull((Object)processInstanceId);
        List workItems = this.processService.getWorkItemByProcessInstance(Long.valueOf(processInstanceId));
        Assert.assertEquals((long)1L, (long)workItems.size());
        this.processService.abortProcessInstance(Long.valueOf(processInstanceId));
        try {
            this.processService.abortWorkItem(Long.valueOf(((WorkItem)workItems.get(0)).getId()));
            Assert.fail((String)"Aborting work item of already aborted process instance should throw ProcessInstanceNotFoundException.");
        }
        catch (ProcessInstanceNotFoundException processInstanceNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testGetWorkItemAbortedProcess() {
        long processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), PROCESS_ID_HUMAN_TASK);
        Assert.assertNotNull((Object)processInstanceId);
        List workItems = this.processService.getWorkItemByProcessInstance(Long.valueOf(processInstanceId));
        Assert.assertEquals((long)1L, (long)workItems.size());
        this.processService.abortProcessInstance(Long.valueOf(processInstanceId));
        try {
            this.processService.getWorkItem(Long.valueOf(((WorkItem)workItems.get(0)).getId()));
            Assert.fail((String)"Getting work item of already aborted process instance should throw ProcessInstanceNotFoundException.");
        }
        catch (ProcessInstanceNotFoundException processInstanceNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testExecuteCommandOnAbortedProcess() {
        long processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), PROCESS_ID_HUMAN_TASK);
        Assert.assertNotNull((Object)processInstanceId);
        this.processService.abortProcessInstance(Long.valueOf(processInstanceId));
        try {
            this.processService.execute(this.deploymentUnit.getIdentifier(), (Command)new GetProcessInstanceCommand(Long.valueOf(processInstanceId)));
            Assert.fail((String)"Executing command on already aborted process instance should throw ProcessInstanceNotFoundException.");
        }
        catch (ProcessInstanceNotFoundException processInstanceNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testExecuteCommandWithContextOnAbortedProcess() {
        long processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), PROCESS_ID_HUMAN_TASK);
        Assert.assertNotNull((Object)processInstanceId);
        this.processService.abortProcessInstance(Long.valueOf(processInstanceId));
        try {
            this.processService.execute(this.deploymentUnit.getIdentifier(), (Context)ProcessInstanceIdContext.get((Long)processInstanceId), (Command)new GetProcessInstanceCommand(Long.valueOf(processInstanceId)));
            Assert.fail((String)"Executing command with context on already aborted process instance should throw ProcessInstanceNotFoundException.");
        }
        catch (ProcessInstanceNotFoundException processInstanceNotFoundException) {
            // empty catch block
        }
    }
}

