/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.test;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.naming.InitialContext;
import javax.transaction.UserTransaction;
import org.appformer.maven.support.AFReleaseId;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.core.command.runtime.process.GetProcessInstanceCommand;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.kie.test.util.AbstractKieServicesBaseTest;
import org.jbpm.services.api.ProcessInstanceNotFoundException;
import org.jbpm.services.api.model.DeploymentUnit;
import org.jbpm.services.api.model.NodeInstanceDesc;
import org.jbpm.services.api.model.ProcessInstanceDesc;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.command.Command;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.query.QueryContext;
import org.kie.internal.KieInternalServices;
import org.kie.internal.process.CorrelationKey;
import org.kie.internal.runtime.conf.DeploymentDescriptor;
import org.kie.internal.runtime.conf.RuntimeStrategy;
import org.kie.internal.runtime.manager.deploy.DeploymentDescriptorImpl;
import org.kie.scanner.KieMavenRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessServiceImplTest
extends AbstractKieServicesBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(ProcessServiceImplTest.class);
    private List<DeploymentUnit> units = new ArrayList<DeploymentUnit>();

    @Before
    public void prepare() {
        this.configureServices();
        logger.debug("Preparing kjar");
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.jbpm.test", "test-module", "1.0.0");
        ArrayList<String> processes = new ArrayList<String>();
        processes.add("repo/processes/general/customtask.bpmn");
        processes.add("repo/processes/general/humanTask.bpmn");
        processes.add("repo/processes/general/import.bpmn");
        processes.add("repo/processes/general/signal.bpmn");
        processes.add("repo/processes/general/signalWithExpression.bpmn2");
        processes.add("repo/processes/general/callactivity.bpmn");
        processes.add("repo/processes/general/boundarysignal.bpmn2");
        processes.add("repo/processes/general/boundarysignalwithexpression.bpmn2");
        processes.add("repo/processes/parentProcess/parentWithIndependentSubProcessOne.bpmn");
        processes.add("repo/processes/parentProcess/parentWithIndependentSubProcess.bpmn");
        processes.add("repo/processes/parentProcess/parentWithNotIndepententSubProcess.bpmn");
        processes.add("repo/processes/parentProcess/subprocess.bpmn");
        InternalKieModule kJar1 = this.createKieJar(ks, releaseId, processes);
        File pom = new File("target/kmodule", "pom.xml");
        pom.getParentFile().mkdir();
        try {
            FileOutputStream fs = new FileOutputStream(pom);
            fs.write(this.getPom(releaseId, new ReleaseId[0]).getBytes());
            fs.close();
        }
        catch (Exception fs) {
            // empty catch block
        }
        KieMavenRepository repository = KieMavenRepository.getKieMavenRepository();
        repository.deployArtifact((AFReleaseId)releaseId, kJar1, pom);
        ReleaseId releaseId3 = ks.newReleaseId("org.jbpm.test", "test-module", "1.1.0");
        InternalKieModule kJar3 = this.createKieJar(ks, releaseId3, processes);
        File pom3 = new File("target/kmodule3", "pom.xml");
        pom3.getParentFile().mkdirs();
        try {
            FileOutputStream fs = new FileOutputStream(pom3);
            fs.write(this.getPom(releaseId3, new ReleaseId[0]).getBytes());
            fs.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        repository = KieMavenRepository.getKieMavenRepository();
        repository.deployArtifact((AFReleaseId)releaseId3, kJar3, pom3);
    }

    @After
    public void cleanup() {
        ProcessServiceImplTest.cleanupSingletonSessionId();
        if (this.units != null && !this.units.isEmpty()) {
            for (DeploymentUnit unit : this.units) {
                try {
                    this.deploymentService.undeploy(unit);
                }
                catch (Exception exception) {}
            }
            this.units.clear();
        }
        this.close();
    }

    @Test
    public void testStartProcess() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        Assert.assertNotNull((Object)this.processService);
        long processInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), "customtask");
        Assert.assertNotNull((Object)processInstanceId);
        ProcessInstance pi = this.processService.getProcessInstance(Long.valueOf(processInstanceId));
        Assert.assertNull((Object)pi);
    }

    @Test
    public void testStartProcessWithParms() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        Assert.assertNotNull((Object)this.processService);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", "test");
        long processInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), "customtask", params);
        Assert.assertNotNull((Object)processInstanceId);
        ProcessInstance pi = this.processService.getProcessInstance(Long.valueOf(processInstanceId));
        Assert.assertNull((Object)pi);
    }

    @Test
    public void testStartProcessWithCorrelationKey() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        Assert.assertNotNull((Object)this.processService);
        CorrelationKey key = KieInternalServices.Factory.get().newCorrelationKeyFactory().newCorrelationKey("my business key");
        long processInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), "customtask", key);
        Assert.assertNotNull((Object)processInstanceId);
        ProcessInstance pi = this.processService.getProcessInstance(key);
        Assert.assertNull((Object)pi);
    }

    @Test
    public void testStartProcessWithParmsWithCorrelationKey() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        Assert.assertNotNull((Object)this.processService);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", "test");
        CorrelationKey key = KieInternalServices.Factory.get().newCorrelationKeyFactory().newCorrelationKey("my business key");
        long processInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), "customtask", key, params);
        Assert.assertNotNull((Object)processInstanceId);
        ProcessInstance pi = this.processService.getProcessInstance(key);
        Assert.assertNull((Object)pi);
    }

    @Test
    public void testStartAndAbortProcess() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        Assert.assertNotNull((Object)this.processService);
        boolean isDeployed = this.deploymentService.isDeployed(deploymentUnit.getIdentifier());
        Assert.assertTrue((boolean)isDeployed);
        long processInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)processInstanceId);
        ProcessInstance pi = this.processService.getProcessInstance(Long.valueOf(processInstanceId));
        Assert.assertNotNull((Object)pi);
        this.processService.abortProcessInstance(Long.valueOf(processInstanceId));
        pi = this.processService.getProcessInstance(Long.valueOf(processInstanceId));
        Assert.assertNull((Object)pi);
    }

    @Test
    public void testStartAndAbortProcesses() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        boolean isDeployed = this.deploymentService.isDeployed(deploymentUnit.getIdentifier());
        Assert.assertTrue((boolean)isDeployed);
        Assert.assertNotNull((Object)this.processService);
        long processInstanceId1 = this.processService.startProcess(deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)processInstanceId1);
        ProcessInstance pi = this.processService.getProcessInstance(Long.valueOf(processInstanceId1));
        Assert.assertNotNull((Object)pi);
        long processInstanceId2 = this.processService.startProcess(deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)processInstanceId2);
        ProcessInstance pi2 = this.processService.getProcessInstance(Long.valueOf(processInstanceId2));
        Assert.assertNotNull((Object)pi2);
        ArrayList<Long> instances = new ArrayList<Long>();
        instances.add(processInstanceId1);
        instances.add(processInstanceId2);
        this.processService.abortProcessInstances(instances);
        pi = this.processService.getProcessInstance(Long.valueOf(processInstanceId1));
        Assert.assertNull((Object)pi);
        pi2 = this.processService.getProcessInstance(Long.valueOf(processInstanceId2));
        Assert.assertNull((Object)pi2);
    }

    @Test
    public void testAbortedParentProcessAndChildProcessInProcessInstanceListWithNotIndenpendentSubProcess() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        Assert.assertNotNull((Object)this.processService);
        boolean isDeployed = this.deploymentService.isDeployed(deploymentUnit.getIdentifier());
        Assert.assertTrue((boolean)isDeployed);
        Assert.assertNotNull((Object)this.processService);
        long parentProcessInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), "testone.parentWithNotIndepententSubProcess");
        Assert.assertNotNull((Object)parentProcessInstanceId);
        ProcessInstance pi = this.processService.getProcessInstance(Long.valueOf(parentProcessInstanceId));
        Assert.assertNotNull((Object)pi);
        this.testResultForAbortedParentProcessAndChildProcessInProcessInstanceList(parentProcessInstanceId);
    }

    private void testResultForAbortedParentProcessAndChildProcessInProcessInstanceList(Long parentProcessInstanceId) {
        Collection instances = this.runtimeDataService.getProcessInstancesByParent(parentProcessInstanceId, Arrays.asList(1), new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)2L, (long)instances.size());
        List processInstanceList = instances.stream().map(p -> p.getId()).collect(Collectors.toList());
        processInstanceList.add(0, parentProcessInstanceId);
        this.processService.abortProcessInstances(processInstanceList);
        ProcessInstance parent = this.processService.getProcessInstance(parentProcessInstanceId);
        Assert.assertNull((Object)parent);
        instances = this.runtimeDataService.getProcessInstancesByParent(parentProcessInstanceId, Arrays.asList(3), new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)2L, (long)instances.size());
    }

    @Test
    public void testAbortedParentProcessAndChildProcessInProcessInstanceListWithIndenpendentSubProcessOne() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        Assert.assertNotNull((Object)this.processService);
        boolean isDeployed = this.deploymentService.isDeployed(deploymentUnit.getIdentifier());
        Assert.assertTrue((boolean)isDeployed);
        Assert.assertNotNull((Object)this.processService);
        long parentProcessInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), "testone.parentWithIndependentSubProcessOne");
        Assert.assertNotNull((Object)parentProcessInstanceId);
        ProcessInstance pi = this.processService.getProcessInstance(Long.valueOf(parentProcessInstanceId));
        Assert.assertNotNull((Object)pi);
        this.testResultForAbortedParentProcessAndChildProcessInProcessInstanceList(parentProcessInstanceId);
    }

    @Test
    public void testAbortedParentProcessAndChildProcessInProcessInstanceListWithIndenpendentSubProcess() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        Assert.assertNotNull((Object)this.processService);
        boolean isDeployed = this.deploymentService.isDeployed(deploymentUnit.getIdentifier());
        Assert.assertTrue((boolean)isDeployed);
        Assert.assertNotNull((Object)this.processService);
        long parentProcessInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), "testone.parentWithIndependentSubProcess");
        Assert.assertNotNull((Object)parentProcessInstanceId);
        ProcessInstance pi = this.processService.getProcessInstance(Long.valueOf(parentProcessInstanceId));
        Assert.assertNull((Object)pi);
        this.testResultForAbortedParentProcessAndChildProcessInProcessInstanceList(parentProcessInstanceId);
    }

    @Test
    public void testStartAndSignalProcess() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        boolean isDeployed = this.deploymentService.isDeployed(deploymentUnit.getIdentifier());
        Assert.assertTrue((boolean)isDeployed);
        Assert.assertNotNull((Object)this.processService);
        long processInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), "org.jbpm.signal");
        Assert.assertNotNull((Object)processInstanceId);
        ProcessInstance pi = this.processService.getProcessInstance(Long.valueOf(processInstanceId));
        Assert.assertNotNull((Object)pi);
        Collection signals = this.processService.getAvailableSignals(Long.valueOf(processInstanceId));
        Assert.assertNotNull((Object)signals);
        Assert.assertEquals((long)1L, (long)signals.size());
        Assert.assertTrue((boolean)signals.contains("MySignal"));
        this.processService.signalProcessInstance(Long.valueOf(processInstanceId), "MySignal", null);
        pi = this.processService.getProcessInstance(Long.valueOf(processInstanceId));
        Assert.assertNull((Object)pi);
    }

    @Test
    public void testStartAndSignalProcessWithExpression() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        boolean isDeployed = this.deploymentService.isDeployed(deploymentUnit.getIdentifier());
        Assert.assertTrue((boolean)isDeployed);
        Assert.assertNotNull((Object)this.processService);
        long processInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), "org.jbpm.signalWithExpression");
        Assert.assertNotNull((Object)processInstanceId);
        ProcessInstance pi = this.processService.getProcessInstance(Long.valueOf(processInstanceId));
        Assert.assertNotNull((Object)pi);
        Collection signals = this.processService.getAvailableSignals(Long.valueOf(processInstanceId));
        Assert.assertNotNull((Object)signals);
        Assert.assertEquals((long)1L, (long)signals.size());
        Assert.assertTrue((boolean)signals.contains("MySignal"));
        this.processService.signalProcessInstance(Long.valueOf(processInstanceId), "MySignal", null);
        pi = this.processService.getProcessInstance(Long.valueOf(processInstanceId));
        Assert.assertNull((Object)pi);
    }

    @Test
    public void testStartAndSignalProcesses() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        boolean isDeployed = this.deploymentService.isDeployed(deploymentUnit.getIdentifier());
        Assert.assertTrue((boolean)isDeployed);
        Assert.assertNotNull((Object)this.processService);
        long processInstanceId1 = this.processService.startProcess(deploymentUnit.getIdentifier(), "org.jbpm.signal");
        Assert.assertNotNull((Object)processInstanceId1);
        ProcessInstance pi = this.processService.getProcessInstance(Long.valueOf(processInstanceId1));
        Assert.assertNotNull((Object)pi);
        long processInstanceId2 = this.processService.startProcess(deploymentUnit.getIdentifier(), "org.jbpm.signal");
        Assert.assertNotNull((Object)processInstanceId2);
        ProcessInstance pi2 = this.processService.getProcessInstance(Long.valueOf(processInstanceId2));
        Assert.assertNotNull((Object)pi2);
        ArrayList<Long> instances = new ArrayList<Long>();
        instances.add(processInstanceId1);
        instances.add(processInstanceId2);
        this.processService.signalProcessInstances(instances, "MySignal", null);
        pi = this.processService.getProcessInstance(Long.valueOf(processInstanceId1));
        Assert.assertNull((Object)pi);
        pi2 = this.processService.getProcessInstance(Long.valueOf(processInstanceId2));
        Assert.assertNull((Object)pi2);
    }

    @Test
    public void testStartAndSignal() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        boolean isDeployed = this.deploymentService.isDeployed(deploymentUnit.getIdentifier());
        Assert.assertTrue((boolean)isDeployed);
        Assert.assertNotNull((Object)this.processService);
        long processInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), "org.jbpm.signal");
        Assert.assertNotNull((Object)processInstanceId);
        long processInstanceId2 = this.processService.startProcess(deploymentUnit.getIdentifier(), "org.jbpm.signal");
        Assert.assertNotNull((Object)processInstanceId2);
        ProcessInstance pi = this.processService.getProcessInstance(Long.valueOf(processInstanceId));
        Assert.assertNotNull((Object)pi);
        pi = this.processService.getProcessInstance(Long.valueOf(processInstanceId2));
        Assert.assertNotNull((Object)pi);
        this.processService.signalEvent(deploymentUnit.getIdentifier(), "MySignal", null);
        pi = this.processService.getProcessInstance(Long.valueOf(processInstanceId));
        Assert.assertNull((Object)pi);
        pi = this.processService.getProcessInstance(Long.valueOf(processInstanceId2));
        Assert.assertNull((Object)pi);
    }

    @Test
    public void testStartProcessAndChangeVariables() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        boolean isDeployed = this.deploymentService.isDeployed(deploymentUnit.getIdentifier());
        Assert.assertTrue((boolean)isDeployed);
        Assert.assertNotNull((Object)this.processService);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("approval_document", "test");
        params.put("approval_reviewComment", "need review");
        long processInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), "org.jbpm.writedocument", params);
        Assert.assertNotNull((Object)processInstanceId);
        ProcessInstance pi = this.processService.getProcessInstance(Long.valueOf(processInstanceId));
        Assert.assertNotNull((Object)pi);
        Object variableValue = this.processService.getProcessInstanceVariable(Long.valueOf(processInstanceId), "approval_document");
        Assert.assertNotNull((Object)variableValue);
        Assert.assertTrue((boolean)(variableValue instanceof String));
        Assert.assertEquals((Object)"test", (Object)variableValue);
        Map variables = this.processService.getProcessInstanceVariables(Long.valueOf(processInstanceId));
        Assert.assertNotNull((Object)variables);
        Assert.assertEquals((long)2L, (long)variables.size());
        Assert.assertTrue((boolean)variables.containsKey("approval_document"));
        Assert.assertTrue((boolean)variables.containsKey("approval_reviewComment"));
        Assert.assertEquals((Object)"test", variables.get("approval_document"));
        Assert.assertEquals((Object)"need review", variables.get("approval_reviewComment"));
        this.processService.setProcessVariable(Long.valueOf(processInstanceId), "approval_reviewComment", (Object)"updated review comment");
        variableValue = this.processService.getProcessInstanceVariable(Long.valueOf(processInstanceId), "approval_reviewComment");
        Assert.assertNotNull((Object)variableValue);
        Assert.assertTrue((boolean)(variableValue instanceof String));
        Assert.assertEquals((Object)"updated review comment", (Object)variableValue);
        params = new HashMap();
        params.put("approval_document", "updated document");
        params.put("approval_reviewComment", "final review");
        this.processService.setProcessVariables(Long.valueOf(processInstanceId), params);
        variables = this.processService.getProcessInstanceVariables(Long.valueOf(processInstanceId));
        Assert.assertNotNull((Object)variables);
        Assert.assertEquals((long)2L, (long)variables.size());
        Assert.assertTrue((boolean)variables.containsKey("approval_document"));
        Assert.assertTrue((boolean)variables.containsKey("approval_reviewComment"));
        Assert.assertEquals((Object)"updated document", variables.get("approval_document"));
        Assert.assertEquals((Object)"final review", variables.get("approval_reviewComment"));
        this.processService.abortProcessInstance(Long.valueOf(processInstanceId));
        pi = this.processService.getProcessInstance(Long.valueOf(processInstanceId));
        Assert.assertNull((Object)pi);
    }

    @Test
    public void testStartProcessAndCompleteWorkItem() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        boolean isDeployed = this.deploymentService.isDeployed(deploymentUnit.getIdentifier());
        Assert.assertTrue((boolean)isDeployed);
        Assert.assertNotNull((Object)this.processService);
        long processInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)processInstanceId);
        ProcessInstance pi = this.processService.getProcessInstance(Long.valueOf(processInstanceId));
        Assert.assertNotNull((Object)pi);
        Collection activeNodes = this.runtimeDataService.getProcessInstanceHistoryActive(processInstanceId, new QueryContext());
        Assert.assertNotNull((Object)activeNodes);
        Assert.assertEquals((long)1L, (long)activeNodes.size());
        Assert.assertEquals((Object)"Write a Document", (Object)((NodeInstanceDesc)activeNodes.iterator().next()).getName());
        HashMap<String, String> outcome = new HashMap<String, String>();
        outcome.put("Result", "here is my first document");
        this.processService.completeWorkItem(((NodeInstanceDesc)activeNodes.iterator().next()).getWorkItemId(), outcome);
        activeNodes = this.runtimeDataService.getProcessInstanceHistoryActive(processInstanceId, new QueryContext());
        Assert.assertNotNull((Object)activeNodes);
        Assert.assertEquals((long)2L, (long)activeNodes.size());
        Object variableValue = this.processService.getProcessInstanceVariable(Long.valueOf(processInstanceId), "approval_document");
        Assert.assertNotNull((Object)variableValue);
        Assert.assertTrue((boolean)(variableValue instanceof String));
        Assert.assertEquals((Object)"here is my first document", (Object)variableValue);
        this.processService.abortProcessInstance(Long.valueOf(processInstanceId));
        pi = this.processService.getProcessInstance(Long.valueOf(processInstanceId));
        Assert.assertNull((Object)pi);
    }

    @Test
    public void testStartProcessAndAbortWorkItem() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        boolean isDeployed = this.deploymentService.isDeployed(deploymentUnit.getIdentifier());
        Assert.assertTrue((boolean)isDeployed);
        Assert.assertNotNull((Object)this.processService);
        long processInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)processInstanceId);
        ProcessInstance pi = this.processService.getProcessInstance(Long.valueOf(processInstanceId));
        Assert.assertNotNull((Object)pi);
        Collection activeNodes = this.runtimeDataService.getProcessInstanceHistoryActive(processInstanceId, new QueryContext());
        Assert.assertNotNull((Object)activeNodes);
        Assert.assertEquals((long)1L, (long)activeNodes.size());
        Assert.assertEquals((Object)"Write a Document", (Object)((NodeInstanceDesc)activeNodes.iterator().next()).getName());
        this.processService.abortWorkItem(((NodeInstanceDesc)activeNodes.iterator().next()).getWorkItemId());
        activeNodes = this.runtimeDataService.getProcessInstanceHistoryActive(processInstanceId, new QueryContext());
        Assert.assertNotNull((Object)activeNodes);
        Assert.assertEquals((long)2L, (long)activeNodes.size());
        Object variableValue = this.processService.getProcessInstanceVariable(Long.valueOf(processInstanceId), "approval_document");
        Assert.assertNull((Object)variableValue);
        this.processService.abortProcessInstance(Long.valueOf(processInstanceId));
        pi = this.processService.getProcessInstance(Long.valueOf(processInstanceId));
        Assert.assertNull((Object)pi);
    }

    @Test
    public void testStartProcessAndGetWorkItem() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        boolean isDeployed = this.deploymentService.isDeployed(deploymentUnit.getIdentifier());
        Assert.assertTrue((boolean)isDeployed);
        Assert.assertNotNull((Object)this.processService);
        long processInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)processInstanceId);
        ProcessInstance pi = this.processService.getProcessInstance(Long.valueOf(processInstanceId));
        Assert.assertNotNull((Object)pi);
        Collection activeNodes = this.runtimeDataService.getProcessInstanceHistoryActive(processInstanceId, new QueryContext());
        Assert.assertNotNull((Object)activeNodes);
        Assert.assertEquals((long)1L, (long)activeNodes.size());
        Assert.assertEquals((Object)"Write a Document", (Object)((NodeInstanceDesc)activeNodes.iterator().next()).getName());
        WorkItem wi = this.processService.getWorkItem(((NodeInstanceDesc)activeNodes.iterator().next()).getWorkItemId());
        Assert.assertNotNull((Object)wi);
        Assert.assertEquals((Object)"Human Task", (Object)wi.getName());
        Assert.assertEquals((Object)"Write a Document", (Object)wi.getParameter("NodeName"));
        this.processService.abortProcessInstance(Long.valueOf(processInstanceId));
        pi = this.processService.getProcessInstance(Long.valueOf(processInstanceId));
        Assert.assertNull((Object)pi);
    }

    @Test
    public void testStartProcessAndGetWorkItems() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        boolean isDeployed = this.deploymentService.isDeployed(deploymentUnit.getIdentifier());
        Assert.assertTrue((boolean)isDeployed);
        Assert.assertNotNull((Object)this.processService);
        long processInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)processInstanceId);
        ProcessInstance pi = this.processService.getProcessInstance(Long.valueOf(processInstanceId));
        Assert.assertNotNull((Object)pi);
        Collection activeNodes = this.runtimeDataService.getProcessInstanceHistoryActive(processInstanceId, new QueryContext());
        Assert.assertNotNull((Object)activeNodes);
        Assert.assertEquals((long)1L, (long)activeNodes.size());
        Assert.assertEquals((Object)"Write a Document", (Object)((NodeInstanceDesc)activeNodes.iterator().next()).getName());
        List wis = this.processService.getWorkItemByProcessInstance(Long.valueOf(processInstanceId));
        Assert.assertNotNull((Object)wis);
        Assert.assertEquals((long)1L, (long)wis.size());
        Assert.assertEquals((Object)"Human Task", (Object)((WorkItem)wis.get(0)).getName());
        Assert.assertEquals((Object)"Write a Document", (Object)((WorkItem)wis.get(0)).getParameter("NodeName"));
        this.processService.abortProcessInstance(Long.valueOf(processInstanceId));
        pi = this.processService.getProcessInstance(Long.valueOf(processInstanceId));
        Assert.assertNull((Object)pi);
    }

    @Test
    public void testStartProcessAndExecuteCmd() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        boolean isDeployed = this.deploymentService.isDeployed(deploymentUnit.getIdentifier());
        Assert.assertTrue((boolean)isDeployed);
        Assert.assertNotNull((Object)this.processService);
        long processInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)processInstanceId);
        ProcessInstance pi = (ProcessInstance)this.processService.execute(deploymentUnit.getIdentifier(), (Command)new GetProcessInstanceCommand(Long.valueOf(processInstanceId)));
        Assert.assertNotNull((Object)pi);
        this.processService.abortProcessInstance(Long.valueOf(processInstanceId));
        pi = this.processService.getProcessInstance(Long.valueOf(processInstanceId));
        Assert.assertNull((Object)pi);
    }

    @Test
    public void testStartProcessFromLatestDeployment() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        KModuleDeploymentUnit deploymentUnit2 = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.1.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        boolean isDeployed = this.deploymentService.isDeployed(deploymentUnit.getIdentifier());
        Assert.assertTrue((boolean)isDeployed);
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit2);
        this.units.add((DeploymentUnit)deploymentUnit2);
        isDeployed = this.deploymentService.isDeployed(deploymentUnit2.getIdentifier());
        Assert.assertTrue((boolean)isDeployed);
        Assert.assertNotNull((Object)this.processService);
        long processInstanceId = this.processService.startProcess("org.jbpm.test:test-module:LATEST", "customtask");
        Assert.assertNotNull((Object)processInstanceId);
        ProcessInstance pi = this.processService.getProcessInstance(Long.valueOf(processInstanceId));
        Assert.assertNull((Object)pi);
        ProcessInstanceDesc piDesc = this.runtimeDataService.getProcessInstanceById(processInstanceId);
        Assert.assertNotNull((Object)piDesc);
        Assert.assertEquals((Object)deploymentUnit2.getIdentifier(), (Object)piDesc.getDeploymentId());
    }

    @Test
    public void testStartProcessAfterDeactivation() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        boolean isDeployed = this.deploymentService.isDeployed(deploymentUnit.getIdentifier());
        Assert.assertTrue((boolean)isDeployed);
        Assert.assertNotNull((Object)this.processService);
        this.deploymentService.deactivate(deploymentUnit.getIdentifier());
        try {
            this.processService.startProcess(deploymentUnit.getIdentifier(), "customtask");
            Assert.fail((String)"Deployment is deactivated so cannot start new process instances");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Deployment org.jbpm.test:test-module:1.0.0 is not active"));
        }
    }

    @Test
    public void testStartProcessAndCompleteWorkItemAfterDeactivation() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        boolean isDeployed = this.deploymentService.isDeployed(deploymentUnit.getIdentifier());
        Assert.assertTrue((boolean)isDeployed);
        Assert.assertNotNull((Object)this.processService);
        long processInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)processInstanceId);
        ProcessInstance pi = this.processService.getProcessInstance(Long.valueOf(processInstanceId));
        Assert.assertNotNull((Object)pi);
        this.deploymentService.deactivate(deploymentUnit.getIdentifier());
        Collection activeNodes = this.runtimeDataService.getProcessInstanceHistoryActive(processInstanceId, new QueryContext());
        Assert.assertNotNull((Object)activeNodes);
        Assert.assertEquals((long)1L, (long)activeNodes.size());
        Assert.assertEquals((Object)"Write a Document", (Object)((NodeInstanceDesc)activeNodes.iterator().next()).getName());
        HashMap<String, String> outcome = new HashMap<String, String>();
        outcome.put("Result", "here is my first document");
        this.processService.completeWorkItem(((NodeInstanceDesc)activeNodes.iterator().next()).getWorkItemId(), outcome);
        activeNodes = this.runtimeDataService.getProcessInstanceHistoryActive(processInstanceId, new QueryContext());
        Assert.assertNotNull((Object)activeNodes);
        Assert.assertEquals((long)2L, (long)activeNodes.size());
        Object variableValue = this.processService.getProcessInstanceVariable(Long.valueOf(processInstanceId), "approval_document");
        Assert.assertNotNull((Object)variableValue);
        Assert.assertTrue((boolean)(variableValue instanceof String));
        Assert.assertEquals((Object)"here is my first document", (Object)variableValue);
        this.processService.abortProcessInstance(Long.valueOf(processInstanceId));
        pi = this.processService.getProcessInstance(Long.valueOf(processInstanceId));
        Assert.assertNull((Object)pi);
    }

    @Test
    public void testStartAndAbortProcessInExternalTransactionsSingleton() throws Exception {
        this.testStartAndAbortProcessInExternalTransactions(RuntimeStrategy.SINGLETON);
    }

    @Test
    public void testStartAndAbortProcessInExternalTransactionsPerRequest() throws Exception {
        this.testStartAndAbortProcessInExternalTransactions(RuntimeStrategy.PER_REQUEST);
    }

    @Test
    public void testStartAndAbortProcessInExternalTransactionsPerProcessInstance() throws Exception {
        this.testStartAndAbortProcessInExternalTransactions(RuntimeStrategy.PER_PROCESS_INSTANCE);
    }

    protected void testStartAndAbortProcessInExternalTransactions(RuntimeStrategy strategy) throws Exception {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        DeploymentDescriptorImpl customDescriptor = new DeploymentDescriptorImpl("org.jbpm.domain");
        customDescriptor.getBuilder().runtimeStrategy(strategy);
        deploymentUnit.setDeploymentDescriptor((DeploymentDescriptor)customDescriptor);
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        Assert.assertNotNull((Object)this.processService);
        boolean isDeployed = this.deploymentService.isDeployed(deploymentUnit.getIdentifier());
        Assert.assertTrue((boolean)isDeployed);
        UserTransaction ut = (UserTransaction)InitialContext.doLookup("java:comp/UserTransaction");
        ut.begin();
        long processInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)processInstanceId);
        this.processService.signalEvent(deploymentUnit.getIdentifier(), "test", null);
        ut.commit();
        ut.begin();
        this.processService.abortProcessInstance(Long.valueOf(processInstanceId));
        ut.commit();
        try {
            this.processService.getProcessInstance(Long.valueOf(processInstanceId));
        }
        catch (ProcessInstanceNotFoundException processInstanceNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testStartAndGetProcessInExternalTransactionsSingleton() throws Exception {
        this.testStartAndGetProcessInExternalTransactions(RuntimeStrategy.SINGLETON);
    }

    @Test
    public void testStartAndGetProcessInExternalTransactionsPerRequest() throws Exception {
        this.testStartAndGetProcessInExternalTransactions(RuntimeStrategy.PER_REQUEST);
    }

    @Test
    public void testStartAndGetProcessInExternalTransactionsPerProcessInstance() throws Exception {
        this.testStartAndGetProcessInExternalTransactions(RuntimeStrategy.PER_PROCESS_INSTANCE);
    }

    protected void testStartAndGetProcessInExternalTransactions(RuntimeStrategy strategy) throws Exception {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        DeploymentDescriptorImpl customDescriptor = new DeploymentDescriptorImpl("org.jbpm.domain");
        customDescriptor.getBuilder().runtimeStrategy(strategy);
        deploymentUnit.setDeploymentDescriptor((DeploymentDescriptor)customDescriptor);
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        Assert.assertNotNull((Object)this.processService);
        boolean isDeployed = this.deploymentService.isDeployed(deploymentUnit.getIdentifier());
        Assert.assertTrue((boolean)isDeployed);
        UserTransaction ut = (UserTransaction)InitialContext.doLookup("java:comp/UserTransaction");
        ut.begin();
        long processInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)processInstanceId);
        ProcessInstance pi = this.processService.getProcessInstance(Long.valueOf(processInstanceId));
        Assert.assertNotNull((Object)pi);
        this.processService.abortProcessInstance(Long.valueOf(processInstanceId));
        ut.commit();
        try {
            this.processService.getProcessInstance(Long.valueOf(processInstanceId));
        }
        catch (ProcessInstanceNotFoundException processInstanceNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testStartProcessAndAbortThenChangeVariables() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("approval_document", "test");
        params.put("approval_reviewComment", "need review");
        long processInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), "org.jbpm.writedocument", params);
        Assert.assertNotNull((Object)processInstanceId);
        this.processService.abortProcessInstance(Long.valueOf(processInstanceId));
        ProcessInstance pi = this.processService.getProcessInstance(Long.valueOf(processInstanceId));
        Assert.assertNull((Object)pi);
        try {
            this.processService.getProcessInstanceVariable(Long.valueOf(processInstanceId), "approval_reviewComment");
            Assert.fail((String)"Process instance was aborted so variables do not exist");
        }
        catch (ProcessInstanceNotFoundException processInstanceNotFoundException) {
            // empty catch block
        }
        try {
            this.processService.getProcessInstanceVariable(Long.valueOf(processInstanceId), "approval_reviewComment");
            Assert.fail((String)"Process instance was aborted so variables do not exist");
        }
        catch (ProcessInstanceNotFoundException processInstanceNotFoundException) {
            // empty catch block
        }
        params = new HashMap();
        params.put("approval_document", "updated document");
        params.put("approval_reviewComment", "final review");
        try {
            this.processService.setProcessVariables(Long.valueOf(processInstanceId), params);
            Assert.fail((String)"Process instance was aborted so cannot be changed");
        }
        catch (ProcessInstanceNotFoundException processInstanceNotFoundException) {
            // empty catch block
        }
        try {
            this.processService.setProcessVariable(Long.valueOf(processInstanceId), "approval_reviewComment", (Object)"updated review comment");
            Assert.fail((String)"Process instance was aborted so cannot be changed");
        }
        catch (ProcessInstanceNotFoundException processInstanceNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testStartProcessAndAbortAlreadyAborted() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("approval_document", "test");
        params.put("approval_reviewComment", "need review");
        long processInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), "org.jbpm.writedocument", params);
        Assert.assertNotNull((Object)processInstanceId);
        this.processService.abortProcessInstance(Long.valueOf(processInstanceId));
        ProcessInstance pi = this.processService.getProcessInstance(Long.valueOf(processInstanceId));
        Assert.assertNull((Object)pi);
        try {
            this.processService.abortProcessInstance(Long.valueOf(processInstanceId));
            Assert.fail((String)"Process instance was aborted so process instance does not exist any more");
        }
        catch (ProcessInstanceNotFoundException processInstanceNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testStartProcessCallActivity() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        Assert.assertNotNull((Object)this.processService);
        long processInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), "ParentProcess");
        Assert.assertNotNull((Object)processInstanceId);
        ProcessInstance pi = this.processService.getProcessInstance(Long.valueOf(processInstanceId));
        Assert.assertNotNull((Object)pi);
        Collection children = this.runtimeDataService.getProcessInstancesByParent(Long.valueOf(processInstanceId), null, new QueryContext());
        Assert.assertNotNull((Object)children);
        Assert.assertEquals((long)1L, (long)children.size());
        ProcessInstanceDesc childInstance = (ProcessInstanceDesc)children.iterator().next();
        Assert.assertNotNull((Object)childInstance);
        Assert.assertEquals((Object)"org.jbpm.signal", (Object)childInstance.getProcessId());
        children = this.runtimeDataService.getProcessInstancesByParent(Long.valueOf(processInstanceId), Arrays.asList(2, 3), new QueryContext());
        Assert.assertNotNull((Object)children);
        Assert.assertEquals((long)0L, (long)children.size());
        this.processService.signalProcessInstance(childInstance.getId(), "MySignal", null);
        children = this.runtimeDataService.getProcessInstancesByParent(Long.valueOf(processInstanceId), Arrays.asList(2, 3), new QueryContext());
        Assert.assertNotNull((Object)children);
        Assert.assertEquals((long)1L, (long)children.size());
        childInstance = (ProcessInstanceDesc)children.iterator().next();
        Assert.assertNotNull((Object)childInstance);
        Assert.assertEquals((Object)"org.jbpm.signal", (Object)childInstance.getProcessId());
        pi = this.processService.getProcessInstance(Long.valueOf(processInstanceId));
        Assert.assertNull((Object)pi);
    }

    @Test
    public void testStartProcessCallActivityCheckNodes() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        Assert.assertNotNull((Object)this.processService);
        long processInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), "ParentProcess");
        Assert.assertNotNull((Object)processInstanceId);
        ProcessInstance pi = this.processService.getProcessInstance(Long.valueOf(processInstanceId));
        Assert.assertNotNull((Object)pi);
        Collection children = this.runtimeDataService.getProcessInstancesByParent(Long.valueOf(processInstanceId), null, new QueryContext());
        Assert.assertNotNull((Object)children);
        Assert.assertEquals((long)1L, (long)children.size());
        ProcessInstanceDesc childInstance = (ProcessInstanceDesc)children.iterator().next();
        Assert.assertNotNull((Object)childInstance);
        Assert.assertEquals((Object)"org.jbpm.signal", (Object)childInstance.getProcessId());
        Collection activeNodes = this.runtimeDataService.getProcessInstanceHistoryActive(processInstanceId, new QueryContext());
        Assert.assertNotNull((Object)activeNodes);
        Assert.assertEquals((long)1L, (long)activeNodes.size());
        NodeInstanceDesc activeNode = (NodeInstanceDesc)activeNodes.iterator().next();
        Assert.assertNotNull((Object)activeNode);
        Assert.assertEquals((Object)"SubProcessNode", (Object)activeNode.getNodeType());
        Assert.assertEquals((Object)childInstance.getId(), (Object)activeNode.getReferenceId());
        this.processService.signalProcessInstance(childInstance.getId(), "MySignal", null);
        children = this.runtimeDataService.getProcessInstancesByParent(Long.valueOf(processInstanceId), Arrays.asList(2, 3), new QueryContext());
        Assert.assertNotNull((Object)children);
        Assert.assertEquals((long)1L, (long)children.size());
        childInstance = (ProcessInstanceDesc)children.iterator().next();
        Assert.assertNotNull((Object)childInstance);
        Assert.assertEquals((Object)"org.jbpm.signal", (Object)childInstance.getProcessId());
        pi = this.processService.getProcessInstance(Long.valueOf(processInstanceId));
        Assert.assertNull((Object)pi);
        Collection completedNodes = this.runtimeDataService.getProcessInstanceHistoryCompleted(processInstanceId, new QueryContext());
        Assert.assertNotNull((Object)completedNodes);
        Assert.assertEquals((long)3L, (long)completedNodes.size());
        NodeInstanceDesc completedNode = completedNodes.stream().filter(n -> n.getNodeType().equals("SubProcessNode")).findFirst().orElse(null);
        Assert.assertNotNull((Object)completedNode);
        Assert.assertEquals((Object)"SubProcessNode", (Object)completedNode.getNodeType());
        Assert.assertEquals((Object)childInstance.getId(), (Object)completedNode.getReferenceId());
    }

    @Test
    public void testStartAndSignalBoundary() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        boolean isDeployed = this.deploymentService.isDeployed(deploymentUnit.getIdentifier());
        Assert.assertTrue((boolean)isDeployed);
        Assert.assertNotNull((Object)this.processService);
        long processInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), "org.jbpm.boundarysignal");
        Assert.assertNotNull((Object)processInstanceId);
        ProcessInstance pi = this.processService.getProcessInstance(Long.valueOf(processInstanceId));
        Assert.assertNotNull((Object)pi);
        Collection signals = this.processService.getAvailableSignals(Long.valueOf(processInstanceId));
        Assert.assertNotNull((Object)signals);
        Assert.assertEquals((long)1L, (long)signals.size());
        Assert.assertTrue((boolean)signals.contains("MySignal"));
        this.processService.signalProcessInstance(Long.valueOf(processInstanceId), "MySignal", null);
        pi = this.processService.getProcessInstance(Long.valueOf(processInstanceId));
        Assert.assertNull((Object)pi);
    }

    @Test
    public void testStartAndSignalBoundaryWithExpression() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        boolean isDeployed = this.deploymentService.isDeployed(deploymentUnit.getIdentifier());
        Assert.assertTrue((boolean)isDeployed);
        Assert.assertNotNull((Object)this.processService);
        long processInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), "org.jbpm.boundarysignalwithexpression");
        Assert.assertNotNull((Object)processInstanceId);
        ProcessInstance pi = this.processService.getProcessInstance(Long.valueOf(processInstanceId));
        Assert.assertNotNull((Object)pi);
        Collection signals = this.processService.getAvailableSignals(Long.valueOf(processInstanceId));
        Assert.assertNotNull((Object)signals);
        Assert.assertEquals((long)1L, (long)signals.size());
        Assert.assertTrue((boolean)signals.contains("MySignal"));
        this.processService.signalProcessInstance(Long.valueOf(processInstanceId), "MySignal", null);
        pi = this.processService.getProcessInstance(Long.valueOf(processInstanceId));
        Assert.assertNull((Object)pi);
    }

    @Test
    public void testGetProcessInstanceVariablesOfAbortedProcess() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        boolean isDeployed = this.deploymentService.isDeployed(deploymentUnit.getIdentifier());
        Assert.assertTrue((boolean)isDeployed);
        Assert.assertNotNull((Object)this.processService);
        long processInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)processInstanceId);
        this.processService.abortProcessInstance(deploymentUnit.getIdentifier(), Long.valueOf(processInstanceId));
        try {
            this.processService.getProcessInstanceVariables(deploymentUnit.getIdentifier(), Long.valueOf(processInstanceId));
            Assert.fail((String)"Getting process variables of already aborted process instance should throw ProcessInstanceNotFoundException.");
        }
        catch (ProcessInstanceNotFoundException processInstanceNotFoundException) {
            // empty catch block
        }
    }
}

