/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.test;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.appformer.maven.support.AFReleaseId;
import org.assertj.core.api.Assertions;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.kie.test.util.AbstractKieServicesBaseTest;
import org.jbpm.services.api.ProcessInstanceNotFoundException;
import org.jbpm.services.api.model.DeploymentUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.internal.KieInternalServices;
import org.kie.internal.process.CorrelationKey;
import org.kie.internal.runtime.conf.AuditMode;
import org.kie.internal.runtime.conf.DeploymentDescriptorBuilder;
import org.kie.internal.runtime.manager.deploy.DeploymentDescriptorImpl;
import org.kie.scanner.KieMavenRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessServiceImplWithoutAuditTest
extends AbstractKieServicesBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(ProcessServiceImplWithoutAuditTest.class);
    private List<DeploymentUnit> units = new ArrayList<DeploymentUnit>();

    @Before
    public void prepare() {
        this.configureServices();
        logger.debug("Preparing kjar");
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.jbpm.test", "test-module", "1.0.0");
        ArrayList<String> processes = new ArrayList<String>();
        processes.add("repo/processes/general/customtask.bpmn");
        processes.add("repo/processes/general/humanTask.bpmn");
        processes.add("repo/processes/general/import.bpmn");
        processes.add("repo/processes/general/signal.bpmn");
        processes.add("repo/processes/general/signalWithExpression.bpmn2");
        processes.add("repo/processes/general/callactivity.bpmn");
        DeploymentDescriptorImpl customDescriptor = new DeploymentDescriptorImpl("org.jbpm.domain");
        DeploymentDescriptorBuilder ddBuilder = customDescriptor.getBuilder();
        ddBuilder.auditMode(AuditMode.NONE);
        HashMap<String, String> extraResources = new HashMap<String, String>();
        extraResources.put("src/main/resources/META-INF/kie-deployment-descriptor.xml", customDescriptor.toXml());
        InternalKieModule kJar1 = this.createKieJar(ks, releaseId, processes, extraResources, new ReleaseId[0]);
        File pom = new File("target/kmodule", "pom.xml");
        pom.getParentFile().mkdir();
        try {
            FileOutputStream fs = new FileOutputStream(pom);
            fs.write(this.getPom(releaseId, new ReleaseId[0]).getBytes());
            fs.close();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to save pom content", e);
        }
        KieMavenRepository repository = KieMavenRepository.getKieMavenRepository();
        repository.deployArtifact((AFReleaseId)releaseId, kJar1, pom);
    }

    @After
    public void cleanup() {
        ProcessServiceImplWithoutAuditTest.cleanupSingletonSessionId();
        if (this.units != null && !this.units.isEmpty()) {
            for (DeploymentUnit unit : this.units) {
                try {
                    this.deploymentService.undeploy(unit);
                }
                catch (Exception exception) {}
            }
            this.units.clear();
        }
        this.close();
    }

    @Test
    public void testStartProcess() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        Assert.assertNotNull((Object)this.processService);
        long processInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), "customtask");
        Assert.assertNotNull((Object)processInstanceId);
        ProcessInstance pi = this.processService.getProcessInstance(deploymentUnit.getIdentifier(), Long.valueOf(processInstanceId));
        Assert.assertNull((Object)pi);
    }

    @Test
    public void testStartProcessWithCorrelationKey() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        Assert.assertNotNull((Object)this.processService);
        CorrelationKey key = KieInternalServices.Factory.get().newCorrelationKeyFactory().newCorrelationKey("my business key");
        long processInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), "customtask", key);
        Assert.assertNotNull((Object)processInstanceId);
        ProcessInstance pi = this.processService.getProcessInstance(deploymentUnit.getIdentifier(), key);
        Assert.assertNull((Object)pi);
    }

    @Test
    public void testStartAndAbortProcess() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        Assert.assertNotNull((Object)this.processService);
        boolean isDeployed = this.deploymentService.isDeployed(deploymentUnit.getIdentifier());
        Assert.assertTrue((boolean)isDeployed);
        long processInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)processInstanceId);
        ProcessInstance pi = this.processService.getProcessInstance(deploymentUnit.getIdentifier(), Long.valueOf(processInstanceId));
        Assert.assertNotNull((Object)pi);
        this.processService.abortProcessInstance(deploymentUnit.getIdentifier(), Long.valueOf(processInstanceId));
        pi = this.processService.getProcessInstance(deploymentUnit.getIdentifier(), Long.valueOf(processInstanceId));
        Assert.assertNull((Object)pi);
    }

    @Test
    public void testStartAndSignalProcess() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        boolean isDeployed = this.deploymentService.isDeployed(deploymentUnit.getIdentifier());
        Assert.assertTrue((boolean)isDeployed);
        Assert.assertNotNull((Object)this.processService);
        long processInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), "org.jbpm.signal");
        Assert.assertNotNull((Object)processInstanceId);
        ProcessInstance pi = this.processService.getProcessInstance(deploymentUnit.getIdentifier(), Long.valueOf(processInstanceId));
        Assert.assertNotNull((Object)pi);
        Collection signals = this.processService.getAvailableSignals(deploymentUnit.getIdentifier(), Long.valueOf(processInstanceId));
        Assert.assertNotNull((Object)signals);
        Assert.assertEquals((long)1L, (long)signals.size());
        Assert.assertTrue((boolean)signals.contains("MySignal"));
        this.processService.signalProcessInstance(deploymentUnit.getIdentifier(), Long.valueOf(processInstanceId), "MySignal", null);
        pi = this.processService.getProcessInstance(deploymentUnit.getIdentifier(), Long.valueOf(processInstanceId));
        Assert.assertNull((Object)pi);
    }

    @Test
    public void testStartAndSignalProcesses() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        boolean isDeployed = this.deploymentService.isDeployed(deploymentUnit.getIdentifier());
        Assert.assertTrue((boolean)isDeployed);
        Assert.assertNotNull((Object)this.processService);
        long processInstanceId1 = this.processService.startProcess(deploymentUnit.getIdentifier(), "org.jbpm.signal");
        Assert.assertNotNull((Object)processInstanceId1);
        ProcessInstance pi = this.processService.getProcessInstance(deploymentUnit.getIdentifier(), Long.valueOf(processInstanceId1));
        Assert.assertNotNull((Object)pi);
        long processInstanceId2 = this.processService.startProcess(deploymentUnit.getIdentifier(), "org.jbpm.signal");
        Assert.assertNotNull((Object)processInstanceId2);
        ProcessInstance pi2 = this.processService.getProcessInstance(deploymentUnit.getIdentifier(), Long.valueOf(processInstanceId2));
        Assert.assertNotNull((Object)pi2);
        ArrayList<Long> instances = new ArrayList<Long>();
        instances.add(processInstanceId1);
        instances.add(processInstanceId2);
        this.processService.signalProcessInstances(deploymentUnit.getIdentifier(), instances, "MySignal", null);
        pi = this.processService.getProcessInstance(deploymentUnit.getIdentifier(), Long.valueOf(processInstanceId1));
        Assert.assertNull((Object)pi);
        pi2 = this.processService.getProcessInstance(deploymentUnit.getIdentifier(), Long.valueOf(processInstanceId2));
        Assert.assertNull((Object)pi2);
    }

    @Test
    public void testStartProcessAndChangeVariables() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        boolean isDeployed = this.deploymentService.isDeployed(deploymentUnit.getIdentifier());
        Assert.assertTrue((boolean)isDeployed);
        Assert.assertNotNull((Object)this.processService);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("approval_document", "test");
        params.put("approval_reviewComment", "need review");
        long processInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), "org.jbpm.writedocument", params);
        Assert.assertNotNull((Object)processInstanceId);
        ProcessInstance pi = this.processService.getProcessInstance(deploymentUnit.getIdentifier(), Long.valueOf(processInstanceId));
        Assert.assertNotNull((Object)pi);
        Object variableValue = this.processService.getProcessInstanceVariable(deploymentUnit.getIdentifier(), Long.valueOf(processInstanceId), "approval_document");
        Assert.assertNotNull((Object)variableValue);
        Assert.assertTrue((boolean)(variableValue instanceof String));
        Assert.assertEquals((Object)"test", (Object)variableValue);
        Map variables = this.processService.getProcessInstanceVariables(deploymentUnit.getIdentifier(), Long.valueOf(processInstanceId));
        Assert.assertNotNull((Object)variables);
        Assert.assertEquals((long)2L, (long)variables.size());
        Assert.assertTrue((boolean)variables.containsKey("approval_document"));
        Assert.assertTrue((boolean)variables.containsKey("approval_reviewComment"));
        Assert.assertEquals((Object)"test", variables.get("approval_document"));
        Assert.assertEquals((Object)"need review", variables.get("approval_reviewComment"));
        this.processService.setProcessVariable(deploymentUnit.getIdentifier(), Long.valueOf(processInstanceId), "approval_reviewComment", (Object)"updated review comment");
        variableValue = this.processService.getProcessInstanceVariable(deploymentUnit.getIdentifier(), Long.valueOf(processInstanceId), "approval_reviewComment");
        Assert.assertNotNull((Object)variableValue);
        Assert.assertTrue((boolean)(variableValue instanceof String));
        Assert.assertEquals((Object)"updated review comment", (Object)variableValue);
        params = new HashMap();
        params.put("approval_document", "updated document");
        params.put("approval_reviewComment", "final review");
        this.processService.setProcessVariables(deploymentUnit.getIdentifier(), Long.valueOf(processInstanceId), params);
        variables = this.processService.getProcessInstanceVariables(deploymentUnit.getIdentifier(), Long.valueOf(processInstanceId));
        Assert.assertNotNull((Object)variables);
        Assert.assertEquals((long)2L, (long)variables.size());
        Assert.assertTrue((boolean)variables.containsKey("approval_document"));
        Assert.assertTrue((boolean)variables.containsKey("approval_reviewComment"));
        Assert.assertEquals((Object)"updated document", variables.get("approval_document"));
        Assert.assertEquals((Object)"final review", variables.get("approval_reviewComment"));
        this.processService.abortProcessInstance(deploymentUnit.getIdentifier(), Long.valueOf(processInstanceId));
        pi = this.processService.getProcessInstance(deploymentUnit.getIdentifier(), Long.valueOf(processInstanceId));
        Assert.assertNull((Object)pi);
    }

    @Test
    public void testStartProcessAndAbortThenChangeVariables() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("approval_document", "test");
        params.put("approval_reviewComment", "need review");
        long processInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), "org.jbpm.writedocument", params);
        Assert.assertNotNull((Object)processInstanceId);
        this.processService.abortProcessInstance(deploymentUnit.getIdentifier(), Long.valueOf(processInstanceId));
        ProcessInstance pi = this.processService.getProcessInstance(deploymentUnit.getIdentifier(), Long.valueOf(processInstanceId));
        Assert.assertNull((Object)pi);
        Assertions.assertThatExceptionOfType(ProcessInstanceNotFoundException.class).isThrownBy(() -> this.processService.getProcessInstanceVariable(deploymentUnit.getIdentifier(), Long.valueOf(processInstanceId), "approval_reviewComment"));
        params.clear();
        params.put("approval_document", "updated document");
        params.put("approval_reviewComment", "final review");
        Assertions.assertThatExceptionOfType(ProcessInstanceNotFoundException.class).isThrownBy(() -> this.processService.setProcessVariables(deploymentUnit.getIdentifier(), Long.valueOf(processInstanceId), params));
        Assertions.assertThatExceptionOfType(ProcessInstanceNotFoundException.class).isThrownBy(() -> this.processService.setProcessVariable(deploymentUnit.getIdentifier(), Long.valueOf(processInstanceId), "approval_reviewComment", (Object)"updated review comment"));
    }

    @Test
    public void testStartProcessAndAbortAlreadyAborted() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("approval_document", "test");
        params.put("approval_reviewComment", "need review");
        long processInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), "org.jbpm.writedocument", params);
        Assert.assertNotNull((Object)processInstanceId);
        this.processService.abortProcessInstance(deploymentUnit.getIdentifier(), Long.valueOf(processInstanceId));
        ProcessInstance pi = this.processService.getProcessInstance(deploymentUnit.getIdentifier(), Long.valueOf(processInstanceId));
        Assert.assertNull((Object)pi);
        Assertions.assertThatExceptionOfType(ProcessInstanceNotFoundException.class).isThrownBy(() -> this.processService.abortProcessInstance(deploymentUnit.getIdentifier(), Long.valueOf(processInstanceId)));
    }
}

