/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.test;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.appformer.maven.support.AFReleaseId;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.kie.test.util.AbstractKieServicesBaseTest;
import org.jbpm.services.api.RuntimeDataService;
import org.jbpm.services.api.model.DeploymentUnit;
import org.jbpm.services.api.model.NodeInstanceDesc;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.query.QueryContext;
import org.kie.api.task.model.Task;
import org.kie.scanner.KieMavenRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartProcessFromArbitraryNodesServiceImplTest
extends AbstractKieServicesBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(StartProcessFromArbitraryNodesServiceImplTest.class);
    private List<DeploymentUnit> units = new ArrayList<DeploymentUnit>();

    @Before
    public void prepare() {
        this.configureServices();
        logger.debug("Preparing kjar");
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.jbpm.test", "test-module", "1.0.0");
        ArrayList<String> processes = new ArrayList<String>();
        processes.add("repo/processes/general/BPMN2-SimpleRestartTest.bpmn2");
        processes.add("repo/processes/general/BPMN2-SimpleRestartWithTimerTest.bpmn2");
        processes.add("repo/processes/general/BPMN2-SimpleRestartWithObsoleteTest.bpmn2");
        processes.add("repo/processes/general/BPMN2-SimpleRestartWithErrorOnEntryScriptHT.bpmn2");
        processes.add("repo/processes/general/BPMN2-SimpleRestartWithErrorOnExitScriptHT.bpmn2");
        InternalKieModule kJar1 = this.createKieJar(ks, releaseId, processes);
        File pom = new File("target/kmodule", "pom.xml");
        pom.getParentFile().mkdir();
        try {
            FileOutputStream fs = new FileOutputStream(pom);
            fs.write(this.getPom(releaseId, new ReleaseId[0]).getBytes());
            fs.close();
        }
        catch (Exception fs) {
            // empty catch block
        }
        KieMavenRepository repository = KieMavenRepository.getKieMavenRepository();
        repository.deployArtifact((AFReleaseId)releaseId, kJar1, pom);
        ReleaseId releaseId2 = ks.newReleaseId("org.jbpm.test", "test-module", "1.1.0");
        InternalKieModule kJar2 = this.createKieJar(ks, releaseId2, processes);
        File pom2 = new File("target/kmodule2", "pom.xml");
        pom2.getParentFile().mkdirs();
        try {
            FileOutputStream fs = new FileOutputStream(pom2);
            fs.write(this.getPom(releaseId2, new ReleaseId[0]).getBytes());
            fs.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        repository = KieMavenRepository.getKieMavenRepository();
        repository.deployArtifact((AFReleaseId)releaseId2, kJar2, pom2);
    }

    @After
    public void cleanup() {
        StartProcessFromArbitraryNodesServiceImplTest.cleanupSingletonSessionId();
        if (this.units != null && !this.units.isEmpty()) {
            for (DeploymentUnit unit : this.units) {
                try {
                    this.deploymentService.undeploy(unit);
                }
                catch (Exception exception) {}
            }
            this.units.clear();
        }
        this.close();
    }

    @Test
    public void testStartProcessFromNodeIds() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        Assert.assertNotNull((Object)this.processService);
        Long processInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), "restart.simple", Collections.singletonMap("var_a", 3));
        Assert.assertNotNull((Object)processInstanceId);
        this.processService.abortProcessInstance(processInstanceId);
        Collection logs = this.runtimeDataService.getProcessInstanceFullHistoryByType(processInstanceId.longValue(), RuntimeDataService.EntryType.ABORTED, new QueryContext(Integer.valueOf(0), Integer.valueOf(0)));
        Assert.assertThat((Object)logs.size(), (Matcher)CoreMatchers.is((Object)1));
        String[] nodeIds = (String[])logs.stream().map(NodeInstanceDesc::getNodeId).toArray(String[]::new);
        processInstanceId = this.processService.startProcessFromNodeIds(deploymentUnit.getIdentifier(), "restart.simple", Collections.singletonMap("var_a", 3), nodeIds);
        this.runtimeDataService.getTasksByProcessInstanceId(processInstanceId).forEach(e -> {
            this.userTaskService.start(e, "john");
            this.userTaskService.complete(e, "john", Collections.emptyMap());
        });
        this.processService.abortProcessInstance(processInstanceId);
        logs = this.runtimeDataService.getProcessInstanceFullHistoryByType(processInstanceId.longValue(), RuntimeDataService.EntryType.ABORTED, new QueryContext(Integer.valueOf(0), Integer.valueOf(0)));
        nodeIds = (String[])logs.stream().map(NodeInstanceDesc::getNodeId).toArray(String[]::new);
        processInstanceId = this.processService.startProcessFromNodeIds(deploymentUnit.getIdentifier(), "restart.simple", Collections.singletonMap("var_a", 3), nodeIds);
        this.runtimeDataService.getTasksByProcessInstanceId(processInstanceId).forEach(e -> {
            this.userTaskService.start(e, "john");
            this.userTaskService.complete(e, "john", Collections.emptyMap());
        });
        ProcessInstance pi = this.processService.getProcessInstance(processInstanceId);
        Assert.assertNull((Object)pi);
    }

    @Test
    public void testStartProcessFromNodeIdsWithTimer() throws InterruptedException {
        String processId = "simple.restartWithTimer";
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        Assert.assertNotNull((Object)this.processService);
        Long processInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), "simple.restartWithTimer", Collections.singletonMap("var_a", 3));
        Assert.assertNotNull((Object)processInstanceId);
        TimeUnit.SECONDS.sleep(3L);
        this.processService.abortProcessInstance(processInstanceId);
        Collection skipped = this.runtimeDataService.getProcessInstanceFullHistoryByType(processInstanceId.longValue(), RuntimeDataService.EntryType.SKIPPED, new QueryContext(Integer.valueOf(0), Integer.valueOf(0)));
        Assert.assertThat((Object)skipped.size(), (Matcher)CoreMatchers.is((Object)1));
        Collection aborted = this.runtimeDataService.getProcessInstanceFullHistoryByType(processInstanceId.longValue(), RuntimeDataService.EntryType.ABORTED, new QueryContext(Integer.valueOf(0), Integer.valueOf(0)));
        Assert.assertThat((Object)aborted.size(), (Matcher)CoreMatchers.is((Object)1));
        String[] nodeIds = (String[])aborted.stream().map(NodeInstanceDesc::getNodeId).toArray(String[]::new);
        processInstanceId = this.processService.startProcessFromNodeIds(deploymentUnit.getIdentifier(), "simple.restartWithTimer", Collections.singletonMap("var_a", 3), nodeIds);
        this.runtimeDataService.getTasksByProcessInstanceId(processInstanceId).forEach(e -> {
            Task task = this.userTaskService.getTask(e);
            Assert.assertThat((Object)task.getName(), (Matcher)CoreMatchers.is((Object)"Third Task"));
            this.userTaskService.start(e, "katy");
            this.userTaskService.complete(e, "katy", Collections.emptyMap());
        });
        ProcessInstance pi = this.processService.getProcessInstance(processInstanceId);
        Assert.assertNull((Object)pi);
    }

    @Test
    public void testObsoleteNodes() throws Exception {
        String processId = "restart.simpleObsolete";
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        Assert.assertNotNull((Object)this.processService);
        Long processInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), "restart.simpleObsolete", Collections.singletonMap("var_a", 3));
        Assert.assertNotNull((Object)processInstanceId);
        this.processService.abortProcessInstance(processInstanceId);
        Collection aborted = this.runtimeDataService.getProcessInstanceFullHistoryByType(processInstanceId.longValue(), RuntimeDataService.EntryType.ABORTED, new QueryContext(Integer.valueOf(0), Integer.valueOf(0)));
        Assert.assertThat((Object)aborted.size(), (Matcher)CoreMatchers.is((Object)2));
        String[] nodeIds = (String[])aborted.stream().map(e -> e.getNodeId()).toArray(String[]::new);
        processInstanceId = this.processService.startProcessFromNodeIds(deploymentUnit.getIdentifier(), "restart.simpleObsolete", Collections.singletonMap("var_a", 3), nodeIds);
        this.runtimeDataService.getTasksByProcessInstanceId(processInstanceId).forEach(e -> {
            Task task = this.userTaskService.getTask(e);
            if (task.getName().equals("First Task")) {
                this.userTaskService.start(e, "katy");
                this.userTaskService.complete(e, "katy", Collections.emptyMap());
            }
        });
        Collection obsolete = this.runtimeDataService.getProcessInstanceFullHistoryByType(processInstanceId.longValue(), RuntimeDataService.EntryType.OBSOLETE, new QueryContext(Integer.valueOf(0), Integer.valueOf(0)));
        Assert.assertThat((Object)obsolete.size(), (Matcher)CoreMatchers.is((Object)1));
        ProcessInstance pi = this.processService.getProcessInstance(processInstanceId);
        Assert.assertNull((Object)pi);
    }

    @Test
    public void testErrorNodesOnExitScript() throws Exception {
        String processId = "restart.simpleErrorOnExitScript";
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        Assert.assertNotNull((Object)this.processService);
        Long processInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), "restart.simpleErrorOnExitScript", Collections.singletonMap("var_exception", "yes"));
        Assert.assertNotNull((Object)processInstanceId);
        try {
            this.startAndCompleteTask(processInstanceId, "User Task 1");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.processService.abortProcessInstance(processInstanceId);
        Collection errorNodes = this.runtimeDataService.getProcessInstanceFullHistoryByType(processInstanceId.longValue(), RuntimeDataService.EntryType.ERROR, new QueryContext(Integer.valueOf(0), Integer.valueOf(0)));
        Assert.assertThat((Object)errorNodes.size(), (Matcher)CoreMatchers.is((Object)1));
        String[] nodeIds = (String[])errorNodes.stream().map(e -> e.getNodeId()).toArray(String[]::new);
        processInstanceId = this.processService.startProcessFromNodeIds(deploymentUnit.getIdentifier(), "restart.simpleErrorOnExitScript", Collections.singletonMap("var_exception", "no"), nodeIds);
        this.startAndCompleteTask(processInstanceId, "User Task 1");
        this.startAndCompleteTask(processInstanceId, "User Task 2");
        ProcessInstance pi = this.processService.getProcessInstance(processInstanceId);
        Assert.assertNull((Object)pi);
    }

    @Test
    public void testErrorNodesOnEntryScript() throws Exception {
        String processId = "restart.simpleErrorOnEntryScript";
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        Assert.assertNotNull((Object)this.processService);
        Long processInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), "restart.simpleErrorOnEntryScript", Collections.singletonMap("var_exception", "yes"));
        Assert.assertNotNull((Object)processInstanceId);
        try {
            this.runtimeDataService.getTasksByProcessInstanceId(processInstanceId).forEach(e -> this.userTaskService.start(e, "katy"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.processService.abortProcessInstance(processInstanceId);
        Collection errorNodes = this.runtimeDataService.getProcessInstanceFullHistoryByType(processInstanceId.longValue(), RuntimeDataService.EntryType.ERROR, new QueryContext(Integer.valueOf(0), Integer.valueOf(0)));
        Assert.assertThat((Object)errorNodes.size(), (Matcher)CoreMatchers.is((Object)1));
        String[] nodeIds = (String[])errorNodes.stream().map(e -> e.getNodeId()).toArray(String[]::new);
        processInstanceId = this.processService.startProcessFromNodeIds(deploymentUnit.getIdentifier(), "restart.simpleErrorOnEntryScript", Collections.singletonMap("var_exception", "no"), nodeIds);
        this.startAndCompleteTask(processInstanceId, "User Task 1");
        this.startAndCompleteTask(processInstanceId, "User Task 2");
        ProcessInstance pi = this.processService.getProcessInstance(processInstanceId);
        Assert.assertNull((Object)pi);
    }

    private void startAndCompleteTask(Long processInstanceId, String taskName) {
        this.runtimeDataService.getTasksByProcessInstanceId(processInstanceId).forEach(e -> {
            Task task = this.userTaskService.getTask(e);
            if (taskName.equals(task.getName())) {
                this.userTaskService.start(e, "katy");
                this.userTaskService.complete(e, "katy", Collections.emptyMap());
            }
        });
    }
}

