/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.test;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.appformer.maven.support.AFReleaseId;
import org.assertj.core.api.Assertions;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.kie.services.test.KModuleDeploymentServiceTest;
import org.jbpm.kie.test.util.AbstractKieServicesBaseTest;
import org.jbpm.services.api.ProcessInstanceNotFoundException;
import org.jbpm.services.api.model.DeploymentUnit;
import org.jbpm.services.api.model.ProcessInstanceDesc;
import org.jbpm.services.api.model.UserTaskInstanceDesc;
import org.jbpm.services.api.query.QueryNotFoundException;
import org.jbpm.services.api.query.model.QueryDefinition;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.task.query.TaskSummaryQueryBuilder;
import org.kie.scanner.KieMavenRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskQueryBuilderTest
extends AbstractKieServicesBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(KModuleDeploymentServiceTest.class);
    private List<DeploymentUnit> units = new ArrayList<DeploymentUnit>();
    protected String correctUser = "salaboy";
    protected String wrongUser = "wrongUser";
    protected Long[] pids;
    protected KModuleDeploymentUnit deploymentUnit = null;
    protected KModuleDeploymentUnit deploymentUnitJPA = null;
    protected QueryDefinition query;
    protected String dataSourceJNDIname;

    @Before
    public void prepare() {
        this.dataSourceJNDIname = this.getDataSourceJNDI();
        this.configureServices();
        logger.debug("Preparing kjar");
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.jbpm.test", "test-module", "1.0.0");
        ArrayList<String> processes = new ArrayList<String>();
        processes.add("repo/processes/general/humanTask.bpmn");
        processes.add("repo/processes/hr/hiring.bpmn2");
        processes.add("repo/processes/hr/hiring_parallel.bpmn2");
        InternalKieModule kJar1 = this.createKieJar(ks, releaseId, processes);
        File pom = new File("target/kmodule", "pom.xml");
        pom.getParentFile().mkdir();
        try {
            FileOutputStream fs = new FileOutputStream(pom);
            fs.write(this.getPom(releaseId, new ReleaseId[0]).getBytes());
            fs.close();
        }
        catch (Exception fs) {
            // empty catch block
        }
        KieMavenRepository repository = KieMavenRepository.getKieMavenRepository();
        repository.deployArtifact((AFReleaseId)releaseId, kJar1, pom);
        Assert.assertNotNull((Object)this.deploymentService);
        this.deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)this.deploymentUnit);
        this.units.add((DeploymentUnit)this.deploymentUnit);
        this.prepareJPAModule(ks, repository);
        Assert.assertNotNull((Object)this.processService);
    }

    protected void prepareJPAModule(KieServices ks, KieMavenRepository repository) {
        ReleaseId releaseIdJPA = ks.newReleaseId("org.jbpm.test", "persistence-test", "1.0.0");
        File kjarJPA = new File("src/test/resources/kjar-jpa/persistence-test.jar");
        File pomJPA = new File("src/test/resources/kjar-jpa/pom.xml");
        repository.installArtifact((AFReleaseId)releaseIdJPA, kjarJPA, pomJPA);
        this.deploymentUnitJPA = new KModuleDeploymentUnit("org.jbpm.test", "persistence-test", "1.0.0");
    }

    protected String getDataSourceJNDI() {
        return "jdbc/testDS1";
    }

    @After
    public void cleanup() {
        if (this.query != null) {
            try {
                this.queryService.unregisterQuery(this.query.getName());
            }
            catch (QueryNotFoundException queryNotFoundException) {
                // empty catch block
            }
        }
        if (this.pids != null) {
            for (int i = 0; i < this.pids.length; ++i) {
                try {
                    long pid = this.pids[i];
                    this.processService.abortProcessInstance(Long.valueOf(pid));
                    ProcessInstance pi = this.processService.getProcessInstance(Long.valueOf(pid));
                    Assert.assertNull((Object)pi);
                    continue;
                }
                catch (ProcessInstanceNotFoundException pid) {
                    // empty catch block
                }
            }
            this.pids = null;
        }
        TaskQueryBuilderTest.cleanupSingletonSessionId();
        if (this.units != null && !this.units.isEmpty()) {
            for (DeploymentUnit unit : this.units) {
                try {
                    this.deploymentService.undeploy(unit);
                }
                catch (Exception exception) {}
            }
            this.units.clear();
        }
        this.close();
    }

    @Test
    public void testGetTaskInstances() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("approval_document", "initial content");
        this.pids = new Long[1];
        this.pids[0] = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument", params);
        Assert.assertNotNull((Object)this.pids[0]);
        List taskInstanceLogs = this.runtimeDataService.taskSummaryQuery(this.correctUser).build().getResultList();
        Assert.assertNotNull((Object)taskInstanceLogs);
        Assert.assertEquals((long)1L, (long)taskInstanceLogs.size());
    }

    @Test
    public void testGetTaskPageInstances() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("approval_document", "initial content");
        this.pids = new Long[10];
        for (int i = 0; i < 10; ++i) {
            this.pids[i] = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument", params);
            Assert.assertNotNull((Object)this.pids[i]);
        }
        List taskInstanceLogs = ((TaskSummaryQueryBuilder)((TaskSummaryQueryBuilder)this.runtimeDataService.taskSummaryQuery(this.correctUser).ascending(TaskSummaryQueryBuilder.OrderBy.processInstanceId).maxResults(4)).offset(6)).build().getResultList();
        Assert.assertNotNull((Object)taskInstanceLogs);
        Assert.assertEquals((long)4L, (long)taskInstanceLogs.size());
        int pid = 6;
        for (TaskSummary ts : taskInstanceLogs) {
            Assert.assertEquals((long)this.pids[pid], (long)ts.getProcessInstanceId());
            ++pid;
        }
    }

    @Test
    public void testGetTaskIdGroupsInstances() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("approval_document", "initial content");
        this.pids = new Long[5];
        for (int i = 0; i < 5; ++i) {
            this.pids[i] = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument", params);
            Assert.assertNotNull((Object)this.pids[i]);
        }
        List allTaskInstanceLogs = this.runtimeDataService.taskSummaryQuery(this.correctUser).ascending(TaskSummaryQueryBuilder.OrderBy.taskId).build().getResultList();
        Assert.assertNotNull((Object)allTaskInstanceLogs);
        long firstTaskId = ((TaskSummary)allTaskInstanceLogs.get(0)).getId();
        List taskInstanceLogs = ((TaskSummaryQueryBuilder)((TaskSummaryQueryBuilder)((TaskSummaryQueryBuilder)((TaskSummaryQueryBuilder)((TaskSummaryQueryBuilder)this.runtimeDataService.taskSummaryQuery(this.correctUser).newGroup()).taskIdRange(Long.valueOf(firstTaskId), Long.valueOf(firstTaskId + 1L)).endGroup()).or()).newGroup()).taskIdRange(Long.valueOf(firstTaskId + 3L), Long.valueOf(firstTaskId + 4L)).endGroup()).build().getResultList();
        Assert.assertNotNull((Object)taskInstanceLogs);
        Assert.assertEquals((long)4L, (long)taskInstanceLogs.size());
        long tid = firstTaskId;
        for (TaskSummary ts : taskInstanceLogs) {
            Assert.assertEquals((long)tid, (long)ts.getId());
            if (++tid != firstTaskId + 2L) continue;
            ++tid;
        }
    }

    @Test
    public void testGetDescendingTaskInstances() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("approval_document", "initial content");
        this.pids = new Long[3];
        for (int i = 0; i < 3; ++i) {
            this.pids[i] = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument", params);
            Assert.assertNotNull((Object)this.pids[i]);
        }
        List taskInstanceLogs = this.runtimeDataService.taskSummaryQuery(this.correctUser).descending(TaskSummaryQueryBuilder.OrderBy.processInstanceId).build().getResultList();
        Assert.assertNotNull((Object)taskInstanceLogs);
        Assert.assertEquals((long)3L, (long)taskInstanceLogs.size());
        int pos = 2;
        for (TaskSummary ts : taskInstanceLogs) {
            Assert.assertEquals((long)this.pids[pos], (long)ts.getProcessInstanceId());
            --pos;
        }
    }

    @Test
    public void testGetTaskVariables() {
        HashMap<String, String> params = new HashMap<String, String>();
        this.pids = new Long[3];
        String[] names = new String[]{"Dalinar Kholin", "Shallan", "Kaladin"};
        for (int i = 0; i < 3; ++i) {
            params.put("name", names[i]);
            this.pids[i] = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "hiring", params);
            Assert.assertNotNull((Object)this.pids[i]);
        }
        List taskInstanceLogs = ((TaskSummaryQueryBuilder)((TaskSummaryQueryBuilder)((TaskSummaryQueryBuilder)((TaskSummaryQueryBuilder)((TaskSummaryQueryBuilder)this.runtimeDataService.taskSummaryQuery("katy").ascending(TaskSummaryQueryBuilder.OrderBy.processInstanceId).newGroup()).variableName(new String[]{"name"}).variableValue(new String[]{"Shallan"}).endGroup()).or()).newGroup()).variableName(new String[]{"name"}).variableValue(new String[]{"Kaladin"}).endGroup()).build().getResultList();
        Assert.assertNotNull((Object)taskInstanceLogs);
        Assert.assertEquals((long)2L, (long)taskInstanceLogs.size());
        int pos = 1;
        for (TaskSummary ts : taskInstanceLogs) {
            Assert.assertEquals((long)this.pids[pos], (long)ts.getProcessInstanceId());
            ++pos;
        }
        taskInstanceLogs = this.runtimeDataService.taskSummaryQuery("katy").variableName(new String[]{"name"}).variableValue(new String[]{"Dalinar Kholin", "Shallan"}).build().getResultList();
        Assert.assertNotNull((Object)taskInstanceLogs);
        Assert.assertEquals((long)2L, (long)taskInstanceLogs.size());
        taskInstanceLogs = ((TaskSummaryQueryBuilder)this.runtimeDataService.taskSummaryQuery("katy").variableName(new String[]{"name"}).regex()).variableValue(new String[]{"*lad*"}).build().getResultList();
        Assert.assertNotNull((Object)taskInstanceLogs);
        Assert.assertEquals((long)1L, (long)taskInstanceLogs.size());
    }

    @Test
    public void testFormName() {
        this.pids = new Long[1];
        this.pids[0] = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "hiring");
        Assert.assertNotNull((Object)this.pids[0]);
        ProcessInstance instance = this.processService.getProcessInstance(this.pids[0]);
        Assert.assertNotNull((Object)instance);
        this.claimAndCompleteTask(this.pids[0], 0, "katy");
        this.claimAndCompleteTask(this.pids[0], 1, "salaboy");
        List taskIds = this.runtimeDataService.getTasksByProcessInstanceId(this.pids[0]);
        UserTaskInstanceDesc userTask = this.runtimeDataService.getTaskById((Long)taskIds.get(2));
        Assert.assertEquals((Object)"CreateProposal", (Object)userTask.getFormName());
        Assert.assertEquals((Object)"Proposal for: ", (Object)userTask.getSubject());
        userTask = this.runtimeDataService.getTaskByWorkItemId((Long)taskIds.get(0));
        Assert.assertEquals((Object)"HRInterview", (Object)userTask.getFormName());
        ProcessInstanceDesc instanceDesc = this.runtimeDataService.getProcessInstanceById(this.pids[0].longValue());
        Assert.assertNotNull((Object)instanceDesc);
        List tasks = instanceDesc.getActiveTasks();
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        Assert.assertEquals((Object)"CreateProposal", (Object)((UserTaskInstanceDesc)tasks.get(0)).getFormName());
    }

    @Test
    public void testFormNameParallelTasks() {
        this.pids = new Long[1];
        this.pids[0] = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "hiring_parallel");
        Assert.assertNotNull((Object)this.pids[0]);
        ProcessInstanceDesc instanceDesc = this.runtimeDataService.getProcessInstanceById(this.pids[0].longValue());
        Assert.assertNotNull((Object)instanceDesc);
        List tasks = instanceDesc.getActiveTasks();
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)2L, (long)tasks.size());
        Assertions.assertThat((List)tasks).extracting("getFormName").contains(new Object[]{"HRInterview", "TechInterview"});
    }

    private void claimAndCompleteTask(Long processInstanceId, int position, String user) {
        List taskIds = this.runtimeDataService.getTasksByProcessInstanceId(processInstanceId);
        Assert.assertTrue((!taskIds.isEmpty() ? 1 : 0) != 0);
        Long taskId = (Long)taskIds.get(position);
        this.userTaskService.claim(taskId, user);
        this.userTaskService.start(taskId, user);
        this.userTaskService.complete(taskId, user, new HashMap());
    }
}

