/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.test;

import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import org.appformer.maven.support.AFReleaseId;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.kie.services.impl.query.SqlQueryDefinition;
import org.jbpm.kie.services.impl.query.mapper.UserTaskInstanceWithCustomVarsQueryMapper;
import org.jbpm.kie.test.util.AbstractKieServicesBaseTest;
import org.jbpm.services.api.model.DeployedUnit;
import org.jbpm.services.api.model.DeploymentUnit;
import org.jbpm.services.api.query.QueryResultMapper;
import org.jbpm.services.api.query.model.QueryDefinition;
import org.jbpm.services.api.query.model.QueryParam;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.query.QueryContext;
import org.kie.api.task.model.Status;
import org.kie.internal.runtime.conf.DeploymentDescriptor;
import org.kie.internal.runtime.conf.ObjectModel;
import org.kie.internal.runtime.manager.InternalRuntimeManager;
import org.kie.internal.runtime.manager.deploy.DeploymentDescriptorImpl;
import org.kie.internal.task.query.TaskSummaryQueryBuilder;
import org.kie.scanner.KieMavenRepository;
import org.kie.test.util.db.DataSourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Ignore
public class TaskVariablesQueryServiceTest
extends AbstractKieServicesBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(TaskVariablesQueryServiceTest.class);
    private List<DeploymentUnit> units = new ArrayList<DeploymentUnit>();
    private static final String ARTIFACT_ID = "task-vars";
    private static final String GROUP_ID = "org.jbpm.test";
    private static final String VERSION = "1.0";
    private static final String SALES_ARTIFACT_ID = "product-sale";
    private static final String SALES_GROUP_ID = "org.jbpm.test";
    private static final String SALES_VERSION = "1.0";
    private static List<String> productCodes = new ArrayList<String>();
    private static List<String> countries = new ArrayList<String>();
    private static List<Integer> zipCodes = new ArrayList<Integer>();
    private String deploymentUnitId;
    private String deploymentUnitSalesId;

    @BeforeClass
    public static void fillTestData() {
        Random random = new Random();
        productCodes.add("BPMS");
        productCodes.add("BRMS");
        productCodes.add("KIE");
        productCodes.add("Fuse");
        productCodes.add("EAP");
        productCodes.add("WILDFLY");
        productCodes.add("TOMCAT");
        productCodes.add("APACHE");
        productCodes.add("WEBSPHERE");
        productCodes.add("WEBLOGIC");
        countries.add("United States");
        countries.add("United Kindgdom");
        countries.add("Belgium");
        countries.add("Poland");
        countries.add("Brazil");
        countries.add("Australia");
        countries.add("Netherland");
        countries.add("Italy");
        countries.add("Canada");
        countries.add("Finland");
        zipCodes.add(random.nextInt(1000));
        zipCodes.add(random.nextInt(1000));
        zipCodes.add(random.nextInt(1000));
        zipCodes.add(random.nextInt(1000));
        zipCodes.add(random.nextInt(1000));
        zipCodes.add(random.nextInt(1000));
        zipCodes.add(random.nextInt(1000));
        zipCodes.add(random.nextInt(1000));
        zipCodes.add(random.nextInt(1000));
        zipCodes.add(random.nextInt(1000));
        System.setProperty("org.jbpm.ht.callback", "jaas");
    }

    protected void buildDatasource() {
        Properties driverProperties = new Properties();
        driverProperties.put("user", "bpms");
        driverProperties.put("password", "bpms");
        driverProperties.put("serverName", "localhost");
        driverProperties.put("portNumber", "5432");
        driverProperties.put("databaseName", "bpms");
        driverProperties.put("className", "org.postgresql.xa.PGXADataSource");
        this.ds = DataSourceFactory.setupPoolingDataSource((String)"jdbc/testDS1", (Properties)driverProperties);
    }

    @Before
    public void prepare() {
        this.configureServices();
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.jbpm.test", ARTIFACT_ID, "1.0");
        File kjar = new File("src/test/resources/kjar-task-vars/task-vars-1.0.jar");
        File pom = new File("src/test/resources/kjar-task-vars/pom.xml");
        KieMavenRepository repository = KieMavenRepository.getKieMavenRepository();
        repository.installArtifact((AFReleaseId)releaseId, kjar, pom);
        ReleaseId releaseIdSales = ks.newReleaseId("org.jbpm.test", SALES_ARTIFACT_ID, "1.0");
        File kjarSales = new File("src/test/resources/kjar-sales/product-sale-1.0.jar");
        File pomSales = new File("src/test/resources/kjar-sales/pom.xml");
        repository.installArtifact((AFReleaseId)releaseIdSales, kjarSales, pomSales);
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", ARTIFACT_ID, "1.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        KModuleDeploymentUnit deploymentUnitSales = new KModuleDeploymentUnit("org.jbpm.test", SALES_ARTIFACT_ID, "1.0");
        DeploymentDescriptorImpl customDescriptor = new DeploymentDescriptorImpl("org.jbpm.domain");
        customDescriptor.getBuilder().addMarshalingStrategy(new ObjectModel("mvel", "new org.drools.persistence.jpa.marshaller.JPAPlaceholderResolverStrategy(\"org.jbpm.test:product-sale:1.0\", classLoader)", new Object[0]));
        deploymentUnitSales.setDeploymentDescriptor((DeploymentDescriptor)customDescriptor);
        this.deploymentService.deploy((DeploymentUnit)deploymentUnitSales);
        this.deploymentUnitSalesId = deploymentUnitSales.getIdentifier();
        DeployedUnit deployed = this.deploymentService.getDeployedUnit(deploymentUnit.getIdentifier());
        Assert.assertNotNull((Object)deployed);
        Assert.assertNotNull((Object)deployed.getDeploymentUnit());
        Assert.assertNotNull((Object)this.runtimeDataService);
        Collection processes = this.runtimeDataService.getProcesses(new QueryContext());
        Assert.assertNotNull((Object)processes);
        Assert.assertEquals((long)2L, (long)processes.size());
        this.deploymentUnitId = deploymentUnit.getIdentifier();
    }

    @After
    public void cleanup() {
        TaskVariablesQueryServiceTest.cleanupSingletonSessionId();
        if (this.units != null && !this.units.isEmpty()) {
            for (DeploymentUnit unit : this.units) {
                this.deploymentService.undeploy(unit);
            }
            this.units.clear();
        }
        this.close();
    }

    @Test
    public void testTaskVariableQueryOnBigTaskSet() {
        Random random = new Random();
        HashMap<String, Integer> numberOfInstancesPerProduct = new HashMap<String, Integer>();
        int i = 0;
        for (i = 0; i < 10000; ++i) {
            int variablesIndex = random.nextInt(9);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("ProductCode", productCodes.get(variablesIndex));
            params.put("Country", countries.get(variablesIndex));
            params.put("ZipCode", zipCodes.get(variablesIndex));
            params.put("Delivery", i % 2 == 0);
            params.put("Actor", "john,actor" + i);
            params.put("Group", "Crusaders");
            logger.debug("Params : " + params);
            this.processService.startProcess(this.deploymentUnitId, "task-vars.TaskWithVars", params);
            Integer currentValue = (Integer)numberOfInstancesPerProduct.get(productCodes.get(variablesIndex));
            if (currentValue == null) {
                currentValue = 0;
            }
            currentValue = currentValue + 1;
            numberOfInstancesPerProduct.put(productCodes.get(variablesIndex), currentValue);
        }
        logger.info("Generated {} process instances... doing searches now", (Object)i);
        logger.info("let's find tasks for product EAP only");
        long timestamp = System.currentTimeMillis();
        List myTasks = ((TaskSummaryQueryBuilder)this.runtimeDataService.taskSummaryQuery("john").variableName(new String[]{"productCode"}).and()).variableValue(new String[]{"EAP"}).build().getResultList();
        logger.info("Task query by variable took {} ms with result size {}", (Object)(System.currentTimeMillis() - timestamp), (Object)myTasks.size());
        Assert.assertEquals((long)((Integer)numberOfInstancesPerProduct.get("EAP")).intValue(), (long)myTasks.size());
        logger.info("let's find tasks for product EAP or Wildfly");
        timestamp = System.currentTimeMillis();
        myTasks = ((TaskSummaryQueryBuilder)this.runtimeDataService.taskSummaryQuery("john").and()).variableName(new String[]{"productCode"}).variableValue(new String[]{"EAP", "WILDFLY"}).build().getResultList();
        logger.info("Task query by variable took {} ms with result size {}", (Object)(System.currentTimeMillis() - timestamp), (Object)myTasks.size());
        int total = (Integer)numberOfInstancesPerProduct.get("EAP") + (Integer)numberOfInstancesPerProduct.get("WILDFLY");
        Assert.assertEquals((long)total, (long)myTasks.size());
        logger.info("let's find tasks for product EAP or Wildfly but take only first 10 results");
        timestamp = System.currentTimeMillis();
        myTasks = ((TaskSummaryQueryBuilder)((TaskSummaryQueryBuilder)((TaskSummaryQueryBuilder)this.runtimeDataService.taskSummaryQuery("john").and()).variableName(new String[]{"productCode"}).variableValue(new String[]{"EAP", "WILDFLY"}).maxResults(10)).offset(0)).build().getResultList();
        logger.info("Task query by variable took {} ms with result size {}", (Object)(System.currentTimeMillis() - timestamp), (Object)myTasks.size());
        Assert.assertEquals((long)10L, (long)myTasks.size());
        logger.info("let's find tasks for product EAP and country Brazil");
        timestamp = System.currentTimeMillis();
        myTasks = ((TaskSummaryQueryBuilder)((TaskSummaryQueryBuilder)((TaskSummaryQueryBuilder)((TaskSummaryQueryBuilder)((TaskSummaryQueryBuilder)((TaskSummaryQueryBuilder)((TaskSummaryQueryBuilder)this.runtimeDataService.taskSummaryQuery("john").and()).newGroup()).variableName(new String[]{"productCode"}).variableValue(new String[]{"EAP"}).endGroup()).newGroup()).variableName(new String[]{"country"}).variableValue(new String[]{"Brazil"}).endGroup()).maxResults(30)).offset(0)).build().getResultList();
        logger.info("Task query by variable took {} ms with result size {}", (Object)(System.currentTimeMillis() - timestamp), (Object)myTasks.size());
        logger.info("let's find tasks for product BPMS and BRMS by using wildcard search");
        timestamp = System.currentTimeMillis();
        myTasks = ((TaskSummaryQueryBuilder)((TaskSummaryQueryBuilder)this.runtimeDataService.taskSummaryQuery("john").and()).variableName(new String[]{"productCode"}).regex()).variableValue(new String[]{"B*"}).build().getResultList();
        logger.info("Task query by variable took {} ms with result size {}", (Object)(System.currentTimeMillis() - timestamp), (Object)myTasks.size());
        total = (Integer)numberOfInstancesPerProduct.get("BPMS") + (Integer)numberOfInstancesPerProduct.get("BRMS");
        Assert.assertEquals((long)total, (long)myTasks.size());
        logger.info("let's find tasks for product Weblogic or WebSphere by wildcard and country Canada");
        timestamp = System.currentTimeMillis();
        myTasks = ((TaskSummaryQueryBuilder)((TaskSummaryQueryBuilder)((TaskSummaryQueryBuilder)((TaskSummaryQueryBuilder)((TaskSummaryQueryBuilder)((TaskSummaryQueryBuilder)((TaskSummaryQueryBuilder)((TaskSummaryQueryBuilder)this.runtimeDataService.taskSummaryQuery("john").and()).newGroup()).variableName(new String[]{"productCode"}).regex()).variableValue(new String[]{"WEB*"}).endGroup()).newGroup()).variableName(new String[]{"country"}).variableValue(new String[]{"Canada"}).endGroup()).maxResults(30)).offset(0)).build().getResultList();
        logger.info("Task query by variable took {} ms with result size {}", (Object)(System.currentTimeMillis() - timestamp), (Object)myTasks.size());
        logger.info("let's find tasks for product Weblogic and WebSphere by wildcard and country starting with United");
        timestamp = System.currentTimeMillis();
        myTasks = ((TaskSummaryQueryBuilder)((TaskSummaryQueryBuilder)((TaskSummaryQueryBuilder)((TaskSummaryQueryBuilder)((TaskSummaryQueryBuilder)((TaskSummaryQueryBuilder)((TaskSummaryQueryBuilder)((TaskSummaryQueryBuilder)((TaskSummaryQueryBuilder)((TaskSummaryQueryBuilder)((TaskSummaryQueryBuilder)this.runtimeDataService.taskSummaryQuery("john").and()).newGroup()).variableName(new String[]{"productCode"}).regex()).variableValue(new String[]{"WEBLOGIC"}).endGroup()).newGroup()).variableName(new String[]{"productCode"}).variableValue(new String[]{"WEBSPHERE"}).endGroup()).newGroup()).variableName(new String[]{"country"}).regex()).variableValue(new String[]{"United*"}).endGroup()).maxResults(30)).offset(0)).build().getResultList();
        logger.info("Task query by variable took {} ms with result size {}", (Object)(System.currentTimeMillis() - timestamp), (Object)myTasks.size());
        Assert.assertEquals((long)0L, (long)myTasks.size());
        logger.info("let's find tasks for product EAP and country Brazil and tasks with status Ready and Reserver");
        timestamp = System.currentTimeMillis();
        myTasks = ((TaskSummaryQueryBuilder)((TaskSummaryQueryBuilder)((TaskSummaryQueryBuilder)((TaskSummaryQueryBuilder)((TaskSummaryQueryBuilder)((TaskSummaryQueryBuilder)((TaskSummaryQueryBuilder)((TaskSummaryQueryBuilder)this.runtimeDataService.taskSummaryQuery("john").and()).newGroup()).variableName(new String[]{"productCode"}).variableValue(new String[]{"EAP"}).endGroup()).newGroup()).variableName(new String[]{"country"}).variableValue(new String[]{"Brazil"}).endGroup()).and()).status(new Status[]{Status.Ready, Status.Reserved}).maxResults(30)).offset(0)).build().getResultList();
        logger.info("Task query by variable took {} ms with result size {}", (Object)(System.currentTimeMillis() - timestamp), (Object)myTasks.size());
    }

    @Test
    public void testTaskVariableQueryOnBigTaskSetAsJPA() throws Exception {
        HashMap<String, String> variableMap = new HashMap<String, String>();
        variableMap.put("COUNTRY", "string");
        variableMap.put("PRODUCTCODE", "string");
        variableMap.put("QUANTITY", "integer");
        variableMap.put("PRICE", "double");
        variableMap.put("SALEDATE", "date");
        SqlQueryDefinition query = new SqlQueryDefinition("getAllTaskInstancesWithCustomVariables", "jdbc/testDS1");
        query.setExpression("select ti.*,  c.country, c.productCode, c.quantity, c.price, c.saleDate from AuditTaskImpl ti     inner join (select mv.map_var_id, mv.taskid from MappedVariable mv) mv       on (mv.taskid = ti.taskId)     inner join ProductSale c       on (c.id = mv.map_var_id)");
        this.queryService.registerQuery((QueryDefinition)query);
        SqlQueryDefinition queryTPO = new SqlQueryDefinition("getMyTaskInstancesWithCustomVariables", "jdbc/testDS1", QueryDefinition.Target.PO_TASK);
        queryTPO.setExpression("select ti.*,  c.country, c.productCode, c.quantity, c.price, c.saleDate, oe.id oeid from AuditTaskImpl ti     inner join (select mv.map_var_id, mv.taskid from MappedVariable mv) mv       on (mv.taskid = ti.taskId)     inner join ProductSale c       on (c.id = mv.map_var_id),   PeopleAssignments_PotOwners po, OrganizationalEntity oe     where ti.taskId = po.task_id and po.entity_id = oe.id");
        this.queryService.registerQuery((QueryDefinition)queryTPO);
        this.queryService.query(query.getName(), (QueryResultMapper)UserTaskInstanceWithCustomVarsQueryMapper.get(variableMap), new QueryContext(), new QueryParam[]{QueryParam.equalsTo((String)"productCode", (Comparable[])new Comparable[]{"EAP"})});
        long currentTime = System.currentTimeMillis();
        Calendar cal = Calendar.getInstance();
        RuntimeManager manager = this.deploymentService.getRuntimeManager(this.deploymentUnitSalesId);
        Assert.assertNotNull((Object)manager);
        Class<?> clazz = Class.forName("org.jbpm.test.ProductSale", true, ((InternalRuntimeManager)manager).getEnvironment().getClassLoader());
        Random random = new Random();
        int i = 0;
        for (i = 0; i < 10000; ++i) {
            cal.setTimeInMillis(currentTime);
            cal.add(6, random.nextInt(60));
            Object product = clazz.newInstance();
            this.setFieldValue(product, "country", countries.get(random.nextInt(9)));
            this.setFieldValue(product, "productCode", productCodes.get(random.nextInt(9)));
            this.setFieldValue(product, "quantity", random.nextInt(50));
            this.setFieldValue(product, "price", random.nextDouble() * 1000.0);
            this.setFieldValue(product, "saleDate", cal.getTime());
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("product", product);
            params.put("sales", "john,actor" + i);
            params.put("salesGroup", "Crusaders");
            logger.debug("Params : " + params);
            this.processService.startProcess(this.deploymentUnitSalesId, "product-sale.sale-product", params);
        }
        logger.info("Generated {} process instances... doing searches now", (Object)i);
        logger.info("let's find tasks for product EAP only");
        long timestamp = System.currentTimeMillis();
        List taskInstanceLogs = (List)this.queryService.query(query.getName(), (QueryResultMapper)UserTaskInstanceWithCustomVarsQueryMapper.get(variableMap), new QueryContext(), new QueryParam[]{QueryParam.equalsTo((String)"productCode", (Comparable[])new Comparable[]{"EAP"})});
        logger.info("Task query by variable took {} ms with result size {}", (Object)(System.currentTimeMillis() - timestamp), (Object)taskInstanceLogs.size());
        logger.info("let's find tasks for product EAP or Wildfly");
        timestamp = System.currentTimeMillis();
        taskInstanceLogs = (List)this.queryService.query(query.getName(), (QueryResultMapper)UserTaskInstanceWithCustomVarsQueryMapper.get(variableMap), new QueryContext(), new QueryParam[]{QueryParam.in((String)"productCode", Arrays.asList("EAP", "WILDFLY"))});
        logger.info("Task query by variable took {} ms with result size {}", (Object)(System.currentTimeMillis() - timestamp), (Object)taskInstanceLogs.size());
        logger.info("let's find tasks for product EAP and country Brazil");
        timestamp = System.currentTimeMillis();
        taskInstanceLogs = (List)this.queryService.query(query.getName(), (QueryResultMapper)UserTaskInstanceWithCustomVarsQueryMapper.get(variableMap), new QueryContext(), new QueryParam[]{QueryParam.equalsTo((String)"productCode", (Comparable[])new Comparable[]{"EAP"}), QueryParam.equalsTo((String)"country", (Comparable[])new Comparable[]{"Brazil"})});
        logger.info("Task query by variable took {} ms with result size {}", (Object)(System.currentTimeMillis() - timestamp), (Object)taskInstanceLogs.size());
        logger.info("let's find tasks for product BPMS and BRMS by using wildcard search");
        timestamp = System.currentTimeMillis();
        taskInstanceLogs = (List)this.queryService.query(query.getName(), (QueryResultMapper)UserTaskInstanceWithCustomVarsQueryMapper.get(variableMap), new QueryContext(), new QueryParam[]{QueryParam.likeTo((String)"productCode", (boolean)false, (Comparable)((Object)"B%"))});
        logger.info("Task query by variable took {} ms with result size {}", (Object)(System.currentTimeMillis() - timestamp), (Object)taskInstanceLogs.size());
        logger.info("let's find tasks for product Weblogic or WebSphere by wildcard and country Canada");
        timestamp = System.currentTimeMillis();
        taskInstanceLogs = (List)this.queryService.query(query.getName(), (QueryResultMapper)UserTaskInstanceWithCustomVarsQueryMapper.get(variableMap), new QueryContext(), new QueryParam[]{QueryParam.likeTo((String)"productCode", (boolean)false, (Comparable)((Object)"WEB%")), QueryParam.equalsTo((String)"country", (Comparable[])new Comparable[]{"Canada"})});
        logger.info("Task query by variable took {} ms with result size {}", (Object)(System.currentTimeMillis() - timestamp), (Object)taskInstanceLogs.size());
        logger.info("let's find tasks for product EAP and country Brazil and tasks with status Ready and Reserved");
        timestamp = System.currentTimeMillis();
        taskInstanceLogs = (List)this.queryService.query(query.getName(), (QueryResultMapper)UserTaskInstanceWithCustomVarsQueryMapper.get(variableMap), new QueryContext(), new QueryParam[]{QueryParam.equalsTo((String)"productCode", (Comparable[])new Comparable[]{"EAP"}), QueryParam.equalsTo((String)"country", (Comparable[])new Comparable[]{"Brazil"}), QueryParam.in((String)"status", Arrays.asList(Status.Ready.toString(), Status.Reserved.toString()))});
        logger.info("Task query by variable took {} ms with result size {}", (Object)(System.currentTimeMillis() - timestamp), (Object)taskInstanceLogs.size());
        logger.info("let's find tasks for product Weblogic or WebSphere by wildcard where quantity is bigger than 20");
        timestamp = System.currentTimeMillis();
        taskInstanceLogs = (List)this.queryService.query(query.getName(), (QueryResultMapper)UserTaskInstanceWithCustomVarsQueryMapper.get(variableMap), new QueryContext(), new QueryParam[]{QueryParam.likeTo((String)"productCode", (boolean)false, (Comparable)((Object)"WEB%")), QueryParam.greaterOrEqualTo((String)"quantity", (Comparable)Integer.valueOf(20))});
        logger.info("Task query by variable took {} ms with result size {}", (Object)(System.currentTimeMillis() - timestamp), (Object)taskInstanceLogs.size());
        logger.info("let's find tasks for product EAP where sale was put in one month from now");
        cal.setTimeInMillis(currentTime);
        Date from = cal.getTime();
        cal.add(2, 1);
        Date to = cal.getTime();
        timestamp = System.currentTimeMillis();
        taskInstanceLogs = (List)this.queryService.query(query.getName(), (QueryResultMapper)UserTaskInstanceWithCustomVarsQueryMapper.get(variableMap), new QueryContext(), new QueryParam[]{QueryParam.equalsTo((String)"productCode", (Comparable[])new Comparable[]{"EAP"}), QueryParam.between((String)"saleDate", (Comparable)from, (Comparable)to)});
        logger.info("Task query by variable took {} ms with result size {}", (Object)(System.currentTimeMillis() - timestamp), (Object)taskInstanceLogs.size());
        logger.info("################################################");
        logger.info("Task with user/group filtering");
        logger.info("################################################");
        this.identityProvider.setName("john");
        timestamp = System.currentTimeMillis();
        taskInstanceLogs = (List)this.queryService.query(queryTPO.getName(), (QueryResultMapper)UserTaskInstanceWithCustomVarsQueryMapper.get(variableMap), new QueryContext(), new QueryParam[]{QueryParam.equalsTo((String)"productCode", (Comparable[])new Comparable[]{"EAP"})});
        logger.info("Task query by variable took {} ms with result size {}", (Object)(System.currentTimeMillis() - timestamp), (Object)taskInstanceLogs.size());
        logger.info("let's find tasks for product EAP or Wildfly");
        timestamp = System.currentTimeMillis();
        taskInstanceLogs = (List)this.queryService.query(queryTPO.getName(), (QueryResultMapper)UserTaskInstanceWithCustomVarsQueryMapper.get(variableMap), new QueryContext(), new QueryParam[]{QueryParam.in((String)"productCode", Arrays.asList("EAP", "WILDFLY"))});
        logger.info("Task query by variable took {} ms with result size {}", (Object)(System.currentTimeMillis() - timestamp), (Object)taskInstanceLogs.size());
        logger.info("let's find tasks for product EAP and country Brazil");
        timestamp = System.currentTimeMillis();
        taskInstanceLogs = (List)this.queryService.query(queryTPO.getName(), (QueryResultMapper)UserTaskInstanceWithCustomVarsQueryMapper.get(variableMap), new QueryContext(), new QueryParam[]{QueryParam.equalsTo((String)"productCode", (Comparable[])new Comparable[]{"EAP"}), QueryParam.equalsTo((String)"country", (Comparable[])new Comparable[]{"Brazil"})});
        logger.info("Task query by variable took {} ms with result size {}", (Object)(System.currentTimeMillis() - timestamp), (Object)taskInstanceLogs.size());
        logger.info("let's find tasks for product BPMS and BRMS by using wildcard search");
        timestamp = System.currentTimeMillis();
        taskInstanceLogs = (List)this.queryService.query(queryTPO.getName(), (QueryResultMapper)UserTaskInstanceWithCustomVarsQueryMapper.get(variableMap), new QueryContext(), new QueryParam[]{QueryParam.likeTo((String)"productCode", (boolean)false, (Comparable)((Object)"B%"))});
        logger.info("Task query by variable took {} ms with result size {}", (Object)(System.currentTimeMillis() - timestamp), (Object)taskInstanceLogs.size());
        logger.info("let's find tasks for product Weblogic or WebSphere by wildcard and country Canada");
        timestamp = System.currentTimeMillis();
        taskInstanceLogs = (List)this.queryService.query(queryTPO.getName(), (QueryResultMapper)UserTaskInstanceWithCustomVarsQueryMapper.get(variableMap), new QueryContext(), new QueryParam[]{QueryParam.likeTo((String)"productCode", (boolean)false, (Comparable)((Object)"WEB%")), QueryParam.equalsTo((String)"country", (Comparable[])new Comparable[]{"Canada"})});
        logger.info("Task query by variable took {} ms with result size {}", (Object)(System.currentTimeMillis() - timestamp), (Object)taskInstanceLogs.size());
        logger.info("let's find tasks for product EAP and country Brazil and tasks with status Ready and Reserved");
        timestamp = System.currentTimeMillis();
        taskInstanceLogs = (List)this.queryService.query(queryTPO.getName(), (QueryResultMapper)UserTaskInstanceWithCustomVarsQueryMapper.get(variableMap), new QueryContext(), new QueryParam[]{QueryParam.equalsTo((String)"productCode", (Comparable[])new Comparable[]{"EAP"}), QueryParam.equalsTo((String)"country", (Comparable[])new Comparable[]{"Brazil"}), QueryParam.in((String)"status", Arrays.asList(Status.Ready.toString(), Status.Reserved.toString()))});
        logger.info("Task query by variable took {} ms with result size {}", (Object)(System.currentTimeMillis() - timestamp), (Object)taskInstanceLogs.size());
        logger.info("let's find tasks for product Weblogic or WebSphere by wildcard where quantity is bigger than 20");
        timestamp = System.currentTimeMillis();
        taskInstanceLogs = (List)this.queryService.query(queryTPO.getName(), (QueryResultMapper)UserTaskInstanceWithCustomVarsQueryMapper.get(variableMap), new QueryContext(), new QueryParam[]{QueryParam.likeTo((String)"productCode", (boolean)false, (Comparable)((Object)"WEB%")), QueryParam.greaterOrEqualTo((String)"quantity", (Comparable)Integer.valueOf(20))});
        logger.info("Task query by variable took {} ms with result size {}", (Object)(System.currentTimeMillis() - timestamp), (Object)taskInstanceLogs.size());
        logger.info("let's find tasks for product EAP where sale was put in one month from now");
        timestamp = System.currentTimeMillis();
        taskInstanceLogs = (List)this.queryService.query(queryTPO.getName(), (QueryResultMapper)UserTaskInstanceWithCustomVarsQueryMapper.get(variableMap), new QueryContext(), new QueryParam[]{QueryParam.equalsTo((String)"productCode", (Comparable[])new Comparable[]{"EAP"}), QueryParam.between((String)"saleDate", (Comparable)from, (Comparable)to)});
        logger.info("Task query by variable took {} ms with result size {}", (Object)(System.currentTimeMillis() - timestamp), (Object)taskInstanceLogs.size());
    }

    protected void setFieldValue(Object instance, String fieldName, Object value) {
        try {
            Field f = instance.getClass().getDeclaredField(fieldName);
            f.setAccessible(true);
            f.set(instance, value);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

