/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.test;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.appformer.maven.support.AFReleaseId;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.kie.services.impl.query.SqlQueryDefinition;
import org.jbpm.kie.services.impl.query.builder.UserTaskPotOwnerQueryBuilderFactory;
import org.jbpm.kie.services.impl.query.mapper.UserTaskInstanceWithModifVarsQueryMapper;
import org.jbpm.kie.services.impl.query.mapper.UserTaskInstanceWithPotOwnerQueryMapper;
import org.jbpm.kie.services.test.KModuleDeploymentServiceTest;
import org.jbpm.kie.test.util.AbstractKieServicesBaseTest;
import org.jbpm.services.api.ProcessInstanceNotFoundException;
import org.jbpm.services.api.model.DeploymentUnit;
import org.jbpm.services.api.model.UserTaskInstanceWithPotOwnerDesc;
import org.jbpm.services.api.query.QueryNotFoundException;
import org.jbpm.services.api.query.QueryParamBuilder;
import org.jbpm.services.api.query.QueryResultMapper;
import org.jbpm.services.api.query.model.QueryDefinition;
import org.jbpm.services.api.query.model.QueryParam;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.query.QueryContext;
import org.kie.internal.runtime.manager.deploy.DeploymentDescriptorImpl;
import org.kie.scanner.KieMavenRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserTaskInstanceWithPotOwnerTest
extends AbstractKieServicesBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(KModuleDeploymentServiceTest.class);
    private List<DeploymentUnit> units = new ArrayList<DeploymentUnit>();
    protected String correctUser = "salaboy";
    protected String wrongUser = "wrongUser";
    protected Long processInstanceId = null;
    protected KModuleDeploymentUnit deploymentUnit = null;
    protected KModuleDeploymentUnit deploymentUnitJPA = null;
    protected QueryDefinition query;
    protected String dataSourceJNDIname;

    @Before
    public void prepare() {
        System.setProperty("org.jbpm.ht.callback", "custom");
        System.setProperty("org.jbpm.ht.custom.callback", "org.jbpm.kie.services.test.objects.TestUserGroupCallbackImpl");
        this.dataSourceJNDIname = this.getDataSourceJNDI();
        this.configureServices();
        logger.debug("Preparing kjar");
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.jbpm.test", "test-module", "1.0.0");
        ArrayList<String> processes = new ArrayList<String>();
        processes.add("repo/processes/general/EmptyHumanTask.bpmn");
        processes.add("repo/processes/general/humanTask.bpmn");
        processes.add("repo/processes/general/BPMN2-UserTask.bpmn2");
        processes.add("repo/processes/general/SimpleHTProcess.bpmn2");
        processes.add("repo/processes/general/AdHocSubProcess.bpmn2");
        processes.add("repo/processes/general/ExcludedOwner.bpmn2");
        DeploymentDescriptorImpl customDescriptor = new DeploymentDescriptorImpl("org.jbpm.domain");
        customDescriptor.getBuilder().addRequiredRole("view:managers");
        HashMap<String, String> resources = new HashMap<String, String>();
        resources.put("src/main/resources/META-INF/kie-deployment-descriptor.xml", customDescriptor.toXml());
        InternalKieModule kJar1 = this.createKieJar(ks, releaseId, processes, resources, new ReleaseId[0]);
        File pom = new File("target/kmodule", "pom.xml");
        pom.getParentFile().mkdir();
        try {
            FileOutputStream fs = new FileOutputStream(pom);
            fs.write(this.getPom(releaseId, new ReleaseId[0]).getBytes());
            fs.close();
        }
        catch (Exception fs) {
            // empty catch block
        }
        KieMavenRepository repository = KieMavenRepository.getKieMavenRepository();
        repository.deployArtifact((AFReleaseId)releaseId, kJar1, pom);
        Assert.assertNotNull((Object)this.deploymentService);
        this.deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)this.deploymentUnit);
        this.units.add((DeploymentUnit)this.deploymentUnit);
        this.prepareJPAModule(ks, repository);
        Assert.assertNotNull((Object)this.processService);
    }

    protected void prepareJPAModule(KieServices ks, KieMavenRepository repository) {
        ReleaseId releaseIdJPA = ks.newReleaseId("org.jbpm.test", "persistence-test", "1.0.0");
        File kjarJPA = new File("src/test/resources/kjar-jpa/persistence-test.jar");
        File pomJPA = new File("src/test/resources/kjar-jpa/pom.xml");
        repository.installArtifact((AFReleaseId)releaseIdJPA, kjarJPA, pomJPA);
        this.deploymentUnitJPA = new KModuleDeploymentUnit("org.jbpm.test", "persistence-test", "1.0.0");
    }

    protected String getDataSourceJNDI() {
        return "jdbc/testDS1";
    }

    @After
    public void cleanup() {
        System.clearProperty("org.jbpm.ht.callback");
        System.clearProperty("org.jbpm.ht.custom.callback");
        if (this.query != null) {
            try {
                this.queryService.unregisterQuery(this.query.getName());
            }
            catch (QueryNotFoundException queryNotFoundException) {
                // empty catch block
            }
        }
        if (this.processInstanceId != null) {
            try {
                this.processService.abortProcessInstance(this.processInstanceId);
                ProcessInstance pi = this.processService.getProcessInstance(this.processInstanceId);
                Assert.assertNull((Object)pi);
            }
            catch (ProcessInstanceNotFoundException processInstanceNotFoundException) {
                // empty catch block
            }
        }
        UserTaskInstanceWithPotOwnerTest.cleanupSingletonSessionId();
        if (this.units != null && !this.units.isEmpty()) {
            for (DeploymentUnit unit : this.units) {
                try {
                    this.deploymentService.undeploy(unit);
                }
                catch (Exception exception) {}
            }
            this.units.clear();
        }
        this.close();
    }

    @Test
    public void testSearchTaskByPotOwnerMapper() {
        this.query = new SqlQueryDefinition("jbpmHumanTasksPO", this.dataSourceJNDIname);
        this.query.setExpression("select t.actualowner_id as actualowner, t.CREATEDBY_ID as createdby, t.CREATEDON as CREATEDON, t.EXPIRATIONTIME as expirationDate, t.id as TASKID, t.name as NAME, t.priority as PRIORITY, t.PROCESSINSTANCEID as PROCESSINSTANCEID, t.PROCESSID as PROCESSID, t.STATUS as STATUS,  po.entity_id as POTOWNER, t.FORMNAME AS FORMNAME, p.processinstancedescription as PROCESSINSTANCEDESCRIPTION, t.subject as SUBJECT, t.deploymentid as DEPLOYMENTID from TASK t inner join PEOPLEASSIGNMENTS_POTOWNERS po on t.id=po.task_id inner join PROCESSINSTANCELOG p on t.processinstanceid = p.processinstanceid");
        this.queryService.registerQuery(this.query);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("approval_document", "initial content");
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument", params);
        Assert.assertNotNull((Object)this.processInstanceId);
        List taskInstanceLogs = (List)this.queryService.query(this.query.getName(), (QueryResultMapper)UserTaskInstanceWithPotOwnerQueryMapper.get(), new QueryContext(), new QueryParam[0]);
        Assert.assertNotNull((Object)taskInstanceLogs);
        Assert.assertEquals((long)1L, (long)taskInstanceLogs.size());
        taskInstanceLogs = (List)this.queryService.query(this.query.getName(), (QueryResultMapper)UserTaskInstanceWithPotOwnerQueryMapper.get(), new QueryContext(), new QueryParam[]{QueryParam.equalsTo((String)"POTOWNER", (Comparable[])new Comparable[]{this.wrongUser})});
        Assert.assertNotNull((Object)taskInstanceLogs);
        Assert.assertEquals((long)0L, (long)taskInstanceLogs.size());
        taskInstanceLogs = (List)this.queryService.query(this.query.getName(), (QueryResultMapper)UserTaskInstanceWithPotOwnerQueryMapper.get(), new QueryContext(), new QueryParam[]{QueryParam.equalsTo((String)"POTOWNER", (Comparable[])new Comparable[]{this.correctUser})});
        Assert.assertNotNull((Object)taskInstanceLogs);
        Assert.assertEquals((long)1L, (long)taskInstanceLogs.size());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
    }

    @Test
    public void testSearchTaskByPotOwnerQueryParamBuilder() {
        this.query = new SqlQueryDefinition("jbpmHumanTasksPO", this.dataSourceJNDIname);
        this.query.setExpression("select t.actualowner_id as actualowner, t.CREATEDBY_ID as createdby, t.CREATEDON as CREATEDON, t.EXPIRATIONTIME as expirationDate, t.id as TASKID, t.name as NAME, t.priority as PRIORITY, t.PROCESSINSTANCEID as PROCESSINSTANCEID, t.PROCESSID as PROCESSID, t.STATUS as STATUS,  po.entity_id as POTOWNER, t.FORMNAME AS FORMNAME, p.processinstancedescription as PROCESSINSTANCEDESCRIPTION, t.subject as SUBJECT, t.deploymentid as DEPLOYMENTID from TASK t inner join PEOPLEASSIGNMENTS_POTOWNERS po on t.id=po.task_id inner join PROCESSINSTANCELOG p on t.processinstanceid = p.processinstanceid");
        this.queryService.registerQuery(this.query);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("approval_document", "initial content");
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument", params);
        Assert.assertNotNull((Object)this.processInstanceId);
        List taskInstanceLogs = (List)this.queryService.query(this.query.getName(), (QueryResultMapper)UserTaskInstanceWithPotOwnerQueryMapper.get(), new QueryContext(), new QueryParam[0]);
        Assert.assertNotNull((Object)taskInstanceLogs);
        Assert.assertEquals((long)1L, (long)taskInstanceLogs.size());
        Assert.assertNotNull((Object)((UserTaskInstanceWithPotOwnerDesc)taskInstanceLogs.get(0)).getProcessInstanceDescription());
        UserTaskPotOwnerQueryBuilderFactory qbFactory = new UserTaskPotOwnerQueryBuilderFactory();
        Assert.assertTrue((boolean)qbFactory.accept("potOwnerBuilder"));
        ArrayList<String> potOwners = new ArrayList<String>();
        potOwners.add("salaboy");
        HashMap<String, ArrayList<String>> parameters = new HashMap<String, ArrayList<String>>();
        parameters.put("potOwner", potOwners);
        QueryParamBuilder paramBuilder = qbFactory.newInstance(parameters);
        taskInstanceLogs = (List)this.queryService.query(this.query.getName(), (QueryResultMapper)UserTaskInstanceWithPotOwnerQueryMapper.get(), new QueryContext(), paramBuilder);
        Assert.assertNotNull((Object)taskInstanceLogs);
        Assert.assertEquals((long)1L, (long)taskInstanceLogs.size());
        potOwners = new ArrayList();
        potOwners.add("wrongPotOwner");
        parameters = new HashMap();
        parameters.put("potOwner", potOwners);
        paramBuilder = qbFactory.newInstance(parameters);
        taskInstanceLogs = (List)this.queryService.query(this.query.getName(), (QueryResultMapper)UserTaskInstanceWithPotOwnerQueryMapper.get(), new QueryContext(), paramBuilder);
        Assert.assertNotNull((Object)taskInstanceLogs);
        Assert.assertEquals((long)0L, (long)taskInstanceLogs.size());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
    }

    @Test
    public void testSearchTaskWithModifVarsMapper() {
        this.query = new SqlQueryDefinition("jbpmGetTaskWithPO", this.dataSourceJNDIname);
        this.query.setExpression("select t.id as TASKID, t.name as NAME,  t.FORMNAME AS FORMNAME, t.subject as SUBJECT, t.actualowner_id as ACTUALOWNER, po.entity_id as POTOWNER, p.processinstancedescription as PROCESSINSTANCEDESCRIPTION, t.CREATEDON as CREATEDON, t.CREATEDBY_ID as CREATEDBY, t.EXPIRATIONTIME as EXPIRATIONTIME, (select max(logtime) from taskevent where processinstanceid = t.processinstanceid and taskid = t.id) as lastmodificationdate, (select a.userid from taskevent a left join taskevent b on a.id < b.id where b.id IS NULL) as lastmodificationuser, t.priority as PRIORITY, t.STATUS as STATUS, t.PROCESSINSTANCEID as PROCESSINSTANCEID, t.PROCESSID as PROCESSID, t.deploymentid as DEPLOYMENTID, d.name as TVNAME, d.type as TVTYPE, d.value as TVVALUE from TASK t inner join PEOPLEASSIGNMENTS_POTOWNERS po on t.id=po.task_id inner join PROCESSINSTANCELOG p on t.processinstanceid = p.processinstanceid inner join TASKVARIABLEIMPL d on t.id=d.taskid");
        this.queryService.registerQuery(this.query);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("approval_document", "initial content");
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument", params);
        Assert.assertNotNull((Object)this.processInstanceId);
        List taskInstanceLogs = (List)this.queryService.query(this.query.getName(), (QueryResultMapper)UserTaskInstanceWithModifVarsQueryMapper.get(), new QueryContext(), new QueryParam[0]);
        Assert.assertNotNull((Object)taskInstanceLogs);
        Assert.assertEquals((long)1L, (long)taskInstanceLogs.size());
        taskInstanceLogs = (List)this.queryService.query(this.query.getName(), (QueryResultMapper)UserTaskInstanceWithModifVarsQueryMapper.get(), new QueryContext(), new QueryParam[]{QueryParam.equalsTo((String)"POTOWNER", (Comparable[])new Comparable[]{this.wrongUser})});
        Assert.assertNotNull((Object)taskInstanceLogs);
        Assert.assertEquals((long)0L, (long)taskInstanceLogs.size());
        taskInstanceLogs = (List)this.queryService.query(this.query.getName(), (QueryResultMapper)UserTaskInstanceWithModifVarsQueryMapper.get(), new QueryContext(), new QueryParam[]{QueryParam.equalsTo((String)"POTOWNER", (Comparable[])new Comparable[]{this.correctUser})});
        Assert.assertNotNull((Object)taskInstanceLogs);
        Assert.assertEquals((long)1L, (long)taskInstanceLogs.size());
        taskInstanceLogs = (List)this.queryService.query(this.query.getName(), (QueryResultMapper)UserTaskInstanceWithModifVarsQueryMapper.get(), new QueryContext(), new QueryParam[]{QueryParam.equalsTo((String)"POTOWNER", (Comparable[])new Comparable[]{this.correctUser})});
        Assert.assertNotNull((Object)((UserTaskInstanceWithPotOwnerDesc)taskInstanceLogs.get(0)).getLastModificationUser());
        Assert.assertNotNull((Object)((UserTaskInstanceWithPotOwnerDesc)taskInstanceLogs.get(0)).getProcessInstanceDescription());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
    }
}

