/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.test.store;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import org.apache.commons.io.IOUtils;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.kie.services.impl.store.DeploymentStore;
import org.jbpm.kie.services.impl.store.DeploymentStoreEntry;
import org.jbpm.kie.test.util.AbstractKieServicesBaseTest;
import org.jbpm.runtime.manager.impl.jpa.EntityManagerFactoryManager;
import org.jbpm.services.api.model.DeploymentUnit;
import org.jbpm.shared.services.impl.JpaPersistenceContext;
import org.jbpm.shared.services.impl.TransactionalCommandService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.command.Command;
import org.kie.api.command.ExecutableCommand;
import org.kie.api.runtime.Context;
import org.kie.internal.runtime.conf.DeploymentDescriptor;
import org.kie.internal.runtime.conf.NamedObjectModel;
import org.kie.internal.runtime.conf.ObjectModel;
import org.kie.internal.runtime.manager.deploy.DeploymentDescriptorImpl;
import org.kie.internal.runtime.manager.deploy.TransientNamedObjectModel;
import org.kie.internal.runtime.manager.deploy.TransientObjectModel;

public class DeploymentStoreTest
extends AbstractKieServicesBaseTest {
    private DeploymentStore store;
    private TransactionalCommandService transactionalCommandService;

    @Before
    public void setup() {
        this.buildDatasource();
        this.emf = EntityManagerFactoryManager.get().getOrCreate("org.jbpm.domain");
        this.store = new DeploymentStore();
        this.transactionalCommandService = new TransactionalCommandService(this.emf);
        this.store.setCommandService(this.transactionalCommandService);
    }

    @After
    public void cleanup() {
        this.close();
    }

    @Test
    public void testEnableAndGetActiveDeployments() {
        Collection enabled = this.store.getEnabledDeploymentUnits();
        Assert.assertNotNull((Object)enabled);
        Assert.assertEquals((long)0L, (long)enabled.size());
        KModuleDeploymentUnit unit = new KModuleDeploymentUnit("org.jbpm", "test", "1.0");
        this.store.enableDeploymentUnit((DeploymentUnit)unit);
        enabled = this.store.getEnabledDeploymentUnits();
        Assert.assertNotNull((Object)enabled);
        Assert.assertEquals((long)1L, (long)enabled.size());
    }

    @Test
    public void testEnableAndGetAndDisableActiveDeployments() {
        Collection enabled = this.store.getEnabledDeploymentUnits();
        Assert.assertNotNull((Object)enabled);
        Assert.assertEquals((long)0L, (long)enabled.size());
        KModuleDeploymentUnit unit = new KModuleDeploymentUnit("org.jbpm", "test", "1.0");
        this.store.enableDeploymentUnit((DeploymentUnit)unit);
        enabled = this.store.getEnabledDeploymentUnits();
        Assert.assertNotNull((Object)enabled);
        Assert.assertEquals((long)1L, (long)enabled.size());
        this.store.disableDeploymentUnit((DeploymentUnit)unit);
        enabled = this.store.getEnabledDeploymentUnits();
        Assert.assertNotNull((Object)enabled);
        Assert.assertEquals((long)0L, (long)enabled.size());
    }

    @Test
    public void testEnableAndGetByDateActiveDeployments() {
        Collection enabled = this.store.getEnabledDeploymentUnits();
        Assert.assertNotNull((Object)enabled);
        Assert.assertEquals((long)0L, (long)enabled.size());
        Date date = new Date();
        KModuleDeploymentUnit unit = new KModuleDeploymentUnit("org.jbpm", "test", "1.0");
        this.store.enableDeploymentUnit((DeploymentUnit)unit);
        unit = new KModuleDeploymentUnit("org.jbpm", "prod", "1.0");
        this.store.enableDeploymentUnit((DeploymentUnit)unit);
        HashSet unitsEnabled = new HashSet();
        HashSet unitsDisabled = new HashSet();
        HashSet unitsActivated = new HashSet();
        HashSet unitsDeactivated = new HashSet();
        this.store.getDeploymentUnitsByDate(date, unitsEnabled, unitsDisabled, unitsActivated, unitsDeactivated);
        Assert.assertNotNull(unitsEnabled);
        Assert.assertEquals((long)2L, (long)unitsEnabled.size());
        Assert.assertNotNull(unitsDisabled);
        Assert.assertEquals((long)0L, (long)unitsDisabled.size());
        date = new Date();
        this.store.disableDeploymentUnit((DeploymentUnit)unit);
        unitsEnabled.clear();
        unitsDisabled.clear();
        unitsActivated.clear();
        unitsDeactivated.clear();
        this.store.getDeploymentUnitsByDate(date, unitsEnabled, unitsDisabled, unitsActivated, unitsDeactivated);
        Assert.assertNotNull(unitsEnabled);
        Assert.assertEquals((long)0L, (long)unitsEnabled.size());
        Assert.assertNotNull(unitsDisabled);
        Assert.assertEquals((long)1L, (long)unitsDisabled.size());
    }

    @Test
    public void testEnableAndGetActiveDeploymentsWithTransientNamedObject() {
        Collection enabled = this.store.getEnabledDeploymentUnits();
        Assert.assertNotNull((Object)enabled);
        Assert.assertEquals((long)0L, (long)enabled.size());
        KModuleDeploymentUnit unit = new KModuleDeploymentUnit("org.jbpm", "test", "1.0");
        DeploymentDescriptor descriptor = unit.getDeploymentDescriptor();
        if (descriptor == null) {
            descriptor = new DeploymentDescriptorImpl("org.jbpm.domain");
        }
        descriptor.getBuilder().addWorkItemHandler((NamedObjectModel)new TransientNamedObjectModel("ejb", "async", "org.jbpm.executor.impl.wih.AsyncWorkItemHandler", new Object[]{"jndi:java:module/ExecutorServiceEJBImpl", "org.jbpm.executor.commands.PrintOutCommand"})).addEventListener((ObjectModel)new TransientObjectModel("ejb", "not.existing.listener", new Object[0]));
        unit.setDeploymentDescriptor(descriptor);
        this.store.enableDeploymentUnit((DeploymentUnit)unit);
        enabled = this.store.getEnabledDeploymentUnits();
        Assert.assertNotNull((Object)enabled);
        Assert.assertEquals((long)1L, (long)enabled.size());
        DeploymentUnit unitEnabled = (DeploymentUnit)enabled.iterator().next();
        Assert.assertTrue((boolean)(unitEnabled instanceof KModuleDeploymentUnit));
        DeploymentDescriptor descriptorEnabled = ((KModuleDeploymentUnit)unitEnabled).getDeploymentDescriptor();
        Assert.assertNotNull((Object)descriptorEnabled);
        Assert.assertEquals((long)0L, (long)descriptorEnabled.getWorkItemHandlers().size());
        Assert.assertEquals((long)0L, (long)descriptorEnabled.getEventListeners().size());
    }

    @Test
    public void testActiveDefaultValueInDeploymentUnit() {
        this.transactionalCommandService.execute((Command)new ExecutableCommand<Long>(){

            public Long execute(Context context) {
                try {
                    DeploymentStoreEntry entry = new DeploymentStoreEntry();
                    entry.setDeploymentId("org.guvnor:guvnor-asset-mgmt-project:6.5.0.Final-redhat-17 ");
                    URL file = this.getClass().getClassLoader().getResource("descriptor/KModuleDeploymentUnit.txt");
                    entry.setDeploymentUnit(IOUtils.toString((URL)file, (String)"UTF-8"));
                    entry.setState(Integer.valueOf(2));
                    entry.setUpdateDate(new Date());
                    JpaPersistenceContext jpaContext = (JpaPersistenceContext)context;
                    entry = (DeploymentStoreEntry)jpaContext.persist((Object)entry);
                    return entry.getId();
                }
                catch (IOException e) {
                    return null;
                }
            }
        });
        Collection enabled = this.store.getEnabledDeploymentUnits();
        Assert.assertTrue((enabled.size() > 0 ? 1 : 0) != 0);
        KModuleDeploymentUnit deploymentUnit = (KModuleDeploymentUnit)enabled.iterator().next();
        Assert.assertTrue((boolean)deploymentUnit.isActive());
    }
}

