/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.test.util;

import java.util.List;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import org.dashbuilder.DataSetCore;
import org.jbpm.kie.services.impl.FormManagerService;
import org.jbpm.kie.services.impl.utils.DefaultKieServiceConfigurator;
import org.jbpm.services.api.model.DeploymentUnit;
import org.jbpm.services.api.model.UserTaskInstanceDesc;
import org.jbpm.test.services.AbstractKieServicesTest;
import org.junit.Assert;
import org.kie.api.KieServices;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.builder.model.KieSessionModel;
import org.kie.api.conf.EqualityBehaviorOption;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.io.ResourceFactory;

public abstract class AbstractKieServicesBaseTest
extends AbstractKieServicesTest {
    protected static final String ARTIFACT_ID = "test-module";
    protected static final String GROUP_ID = "org.jbpm.test";
    protected static final String VERSION = "1.0.0";
    protected FormManagerService formManagerService;

    protected void close() {
        DataSetCore.set(null);
        super.close();
    }

    protected DeploymentUnit prepareDeploymentUnit() throws Exception {
        return null;
    }

    protected List<String> getProcessDefinitionFiles() {
        return null;
    }

    protected void configureServices() {
        super.configureServices();
        this.formManagerService = ((DefaultKieServiceConfigurator)this.serviceConfigurator).getFormManagerService();
        this.emf = ((DefaultKieServiceConfigurator)this.serviceConfigurator).getEmf();
    }

    protected static void waitForTheOtherThreads(CyclicBarrier barrier) {
        try {
            barrier.await();
        }
        catch (InterruptedException e) {
            Assert.fail((String)"Thread 1 was interrupted while waiting for the other threads!");
        }
        catch (BrokenBarrierException e) {
            Assert.fail((String)"Thread 1's barrier was broken while waiting for the other threads!");
        }
    }

    protected KieFileSystem createKieFileSystemWithKProject(KieServices ks) {
        KieModuleModel kproj = ks.newKieModuleModel();
        KieBaseModel kieBaseModel1 = kproj.newKieBaseModel("KBase-test").setDefault(true).addPackage("*").setEqualsBehavior(EqualityBehaviorOption.EQUALITY).setEventProcessingMode(EventProcessingOption.STREAM);
        kieBaseModel1.newKieSessionModel("ksession-test").setDefault(true).setType(KieSessionModel.KieSessionType.STATEFUL).setClockType(ClockTypeOption.get((String)"realtime")).newWorkItemHandlerModel("Log", "new org.jbpm.process.instance.impl.demo.SystemOutWorkItemHandler()");
        kieBaseModel1.newKieSessionModel("ksession-test-2").setDefault(false).setType(KieSessionModel.KieSessionType.STATEFUL).setClockType(ClockTypeOption.get((String)"realtime")).newWorkItemHandlerModel("Log", "new org.jbpm.kie.services.test.objects.KieConteinerSystemOutWorkItemHandler(kieContainer)");
        kieBaseModel1.newKieSessionModel("ksession-test2").setDefault(false).setType(KieSessionModel.KieSessionType.STATEFUL).setClockType(ClockTypeOption.get((String)"realtime"));
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.writeKModuleXML(kproj.toXML());
        kfs.write("src/main/resources/forms/DefaultProcess.ftl", ResourceFactory.newClassPathResource((String)"repo/globals/forms/DefaultProcess.ftl"));
        kfs.write("src/main/resources/forms/DefaultProcess.form", ResourceFactory.newClassPathResource((String)"repo/globals/forms/DefaultProcess.form"));
        kfs.write("src/main/resources/forms/DefaultProcess.frm", ResourceFactory.newClassPathResource((String)"repo/globals/forms/DefaultProcess.frm"));
        return kfs;
    }

    protected void assertCorrelationAndProcess(UserTaskInstanceDesc userTask, long processInstanceId) {
        this.assertCorrelationAndProcess(userTask, Long.toString(processInstanceId));
    }

    protected void assertCorrelationAndProcess(UserTaskInstanceDesc userTask, String correlationKey) {
        Assert.assertEquals((Object)correlationKey, (Object)userTask.getCorrelationKey());
        Assert.assertEquals((Object)1, (Object)userTask.getProcessType());
    }

    protected void assertTasksDesc(List<UserTaskInstanceDesc> tasks, int expectedSize, long processInstanceId) {
        Assert.assertNotNull(tasks);
        Assert.assertEquals((long)expectedSize, (long)tasks.size());
        for (UserTaskInstanceDesc task : tasks) {
            this.assertCorrelationAndProcess(task, processInstanceId);
        }
    }

    protected void assertCorrelationAndProcess(TaskSummary userTask, long processInstanceId) {
        Assert.assertEquals((Object)Long.toString(processInstanceId), (Object)userTask.getCorrelationKey());
        Assert.assertEquals((Object)1, (Object)userTask.getProcessType());
    }

    protected void assertTasksSummary(List<TaskSummary> userTasks, int expectedSize, long processInstanceId) {
        Assert.assertNotNull(userTasks);
        Assert.assertEquals((long)expectedSize, (long)userTasks.size());
        for (TaskSummary task : userTasks) {
            this.assertCorrelationAndProcess(task, processInstanceId);
        }
    }
}

