/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.command.Command;
import org.kie.internal.command.ProcessInstanceIdCommand;
import org.reflections.Reflections;
import org.reflections.scanners.FieldAnnotationsScanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ClasspathHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonUtilsTest {
    private static final Logger logger = LoggerFactory.getLogger(CommonUtilsTest.class);
    private static final Reflections reflections = new Reflections(new Object[]{ClasspathHelper.forPackage((String)"org.drools", (ClassLoader[])new ClassLoader[0]), ClasspathHelper.forPackage((String)"org.jbpm", (ClassLoader[])new ClassLoader[0]), new TypeAnnotationsScanner(), new FieldAnnotationsScanner(), new SubTypesScanner()});

    @Test
    public void testProcessInstanceIdCommands() {
        ArrayList cmdClasses = new ArrayList(reflections.getSubTypesOf(Command.class));
        Assert.assertFalse((String)"Empty set of command classes to test?!?", (boolean)cmdClasses.isEmpty());
        Collections.sort(cmdClasses, new Comparator<Class>(){

            @Override
            public int compare(Class o1, Class o2) {
                if (o1 == null) {
                    return -1;
                }
                if (o2 == null) {
                    return 1;
                }
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (Class cmdClass : cmdClasses) {
            System.out.println(cmdClass.getName());
            Field procInstIdField = CommonUtilsTest.findProcessInstanceIdField(cmdClass);
            if (procInstIdField == null) continue;
            List<Class<?>> cmdClassInterfaces = Arrays.asList(cmdClass.getInterfaces());
            Assert.assertTrue((String)(cmdClass.getName() + " does not implement the " + ProcessInstanceIdCommand.class.getSimpleName() + " interface!"), (boolean)cmdClassInterfaces.contains(ProcessInstanceIdCommand.class));
        }
    }

    private static Field findProcessInstanceIdField(Class<? extends Command> cmdClass) {
        try {
            Field[] fields;
            for (Field field : fields = cmdClass.getDeclaredFields()) {
                field.setAccessible(true);
                if (field.isAnnotationPresent(XmlAttribute.class)) {
                    String attributeName = field.getAnnotation(XmlAttribute.class).name();
                    if ("process-instance-id".equalsIgnoreCase(attributeName)) {
                        return field;
                    }
                    if (!"processInstanceId".equals(field.getName())) continue;
                    return field;
                }
                if (field.isAnnotationPresent(XmlElement.class)) {
                    String elementName = field.getAnnotation(XmlElement.class).name();
                    if ("process-instance-id".equalsIgnoreCase(elementName)) {
                        return field;
                    }
                    if (!"processInstanceId".equals(field.getName())) continue;
                    return field;
                }
                if (!"processInstanceId".equals(field.getName())) continue;
                return field;
            }
        }
        catch (Exception e) {
            logger.debug("Unable to find process instance id field in {} due to {}", (Object)cmdClass.getName(), (Object)e.getMessage());
        }
        return null;
    }
}

