/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl;

import java.util.HashMap;
import org.drools.core.event.ProcessStartedEventImpl;
import org.jbpm.kie.services.impl.IdentityProviderAwareProcessListener;
import org.jbpm.workflow.instance.WorkflowProcessInstance;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieRuntime;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.internal.identity.IdentityProvider;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class IdentityProviderAwareProcessListenerTest {
    @Mock
    Environment environment;
    @Mock
    KieSession kSession;
    @InjectMocks
    IdentityProviderAwareProcessListener listener;

    @Before
    public void setup() {
        Mockito.when((Object)this.kSession.getEnvironment()).thenReturn((Object)this.environment);
    }

    @Test
    public void testSetUser() {
        IdentityProvider identityProvider = (IdentityProvider)Mockito.mock(IdentityProvider.class);
        String userId = "userId";
        Mockito.when((Object)identityProvider.getName()).thenReturn((Object)"userId");
        Mockito.when((Object)this.environment.get("IdentityProvider")).thenReturn((Object)identityProvider);
        WorkflowProcessInstance processInstance = (WorkflowProcessInstance)Mockito.mock(WorkflowProcessInstance.class);
        HashMap metaData = new HashMap();
        Mockito.when((Object)processInstance.getMetaData()).thenReturn(metaData);
        ProcessStartedEventImpl event = new ProcessStartedEventImpl((ProcessInstance)processInstance, (KieRuntime)Mockito.mock(KieRuntime.class));
        this.listener.beforeProcessStarted((ProcessStartedEvent)event);
        Assert.assertEquals((Object)"userId", metaData.get("OwnerId"));
        ((WorkflowProcessInstance)Mockito.verify((Object)processInstance)).setVariable("initiator", (Object)"userId");
    }

    @Test
    public void testUserNotSet() {
        WorkflowProcessInstance processInstance = (WorkflowProcessInstance)Mockito.mock(WorkflowProcessInstance.class);
        HashMap metaData = new HashMap();
        Mockito.when((Object)processInstance.getMetaData()).thenReturn(metaData);
        ProcessStartedEventImpl event = new ProcessStartedEventImpl((ProcessInstance)processInstance, (KieRuntime)Mockito.mock(KieRuntime.class));
        this.listener.beforeProcessStarted((ProcessStartedEvent)event);
        Assert.assertTrue((boolean)metaData.isEmpty());
        ((WorkflowProcessInstance)Mockito.verify((Object)processInstance, (VerificationMode)Mockito.never())).setVariable(Mockito.anyString(), (Object)Mockito.anyString());
    }
}

