/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl.admin;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.appformer.maven.support.AFReleaseId;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.kie.services.impl.admin.ProcessInstanceAdminServiceImpl;
import org.jbpm.kie.services.test.KModuleDeploymentServiceTest;
import org.jbpm.kie.test.util.AbstractKieServicesBaseTest;
import org.jbpm.kie.test.util.CountDownListenerFactory;
import org.jbpm.services.api.ProcessInstanceNotFoundException;
import org.jbpm.services.api.admin.ProcessInstanceAdminService;
import org.jbpm.services.api.admin.ProcessNode;
import org.jbpm.services.api.admin.TimerInstance;
import org.jbpm.services.api.model.DeploymentUnit;
import org.jbpm.services.api.model.NodeInstanceDesc;
import org.jbpm.services.api.model.ProcessInstanceDesc;
import org.jbpm.shared.services.impl.TransactionalCommandService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.query.QueryContext;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.identity.IdentityProvider;
import org.kie.internal.query.QueryFilter;
import org.kie.internal.runtime.conf.ObjectModel;
import org.kie.internal.runtime.error.ExecutionError;
import org.kie.scanner.KieMavenRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessInstanceAdminServiceImplTest
extends AbstractKieServicesBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(KModuleDeploymentServiceTest.class);
    protected static final String ADMIN_ARTIFACT_ID = "test-admin";
    protected static final String ADMIN_GROUP_ID = "org.jbpm.test";
    protected static final String ADMIN_VERSION_V1 = "1.0.0";
    private List<DeploymentUnit> units = new ArrayList<DeploymentUnit>();
    private KModuleDeploymentUnit deploymentUnit;
    private Long processInstanceId = null;
    protected ProcessInstanceAdminService processAdminService;

    @Before
    public void prepare() {
        this.configureServices();
        logger.debug("Preparing kjar");
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId(ADMIN_GROUP_ID, ADMIN_ARTIFACT_ID, ADMIN_VERSION_V1);
        ArrayList<String> processes = new ArrayList<String>();
        processes.add("repo/processes/general/humanTask.bpmn");
        processes.add("repo/processes/general/BPMN2-IntermediateCatchEventTimerDuration.bpmn2");
        processes.add("repo/processes/errors/BPMN2-BrokenScriptTask.bpmn2");
        processes.add("repo/processes/errors/BPMN2-UserTaskWithRollback.bpmn2");
        InternalKieModule kJar1 = this.createKieJar(ks, releaseId, processes);
        File pom = new File("target/admin", "pom.xml");
        pom.getParentFile().mkdir();
        try {
            FileOutputStream fs = new FileOutputStream(pom);
            fs.write(this.getPom(releaseId, new ReleaseId[0]).getBytes());
            fs.close();
        }
        catch (Exception fs) {
            // empty catch block
        }
        KieMavenRepository repository = KieMavenRepository.getKieMavenRepository();
        repository.installArtifact((AFReleaseId)releaseId, kJar1, pom);
        this.processAdminService = new ProcessInstanceAdminServiceImpl();
        ((ProcessInstanceAdminServiceImpl)this.processAdminService).setProcessService(this.processService);
        ((ProcessInstanceAdminServiceImpl)this.processAdminService).setRuntimeDataService(this.runtimeDataService);
        ((ProcessInstanceAdminServiceImpl)this.processAdminService).setCommandService(new TransactionalCommandService(this.emf));
        ((ProcessInstanceAdminServiceImpl)this.processAdminService).setIdentityProvider((IdentityProvider)this.identityProvider);
        this.deploymentUnit = new KModuleDeploymentUnit(ADMIN_GROUP_ID, ADMIN_ARTIFACT_ID, ADMIN_VERSION_V1);
        this.deploymentService.deploy((DeploymentUnit)this.deploymentUnit);
        this.units.add((DeploymentUnit)this.deploymentUnit);
    }

    @After
    public void cleanup() {
        ProcessInstanceAdminServiceImplTest.cleanupSingletonSessionId();
        if (this.processInstanceId != null) {
            try {
                this.processService.abortProcessInstance(this.processInstanceId);
                ProcessInstance pi = this.processService.getProcessInstance(this.processInstanceId);
                Assert.assertNull((Object)pi);
            }
            catch (ProcessInstanceNotFoundException processInstanceNotFoundException) {
                // empty catch block
            }
        }
        if (this.units != null && !this.units.isEmpty()) {
            for (DeploymentUnit unit : this.units) {
                try {
                    this.deploymentService.undeploy(unit);
                }
                catch (Exception exception) {}
            }
            this.units.clear();
        }
        this.close();
        CountDownListenerFactory.clear();
    }

    public void setProcessAdminService(ProcessInstanceAdminService processAdminService) {
        this.processAdminService = processAdminService;
    }

    @Test
    public void testGetNodes() {
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        Collection processNodes = this.processAdminService.getProcessNodes(this.processInstanceId.longValue());
        Assert.assertNotNull((Object)processNodes);
        Assert.assertEquals((long)8L, (long)processNodes.size());
        Map<String, String> mappedNodes = processNodes.stream().collect(Collectors.toMap(ProcessNode::getNodeName, ProcessNode::getNodeType));
        Assert.assertEquals((Object)"StartNode", (Object)mappedNodes.get("Start"));
        Assert.assertEquals((Object)"HumanTaskNode", (Object)mappedNodes.get("Write a Document"));
        Assert.assertEquals((Object)"Split", (Object)mappedNodes.get("Review and Translate"));
        Assert.assertEquals((Object)"HumanTaskNode", (Object)mappedNodes.get("Translate Document"));
        Assert.assertEquals((Object)"HumanTaskNode", (Object)mappedNodes.get("Review Document"));
        Assert.assertEquals((Object)"Join", (Object)mappedNodes.get("Reviewed and Translated"));
        Assert.assertEquals((Object)"ActionNode", (Object)mappedNodes.get("Report"));
        Assert.assertEquals((Object)"EndNode", (Object)mappedNodes.get("End"));
    }

    @Test
    public void testCancelAndTriger() {
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        Collection activeNodes = this.processAdminService.getActiveNodeInstances(this.processInstanceId.longValue());
        Assert.assertNotNull((Object)activeNodes);
        Assert.assertEquals((long)1L, (long)activeNodes.size());
        NodeInstanceDesc active = (NodeInstanceDesc)activeNodes.iterator().next();
        Assert.assertEquals((Object)"Write a Document", (Object)active.getName());
        List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("salaboy", new QueryFilter());
        Assert.assertEquals((long)1L, (long)tasks.size());
        this.processAdminService.cancelNodeInstance(this.processInstanceId.longValue(), active.getId().longValue());
        activeNodes = this.processAdminService.getActiveNodeInstances(this.processInstanceId.longValue());
        Assert.assertNotNull((Object)activeNodes);
        Assert.assertEquals((long)0L, (long)activeNodes.size());
        tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("salaboy", new QueryFilter());
        Assert.assertEquals((long)0L, (long)tasks.size());
        Collection processNodes = this.processAdminService.getProcessNodes(this.processInstanceId.longValue());
        ProcessNode writeDocNode = processNodes.stream().filter(pn -> pn.getNodeName().equals(active.getName())).findFirst().orElse(null);
        this.processAdminService.triggerNode(this.processInstanceId.longValue(), writeDocNode.getNodeId());
        activeNodes = this.processAdminService.getActiveNodeInstances(this.processInstanceId.longValue());
        Assert.assertNotNull((Object)activeNodes);
        Assert.assertEquals((long)1L, (long)activeNodes.size());
        tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("salaboy", new QueryFilter());
        Assert.assertEquals((long)1L, (long)tasks.size());
    }

    @Test
    public void testRetriggerNodeInstance() {
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        Collection activeNodes = this.processAdminService.getActiveNodeInstances(this.processInstanceId.longValue());
        Assert.assertNotNull((Object)activeNodes);
        Assert.assertEquals((long)1L, (long)activeNodes.size());
        NodeInstanceDesc active = (NodeInstanceDesc)activeNodes.iterator().next();
        Assert.assertEquals((Object)"Write a Document", (Object)active.getName());
        List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("salaboy", new QueryFilter());
        Assert.assertEquals((long)1L, (long)tasks.size());
        TaskSummary task = (TaskSummary)tasks.get(0);
        this.processAdminService.retriggerNodeInstance(this.processInstanceId.longValue(), active.getId().longValue());
        activeNodes = this.processAdminService.getActiveNodeInstances(this.processInstanceId.longValue());
        Assert.assertNotNull((Object)activeNodes);
        Assert.assertEquals((long)1L, (long)activeNodes.size());
        NodeInstanceDesc activeRetriggered = (NodeInstanceDesc)activeNodes.iterator().next();
        Assert.assertFalse((active.getId().longValue() == activeRetriggered.getId().longValue() ? 1 : 0) != 0);
        tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("salaboy", new QueryFilter());
        Assert.assertEquals((long)1L, (long)tasks.size());
        TaskSummary taskRetriggered = (TaskSummary)tasks.get(0);
        Assert.assertFalse((task.getId().longValue() == taskRetriggered.getId().longValue() ? 1 : 0) != 0);
    }

    @Test
    public void testCancelAndTrigerAnotherNode() {
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        Collection activeNodes = this.processAdminService.getActiveNodeInstances(this.processInstanceId.longValue());
        Assert.assertNotNull((Object)activeNodes);
        Assert.assertEquals((long)1L, (long)activeNodes.size());
        NodeInstanceDesc active = (NodeInstanceDesc)activeNodes.iterator().next();
        Assert.assertEquals((Object)"Write a Document", (Object)active.getName());
        List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("salaboy", new QueryFilter());
        Assert.assertEquals((long)1L, (long)tasks.size());
        this.processAdminService.cancelNodeInstance(this.processInstanceId.longValue(), active.getId().longValue());
        activeNodes = this.processAdminService.getActiveNodeInstances(this.processInstanceId.longValue());
        Assert.assertNotNull((Object)activeNodes);
        Assert.assertEquals((long)0L, (long)activeNodes.size());
        tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("salaboy", new QueryFilter());
        Assert.assertEquals((long)0L, (long)tasks.size());
        Collection processNodes = this.processAdminService.getProcessNodes(this.processInstanceId.longValue());
        ProcessNode writeDocNode = processNodes.stream().filter(pn -> pn.getNodeName().equals("Report")).findFirst().orElse(null);
        this.processAdminService.triggerNode(this.processInstanceId.longValue(), writeDocNode.getNodeId());
        activeNodes = this.processAdminService.getActiveNodeInstances(this.processInstanceId.longValue());
        Assert.assertNotNull((Object)activeNodes);
        Assert.assertEquals((long)0L, (long)activeNodes.size());
        tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("salaboy", new QueryFilter());
        Assert.assertEquals((long)0L, (long)tasks.size());
        ProcessInstanceDesc pi = this.runtimeDataService.getProcessInstanceById(this.processInstanceId.longValue());
        Assert.assertEquals((long)2L, (long)pi.getState().intValue());
        this.processInstanceId = null;
    }

    @Test
    public void testTrigerLastActionNode() {
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        Collection activeNodes = this.processAdminService.getActiveNodeInstances(this.processInstanceId.longValue());
        Assert.assertNotNull((Object)activeNodes);
        Assert.assertEquals((long)1L, (long)activeNodes.size());
        NodeInstanceDesc active = (NodeInstanceDesc)activeNodes.iterator().next();
        Assert.assertEquals((Object)"Write a Document", (Object)active.getName());
        List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("salaboy", new QueryFilter());
        Assert.assertEquals((long)1L, (long)tasks.size());
        Collection processNodes = this.processAdminService.getProcessNodes(this.processInstanceId.longValue());
        ProcessNode writeDocNode = processNodes.stream().filter(pn -> pn.getNodeName().equals("Report")).findFirst().orElse(null);
        this.processAdminService.triggerNode(this.processInstanceId.longValue(), writeDocNode.getNodeId());
        activeNodes = this.processAdminService.getActiveNodeInstances(this.processInstanceId.longValue());
        Assert.assertNotNull((Object)activeNodes);
        Assert.assertEquals((long)0L, (long)activeNodes.size());
        tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("salaboy", new QueryFilter());
        Assert.assertEquals((long)0L, (long)tasks.size());
        ProcessInstanceDesc pi = this.runtimeDataService.getProcessInstanceById(this.processInstanceId.longValue());
        Assert.assertEquals((long)2L, (long)pi.getState().intValue());
        this.processInstanceId = null;
    }

    @Test(timeout=10000L)
    public void testUpdateTimer() throws Exception {
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "IntermediateCatchEvent");
        Assert.assertNotNull((Object)this.processInstanceId);
        long scheduleTime = System.currentTimeMillis();
        Collection activeNodes = this.processAdminService.getActiveNodeInstances(this.processInstanceId.longValue());
        Assert.assertNotNull((Object)activeNodes);
        Assert.assertEquals((long)1L, (long)activeNodes.size());
        NodeInstanceDesc active = (NodeInstanceDesc)activeNodes.iterator().next();
        Assert.assertEquals((Object)"timer", (Object)active.getName());
        Collection timers = this.processAdminService.getTimerInstances(this.processInstanceId.longValue());
        Assert.assertNotNull((Object)timers);
        Assert.assertEquals((long)1L, (long)timers.size());
        TimerInstance timer = (TimerInstance)timers.iterator().next();
        Assert.assertNotNull((Object)timer.getActivationTime());
        Assert.assertNotNull((Object)timer.getDelay());
        Assert.assertNotNull((Object)timer.getNextFireTime());
        Assert.assertNotNull((Object)timer.getProcessInstanceId());
        Assert.assertNotNull((Object)timer.getSessionId());
        Assert.assertNotNull((Object)timer.getTimerId());
        Assert.assertNotNull((Object)timer.getTimerName());
        Thread.sleep(1000L);
        this.processAdminService.updateTimer(this.processInstanceId.longValue(), timer.getTimerId(), 3L, 0L, 0);
        CountDownListenerFactory.getExisting("processAdminService").waitTillCompleted();
        long fireTime = System.currentTimeMillis();
        long expirationTime = fireTime - scheduleTime;
        Assert.assertTrue((expirationTime < 4000L ? 1 : 0) != 0);
        ProcessInstanceDesc pi = this.runtimeDataService.getProcessInstanceById(this.processInstanceId.longValue());
        Assert.assertEquals((long)2L, (long)pi.getState().intValue());
        this.processInstanceId = null;
    }

    @Test(timeout=10000L)
    public void testUpdateTimerRelative() throws Exception {
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "IntermediateCatchEvent");
        Assert.assertNotNull((Object)this.processInstanceId);
        long scheduleTime = System.currentTimeMillis();
        Collection activeNodes = this.processAdminService.getActiveNodeInstances(this.processInstanceId.longValue());
        Assert.assertNotNull((Object)activeNodes);
        Assert.assertEquals((long)1L, (long)activeNodes.size());
        NodeInstanceDesc active = (NodeInstanceDesc)activeNodes.iterator().next();
        Assert.assertEquals((Object)"timer", (Object)active.getName());
        Collection timers = this.processAdminService.getTimerInstances(this.processInstanceId.longValue());
        Assert.assertNotNull((Object)timers);
        Assert.assertEquals((long)1L, (long)timers.size());
        TimerInstance timer = (TimerInstance)timers.iterator().next();
        Assert.assertNotNull((Object)timer.getActivationTime());
        Assert.assertNotNull((Object)timer.getDelay());
        Assert.assertNotNull((Object)timer.getNextFireTime());
        Assert.assertNotNull((Object)timer.getProcessInstanceId());
        Assert.assertNotNull((Object)timer.getSessionId());
        Assert.assertNotNull((Object)timer.getTimerId());
        Assert.assertNotNull((Object)timer.getTimerName());
        Thread.sleep(1000L);
        this.processAdminService.updateTimerRelative(this.processInstanceId.longValue(), timer.getTimerId(), 3L, 0L, 0);
        CountDownListenerFactory.getExisting("processAdminService").waitTillCompleted();
        long fireTime = System.currentTimeMillis();
        long expirationTime = fireTime - scheduleTime;
        Assert.assertTrue((expirationTime > 3000L ? 1 : 0) != 0);
        ProcessInstanceDesc pi = this.runtimeDataService.getProcessInstanceById(this.processInstanceId.longValue());
        Assert.assertEquals((long)2L, (long)pi.getState().intValue());
        this.processInstanceId = null;
    }

    @Test
    public void testErrorHandlingOnScriptTask() {
        try {
            this.processService.startProcess(this.deploymentUnit.getIdentifier(), "BrokenScriptTask");
        }
        catch (Exception exception) {
            // empty catch block
        }
        List errors = this.processAdminService.getErrors(true, new QueryContext());
        Assert.assertNotNull((Object)errors);
        Assert.assertEquals((long)1L, (long)errors.size());
        ExecutionError error = (ExecutionError)errors.get(0);
        Assert.assertNotNull((Object)error);
        Assert.assertFalse((boolean)error.isAcknowledged());
        this.processAdminService.acknowledgeError(new String[]{error.getErrorId()});
        errors = this.processAdminService.getErrors(true, new QueryContext());
        Assert.assertNotNull((Object)errors);
        Assert.assertEquals((long)1L, (long)errors.size());
        error = (ExecutionError)errors.get(0);
        Assert.assertNotNull((Object)error);
        Assert.assertTrue((boolean)error.isAcknowledged());
    }

    @Override
    protected List<ObjectModel> getProcessListeners() {
        List<ObjectModel> listeners = super.getProcessListeners();
        listeners.add(new ObjectModel("mvel", "org.jbpm.kie.test.util.CountDownListenerFactory.get(\"processAdminService\", \"timer\", 1)", new Object[0]));
        return listeners;
    }

    @Override
    protected boolean createDescriptor() {
        return true;
    }
}

