/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl.admin;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.appformer.maven.support.AFReleaseId;
import org.assertj.core.api.Assertions;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.kie.services.impl.admin.UserTaskAdminServiceImpl;
import org.jbpm.kie.services.impl.query.SqlQueryDefinition;
import org.jbpm.kie.services.impl.query.mapper.RawListQueryMapper;
import org.jbpm.kie.services.impl.query.mapper.TaskSummaryQueryMapper;
import org.jbpm.kie.services.impl.query.mapper.UserTaskInstanceQueryMapper;
import org.jbpm.kie.services.test.KModuleDeploymentServiceTest;
import org.jbpm.kie.test.util.AbstractKieServicesBaseTest;
import org.jbpm.kie.test.util.CountDownListenerFactory;
import org.jbpm.services.api.ProcessInstanceNotFoundException;
import org.jbpm.services.api.TaskNotFoundException;
import org.jbpm.services.api.admin.UserTaskAdminService;
import org.jbpm.services.api.model.DeploymentUnit;
import org.jbpm.services.api.model.UserTaskInstanceDesc;
import org.jbpm.services.api.query.QueryResultMapper;
import org.jbpm.services.api.query.model.QueryDefinition;
import org.jbpm.services.api.query.model.QueryParam;
import org.jbpm.shared.services.impl.TransactionalCommandService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.query.QueryContext;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.TaskSummary;
import org.kie.api.task.model.User;
import org.kie.internal.identity.IdentityProvider;
import org.kie.internal.query.QueryFilter;
import org.kie.internal.runtime.conf.ObjectModel;
import org.kie.internal.task.api.TaskModelFactory;
import org.kie.internal.task.api.TaskModelProvider;
import org.kie.internal.task.api.model.EmailNotification;
import org.kie.internal.task.api.model.Notification;
import org.kie.internal.task.api.model.TaskEvent;
import org.kie.scanner.KieMavenRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserTaskAdminServiceImplTest
extends AbstractKieServicesBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(KModuleDeploymentServiceTest.class);
    protected static final String ADMIN_ARTIFACT_ID = "test-admin";
    protected static final String ADMIN_GROUP_ID = "org.jbpm.test";
    protected static final String ADMIN_VERSION_V1 = "1.0.0";
    private List<DeploymentUnit> units = new ArrayList<DeploymentUnit>();
    private KModuleDeploymentUnit deploymentUnit;
    private Long processInstanceId = null;
    protected UserTaskAdminService userTaskAdminService;
    private TaskModelFactory factory = TaskModelProvider.getFactory();

    @Before
    public void prepare() {
        this.configureServices();
        logger.debug("Preparing kjar");
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId(ADMIN_GROUP_ID, ADMIN_ARTIFACT_ID, ADMIN_VERSION_V1);
        ArrayList<String> processes = new ArrayList<String>();
        processes.add("repo/processes/general/humanTask.bpmn");
        InternalKieModule kJar1 = this.createKieJar(ks, releaseId, processes);
        File pom = new File("target/admin", "pom.xml");
        pom.getParentFile().mkdir();
        try {
            FileOutputStream fs = new FileOutputStream(pom);
            fs.write(this.getPom(releaseId, new ReleaseId[0]).getBytes());
            fs.close();
        }
        catch (Exception fs) {
            // empty catch block
        }
        KieMavenRepository repository = KieMavenRepository.getKieMavenRepository();
        repository.installArtifact((AFReleaseId)releaseId, kJar1, pom);
        this.userTaskAdminService = new UserTaskAdminServiceImpl();
        ((UserTaskAdminServiceImpl)this.userTaskAdminService).setUserTaskService(this.userTaskService);
        ((UserTaskAdminServiceImpl)this.userTaskAdminService).setRuntimeDataService(this.runtimeDataService);
        ((UserTaskAdminServiceImpl)this.userTaskAdminService).setIdentityProvider((IdentityProvider)this.identityProvider);
        ((UserTaskAdminServiceImpl)this.userTaskAdminService).setCommandService(new TransactionalCommandService(this.emf));
        this.deploymentUnit = new KModuleDeploymentUnit(ADMIN_GROUP_ID, ADMIN_ARTIFACT_ID, ADMIN_VERSION_V1);
        this.deploymentService.deploy((DeploymentUnit)this.deploymentUnit);
        this.units.add((DeploymentUnit)this.deploymentUnit);
        this.identityProvider.setName("Administrator");
        this.identityProvider.setRoles(Collections.singletonList(""));
    }

    @After
    public void cleanup() {
        UserTaskAdminServiceImplTest.cleanupSingletonSessionId();
        if (this.processInstanceId != null) {
            try {
                this.processService.abortProcessInstance(this.processInstanceId);
                ProcessInstance pi = this.processService.getProcessInstance(this.processInstanceId);
                Assertions.assertThat((Object)pi).isNull();
            }
            catch (ProcessInstanceNotFoundException processInstanceNotFoundException) {
                // empty catch block
            }
        }
        if (this.units != null && !this.units.isEmpty()) {
            for (DeploymentUnit unit : this.units) {
                try {
                    this.deploymentService.undeploy(unit);
                }
                catch (Exception exception) {}
            }
            this.units.clear();
        }
        this.close();
        CountDownListenerFactory.clear();
    }

    public void setUserTaskAdminService(UserTaskAdminService userTaskAdminService) {
        this.userTaskAdminService = userTaskAdminService;
    }

    @Test
    public void testAddPotentialOwnersNotBusinessAdmin() {
        this.identityProvider.setName("notAdmin");
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assertions.assertThat((Long)this.processInstanceId).isNotNull();
        List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("salaboy", new QueryFilter());
        Assertions.assertThat((List)tasks).hasSize(1);
        TaskSummary task = (TaskSummary)tasks.get(0);
        this.userTaskService.release(task.getId(), "salaboy");
        Assertions.assertThatThrownBy(() -> this.userTaskAdminService.addPotentialOwners(task.getId().longValue(), false, new OrganizationalEntity[]{this.factory.newUser("john")})).hasMessageContaining("User notAdmin is not business admin of task 1");
    }

    @Test
    public void testAddPotentialOwnersToNonExistentTask() {
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assertions.assertThat((Long)this.processInstanceId).isNotNull();
        List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("salaboy", new QueryFilter());
        Assertions.assertThat((List)tasks).hasSize(1);
        TaskSummary task = (TaskSummary)tasks.get(0);
        this.userTaskService.release(task.getId(), "salaboy");
        Assertions.assertThatThrownBy(() -> this.userTaskAdminService.addPotentialOwners(15456L, false, new OrganizationalEntity[]{this.factory.newUser("john")})).hasMessageContaining("Task with id 15456 was not found");
    }

    @Test
    public void testAddRemovePotentialOwnersAsGroup() {
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assertions.assertThat((Long)this.processInstanceId).isNotNull();
        List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("salaboy", new QueryFilter());
        Assertions.assertThat((List)tasks).hasSize(1);
        TaskSummary task = (TaskSummary)tasks.get(0);
        this.userTaskService.release(task.getId(), "salaboy");
        this.identityProvider.setRoles(Collections.singletonList("HR"));
        this.userTaskAdminService.addPotentialOwners(task.getId().longValue(), true, new OrganizationalEntity[]{this.factory.newGroup("HR")});
        tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("katy", new QueryFilter());
        Assertions.assertThat((List)tasks).hasSize(1);
        this.userTaskAdminService.removePotentialOwners(task.getId().longValue(), new OrganizationalEntity[]{this.factory.newGroup("HR")});
        tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("katy", new QueryFilter());
        Assertions.assertThat((List)tasks).hasSize(0);
        this.identityProvider.setRoles(Collections.singletonList("Accounting"));
        this.userTaskAdminService.addPotentialOwners(task.getId().longValue(), false, new OrganizationalEntity[]{this.factory.newGroup("Accounting")});
        tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("mary", new QueryFilter());
        Assertions.assertThat((List)tasks).hasSize(1);
    }

    @Test
    public void testAddPotentialOwners() {
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assertions.assertThat((Long)this.processInstanceId).isNotNull();
        List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("salaboy", new QueryFilter());
        Assertions.assertThat((List)tasks).hasSize(1);
        TaskSummary task = (TaskSummary)tasks.get(0);
        this.userTaskService.release(task.getId(), "salaboy");
        this.userTaskAdminService.addPotentialOwners(task.getId().longValue(), false, new OrganizationalEntity[]{this.factory.newUser("john")});
        List events = this.runtimeDataService.getTaskEvents(task.getId().longValue(), new QueryFilter());
        Assertions.assertThat((List)events).hasSize(3);
        TaskEvent updatedEvent = (TaskEvent)events.get(2);
        Assertions.assertThat((String)updatedEvent.getMessage()).isEqualTo((Object)"Potential owners [john] have been added");
        tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("salaboy", new QueryFilter());
        Assertions.assertThat((List)tasks).hasSize(1);
        tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
        Assertions.assertThat((List)tasks).hasSize(1);
        this.userTaskAdminService.addPotentialOwners(task.getId().longValue(), true, new OrganizationalEntity[]{this.factory.newUser("john")});
        tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("salaboy", new QueryFilter());
        Assertions.assertThat((List)tasks).hasSize(0);
        tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
        Assertions.assertThat((List)tasks).hasSize(1);
    }

    @Test
    public void testAddPotentialOwnersWrongDeploymentId() {
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assertions.assertThat((Long)this.processInstanceId).isNotNull();
        List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("salaboy", new QueryFilter());
        Assertions.assertThat((List)tasks).hasSize(1);
        TaskSummary task = (TaskSummary)tasks.get(0);
        this.userTaskService.release(task.getId(), "salaboy");
        Assertions.assertThatExceptionOfType(TaskNotFoundException.class).isThrownBy(() -> this.userTaskAdminService.addPotentialOwners("wrong-one", task.getId().longValue(), false, new OrganizationalEntity[]{this.factory.newUser("john")})).withMessageContaining("Task with id " + task.getId() + " is not associated with wrong-one");
        tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
        Assertions.assertThat((List)tasks).hasSize(0);
    }

    @Test
    public void testAddExcludedOwners() {
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assertions.assertThat((Long)this.processInstanceId).isNotNull();
        List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("salaboy", new QueryFilter());
        Assertions.assertThat((List)tasks).hasSize(1);
        TaskSummary task = (TaskSummary)tasks.get(0);
        this.userTaskService.release(task.getId(), "salaboy");
        this.userTaskAdminService.addExcludedOwners(task.getId().longValue(), false, new OrganizationalEntity[]{this.factory.newUser("salaboy")});
        List events = this.runtimeDataService.getTaskEvents(task.getId().longValue(), new QueryFilter());
        Assertions.assertThat((List)events).hasSize(3);
        TaskEvent updatedEvent = (TaskEvent)events.get(2);
        Assertions.assertThat((String)updatedEvent.getMessage()).isEqualTo((Object)"Excluded owners [salaboy] have been added");
        tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("salaboy", new QueryFilter());
        Assertions.assertThat((List)tasks).hasSize(0);
        tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
        Assertions.assertThat((List)tasks).hasSize(0);
        this.userTaskAdminService.addExcludedOwners(task.getId().longValue(), true, new OrganizationalEntity[]{this.factory.newUser("john")});
        tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("salaboy", new QueryFilter());
        Assertions.assertThat((List)tasks).hasSize(1);
        tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
        Assertions.assertThat((List)tasks).hasSize(0);
    }

    @Test
    public void testAddBusinessAdmins() {
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assertions.assertThat((Long)this.processInstanceId).isNotNull();
        List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("salaboy", new QueryFilter());
        Assertions.assertThat((List)tasks).hasSize(1);
        TaskSummary task = (TaskSummary)tasks.get(0);
        this.userTaskService.release(task.getId(), "salaboy");
        tasks = this.runtimeDataService.getTasksAssignedAsBusinessAdministrator("salaboy", new QueryFilter());
        Assertions.assertThat((List)tasks).hasSize(0);
        this.userTaskAdminService.addBusinessAdmins(task.getId().longValue(), false, new OrganizationalEntity[]{this.factory.newUser("salaboy")});
        List events = this.runtimeDataService.getTaskEvents(task.getId().longValue(), new QueryFilter());
        Assertions.assertThat((List)events).hasSize(3);
        TaskEvent updatedEvent = (TaskEvent)events.get(2);
        Assertions.assertThat((String)updatedEvent.getMessage()).isEqualTo((Object)"Business administrators [salaboy] have been added");
        tasks = this.runtimeDataService.getTasksAssignedAsBusinessAdministrator("salaboy", new QueryFilter());
        Assertions.assertThat((List)tasks).hasSize(1);
        tasks = this.runtimeDataService.getTasksAssignedAsBusinessAdministrator("Administrator", new QueryFilter());
        Assertions.assertThat((List)tasks).hasSize(1);
        this.userTaskAdminService.addBusinessAdmins(task.getId().longValue(), true, new OrganizationalEntity[]{this.factory.newUser("salaboy")});
        tasks = this.runtimeDataService.getTasksAssignedAsBusinessAdministrator("salaboy", new QueryFilter());
        Assertions.assertThat((List)tasks).hasSize(1);
        tasks = this.runtimeDataService.getTasksAssignedAsBusinessAdministrator("Administrator", new QueryFilter());
        Assertions.assertThat((List)tasks).hasSize(0);
    }

    @Test
    public void testRemovePotentialOwners() {
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assertions.assertThat((Long)this.processInstanceId).isNotNull();
        List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("salaboy", new QueryFilter());
        Assertions.assertThat((List)tasks).hasSize(1);
        TaskSummary task = (TaskSummary)tasks.get(0);
        this.userTaskService.release(task.getId(), "salaboy");
        this.userTaskAdminService.removePotentialOwners(task.getId().longValue(), new OrganizationalEntity[]{this.factory.newUser("salaboy")});
        List events = this.runtimeDataService.getTaskEvents(task.getId().longValue(), new QueryFilter());
        Assertions.assertThat((List)events).hasSize(3);
        TaskEvent updatedEvent = (TaskEvent)events.get(2);
        Assertions.assertThat((String)updatedEvent.getMessage()).isEqualTo((Object)"Potential owners [salaboy] have been removed");
        tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("salaboy", new QueryFilter());
        Assertions.assertThat((List)tasks).hasSize(0);
    }

    @Test
    public void testRemoveExcludedOwners() {
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assertions.assertThat((Long)this.processInstanceId).isNotNull();
        List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("salaboy", new QueryFilter());
        Assertions.assertThat((List)tasks).hasSize(1);
        TaskSummary task = (TaskSummary)tasks.get(0);
        this.userTaskService.release(task.getId(), "salaboy");
        this.userTaskAdminService.addExcludedOwners(task.getId().longValue(), false, new OrganizationalEntity[]{this.factory.newUser("salaboy")});
        List events = this.runtimeDataService.getTaskEvents(task.getId().longValue(), new QueryFilter());
        Assertions.assertThat((List)events).hasSize(3);
        TaskEvent updatedEvent = (TaskEvent)events.get(2);
        Assertions.assertThat((String)updatedEvent.getMessage()).isEqualTo((Object)"Excluded owners [salaboy] have been added");
        tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("salaboy", new QueryFilter());
        Assertions.assertThat((List)tasks).hasSize(0);
        this.userTaskAdminService.removeExcludedOwners(task.getId().longValue(), new OrganizationalEntity[]{this.factory.newUser("salaboy")});
        events = this.runtimeDataService.getTaskEvents(task.getId().longValue(), new QueryFilter());
        Assertions.assertThat((List)events).hasSize(4);
        updatedEvent = (TaskEvent)events.get(3);
        Assertions.assertThat((String)updatedEvent.getMessage()).isEqualTo((Object)"Excluded owners [salaboy] have been removed");
        tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("salaboy", new QueryFilter());
        Assertions.assertThat((List)tasks).hasSize(1);
    }

    @Test
    public void testRemoveBusinessAdmin() {
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assertions.assertThat((Long)this.processInstanceId).isNotNull();
        List tasks = this.runtimeDataService.getTasksAssignedAsBusinessAdministrator("Administrator", new QueryFilter());
        Assertions.assertThat((List)tasks).hasSize(1);
        TaskSummary task = (TaskSummary)tasks.get(0);
        this.userTaskAdminService.removeBusinessAdmins(task.getId().longValue(), new OrganizationalEntity[]{this.factory.newUser("Administrator")});
        List events = this.runtimeDataService.getTaskEvents(task.getId().longValue(), new QueryFilter());
        Assertions.assertThat((List)events).hasSize(2);
        TaskEvent updatedEvent = (TaskEvent)events.get(1);
        Assertions.assertThat((String)updatedEvent.getMessage()).isEqualTo((Object)"Business administrators [Administrator] have been removed");
        List<Status> readyStatuses = Arrays.asList(Status.Ready);
        tasks = this.runtimeDataService.getTasksAssignedAsBusinessAdministratorByStatus("Administrator", readyStatuses, new QueryFilter());
        Assertions.assertThat((List)tasks).hasSize(0);
    }

    @Test
    public void testAddRemoveInputData() {
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assertions.assertThat((Long)this.processInstanceId).isNotNull();
        List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("salaboy", new QueryFilter());
        Assertions.assertThat((List)tasks).hasSize(1);
        TaskSummary task = (TaskSummary)tasks.get(0);
        Map inputData = this.userTaskService.getTaskInputContentByTaskId(task.getId());
        Assertions.assertThat((Map)inputData).doesNotContainKey((Object)"added-input");
        this.userTaskAdminService.addTaskInput(task.getId().longValue(), "added-input", (Object)"just a test");
        inputData = this.userTaskService.getTaskInputContentByTaskId(task.getId());
        Assertions.assertThat((Map)inputData).containsKey((Object)"added-input");
        Assertions.assertThat(inputData.get("added-input")).isEqualTo((Object)"just a test");
        Assertions.assertThat((Map)inputData).doesNotContainKey((Object)"added-input2");
        Assertions.assertThat((Map)inputData).doesNotContainKey((Object)"added-input3");
        HashMap<String, String> extra = new HashMap<String, String>();
        extra.put("added-input2", "1");
        extra.put("added-input3", "2");
        this.userTaskAdminService.addTaskInputs(task.getId().longValue(), extra);
        inputData = this.userTaskService.getTaskInputContentByTaskId(task.getId());
        Assertions.assertThat((Map)inputData).containsKey((Object)"added-input2");
        Assertions.assertThat(inputData.get("added-input2")).isEqualTo((Object)"1");
        Assertions.assertThat((Map)inputData).containsKey((Object)"added-input3");
        Assertions.assertThat(inputData.get("added-input3")).isEqualTo((Object)"2");
        this.userTaskAdminService.removeTaskInputs(task.getId().longValue(), new String[]{"added-input2", "added-input3"});
        inputData = this.userTaskService.getTaskInputContentByTaskId(task.getId());
        Assertions.assertThat((Map)inputData).doesNotContainKey((Object)"added-input2");
        Assertions.assertThat((Map)inputData).doesNotContainKey((Object)"added-input3");
    }

    @Test
    public void testRemoveOutputData() {
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assertions.assertThat((Long)this.processInstanceId).isNotNull();
        List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("salaboy", new QueryFilter());
        Assertions.assertThat((List)tasks).hasSize(1);
        TaskSummary task = (TaskSummary)tasks.get(0);
        HashMap<String, String> output = new HashMap<String, String>();
        output.put("added-output", "draft");
        this.userTaskService.saveContent(task.getId(), output);
        Map outputData = this.userTaskService.getTaskOutputContentByTaskId(task.getId());
        Assertions.assertThat((Map)outputData).containsKey((Object)"added-output");
        Assertions.assertThat(outputData.get("added-output")).isEqualTo((Object)"draft");
        this.userTaskAdminService.removeTaskOutputs(task.getId().longValue(), new String[]{"added-output"});
        outputData = this.userTaskService.getTaskOutputContentByTaskId(task.getId());
        Assertions.assertThat((Map)outputData).doesNotContainKey((Object)"added-output");
    }

    @Test(timeout=10000L)
    public void testReassignNotStarted() throws Exception {
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assertions.assertThat((Long)this.processInstanceId).isNotNull();
        List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("salaboy", new QueryFilter());
        Assertions.assertThat((List)tasks).hasSize(1);
        TaskSummary task = (TaskSummary)tasks.get(0);
        this.userTaskAdminService.reassignWhenNotStarted(task.getId().longValue(), "2s", new OrganizationalEntity[]{this.factory.newUser("john")});
        CountDownListenerFactory.getExistingTask("userTaskAdminService").waitTillCompleted();
        tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("salaboy", new QueryFilter());
        Assertions.assertThat((List)tasks).hasSize(0);
        tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
        Assertions.assertThat((List)tasks).hasSize(1);
    }

    @Test(timeout=10000L)
    public void testReassignNotStartedInvalidTimeExpression() throws Exception {
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assertions.assertThat((Long)this.processInstanceId).isNotNull();
        List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("salaboy", new QueryFilter());
        Assertions.assertThat((List)tasks).hasSize(1);
        TaskSummary task = (TaskSummary)tasks.get(0);
        Assertions.assertThatThrownBy(() -> this.userTaskAdminService.reassignWhenNotStarted(task.getId().longValue(), "2ssssssss", new OrganizationalEntity[]{this.factory.newUser("john")})).hasMessage("Error parsing time string: [ 2ssssssss ]");
        Assertions.assertThatThrownBy(() -> this.userTaskAdminService.reassignWhenNotStarted(task.getId().longValue(), null, new OrganizationalEntity[]{this.factory.newUser("john")})).hasMessage("Invalid time expression");
        Assertions.assertThatThrownBy(() -> this.userTaskAdminService.reassignWhenNotStarted(task.getId().longValue(), "", new OrganizationalEntity[]{this.factory.newUser("john")})).hasMessage("Invalid time expression");
    }

    @Test(timeout=10000L)
    public void testReassignNotStartedInvalidOrgEntities() throws Exception {
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assertions.assertThat((Long)this.processInstanceId).isNotNull();
        List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("salaboy", new QueryFilter());
        Assertions.assertThat((List)tasks).hasSize(1);
        TaskSummary task = (TaskSummary)tasks.get(0);
        Assertions.assertThatThrownBy(() -> this.userTaskAdminService.reassignWhenNotStarted(task.getId().longValue(), "2s", null)).hasMessage("Invalid org entity");
    }

    @Test(timeout=10000L)
    public void testReassignNotCompleted() throws Exception {
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assertions.assertThat((Long)this.processInstanceId).isNotNull();
        List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("salaboy", new QueryFilter());
        Assertions.assertThat((List)tasks).hasSize(1);
        TaskSummary task = (TaskSummary)tasks.get(0);
        this.userTaskService.start(task.getId(), "salaboy");
        Collection reassignments = this.userTaskAdminService.getTaskReassignments(task.getId().longValue(), false);
        Assertions.assertThat((Iterable)reassignments).isNotNull();
        Assertions.assertThat((Iterable)reassignments).hasSize(0);
        this.userTaskAdminService.reassignWhenNotCompleted(task.getId().longValue(), "2s", new OrganizationalEntity[]{this.factory.newUser("john")});
        reassignments = this.userTaskAdminService.getTaskReassignments(task.getId().longValue(), true);
        Assertions.assertThat((Iterable)reassignments).isNotNull();
        Assertions.assertThat((Iterable)reassignments).hasSize(1);
        CountDownListenerFactory.getExistingTask("userTaskAdminService").waitTillCompleted();
        tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("salaboy", new QueryFilter());
        Assertions.assertThat((List)tasks).hasSize(0);
        tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
        Assertions.assertThat((List)tasks).hasSize(1);
        reassignments = this.userTaskAdminService.getTaskReassignments(task.getId().longValue(), true);
        Assertions.assertThat((Iterable)reassignments).isNotNull();
        Assertions.assertThat((Iterable)reassignments).hasSize(0);
        reassignments = this.userTaskAdminService.getTaskReassignments(task.getId().longValue(), false);
        Assertions.assertThat((Iterable)reassignments).isNotNull();
        Assertions.assertThat((Iterable)reassignments).hasSize(1);
    }

    @Test(timeout=10000L)
    public void testReassignNotCompletedInvalidTimeExpression() throws Exception {
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assertions.assertThat((Long)this.processInstanceId).isNotNull();
        List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("salaboy", new QueryFilter());
        Assertions.assertThat((List)tasks).hasSize(1);
        TaskSummary task = (TaskSummary)tasks.get(0);
        this.userTaskService.start(task.getId(), "salaboy");
        Collection reassignments = this.userTaskAdminService.getTaskReassignments(task.getId().longValue(), false);
        Assertions.assertThat((Iterable)reassignments).isNotNull();
        Assertions.assertThat((Iterable)reassignments).hasSize(0);
        Assertions.assertThatThrownBy(() -> this.userTaskAdminService.reassignWhenNotCompleted(task.getId().longValue(), "2ssssssss", new OrganizationalEntity[]{this.factory.newUser("john")})).hasMessage("Error parsing time string: [ 2ssssssss ]");
        Assertions.assertThatThrownBy(() -> this.userTaskAdminService.reassignWhenNotCompleted(task.getId().longValue(), null, new OrganizationalEntity[]{this.factory.newUser("john")})).hasMessage("Invalid time expression");
        Assertions.assertThatThrownBy(() -> this.userTaskAdminService.reassignWhenNotCompleted(task.getId().longValue(), "", new OrganizationalEntity[]{this.factory.newUser("john")})).hasMessage("Invalid time expression");
    }

    @Test(timeout=10000L)
    public void testReassignNotCompletedInvalidOrgEntities() throws Exception {
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assertions.assertThat((Long)this.processInstanceId).isNotNull();
        List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("salaboy", new QueryFilter());
        Assertions.assertThat((List)tasks).hasSize(1);
        TaskSummary task = (TaskSummary)tasks.get(0);
        this.userTaskService.start(task.getId(), "salaboy");
        Collection reassignments = this.userTaskAdminService.getTaskReassignments(task.getId().longValue(), false);
        Assertions.assertThat((Iterable)reassignments).isNotNull();
        Assertions.assertThat((Iterable)reassignments).hasSize(0);
        Assertions.assertThatThrownBy(() -> this.userTaskAdminService.reassignWhenNotCompleted(task.getId().longValue(), "2s", null)).hasMessage("Invalid org entity");
    }

    @Test(timeout=10000L)
    public void testNotifyNotStarted() throws Exception {
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assertions.assertThat((Long)this.processInstanceId).isNotNull();
        List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("salaboy", new QueryFilter());
        Assertions.assertThat((List)tasks).hasSize(1);
        TaskSummary task = (TaskSummary)tasks.get(0);
        ArrayList<User> recipients = new ArrayList<User>();
        recipients.add(this.factory.newUser("john"));
        EmailNotification emailNotification = this.userTaskAdminService.buildEmailNotification("test", recipients, "Simple body", "Administrator", "");
        this.userTaskAdminService.notifyWhenNotStarted(task.getId().longValue(), "2s", (Notification)emailNotification);
        CountDownListenerFactory.getExistingTask("userTaskAdminService").waitTillCompleted();
        tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("salaboy", new QueryFilter());
        Assertions.assertThat((List)tasks).hasSize(1);
    }

    @Test(timeout=10000L)
    public void testNotifyNotCompleted() throws Exception {
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assertions.assertThat((Long)this.processInstanceId).isNotNull();
        List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("salaboy", new QueryFilter());
        Assertions.assertThat((List)tasks).hasSize(1);
        TaskSummary task = (TaskSummary)tasks.get(0);
        Collection notifications = this.userTaskAdminService.getTaskNotifications(task.getId().longValue(), false);
        Assertions.assertThat((Iterable)notifications).isNotNull();
        Assertions.assertThat((Iterable)notifications).hasSize(0);
        this.userTaskService.start(task.getId(), "salaboy");
        ArrayList<User> recipients = new ArrayList<User>();
        recipients.add(this.factory.newUser("john"));
        EmailNotification emailNotification = this.userTaskAdminService.buildEmailNotification("test", recipients, "Simple body", "Administrator", "");
        this.userTaskAdminService.notifyWhenNotCompleted(task.getId().longValue(), "2s", (Notification)emailNotification);
        notifications = this.userTaskAdminService.getTaskNotifications(task.getId().longValue(), false);
        Assertions.assertThat((Iterable)notifications).isNotNull();
        Assertions.assertThat((Iterable)notifications).hasSize(1);
        CountDownListenerFactory.getExistingTask("userTaskAdminService").waitTillCompleted();
        tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("salaboy", new QueryFilter());
        Assertions.assertThat((List)tasks).hasSize(1);
        notifications = this.userTaskAdminService.getTaskNotifications(task.getId().longValue(), true);
        Assertions.assertThat((Iterable)notifications).isNotNull();
        Assertions.assertThat((Iterable)notifications).hasSize(0);
        notifications = this.userTaskAdminService.getTaskNotifications(task.getId().longValue(), false);
        Assertions.assertThat((Iterable)notifications).isNotNull();
        Assertions.assertThat((Iterable)notifications).hasSize(1);
    }

    @Test(timeout=10000L)
    public void testNotifyNotStartedAndCancel() throws Exception {
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assertions.assertThat((Long)this.processInstanceId).isNotNull();
        List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("salaboy", new QueryFilter());
        Assertions.assertThat((List)tasks).hasSize(1);
        TaskSummary task = (TaskSummary)tasks.get(0);
        Collection notifications = this.userTaskAdminService.getTaskNotifications(task.getId().longValue(), false);
        Assertions.assertThat((Iterable)notifications).isNotNull();
        Assertions.assertThat((Iterable)notifications).hasSize(0);
        ArrayList<User> recipients = new ArrayList<User>();
        recipients.add(this.factory.newUser("john"));
        EmailNotification emailNotification = this.userTaskAdminService.buildEmailNotification("test", recipients, "Simple body", "Administrator", "");
        long notificationId = this.userTaskAdminService.notifyWhenNotStarted(task.getId().longValue(), "2s", (Notification)emailNotification);
        notifications = this.userTaskAdminService.getTaskNotifications(task.getId().longValue(), true);
        Assertions.assertThat((Iterable)notifications).isNotNull();
        Assertions.assertThat((Iterable)notifications).hasSize(1);
        this.userTaskAdminService.cancelNotification(task.getId().longValue(), notificationId);
        notifications = this.userTaskAdminService.getTaskNotifications(task.getId().longValue(), true);
        Assertions.assertThat((Iterable)notifications).isNotNull();
        Assertions.assertThat((Iterable)notifications).hasSize(0);
    }

    @Test(timeout=10000L)
    public void testReassignNotStartedAndCancel() throws Exception {
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assertions.assertThat((Long)this.processInstanceId).isNotNull();
        List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("salaboy", new QueryFilter());
        Assertions.assertThat((List)tasks).hasSize(1);
        TaskSummary task = (TaskSummary)tasks.get(0);
        Collection reassignments = this.userTaskAdminService.getTaskReassignments(task.getId().longValue(), false);
        Assertions.assertThat((Iterable)reassignments).isNotNull();
        Assertions.assertThat((Iterable)reassignments).hasSize(0);
        Long reassignmentId = this.userTaskAdminService.reassignWhenNotStarted(task.getId().longValue(), "2s", new OrganizationalEntity[]{this.factory.newUser("john")});
        reassignments = this.userTaskAdminService.getTaskReassignments(task.getId().longValue(), true);
        Assertions.assertThat((Iterable)reassignments).isNotNull();
        Assertions.assertThat((Iterable)reassignments).hasSize(1);
        this.userTaskAdminService.cancelReassignment(task.getId().longValue(), reassignmentId.longValue());
        reassignments = this.userTaskAdminService.getTaskReassignments(task.getId().longValue(), true);
        Assertions.assertThat((Iterable)reassignments).isNotNull();
        Assertions.assertThat((Iterable)reassignments).hasSize(0);
    }

    @Test
    public void testGetTaskInstancesAsPotOwners() {
        String PO_TASK_QUERY = "select ti.taskId, ti.activationTime, ti.actualOwner, ti.createdBy, ti.createdOn, ti.deploymentId, ti.description, ti.dueDate, ti.name, ti.parentId, ti.priority, ti.processId, ti.processInstanceId, ti.processSessionId, ti.status, ti.workItemId, oe.id, eo.entity_id from AuditTaskImpl ti left join PeopleAssignments_PotOwners po on ti.taskId = po.task_id left join OrganizationalEntity oe on po.entity_id = oe.id  left join PeopleAssignments_ExclOwners eo on ti.taskId = eo.task_id ";
        SqlQueryDefinition query = new SqlQueryDefinition("getMyTaskInstances", "jdbc/testDS1", QueryDefinition.Target.PO_TASK);
        query.setExpression(PO_TASK_QUERY);
        this.queryService.registerQuery((QueryDefinition)query);
        List queries = this.queryService.getQueries(new QueryContext());
        Assert.assertNotNull((Object)queries);
        Assert.assertEquals((long)1L, (long)queries.size());
        QueryDefinition registeredQuery = (QueryDefinition)queries.get(0);
        Assert.assertNotNull((Object)registeredQuery);
        Assert.assertEquals((Object)query.getName(), (Object)registeredQuery.getName());
        Assert.assertEquals((Object)query.getSource(), (Object)registeredQuery.getSource());
        Assert.assertEquals((Object)query.getExpression(), (Object)registeredQuery.getExpression());
        Assert.assertEquals((Object)query.getTarget(), (Object)registeredQuery.getTarget());
        registeredQuery = this.queryService.getQuery(query.getName());
        Assert.assertNotNull((Object)registeredQuery);
        Assert.assertEquals((Object)query.getName(), (Object)registeredQuery.getName());
        Assert.assertEquals((Object)query.getSource(), (Object)registeredQuery.getSource());
        Assert.assertEquals((Object)query.getExpression(), (Object)registeredQuery.getExpression());
        Assert.assertEquals((Object)query.getTarget(), (Object)registeredQuery.getTarget());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("approval_document", "initial content");
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument", params);
        Assert.assertNotNull((Object)this.processInstanceId);
        this.identityProvider.setName("notvalid");
        List taskInstanceLogs = (List)this.queryService.query(query.getName(), (QueryResultMapper)UserTaskInstanceQueryMapper.get(), new QueryContext(), new QueryParam[0]);
        Assert.assertNotNull((Object)taskInstanceLogs);
        Assert.assertEquals((long)0L, (long)taskInstanceLogs.size());
        this.identityProvider.setName("salaboy");
        taskInstanceLogs = (List)this.queryService.query(query.getName(), (QueryResultMapper)UserTaskInstanceQueryMapper.get(), new QueryContext(), new QueryParam[0]);
        Assert.assertNotNull((Object)taskInstanceLogs);
        Assert.assertEquals((long)1L, (long)taskInstanceLogs.size());
        List taskSummaries = (List)this.queryService.query(query.getName(), (QueryResultMapper)TaskSummaryQueryMapper.get(), new QueryContext(), new QueryParam[0]);
        Assert.assertNotNull((Object)taskSummaries);
        Assert.assertEquals((long)1L, (long)taskSummaries.size());
        this.identityProvider.setName("Administrator");
        this.userTaskAdminService.addPotentialOwners(((TaskSummary)taskSummaries.get(0)).getId().longValue(), false, new OrganizationalEntity[]{this.factory.newUser("john")});
        this.identityProvider.setName("salaboy");
        taskInstanceLogs = (List)this.queryService.query(query.getName(), (QueryResultMapper)UserTaskInstanceQueryMapper.get(), new QueryContext(), new QueryParam[0]);
        Assert.assertNotNull((Object)taskInstanceLogs);
        Assert.assertEquals((long)1L, (long)taskInstanceLogs.size());
        taskSummaries = (List)this.queryService.query(query.getName(), (QueryResultMapper)TaskSummaryQueryMapper.get(), new QueryContext(), new QueryParam[0]);
        Assert.assertNotNull((Object)taskSummaries);
        Assert.assertEquals((long)1L, (long)taskSummaries.size());
        QueryParam[] parameters = QueryParam.getBuilder().append(QueryParam.groupBy((String)"NAME")).append(new QueryParam[]{QueryParam.count((String)"TASKID")}).get();
        Collection instances = (Collection)this.queryService.query(query.getName(), (QueryResultMapper)RawListQueryMapper.get(), new QueryContext(), parameters);
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.size());
        List result = (List)instances.iterator().next();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertTrue((boolean)(result.get(1) instanceof Number));
        Assert.assertEquals((long)2L, (long)((Number)result.get(1)).intValue());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
    }

    @Test
    public void testGetTaskInstancesAsPotOwnersMultipleInstances() {
        String PO_TASK_QUERY = "select ti.taskId, ti.activationTime, ti.actualOwner, ti.createdBy, ti.createdOn, ti.deploymentId, ti.description, ti.dueDate, ti.name, ti.parentId, ti.priority, ti.processId, ti.processInstanceId, ti.processSessionId, ti.status, ti.workItemId, oe.id, eo.entity_id from AuditTaskImpl ti left join PeopleAssignments_PotOwners po on ti.taskId = po.task_id left join OrganizationalEntity oe on po.entity_id = oe.id  left join PeopleAssignments_ExclOwners eo on ti.taskId = eo.task_id ";
        SqlQueryDefinition query = new SqlQueryDefinition("getMyTaskInstances", "jdbc/testDS1", QueryDefinition.Target.PO_TASK);
        query.setExpression(PO_TASK_QUERY);
        this.queryService.registerQuery((QueryDefinition)query);
        List queries = this.queryService.getQueries(new QueryContext());
        Assert.assertNotNull((Object)queries);
        Assert.assertEquals((long)1L, (long)queries.size());
        QueryDefinition registeredQuery = (QueryDefinition)queries.get(0);
        Assert.assertNotNull((Object)registeredQuery);
        Assert.assertEquals((Object)query.getName(), (Object)registeredQuery.getName());
        Assert.assertEquals((Object)query.getSource(), (Object)registeredQuery.getSource());
        Assert.assertEquals((Object)query.getExpression(), (Object)registeredQuery.getExpression());
        Assert.assertEquals((Object)query.getTarget(), (Object)registeredQuery.getTarget());
        registeredQuery = this.queryService.getQuery(query.getName());
        Assert.assertNotNull((Object)registeredQuery);
        Assert.assertEquals((Object)query.getName(), (Object)registeredQuery.getName());
        Assert.assertEquals((Object)query.getSource(), (Object)registeredQuery.getSource());
        Assert.assertEquals((Object)query.getExpression(), (Object)registeredQuery.getExpression());
        Assert.assertEquals((Object)query.getTarget(), (Object)registeredQuery.getTarget());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("approval_document", "initial content");
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument", params);
        Assert.assertNotNull((Object)this.processInstanceId);
        Long processInstanceId2 = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument", params);
        Assert.assertNotNull((Object)this.processInstanceId);
        Assert.assertNotNull((Object)processInstanceId2);
        this.identityProvider.setName("notvalid");
        List taskInstanceLogs = (List)this.queryService.query(query.getName(), (QueryResultMapper)UserTaskInstanceQueryMapper.get(), new QueryContext(), new QueryParam[0]);
        Assert.assertNotNull((Object)taskInstanceLogs);
        Assert.assertEquals((long)0L, (long)taskInstanceLogs.size());
        this.identityProvider.setName("salaboy");
        taskInstanceLogs = (List)this.queryService.query(query.getName(), (QueryResultMapper)UserTaskInstanceQueryMapper.get(), new QueryContext(), new QueryParam[0]);
        Assert.assertNotNull((Object)taskInstanceLogs);
        Assert.assertEquals((long)2L, (long)taskInstanceLogs.size());
        this.identityProvider.setName("Administrator");
        this.userTaskAdminService.addPotentialOwners(((UserTaskInstanceDesc)taskInstanceLogs.get(0)).getTaskId().longValue(), false, new OrganizationalEntity[]{this.factory.newUser("john")});
        this.identityProvider.setName("salaboy");
        taskInstanceLogs = (List)this.queryService.query(query.getName(), (QueryResultMapper)UserTaskInstanceQueryMapper.get(), new QueryContext(), new QueryParam[0]);
        Assert.assertNotNull((Object)taskInstanceLogs);
        Assert.assertEquals((long)2L, (long)taskInstanceLogs.size());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
        this.processService.abortProcessInstance(processInstanceId2);
        processInstanceId2 = null;
    }

    @Override
    protected List<ObjectModel> getTaskListeners() {
        List<ObjectModel> listeners = super.getTaskListeners();
        listeners.add(new ObjectModel("mvel", "org.jbpm.kie.test.util.CountDownListenerFactory.getTask(\"userTaskAdminService\", 1)", new Object[0]));
        return listeners;
    }

    @Override
    protected boolean createDescriptor() {
        return true;
    }
}

