/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl.query.preprocessor;

import java.util.Arrays;
import java.util.Collections;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.DataSetMetadata;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.jbpm.kie.services.impl.query.preprocessor.BusinessAdminTasksPreprocessor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.task.UserGroupCallback;
import org.kie.internal.identity.IdentityProvider;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class BusinessAdminTasksPreprocessorTest {
    @Mock
    IdentityProvider identityProvider;
    @Mock
    UserGroupCallback userGroupCallback;
    @Mock
    DataSetMetadata metaData;
    DataSetLookup dataSetLookup;
    BusinessAdminTasksPreprocessor preprocessor;

    @Before
    public void init() {
        System.setProperty("org.jbpm.ht.admin.group", "admins");
        System.setProperty("org.jbpm.ht.admin.user", "admin");
        this.preprocessor = new BusinessAdminTasksPreprocessor(this.identityProvider, this.userGroupCallback, this.metaData);
    }

    @Test
    public void testQueryByGroupBusinessAdmin() {
        this.dataSetLookup = (DataSetLookup)Mockito.spy((Object)new DataSetLookup());
        String role1 = "admins";
        String role2 = "role2";
        String userId = "userId";
        Mockito.when((Object)this.userGroupCallback.getGroupsForUser(userId)).thenReturn(Arrays.asList(role1, role2));
        Mockito.when((Object)this.identityProvider.getName()).thenReturn((Object)userId);
        this.preprocessor.preprocess(this.dataSetLookup);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.dataSetLookup});
        Assert.assertNull((Object)this.dataSetLookup.getFirstFilterOp());
    }

    @Test
    public void testQueryByUserBusinessAdmin() {
        this.dataSetLookup = (DataSetLookup)Mockito.spy((Object)new DataSetLookup());
        String role1 = "role1";
        String role2 = "role2";
        String userId = "admin";
        Mockito.when((Object)this.userGroupCallback.getGroupsForUser(userId)).thenReturn(Arrays.asList(role1, role2));
        Mockito.when((Object)this.identityProvider.getName()).thenReturn((Object)userId);
        this.preprocessor.preprocess(this.dataSetLookup);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.dataSetLookup});
        Assert.assertNull((Object)this.dataSetLookup.getFirstFilterOp());
    }

    @Test
    public void testQueryByNoBusinessAdmin() {
        this.dataSetLookup = new DataSetLookup();
        String role1 = "role1";
        String role2 = "role2";
        String userId = "userId";
        Mockito.when((Object)this.userGroupCallback.getGroupsForUser(userId)).thenReturn(Arrays.asList(role1, role2));
        Mockito.when((Object)this.identityProvider.getName()).thenReturn((Object)userId);
        this.preprocessor.preprocess(this.dataSetLookup);
        Assert.assertEquals((Object)"ID = role1, role2, userId", (Object)((ColumnFilter)this.dataSetLookup.getFirstFilterOp().getColumnFilterList().get(0)).toString());
    }

    @Test
    public void testSetUserWithoutRoles() {
        this.dataSetLookup = new DataSetLookup();
        String userId = "userId";
        Mockito.when((Object)this.userGroupCallback.getGroupsForUser(userId)).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.identityProvider.getName()).thenReturn((Object)userId);
        this.preprocessor.preprocess(this.dataSetLookup);
        Assert.assertEquals((Object)"ID = userId", (Object)((ColumnFilter)this.dataSetLookup.getFirstFilterOp().getColumnFilterList().get(0)).toString());
    }

    @Test
    public void testNullGroups() {
        this.dataSetLookup = new DataSetLookup();
        String userId = "userId";
        Mockito.when((Object)this.userGroupCallback.getGroupsForUser(userId)).thenReturn(null);
        Mockito.when((Object)this.identityProvider.getName()).thenReturn((Object)userId);
        this.preprocessor.preprocess(this.dataSetLookup);
        Assert.assertEquals((Object)"ID = userId", (Object)((ColumnFilter)this.dataSetLookup.getFirstFilterOp().getColumnFilterList().get(0)).toString());
    }
}

