/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl.query.preprocessor;

import java.util.Arrays;
import java.util.Collections;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.DataSetMetadata;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.jbpm.kie.services.impl.query.preprocessor.PotOwnerTasksPreprocessor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.task.UserGroupCallback;
import org.kie.internal.identity.IdentityProvider;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class PotOwnerTasksPreprocessorTest {
    @Mock
    IdentityProvider identityProvider;
    @Mock
    UserGroupCallback userGroupCallback;
    @Mock
    DataSetMetadata metaData;
    DataSetLookup dataSetLookup;
    @InjectMocks
    PotOwnerTasksPreprocessor potOwnerTasksPreprocessor;

    @Before
    public void init() {
        this.dataSetLookup = new DataSetLookup();
    }

    @Test
    public void testSetUser() {
        String role1 = "role1";
        String role2 = "role2";
        String userId = "userId";
        Mockito.when((Object)this.userGroupCallback.getGroupsForUser(userId)).thenReturn(Arrays.asList(role1, role2));
        Mockito.when((Object)this.identityProvider.getName()).thenReturn((Object)userId);
        this.potOwnerTasksPreprocessor.preprocess(this.dataSetLookup);
        Assert.assertEquals((Object)("((ENTITY_ID is_null  OR ENTITY_ID != " + userId + ") AND ((ID = " + role1 + ", " + role2 + ", " + userId + " AND (ACTUALOWNER =  OR ACTUALOWNER is_null )) OR ACTUALOWNER = " + userId + "))"), (Object)((ColumnFilter)this.dataSetLookup.getFirstFilterOp().getColumnFilterList().get(0)).toString());
    }

    @Test
    public void testSetUserWithoutRoles() {
        String userId = "userId";
        Mockito.when((Object)this.userGroupCallback.getGroupsForUser(userId)).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.identityProvider.getName()).thenReturn((Object)userId);
        this.potOwnerTasksPreprocessor.preprocess(this.dataSetLookup);
        Assert.assertEquals((Object)("((ENTITY_ID is_null  OR ENTITY_ID != " + userId + ") AND ((ID = " + userId + " AND (ACTUALOWNER =  OR ACTUALOWNER is_null )) OR ACTUALOWNER = " + userId + "))"), (Object)((ColumnFilter)this.dataSetLookup.getFirstFilterOp().getColumnFilterList().get(0)).toString());
    }

    @Test
    public void testNullGroups() {
        String userId = "userId";
        Mockito.when((Object)this.userGroupCallback.getGroupsForUser(userId)).thenReturn(null);
        Mockito.when((Object)this.identityProvider.getName()).thenReturn((Object)userId);
        this.potOwnerTasksPreprocessor.preprocess(this.dataSetLookup);
        Assert.assertEquals((Object)("((ENTITY_ID is_null  OR ENTITY_ID != " + userId + ") AND ((ID = " + userId + " AND (ACTUALOWNER =  OR ACTUALOWNER is_null )) OR ACTUALOWNER = " + userId + "))"), (Object)((ColumnFilter)this.dataSetLookup.getFirstFilterOp().getColumnFilterList().get(0)).toString());
    }
}

