/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.test;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.appformer.maven.support.AFReleaseId;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.jbpm.kie.services.impl.KModuleDeploymentService;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.kie.services.impl.store.DeploymentStore;
import org.jbpm.kie.services.impl.store.DeploymentSyncInvoker;
import org.jbpm.kie.services.impl.store.DeploymentSynchronizer;
import org.jbpm.kie.services.test.objects.CoundDownDeploymentListener;
import org.jbpm.kie.test.util.AbstractKieServicesBaseTest;
import org.jbpm.services.api.DeploymentEvent;
import org.jbpm.services.api.DeploymentEventListener;
import org.jbpm.services.api.ListenerSupport;
import org.jbpm.services.api.model.DeploymentUnit;
import org.jbpm.shared.services.impl.TransactionalCommandService;
import org.jbpm.shared.services.impl.commands.UpdateStringCommand;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.command.Command;
import org.kie.scanner.KieMavenRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeactivateDeploymentServiceWithSyncTest
extends AbstractKieServicesBaseTest {
    static Logger logger = LoggerFactory.getLogger(DeactivateDeploymentServiceWithSyncTest.class);
    protected List<DeploymentUnit> units = new ArrayList<DeploymentUnit>();
    protected DeploymentStore store;
    protected DeploymentSynchronizer sync;
    protected DeploymentSyncInvoker invoker;
    protected TransactionalCommandService commandService;

    public void setCommandService(TransactionalCommandService commandService) {
        this.commandService = commandService;
    }

    @Before
    public void prepare() {
        this.configureServices();
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.jbpm.test", "test-module", "1.0.0");
        ArrayList<String> processes = new ArrayList<String>();
        processes.add("repo/processes/general/customtask.bpmn");
        processes.add("repo/processes/general/humanTask.bpmn");
        processes.add("repo/processes/general/signal.bpmn");
        processes.add("repo/processes/general/import.bpmn");
        processes.add("repo/processes/general/callactivity.bpmn");
        InternalKieModule kJar1 = this.createKieJar(ks, releaseId, processes);
        File pom = new File("target/kmodule", "pom.xml");
        pom.getParentFile().mkdir();
        try {
            FileOutputStream fs = new FileOutputStream(pom);
            fs.write(this.getPom(releaseId, new ReleaseId[0]).getBytes());
            fs.close();
        }
        catch (Exception fs) {
            // empty catch block
        }
        KieMavenRepository repository = KieMavenRepository.getKieMavenRepository();
        repository.deployArtifact((AFReleaseId)releaseId, kJar1, pom);
        ReleaseId releaseIdSupport = ks.newReleaseId("org.jbpm.test", "support", "1.0.0");
        ArrayList<String> processesSupport = new ArrayList<String>();
        processesSupport.add("repo/processes/support/support.bpmn");
        InternalKieModule kJar2 = this.createKieJar(ks, releaseIdSupport, processesSupport);
        File pom2 = new File("target/kmodule2", "pom.xml");
        pom2.getParentFile().mkdir();
        try {
            FileOutputStream fs = new FileOutputStream(pom2);
            fs.write(this.getPom(releaseIdSupport, new ReleaseId[0]).getBytes());
            fs.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        repository.deployArtifact((AFReleaseId)releaseIdSupport, kJar2, pom2);
        this.configureDeploymentSync();
    }

    protected void configureDeploymentSync() {
        Assert.assertNotNull((Object)this.deploymentService);
        this.store = new DeploymentStore();
        if (this.commandService == null) {
            this.commandService = new TransactionalCommandService(this.emf);
        }
        this.store.setCommandService(this.commandService);
        this.sync = new DeploymentSynchronizer();
        this.sync.setDeploymentService(this.deploymentService);
        this.sync.setDeploymentStore(this.store);
        this.invoker = new DeploymentSyncInvoker(this.sync, Long.valueOf(1L), Long.valueOf(1L), TimeUnit.SECONDS);
    }

    @After
    public void cleanup() {
        if (this.invoker != null) {
            this.invoker.stop();
        }
        int deleted = 0;
        logger.info("Deleted " + (deleted += ((Integer)this.commandService.execute((Command)new UpdateStringCommand("delete from  DeploymentStoreEntry dse"))).intValue()));
        DeactivateDeploymentServiceWithSyncTest.cleanupSingletonSessionId();
        if (this.units != null && !this.units.isEmpty()) {
            for (DeploymentUnit unit : this.units) {
                this.deploymentService.undeploy(unit);
            }
            this.units.clear();
        }
        this.close();
    }

    @Test
    public void testDeactivateDeploymentBySync() throws Exception {
        Collection deployed = this.deploymentService.getDeployedUnits();
        Assert.assertNotNull((Object)deployed);
        Assert.assertEquals((long)0L, (long)deployed.size());
        KModuleDeploymentUnit unit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)unit);
        this.deploymentService.deactivate(unit.getIdentifier());
        ((KModuleDeploymentService)this.deploymentService).shutdown();
        this.sync.clear();
        final AtomicBoolean deploymentActive = new AtomicBoolean(true);
        CoundDownDeploymentListener countDownListener = new CoundDownDeploymentListener(1){

            @Override
            public void onDeploy(DeploymentEvent event) {
                deploymentActive.set(event.getDeployedUnit().isActive());
                super.onDeploy(event);
            }
        };
        countDownListener.setDeploy(true);
        ((ListenerSupport)this.deploymentService).addListener((DeploymentEventListener)countDownListener);
        this.invoker.start();
        countDownListener.waitTillCompleted();
        Assert.assertFalse((String)"Deployment should be deactivated", (boolean)deploymentActive.get());
        deployed = this.deploymentService.getDeployedUnits();
        Assert.assertNotNull((Object)deployed);
        Assert.assertEquals((long)1L, (long)deployed.size());
    }
}

