/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.test;

import java.io.File;
import java.io.FileOutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.appformer.maven.support.AFReleaseId;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.kie.test.util.AbstractKieServicesBaseTest;
import org.jbpm.runtime.manager.impl.deploy.DeploymentDescriptorImpl;
import org.jbpm.services.api.model.DeployedUnit;
import org.jbpm.services.api.model.DeploymentUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.query.QueryContext;
import org.kie.internal.runtime.conf.DeploymentDescriptor;
import org.kie.internal.runtime.conf.NamedObjectModel;
import org.kie.internal.runtime.conf.ObjectModel;
import org.kie.scanner.KieMavenRepository;

public class IdentityProviderAwareProcessListenerTest
extends AbstractKieServicesBaseTest {
    private KModuleDeploymentUnit deploymentUnit;

    @Before
    public void init() {
        this.configureServices();
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.jbpm.test", "test-module", "1.0.0");
        List<String> processes = Collections.singletonList("repo/processes/general/humanTask.bpmn");
        InternalKieModule kJar1 = this.createKieJar(ks, releaseId, processes);
        File pom = new File("target/kmodule", "pom.xml");
        pom.getParentFile().mkdir();
        try (FileOutputStream fs = new FileOutputStream(pom);){
            fs.write(this.getPom(releaseId, new ReleaseId[0]).getBytes());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        KieMavenRepository.getKieMavenRepository().deployArtifact((AFReleaseId)releaseId, kJar1, pom);
        this.deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        DeploymentDescriptorImpl descriptor = new DeploymentDescriptorImpl();
        descriptor.getBuilder().addEventListener((ObjectModel)new NamedObjectModel("mvel", "processIdentity", "new org.jbpm.kie.services.impl.IdentityProviderAwareProcessListener(ksession)", new Object[0]));
        this.deploymentUnit.setDeploymentDescriptor((DeploymentDescriptor)descriptor);
        this.deploymentService.deploy((DeploymentUnit)this.deploymentUnit);
        DeployedUnit deployed = this.deploymentService.getDeployedUnit(this.deploymentUnit.getIdentifier());
        Assert.assertNotNull((Object)deployed);
        Assert.assertNotNull((Object)deployed.getDeploymentUnit());
        Assert.assertNotNull((Object)this.runtimeDataService);
        Collection processDefinitions = this.runtimeDataService.getProcesses(new QueryContext());
        Assert.assertNotNull((Object)processDefinitions);
        Assert.assertEquals((long)1L, (long)processDefinitions.size());
    }

    @After
    public void cleanup() {
        IdentityProviderAwareProcessListenerTest.cleanupSingletonSessionId();
        if (this.deploymentUnit != null) {
            this.deploymentService.undeploy((DeploymentUnit)this.deploymentUnit);
        }
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartProcessWithIdentityListener() {
        Assert.assertNotNull((Object)this.processService);
        String userId = "userId";
        this.identityProvider.setName("userId");
        long processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)processInstanceId);
        try {
            String initiator = (String)this.processService.getProcessInstanceVariable(Long.valueOf(processInstanceId), "initiator");
            Assert.assertEquals((Object)"userId", (Object)initiator);
        }
        finally {
            this.processService.abortProcessInstance(Long.valueOf(processInstanceId));
        }
    }
}

