/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.test;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.appformer.maven.support.AFReleaseId;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.kie.test.util.AbstractKieServicesBaseTest;
import org.jbpm.runtime.manager.impl.deploy.DeploymentDescriptorImpl;
import org.jbpm.services.api.model.DeployedUnit;
import org.jbpm.services.api.model.DeploymentUnit;
import org.jbpm.services.api.model.ProcessDefinition;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.query.QueryContext;
import org.kie.internal.runtime.conf.AuditMode;
import org.kie.internal.runtime.conf.DeploymentDescriptor;
import org.kie.internal.runtime.conf.NamedObjectModel;
import org.kie.internal.runtime.conf.PersistenceMode;
import org.kie.internal.runtime.conf.RuntimeStrategy;
import org.kie.internal.runtime.manager.InternalRuntimeManager;
import org.kie.internal.runtime.manager.context.EmptyContext;
import org.kie.scanner.KieMavenRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KModuleDeploymentServiceTest
extends AbstractKieServicesBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(KModuleDeploymentServiceTest.class);
    private List<DeploymentUnit> units = new ArrayList<DeploymentUnit>();

    @Before
    public void prepare() {
        this.configureServices();
        logger.debug("Preparing kjar");
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.jbpm.test", "test-module", "1.0.0");
        ArrayList<String> processes = new ArrayList<String>();
        processes.add("repo/processes/general/customtask.bpmn");
        processes.add("repo/processes/general/humanTask.bpmn");
        processes.add("repo/processes/general/import.bpmn");
        InternalKieModule kJar1 = this.createKieJar(ks, releaseId, processes);
        File pom = new File("target/kmodule", "pom.xml");
        pom.getParentFile().mkdir();
        try {
            FileOutputStream fs = new FileOutputStream(pom);
            fs.write(this.getPom(releaseId, new ReleaseId[0]).getBytes());
            fs.close();
        }
        catch (Exception fs) {
            // empty catch block
        }
        KieMavenRepository repository = KieMavenRepository.getKieMavenRepository();
        repository.deployArtifact((AFReleaseId)releaseId, kJar1, pom);
    }

    @After
    public void cleanup() {
        KModuleDeploymentServiceTest.cleanupSingletonSessionId();
        if (this.units != null && !this.units.isEmpty()) {
            for (DeploymentUnit unit : this.units) {
                this.deploymentService.undeploy(unit);
            }
            this.units.clear();
        }
        this.close();
    }

    @Test
    public void testDeploymentOfProcesses() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0", "KBase-test", "ksession-test");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        Assert.assertNotNull((Object)deploymentUnit.getDeploymentDescriptor());
        DeployedUnit deployed = this.deploymentService.getDeployedUnit(deploymentUnit.getIdentifier());
        Assert.assertNotNull((Object)deployed);
        Assert.assertNotNull((Object)deployed.getDeploymentUnit());
        Assert.assertNotNull((Object)deployed.getRuntimeManager());
        Assert.assertNull((Object)deployed.getDeployedAssetLocation("customtask"));
        Assert.assertEquals((Object)"org.jbpm.test:test-module:1.0.0:KBase-test:ksession-test", (Object)deployed.getDeploymentUnit().getIdentifier());
        Assert.assertNotNull((Object)this.runtimeDataService);
        Collection processes = this.runtimeDataService.getProcesses(new QueryContext());
        Assert.assertNotNull((Object)processes);
        Assert.assertEquals((long)3L, (long)processes.size());
        processes = this.runtimeDataService.getProcessesByFilter("custom", new QueryContext());
        Assert.assertNotNull((Object)processes);
        Assert.assertEquals((long)1L, (long)processes.size());
        processes = this.runtimeDataService.getProcessesByDeploymentId(deploymentUnit.getIdentifier(), new QueryContext());
        Assert.assertNotNull((Object)processes);
        Assert.assertEquals((long)3L, (long)processes.size());
        ProcessDefinition process = this.runtimeDataService.getProcessesByDeploymentIdProcessId(deploymentUnit.getIdentifier(), "customtask");
        Assert.assertNotNull((Object)process);
        RuntimeManager manager = this.deploymentService.getRuntimeManager(deploymentUnit.getIdentifier());
        Assert.assertNotNull((Object)manager);
        RuntimeEngine engine = manager.getRuntimeEngine(EmptyContext.get());
        Assert.assertNotNull((Object)engine);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", "test");
        ProcessInstance processInstance = engine.getKieSession().startProcess("customtask", params);
        Assert.assertEquals((long)2L, (long)processInstance.getState());
        this.checkFormsDeployment(deploymentUnit.getIdentifier());
    }

    @Test
    public void testDeploymentOfProcessesOnDefaultKbaseAndKsession() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        DeployedUnit deployed = this.deploymentService.getDeployedUnit(deploymentUnit.getIdentifier());
        Assert.assertNotNull((Object)deployed);
        Assert.assertNotNull((Object)deployed.getDeploymentUnit());
        Assert.assertNotNull((Object)deployed.getRuntimeManager());
        Assert.assertNull((Object)deployed.getDeployedAssetLocation("customtask"));
        Assert.assertEquals((Object)"org.jbpm.test:test-module:1.0.0", (Object)deployed.getDeploymentUnit().getIdentifier());
        Assert.assertNotNull((Object)this.runtimeDataService);
        Collection processes = this.runtimeDataService.getProcesses(new QueryContext());
        Assert.assertNotNull((Object)processes);
        Assert.assertEquals((long)3L, (long)processes.size());
        processes = this.runtimeDataService.getProcessesByFilter("custom", new QueryContext());
        Assert.assertNotNull((Object)processes);
        Assert.assertEquals((long)1L, (long)processes.size());
        processes = this.runtimeDataService.getProcessesByDeploymentId(deploymentUnit.getIdentifier(), new QueryContext());
        Assert.assertNotNull((Object)processes);
        Assert.assertEquals((long)3L, (long)processes.size());
        ProcessDefinition process = this.runtimeDataService.getProcessesByDeploymentIdProcessId(deploymentUnit.getIdentifier(), "customtask");
        Assert.assertNotNull((Object)process);
        RuntimeManager manager = this.deploymentService.getRuntimeManager(deploymentUnit.getIdentifier());
        Assert.assertNotNull((Object)manager);
        RuntimeEngine engine = manager.getRuntimeEngine(EmptyContext.get());
        Assert.assertNotNull((Object)engine);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", "test");
        ProcessInstance processInstance = engine.getKieSession().startProcess("customtask", params);
        Assert.assertEquals((long)2L, (long)processInstance.getState());
        this.checkFormsDeployment(deploymentUnit.getIdentifier());
    }

    @Test(expected=RuntimeException.class)
    public void testDuplicatedDeployment() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        DeployedUnit deployedGeneral = this.deploymentService.getDeployedUnit(deploymentUnit.getIdentifier());
        Assert.assertNotNull((Object)deployedGeneral);
        Assert.assertNotNull((Object)deployedGeneral.getDeploymentUnit());
        Assert.assertNotNull((Object)deployedGeneral.getRuntimeManager());
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
    }

    @Test
    public void testUnDeploymentWithActiveProcesses() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        DeployedUnit deployedGeneral = this.deploymentService.getDeployedUnit(deploymentUnit.getIdentifier());
        Assert.assertNotNull((Object)deployedGeneral);
        Assert.assertNotNull((Object)deployedGeneral.getDeploymentUnit());
        Assert.assertNotNull((Object)deployedGeneral.getRuntimeManager());
        RuntimeManager manager = this.deploymentService.getRuntimeManager(deploymentUnit.getIdentifier());
        Assert.assertNotNull((Object)manager);
        RuntimeEngine engine = manager.getRuntimeEngine(EmptyContext.get());
        Assert.assertNotNull((Object)engine);
        HashMap params = new HashMap();
        ProcessInstance processInstance = engine.getKieSession().startProcess("org.jbpm.writedocument", params);
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        try {
            this.deploymentService.undeploy((DeploymentUnit)deploymentUnit);
            Assert.fail((String)"Should fail due to active process instance");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        engine.getKieSession().abortProcessInstance(processInstance.getId());
        this.checkFormsDeployment(deploymentUnit.getIdentifier());
    }

    @Test
    public void testDeploymentAndExecutionOfProcessWithImports() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        DeployedUnit deployedGeneral = this.deploymentService.getDeployedUnit(deploymentUnit.getIdentifier());
        Assert.assertNotNull((Object)deployedGeneral);
        Assert.assertNotNull((Object)deployedGeneral.getDeploymentUnit());
        Assert.assertNotNull((Object)deployedGeneral.getRuntimeManager());
        RuntimeManager manager = this.deploymentService.getRuntimeManager(deploymentUnit.getIdentifier());
        Assert.assertNotNull((Object)manager);
        RuntimeEngine engine = manager.getRuntimeEngine(EmptyContext.get());
        Assert.assertNotNull((Object)engine);
        HashMap params = new HashMap();
        ProcessInstance processInstance = engine.getKieSession().startProcess("Import", params);
        Assert.assertEquals((long)2L, (long)processInstance.getState());
        this.checkFormsDeployment(deploymentUnit.getIdentifier());
    }

    @Test
    public void testDeploymentOfProcessWithDescriptor() {
        Assert.assertNotNull((Object)this.deploymentService);
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.jbpm.test", "kjar-with-dd", "1.0.0");
        ArrayList<String> processes = new ArrayList<String>();
        processes.add("repo/processes/general/customtask.bpmn");
        processes.add("repo/processes/general/humanTask.bpmn");
        processes.add("repo/processes/general/import.bpmn");
        DeploymentDescriptorImpl customDescriptor = new DeploymentDescriptorImpl("org.jbpm.domain");
        customDescriptor.getBuilder().runtimeStrategy(RuntimeStrategy.PER_REQUEST).addWorkItemHandler(new NamedObjectModel("Log", "org.jbpm.process.instance.impl.demo.SystemOutWorkItemHandler", new Object[0]));
        HashMap<String, String> resources = new HashMap<String, String>();
        resources.put("src/main/resources/META-INF/kie-deployment-descriptor.xml", customDescriptor.toXml());
        InternalKieModule kJar1 = this.createKieJar(ks, releaseId, processes, resources);
        File pom = new File("target/kmodule", "pom.xml");
        pom.getParentFile().mkdir();
        try {
            FileOutputStream fs = new FileOutputStream(pom);
            fs.write(this.getPom(releaseId, new ReleaseId[0]).getBytes());
            fs.close();
        }
        catch (Exception fs) {
            // empty catch block
        }
        KieMavenRepository repository = KieMavenRepository.getKieMavenRepository();
        repository.deployArtifact((AFReleaseId)releaseId, kJar1, pom);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "kjar-with-dd", "1.0.0", "KBase-test", "ksession-test2");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        DeployedUnit deployedGeneral = this.deploymentService.getDeployedUnit(deploymentUnit.getIdentifier());
        Assert.assertNotNull((Object)deployedGeneral);
        Assert.assertNotNull((Object)deployedGeneral.getDeploymentUnit());
        Assert.assertNotNull((Object)deployedGeneral.getRuntimeManager());
        DeploymentDescriptor descriptor = ((InternalRuntimeManager)deployedGeneral.getRuntimeManager()).getDeploymentDescriptor();
        Assert.assertNotNull((Object)descriptor);
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)descriptor.getPersistenceUnit());
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)descriptor.getAuditPersistenceUnit());
        Assert.assertEquals((Object)AuditMode.JPA, (Object)descriptor.getAuditMode());
        Assert.assertEquals((Object)PersistenceMode.JPA, (Object)descriptor.getPersistenceMode());
        Assert.assertEquals((Object)RuntimeStrategy.PER_REQUEST, (Object)descriptor.getRuntimeStrategy());
        Assert.assertEquals((long)0L, (long)descriptor.getMarshallingStrategies().size());
        Assert.assertEquals((long)0L, (long)descriptor.getConfiguration().size());
        Assert.assertEquals((long)0L, (long)descriptor.getEnvironmentEntries().size());
        Assert.assertEquals((long)0L, (long)descriptor.getEventListeners().size());
        Assert.assertEquals((long)0L, (long)descriptor.getGlobals().size());
        Assert.assertEquals((long)0L, (long)descriptor.getTaskEventListeners().size());
        Assert.assertEquals((long)1L, (long)descriptor.getWorkItemHandlers().size());
        Assert.assertEquals((long)0L, (long)descriptor.getRequiredRoles().size());
        RuntimeManager manager = this.deploymentService.getRuntimeManager(deploymentUnit.getIdentifier());
        Assert.assertNotNull((Object)manager);
        RuntimeEngine engine = manager.getRuntimeEngine(EmptyContext.get());
        Assert.assertNotNull((Object)engine);
        HashMap params = new HashMap();
        ProcessInstance processInstance = engine.getKieSession().startProcess("customtask", params);
        Assert.assertEquals((long)2L, (long)processInstance.getState());
        manager.disposeRuntimeEngine(engine);
        this.checkFormsDeployment(deploymentUnit.getIdentifier());
    }

    @Test(expected=SecurityException.class)
    public void testDeploymentOfProcessWithDescriptorWitSecurityManager() {
        Assert.assertNotNull((Object)this.deploymentService);
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.jbpm.test", "kjar-with-dd", "1.0.0");
        ArrayList<String> processes = new ArrayList<String>();
        processes.add("repo/processes/general/customtask.bpmn");
        processes.add("repo/processes/general/humanTask.bpmn");
        processes.add("repo/processes/general/import.bpmn");
        DeploymentDescriptorImpl customDescriptor = new DeploymentDescriptorImpl("org.jbpm.domain");
        customDescriptor.getBuilder().runtimeStrategy(RuntimeStrategy.PER_PROCESS_INSTANCE).addWorkItemHandler(new NamedObjectModel("Log", "org.jbpm.process.instance.impl.demo.SystemOutWorkItemHandler", new Object[0])).addRequiredRole("experts");
        HashMap<String, String> resources = new HashMap<String, String>();
        resources.put("src/main/resources/META-INF/kie-deployment-descriptor.xml", customDescriptor.toXml());
        InternalKieModule kJar1 = this.createKieJar(ks, releaseId, processes, resources);
        File pom = new File("target/kmodule", "pom.xml");
        pom.getParentFile().mkdir();
        try {
            FileOutputStream fs = new FileOutputStream(pom);
            fs.write(this.getPom(releaseId, new ReleaseId[0]).getBytes());
            fs.close();
        }
        catch (Exception fs) {
            // empty catch block
        }
        KieMavenRepository repository = KieMavenRepository.getKieMavenRepository();
        repository.deployArtifact((AFReleaseId)releaseId, kJar1, pom);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "kjar-with-dd", "1.0.0", "KBase-test", "ksession-test2");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        DeployedUnit deployedGeneral = this.deploymentService.getDeployedUnit(deploymentUnit.getIdentifier());
        Assert.assertNotNull((Object)deployedGeneral);
        Assert.assertNotNull((Object)deployedGeneral.getDeploymentUnit());
        Assert.assertNotNull((Object)deployedGeneral.getRuntimeManager());
        DeploymentDescriptor descriptor = ((InternalRuntimeManager)deployedGeneral.getRuntimeManager()).getDeploymentDescriptor();
        Assert.assertNotNull((Object)descriptor);
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)descriptor.getPersistenceUnit());
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)descriptor.getAuditPersistenceUnit());
        Assert.assertEquals((Object)AuditMode.JPA, (Object)descriptor.getAuditMode());
        Assert.assertEquals((Object)PersistenceMode.JPA, (Object)descriptor.getPersistenceMode());
        Assert.assertEquals((Object)RuntimeStrategy.PER_PROCESS_INSTANCE, (Object)descriptor.getRuntimeStrategy());
        Assert.assertEquals((long)0L, (long)descriptor.getMarshallingStrategies().size());
        Assert.assertEquals((long)0L, (long)descriptor.getConfiguration().size());
        Assert.assertEquals((long)0L, (long)descriptor.getEnvironmentEntries().size());
        Assert.assertEquals((long)0L, (long)descriptor.getEventListeners().size());
        Assert.assertEquals((long)0L, (long)descriptor.getGlobals().size());
        Assert.assertEquals((long)0L, (long)descriptor.getTaskEventListeners().size());
        Assert.assertEquals((long)1L, (long)descriptor.getWorkItemHandlers().size());
        Assert.assertEquals((long)1L, (long)descriptor.getRequiredRoles().size());
        RuntimeManager manager = this.deploymentService.getRuntimeManager(deploymentUnit.getIdentifier());
        Assert.assertNotNull((Object)manager);
        manager.getRuntimeEngine(EmptyContext.get());
        this.checkFormsDeployment(deploymentUnit.getIdentifier());
    }

    @Test
    public void testDeploymentOfProcessWithDescriptorKieConteinerInjection() {
        Assert.assertNotNull((Object)this.deploymentService);
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.jbpm.test", "kjar-with-dd", "1.0.0");
        ArrayList<String> processes = new ArrayList<String>();
        processes.add("repo/processes/general/customtask.bpmn");
        processes.add("repo/processes/general/humanTask.bpmn");
        processes.add("repo/processes/general/import.bpmn");
        DeploymentDescriptorImpl customDescriptor = new DeploymentDescriptorImpl("org.jbpm.domain");
        customDescriptor.getBuilder().runtimeStrategy(RuntimeStrategy.PER_REQUEST).addWorkItemHandler(new NamedObjectModel("mvel", "Log", "new org.jbpm.kie.services.test.objects.KieConteinerSystemOutWorkItemHandler(kieContainer)", new Object[0]));
        HashMap<String, String> resources = new HashMap<String, String>();
        resources.put("src/main/resources/META-INF/kie-deployment-descriptor.xml", customDescriptor.toXml());
        InternalKieModule kJar1 = this.createKieJar(ks, releaseId, processes, resources);
        File pom = new File("target/kmodule", "pom.xml");
        pom.getParentFile().mkdir();
        try {
            FileOutputStream fs = new FileOutputStream(pom);
            fs.write(this.getPom(releaseId, new ReleaseId[0]).getBytes());
            fs.close();
        }
        catch (Exception fs) {
            // empty catch block
        }
        KieMavenRepository repository = KieMavenRepository.getKieMavenRepository();
        repository.deployArtifact((AFReleaseId)releaseId, kJar1, pom);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "kjar-with-dd", "1.0.0", "KBase-test", "ksession-test2");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        DeployedUnit deployedGeneral = this.deploymentService.getDeployedUnit(deploymentUnit.getIdentifier());
        Assert.assertNotNull((Object)deployedGeneral);
        Assert.assertNotNull((Object)deployedGeneral.getDeploymentUnit());
        Assert.assertNotNull((Object)deployedGeneral.getRuntimeManager());
        DeploymentDescriptor descriptor = ((InternalRuntimeManager)deployedGeneral.getRuntimeManager()).getDeploymentDescriptor();
        Assert.assertNotNull((Object)descriptor);
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)descriptor.getPersistenceUnit());
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)descriptor.getAuditPersistenceUnit());
        Assert.assertEquals((Object)AuditMode.JPA, (Object)descriptor.getAuditMode());
        Assert.assertEquals((Object)PersistenceMode.JPA, (Object)descriptor.getPersistenceMode());
        Assert.assertEquals((Object)RuntimeStrategy.PER_REQUEST, (Object)descriptor.getRuntimeStrategy());
        Assert.assertEquals((long)0L, (long)descriptor.getMarshallingStrategies().size());
        Assert.assertEquals((long)0L, (long)descriptor.getConfiguration().size());
        Assert.assertEquals((long)0L, (long)descriptor.getEnvironmentEntries().size());
        Assert.assertEquals((long)0L, (long)descriptor.getEventListeners().size());
        Assert.assertEquals((long)0L, (long)descriptor.getGlobals().size());
        Assert.assertEquals((long)0L, (long)descriptor.getTaskEventListeners().size());
        Assert.assertEquals((long)1L, (long)descriptor.getWorkItemHandlers().size());
        Assert.assertEquals((long)0L, (long)descriptor.getRequiredRoles().size());
        RuntimeManager manager = this.deploymentService.getRuntimeManager(deploymentUnit.getIdentifier());
        Assert.assertNotNull((Object)manager);
        RuntimeEngine engine = manager.getRuntimeEngine(EmptyContext.get());
        Assert.assertNotNull((Object)engine);
        HashMap params = new HashMap();
        ProcessInstance processInstance = engine.getKieSession().startProcess("customtask", params);
        Assert.assertEquals((long)2L, (long)processInstance.getState());
        manager.disposeRuntimeEngine(engine);
        this.checkFormsDeployment(deploymentUnit.getIdentifier());
    }

    @Test
    public void testDeploymentOfProcessesKieConteinerInjection() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0", "KBase-test", "ksession-test-2");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        Assert.assertNotNull((Object)deploymentUnit.getDeploymentDescriptor());
        DeployedUnit deployed = this.deploymentService.getDeployedUnit(deploymentUnit.getIdentifier());
        Assert.assertNotNull((Object)deployed);
        Assert.assertNotNull((Object)deployed.getDeploymentUnit());
        Assert.assertNotNull((Object)deployed.getRuntimeManager());
        Assert.assertNull((Object)deployed.getDeployedAssetLocation("customtask"));
        Assert.assertEquals((Object)"org.jbpm.test:test-module:1.0.0:KBase-test:ksession-test-2", (Object)deployed.getDeploymentUnit().getIdentifier());
        RuntimeManager manager = this.deploymentService.getRuntimeManager(deploymentUnit.getIdentifier());
        Assert.assertNotNull((Object)manager);
        RuntimeEngine engine = manager.getRuntimeEngine(EmptyContext.get());
        Assert.assertNotNull((Object)engine);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", "test");
        ProcessInstance processInstance = engine.getKieSession().startProcess("customtask", params);
        Assert.assertEquals((long)2L, (long)processInstance.getState());
        manager.disposeRuntimeEngine(engine);
        this.checkFormsDeployment(deploymentUnit.getIdentifier());
    }

    @Test
    public void testDeploymentAvoidEmptyDescriptorOverride() {
        Assert.assertNotNull((Object)this.deploymentService);
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.jbpm.test", "kjar-with-dd", "1.0.0");
        ArrayList<String> processes = new ArrayList<String>();
        processes.add("repo/processes/general/customtask.bpmn");
        processes.add("repo/processes/general/humanTask.bpmn");
        processes.add("repo/processes/general/import.bpmn");
        DeploymentDescriptorImpl customDescriptor = new DeploymentDescriptorImpl("org.jbpm.domain");
        customDescriptor.getBuilder().runtimeStrategy(RuntimeStrategy.PER_REQUEST).addWorkItemHandler(new NamedObjectModel("Log", "org.jbpm.process.instance.impl.demo.SystemOutWorkItemHandler", new Object[0]));
        HashMap<String, String> resources = new HashMap<String, String>();
        resources.put("src/main/resources/META-INF/kie-deployment-descriptor.xml", customDescriptor.toXml());
        InternalKieModule kJar1 = this.createKieJar(ks, releaseId, processes, resources);
        File pom = new File("target/kmodule", "pom.xml");
        pom.getParentFile().mkdir();
        try {
            FileOutputStream fs = new FileOutputStream(pom);
            fs.write(this.getPom(releaseId, new ReleaseId[0]).getBytes());
            fs.close();
        }
        catch (Exception fs) {
            // empty catch block
        }
        KieMavenRepository repository = KieMavenRepository.getKieMavenRepository();
        repository.deployArtifact((AFReleaseId)releaseId, kJar1, pom);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "kjar-with-dd", "1.0.0", "KBase-test", "ksession-test2");
        deploymentUnit.setDeploymentDescriptor((DeploymentDescriptor)new DeploymentDescriptorImpl());
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        DeployedUnit deployedGeneral = this.deploymentService.getDeployedUnit(deploymentUnit.getIdentifier());
        Assert.assertNotNull((Object)deployedGeneral);
        Assert.assertNotNull((Object)deployedGeneral.getDeploymentUnit());
        Assert.assertNotNull((Object)deployedGeneral.getRuntimeManager());
        DeploymentDescriptor descriptor = ((InternalRuntimeManager)deployedGeneral.getRuntimeManager()).getDeploymentDescriptor();
        Assert.assertNotNull((Object)descriptor);
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)descriptor.getPersistenceUnit());
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)descriptor.getAuditPersistenceUnit());
        Assert.assertEquals((Object)AuditMode.JPA, (Object)descriptor.getAuditMode());
        Assert.assertEquals((Object)PersistenceMode.JPA, (Object)descriptor.getPersistenceMode());
        Assert.assertEquals((Object)RuntimeStrategy.PER_REQUEST, (Object)descriptor.getRuntimeStrategy());
        Assert.assertEquals((long)0L, (long)descriptor.getMarshallingStrategies().size());
        Assert.assertEquals((long)0L, (long)descriptor.getConfiguration().size());
        Assert.assertEquals((long)0L, (long)descriptor.getEnvironmentEntries().size());
        Assert.assertEquals((long)0L, (long)descriptor.getEventListeners().size());
        Assert.assertEquals((long)0L, (long)descriptor.getGlobals().size());
        Assert.assertEquals((long)0L, (long)descriptor.getTaskEventListeners().size());
        Assert.assertEquals((long)1L, (long)descriptor.getWorkItemHandlers().size());
        Assert.assertEquals((long)0L, (long)descriptor.getRequiredRoles().size());
        RuntimeManager manager = this.deploymentService.getRuntimeManager(deploymentUnit.getIdentifier());
        Assert.assertNotNull((Object)manager);
        RuntimeEngine engine = manager.getRuntimeEngine(EmptyContext.get());
        Assert.assertNotNull((Object)engine);
        HashMap params = new HashMap();
        ProcessInstance processInstance = engine.getKieSession().startProcess("customtask", params);
        Assert.assertEquals((long)2L, (long)processInstance.getState());
        manager.disposeRuntimeEngine(engine);
        this.checkFormsDeployment(deploymentUnit.getIdentifier());
    }

    protected void checkFormsDeployment(String deploymentId) {
        Map deployedForms = this.formManagerService.getAllFormsByDeployment(deploymentId);
        Assert.assertNotNull((Object)deployedForms);
        Assert.assertEquals((long)3L, (long)deployedForms.size());
        Assert.assertNotNull(deployedForms.get("DefaultProcess.frm"));
        Assert.assertNotNull(deployedForms.get("DefaultProcess.form"));
        Assert.assertNotNull(deployedForms.get("DefaultProcess.ftl"));
    }
}

