/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.test;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.appformer.maven.support.AFReleaseId;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.core.command.runtime.process.GetProcessInstanceCommand;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.kie.services.test.KModuleDeploymentServiceTest;
import org.jbpm.kie.test.util.AbstractKieServicesBaseTest;
import org.jbpm.services.api.ProcessInstanceNotFoundException;
import org.jbpm.services.api.model.DeploymentUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.command.Command;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItem;
import org.kie.internal.KieInternalServices;
import org.kie.internal.process.CorrelationKey;
import org.kie.internal.runtime.conf.RuntimeStrategy;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;
import org.kie.scanner.KieMavenRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessServiceImplPerProcessInstanceTest
extends AbstractKieServicesBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(KModuleDeploymentServiceTest.class);
    private static KModuleDeploymentUnit deploymentUnit;
    private static final String PROCESS_ID_HUMAN_TASK = "org.jbpm.writedocument";
    private static final String PROCESS_ID_SIGNAL = "org.jbpm.signal";

    @BeforeClass
    public static void prepareDeploymentUnit() {
        deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        deploymentUnit.setStrategy(RuntimeStrategy.PER_PROCESS_INSTANCE);
    }

    @Before
    public void prepare() {
        this.configureServices();
        logger.debug("Preparing kjar");
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.jbpm.test", "test-module", "1.0.0");
        ArrayList<String> processes = new ArrayList<String>();
        processes.add("repo/processes/general/customtask.bpmn");
        processes.add("repo/processes/general/humanTask.bpmn");
        processes.add("repo/processes/general/import.bpmn");
        processes.add("repo/processes/general/signal.bpmn");
        InternalKieModule kJar1 = this.createKieJar(ks, releaseId, processes);
        File pom = new File("target/kmodule", "pom.xml");
        pom.getParentFile().mkdir();
        try {
            FileOutputStream fs = new FileOutputStream(pom);
            fs.write(this.getPom(releaseId, new ReleaseId[0]).getBytes());
            fs.close();
        }
        catch (Exception fs) {
            // empty catch block
        }
        KieMavenRepository repository = KieMavenRepository.getKieMavenRepository();
        repository.deployArtifact((AFReleaseId)releaseId, kJar1, pom);
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
    }

    @After
    public void cleanup() {
        ProcessServiceImplPerProcessInstanceTest.cleanupSingletonSessionId();
        try {
            this.deploymentService.undeploy((DeploymentUnit)deploymentUnit);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.close();
    }

    @Test
    public void testAbortAlreadyAbortedProcess() {
        long processInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), PROCESS_ID_HUMAN_TASK);
        Assert.assertNotNull((Object)processInstanceId);
        this.processService.abortProcessInstance(Long.valueOf(processInstanceId));
        try {
            this.processService.abortProcessInstance(Long.valueOf(processInstanceId));
            Assert.fail((String)"Aborting of already aborted process instance should throw ProcessInstanceNotFoundException.");
        }
        catch (ProcessInstanceNotFoundException processInstanceNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testSignalProcessInstanceAbortedProcess() {
        long processInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), PROCESS_ID_SIGNAL);
        Assert.assertNotNull((Object)processInstanceId);
        this.processService.abortProcessInstance(Long.valueOf(processInstanceId));
        try {
            this.processService.signalProcessInstance(Long.valueOf(processInstanceId), "MySignal", null);
            Assert.fail((String)"Signalling of already aborted process instance should throw ProcessInstanceNotFoundException.");
        }
        catch (ProcessInstanceNotFoundException processInstanceNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testGetProcessInstanceAbortedProcess() {
        long processInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), PROCESS_ID_SIGNAL);
        Assert.assertNotNull((Object)processInstanceId);
        this.processService.abortProcessInstance(Long.valueOf(processInstanceId));
        try {
            this.processService.getProcessInstance(Long.valueOf(processInstanceId));
            Assert.fail((String)"Getting of already aborted process instance should throw ProcessInstanceNotFoundException.");
        }
        catch (ProcessInstanceNotFoundException processInstanceNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testGetProcessInstanceWithCorrelationKeyAbortedProcess() {
        CorrelationKey key = KieInternalServices.Factory.get().newCorrelationKeyFactory().newCorrelationKey("my business key");
        long processInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), PROCESS_ID_SIGNAL, key);
        Assert.assertNotNull((Object)processInstanceId);
        this.processService.abortProcessInstance(Long.valueOf(processInstanceId));
        ProcessInstance processInstance = this.processService.getProcessInstance(key);
        Assert.assertNull((Object)processInstance);
    }

    @Test
    public void testSetProcessVariableAbortedProcess() {
        long processInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), PROCESS_ID_HUMAN_TASK);
        Assert.assertNotNull((Object)processInstanceId);
        this.processService.abortProcessInstance(Long.valueOf(processInstanceId));
        try {
            this.processService.setProcessVariable(Long.valueOf(processInstanceId), "approval_reviewComment", (Object)"updated review comment");
            Assert.fail((String)"Setting process variable of already aborted process instance should throw ProcessInstanceNotFoundException.");
        }
        catch (ProcessInstanceNotFoundException processInstanceNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testSetProcessVariablesAbortedProcess() {
        long processInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), PROCESS_ID_HUMAN_TASK);
        Assert.assertNotNull((Object)processInstanceId);
        this.processService.abortProcessInstance(Long.valueOf(processInstanceId));
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("approval_document", "updated document");
            params.put("approval_reviewComment", "final review");
            this.processService.setProcessVariables(Long.valueOf(processInstanceId), params);
            Assert.fail((String)"Setting process variables of already aborted process instance should throw ProcessInstanceNotFoundException.");
        }
        catch (ProcessInstanceNotFoundException processInstanceNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testGetProcessInstanceVariableAbortedProcess() {
        long processInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), PROCESS_ID_HUMAN_TASK);
        Assert.assertNotNull((Object)processInstanceId);
        this.processService.abortProcessInstance(Long.valueOf(processInstanceId));
        try {
            this.processService.getProcessInstanceVariable(Long.valueOf(processInstanceId), "approval_document");
            Assert.fail((String)"Getting process variable of already aborted process instance should throw ProcessInstanceNotFoundException.");
        }
        catch (ProcessInstanceNotFoundException processInstanceNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testGetProcessInstanceVariablesAbortedProcess() {
        long processInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), PROCESS_ID_HUMAN_TASK);
        Assert.assertNotNull((Object)processInstanceId);
        this.processService.abortProcessInstance(Long.valueOf(processInstanceId));
        try {
            this.processService.getProcessInstanceVariables(Long.valueOf(processInstanceId));
            Assert.fail((String)"Getting process variables of already aborted process instance should throw ProcessInstanceNotFoundException.");
        }
        catch (ProcessInstanceNotFoundException processInstanceNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testGetAvailableSignalsAbortedProcess() {
        long processInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), PROCESS_ID_SIGNAL);
        Assert.assertNotNull((Object)processInstanceId);
        this.processService.abortProcessInstance(Long.valueOf(processInstanceId));
        try {
            this.processService.getAvailableSignals(Long.valueOf(processInstanceId));
            Assert.fail((String)"Getting available signals of already aborted process instance should throw ProcessInstanceNotFoundException.");
        }
        catch (ProcessInstanceNotFoundException processInstanceNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testGetWorkItemByProcessInstanceAbortedProcess() {
        long processInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), PROCESS_ID_HUMAN_TASK);
        Assert.assertNotNull((Object)processInstanceId);
        this.processService.abortProcessInstance(Long.valueOf(processInstanceId));
        try {
            this.processService.getWorkItemByProcessInstance(Long.valueOf(processInstanceId));
            Assert.fail((String)"Getting work items of already aborted process instance should throw ProcessInstanceNotFoundException.");
        }
        catch (ProcessInstanceNotFoundException processInstanceNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testCompleteWorkItemAbortedProcess() {
        long processInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), PROCESS_ID_HUMAN_TASK);
        Assert.assertNotNull((Object)processInstanceId);
        List workItems = this.processService.getWorkItemByProcessInstance(Long.valueOf(processInstanceId));
        Assert.assertEquals((long)1L, (long)workItems.size());
        this.processService.abortProcessInstance(Long.valueOf(processInstanceId));
        try {
            this.processService.completeWorkItem(Long.valueOf(((WorkItem)workItems.get(0)).getId()), null);
            Assert.fail((String)"Completing work item of already aborted process instance should throw ProcessInstanceNotFoundException.");
        }
        catch (ProcessInstanceNotFoundException processInstanceNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testAbortWorkItemAbortedProcess() {
        long processInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), PROCESS_ID_HUMAN_TASK);
        Assert.assertNotNull((Object)processInstanceId);
        List workItems = this.processService.getWorkItemByProcessInstance(Long.valueOf(processInstanceId));
        Assert.assertEquals((long)1L, (long)workItems.size());
        this.processService.abortProcessInstance(Long.valueOf(processInstanceId));
        try {
            this.processService.abortWorkItem(Long.valueOf(((WorkItem)workItems.get(0)).getId()));
            Assert.fail((String)"Aborting work item of already aborted process instance should throw ProcessInstanceNotFoundException.");
        }
        catch (ProcessInstanceNotFoundException processInstanceNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testGetWorkItemAbortedProcess() {
        long processInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), PROCESS_ID_HUMAN_TASK);
        Assert.assertNotNull((Object)processInstanceId);
        List workItems = this.processService.getWorkItemByProcessInstance(Long.valueOf(processInstanceId));
        Assert.assertEquals((long)1L, (long)workItems.size());
        this.processService.abortProcessInstance(Long.valueOf(processInstanceId));
        try {
            this.processService.getWorkItem(Long.valueOf(((WorkItem)workItems.get(0)).getId()));
            Assert.fail((String)"Getting work item of already aborted process instance should throw ProcessInstanceNotFoundException.");
        }
        catch (ProcessInstanceNotFoundException processInstanceNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testExecuteCommandOnAbortedProcess() {
        long processInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), PROCESS_ID_HUMAN_TASK);
        Assert.assertNotNull((Object)processInstanceId);
        this.processService.abortProcessInstance(Long.valueOf(processInstanceId));
        try {
            this.processService.execute(deploymentUnit.getIdentifier(), (Command)new GetProcessInstanceCommand(Long.valueOf(processInstanceId)));
            Assert.fail((String)"Executing command on already aborted process instance should throw ProcessInstanceNotFoundException.");
        }
        catch (ProcessInstanceNotFoundException processInstanceNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testExecuteCommandWithContextOnAbortedProcess() {
        long processInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), PROCESS_ID_HUMAN_TASK);
        Assert.assertNotNull((Object)processInstanceId);
        this.processService.abortProcessInstance(Long.valueOf(processInstanceId));
        try {
            this.processService.execute(deploymentUnit.getIdentifier(), (Context)ProcessInstanceIdContext.get((Long)processInstanceId), (Command)new GetProcessInstanceCommand(Long.valueOf(processInstanceId)));
            Assert.fail((String)"Executing command with context on already aborted process instance should throw ProcessInstanceNotFoundException.");
        }
        catch (ProcessInstanceNotFoundException processInstanceNotFoundException) {
            // empty catch block
        }
    }
}

