/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.test;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.appformer.maven.support.AFReleaseId;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.core.util.IoUtils;
import org.drools.persistence.jpa.marshaller.MappedVariable;
import org.drools.persistence.jpa.marshaller.VariableEntity;
import org.hibernate.LazyInitializationException;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.kie.test.util.AbstractKieServicesBaseTest;
import org.jbpm.runtime.manager.impl.deploy.DeploymentDescriptorImpl;
import org.jbpm.services.api.model.DeploymentUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.internal.runtime.conf.ObjectModel;
import org.kie.scanner.KieMavenRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessServiceWithEntitiesTest
extends AbstractKieServicesBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(ProcessServiceWithEntitiesTest.class);
    private static final String CASEDETAIL_JAVA = "src/main/java/example/CaseDetail.java";
    private List<DeploymentUnit> units = new ArrayList<DeploymentUnit>();

    @Before
    public void prepare() {
        this.configureServices();
        logger.debug("Preparing kjar");
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.jbpm.test", "test-module", "1.0.0");
        ArrayList<String> processes = new ArrayList<String>();
        processes.add("repo/processes/general/entityprocessvar-process.bpmn2");
        DeploymentDescriptorImpl customDescriptor = new DeploymentDescriptorImpl("org.jbpm.domain");
        List<String> remotableClasses = Arrays.asList("example.CaseDetail", "org.drools.persistence.jpa.marshaller.MappedVariable");
        customDescriptor.setClasses(remotableClasses);
        ArrayList<ObjectModel> marshallingStrategies = new ArrayList<ObjectModel>();
        marshallingStrategies.add(new ObjectModel("mvel", "new org.drools.persistence.jpa.marshaller.JPAPlaceholderResolverStrategy(\"org.jbpm.test:test-module:1.0.0\", classLoader)", new Object[0]));
        customDescriptor.setMarshallingStrategies(marshallingStrategies);
        HashMap<String, String> extraResources = new HashMap<String, String>();
        extraResources.put(CASEDETAIL_JAVA, ProcessServiceWithEntitiesTest.getCaseDetailEntitySource());
        extraResources.put("src/main/resources/META-INF/kie-deployment-descriptor.xml", customDescriptor.toXml());
        extraResources.put("src/main/resources/META-INF/persistence.xml", ProcessServiceWithEntitiesTest.getPersistenceXml());
        InternalKieModule kJar1 = this.createKieJar(ks, releaseId, processes, extraResources);
        File pom = new File("target/kmodule", "pom.xml");
        pom.getParentFile().mkdir();
        try {
            FileOutputStream fs = new FileOutputStream(pom);
            fs.write(this.getPom(releaseId, new ReleaseId[0]).getBytes());
            fs.close();
        }
        catch (Exception fs) {
            // empty catch block
        }
        KieMavenRepository repository = KieMavenRepository.getKieMavenRepository();
        repository.deployArtifact((AFReleaseId)releaseId, kJar1, pom);
    }

    @Test
    public void testStartProcessAndGetVariables() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        boolean isDeployed = this.deploymentService.isDeployed(deploymentUnit.getIdentifier());
        Assert.assertTrue((boolean)isDeployed);
        Assert.assertNotNull((Object)this.processService);
        HashMap params = new HashMap();
        long processInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), "processvarentity", params);
        Assert.assertNotNull((Object)processInstanceId);
        ProcessInstance pi = this.processService.getProcessInstance(Long.valueOf(processInstanceId));
        Assert.assertNotNull((Object)pi);
        Map variables = this.processService.getProcessInstanceVariables(Long.valueOf(processInstanceId));
        Assert.assertNotNull((Object)variables);
        Assert.assertEquals((long)1L, (long)variables.size());
        Assert.assertTrue((boolean)variables.containsKey("caseDetails"));
        VariableEntity varEntity = (VariableEntity)variables.get("caseDetails");
        Set mappedVariables = varEntity.getMappedVariables();
        try {
            Assert.assertEquals((long)1L, (long)mappedVariables.size());
            MappedVariable mappedVariable = (MappedVariable)mappedVariables.iterator().next();
            Assert.assertEquals((Object)"example.CaseDetail", (Object)mappedVariable.getVariableType());
        }
        catch (LazyInitializationException e) {
            Assert.fail((String)("Unable to retrieve mapped variables : " + e.getMessage()));
        }
    }

    @After
    public void cleanup() {
        ProcessServiceWithEntitiesTest.cleanupSingletonSessionId();
        if (this.units != null && !this.units.isEmpty()) {
            for (DeploymentUnit unit : this.units) {
                try {
                    this.deploymentService.undeploy(unit);
                }
                catch (Exception exception) {}
            }
            this.units.clear();
        }
        this.close();
    }

    private static String getPersistenceXml() {
        File entityTestPersistence = new File("src/test/resources/entity/entity-test-persistence.xml");
        Assert.assertTrue((boolean)entityTestPersistence.exists());
        return IoUtils.readFileAsString((File)entityTestPersistence);
    }

    private static String getCaseDetailEntitySource() {
        File entitySource = new File("src/test/resources/entity/entity-casedetail-source.txt");
        Assert.assertTrue((boolean)entitySource.exists());
        return IoUtils.readFileAsString((File)entitySource);
    }
}

