/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.test;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.appformer.maven.support.AFReleaseId;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.kie.services.test.KModuleDeploymentServiceTest;
import org.jbpm.kie.test.util.AbstractKieServicesBaseTest;
import org.jbpm.services.api.ProcessInstanceNotFoundException;
import org.jbpm.services.api.model.DeploymentUnit;
import org.jbpm.services.api.model.VariableDesc;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.query.QueryContext;
import org.kie.internal.runtime.conf.RuntimeStrategy;
import org.kie.scanner.KieMavenRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class ProcessServiceWithServiceRegistryTest
extends AbstractKieServicesBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(KModuleDeploymentServiceTest.class);
    private static final String PROCESS_ID_SCRIPT_TASK = "service-registry-test.script-task-test";
    private RuntimeStrategy strategy;
    private KModuleDeploymentUnit deploymentUnit;

    @Parameterized.Parameters(name="Strategy : {0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({RuntimeStrategy.SINGLETON}, {RuntimeStrategy.PER_PROCESS_INSTANCE}, {RuntimeStrategy.PER_REQUEST}, {RuntimeStrategy.PER_CASE});
    }

    public ProcessServiceWithServiceRegistryTest(RuntimeStrategy strategy) {
        this.strategy = strategy;
        this.deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentUnit.setStrategy(strategy);
    }

    @Before
    public void prepare() {
        this.configureServices();
        logger.debug("Preparing kjar");
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.jbpm.test", "test-module", "1.0.0");
        ArrayList<String> processes = new ArrayList<String>();
        processes.add("repo/processes/general/customtask.bpmn");
        processes.add("repo/processes/general/humanTask.bpmn");
        processes.add("repo/processes/general/import.bpmn");
        processes.add("repo/processes/general/signal.bpmn");
        processes.add("repo/processes/ServiceRegistryScriptTask.bpmn2");
        InternalKieModule kJar1 = this.createKieJar(ks, releaseId, processes);
        File pom = new File("target/kmodule", "pom.xml");
        pom.getParentFile().mkdir();
        try {
            FileOutputStream fs = new FileOutputStream(pom);
            fs.write(this.getPom(releaseId, new ReleaseId[0]).getBytes());
            fs.close();
        }
        catch (Exception fs) {
            // empty catch block
        }
        KieMavenRepository repository = KieMavenRepository.getKieMavenRepository();
        repository.deployArtifact((AFReleaseId)releaseId, kJar1, pom);
        this.deploymentService.deploy((DeploymentUnit)this.deploymentUnit);
    }

    @After
    public void cleanup() {
        ProcessServiceWithServiceRegistryTest.cleanupSingletonSessionId();
        try {
            this.deploymentService.undeploy((DeploymentUnit)this.deploymentUnit);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.close();
    }

    @Test
    public void testRunScriptProcessWithServiceRegistryInScriptTask() {
        long processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), PROCESS_ID_SCRIPT_TASK);
        Assert.assertNotNull((Object)processInstanceId);
        try {
            ProcessInstance pi = this.processService.getProcessInstance(Long.valueOf(processInstanceId));
            if (pi != null) {
                Assert.fail((String)"Process should be already completed");
            }
        }
        catch (ProcessInstanceNotFoundException pi) {
            // empty catch block
        }
        Collection variables = this.runtimeDataService.getVariableHistory(processInstanceId, "correlationKey", new QueryContext());
        Assert.assertNotNull((Object)variables);
        Assert.assertEquals((long)1L, (long)variables.size());
        VariableDesc ckVar = (VariableDesc)variables.iterator().next();
        Assert.assertNotNull((Object)ckVar);
        Assert.assertEquals((Object)"1", (Object)ckVar.getNewValue());
    }
}

