/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.test;

import java.io.File;
import java.io.FileOutputStream;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.appformer.maven.support.AFReleaseId;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.kie.services.impl.query.SqlQueryDefinition;
import org.jbpm.kie.services.impl.query.mapper.ProcessInstanceCustomQueryMapper;
import org.jbpm.kie.services.impl.query.mapper.ProcessInstanceQueryMapper;
import org.jbpm.kie.services.impl.query.mapper.ProcessInstanceWithCustomVarsQueryMapper;
import org.jbpm.kie.services.impl.query.mapper.ProcessInstanceWithVarsQueryMapper;
import org.jbpm.kie.services.impl.query.mapper.RawListQueryMapper;
import org.jbpm.kie.services.impl.query.mapper.TaskSummaryQueryMapper;
import org.jbpm.kie.services.impl.query.mapper.UserTaskInstanceQueryMapper;
import org.jbpm.kie.services.impl.query.mapper.UserTaskInstanceWithCustomVarsQueryMapper;
import org.jbpm.kie.services.impl.query.mapper.UserTaskInstanceWithVarsQueryMapper;
import org.jbpm.kie.services.test.KModuleDeploymentServiceTest;
import org.jbpm.kie.services.test.objects.TestQueryParamBuilderFactory;
import org.jbpm.kie.test.util.AbstractKieServicesBaseTest;
import org.jbpm.runtime.manager.impl.deploy.DeploymentDescriptorImpl;
import org.jbpm.services.api.ProcessInstanceNotFoundException;
import org.jbpm.services.api.model.DeploymentUnit;
import org.jbpm.services.api.model.ProcessInstanceDesc;
import org.jbpm.services.api.model.ProcessInstanceWithVarsDesc;
import org.jbpm.services.api.model.UserTaskInstanceWithVarsDesc;
import org.jbpm.services.api.query.NamedQueryMapper;
import org.jbpm.services.api.query.QueryNotFoundException;
import org.jbpm.services.api.query.QueryParamBuilder;
import org.jbpm.services.api.query.QueryResultMapper;
import org.jbpm.services.api.query.model.QueryDefinition;
import org.jbpm.services.api.query.model.QueryParam;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.query.AdvancedQueryContext;
import org.kie.api.runtime.query.QueryContext;
import org.kie.internal.runtime.manager.InternalRuntimeManager;
import org.kie.scanner.KieMavenRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryServiceImplTest
extends AbstractKieServicesBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(KModuleDeploymentServiceTest.class);
    private static final String PO_TASK_QUERY = "select ti.activationTime, ti.actualOwner, ti.createdBy, ti.createdOn, ti.deploymentId, ti.description, ti.dueDate, ti.name, ti.parentId, ti.priority, ti.processId, ti.processInstanceId, ti.processSessionId, ti.status, ti.taskId, ti.workItemId, oe.id, eo.entity_id from AuditTaskImpl ti left join PeopleAssignments_PotOwners po on ti.taskId = po.task_id left join OrganizationalEntity oe on po.entity_id = oe.id  left join PeopleAssignments_ExclOwners eo on ti.taskId = eo.task_id ";
    private List<DeploymentUnit> units = new ArrayList<DeploymentUnit>();
    protected String correctUser = "testUser";
    protected String wrongUser = "wrongUser";
    protected Long processInstanceId = null;
    protected KModuleDeploymentUnit deploymentUnit = null;
    protected KModuleDeploymentUnit deploymentUnitJPA = null;
    protected QueryDefinition query;
    protected String dataSourceJNDIname;

    @Before
    public void prepare() {
        System.setProperty("org.jbpm.ht.callback", "custom");
        System.setProperty("org.jbpm.ht.custom.callback", "org.jbpm.kie.services.test.objects.TestUserGroupCallbackImpl");
        this.dataSourceJNDIname = this.getDataSourceJNDI();
        this.configureServices();
        logger.debug("Preparing kjar");
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.jbpm.test", "test-module", "1.0.0");
        ArrayList<String> processes = new ArrayList<String>();
        processes.add("repo/processes/general/EmptyHumanTask.bpmn");
        processes.add("repo/processes/general/humanTask.bpmn");
        processes.add("repo/processes/general/BPMN2-UserTask.bpmn2");
        processes.add("repo/processes/general/SimpleHTProcess.bpmn2");
        processes.add("repo/processes/general/AdHocSubProcess.bpmn2");
        processes.add("repo/processes/general/ExcludedOwner.bpmn2");
        DeploymentDescriptorImpl customDescriptor = new DeploymentDescriptorImpl("org.jbpm.domain");
        customDescriptor.getBuilder().addRequiredRole("view:managers");
        HashMap<String, String> resources = new HashMap<String, String>();
        resources.put("src/main/resources/META-INF/kie-deployment-descriptor.xml", customDescriptor.toXml());
        InternalKieModule kJar1 = this.createKieJar(ks, releaseId, processes, resources);
        File pom = new File("target/kmodule", "pom.xml");
        pom.getParentFile().mkdir();
        try {
            FileOutputStream fs = new FileOutputStream(pom);
            fs.write(this.getPom(releaseId, new ReleaseId[0]).getBytes());
            fs.close();
        }
        catch (Exception fs) {
            // empty catch block
        }
        KieMavenRepository repository = KieMavenRepository.getKieMavenRepository();
        repository.deployArtifact((AFReleaseId)releaseId, kJar1, pom);
        Assert.assertNotNull((Object)this.deploymentService);
        this.deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)this.deploymentUnit);
        this.units.add((DeploymentUnit)this.deploymentUnit);
        this.prepareJPAModule(ks, repository);
        Assert.assertNotNull((Object)this.processService);
    }

    protected void prepareJPAModule(KieServices ks, KieMavenRepository repository) {
        ReleaseId releaseIdJPA = ks.newReleaseId("org.jbpm.test", "persistence-test", "1.0.0");
        File kjarJPA = new File("src/test/resources/kjar-jpa/persistence-test.jar");
        File pomJPA = new File("src/test/resources/kjar-jpa/pom.xml");
        repository.installArtifact((AFReleaseId)releaseIdJPA, kjarJPA, pomJPA);
        this.deploymentUnitJPA = new KModuleDeploymentUnit("org.jbpm.test", "persistence-test", "1.0.0");
    }

    protected String getDataSourceJNDI() {
        return "jdbc/testDS1";
    }

    @After
    public void cleanup() {
        System.clearProperty("org.jbpm.ht.callback");
        System.clearProperty("org.jbpm.ht.custom.callback");
        if (this.query != null) {
            try {
                this.queryService.unregisterQuery(this.query.getName());
            }
            catch (QueryNotFoundException queryNotFoundException) {
                // empty catch block
            }
        }
        if (this.processInstanceId != null) {
            try {
                this.processService.abortProcessInstance(this.processInstanceId);
                ProcessInstance pi = this.processService.getProcessInstance(this.processInstanceId);
                Assert.assertNull((Object)pi);
            }
            catch (ProcessInstanceNotFoundException processInstanceNotFoundException) {
                // empty catch block
            }
        }
        QueryServiceImplTest.cleanupSingletonSessionId();
        if (this.units != null && !this.units.isEmpty()) {
            for (DeploymentUnit unit : this.units) {
                try {
                    this.deploymentService.undeploy(unit);
                }
                catch (Exception exception) {}
            }
            this.units.clear();
        }
        this.close();
    }

    @Test
    public void testGetProcessInstances() {
        this.query = new SqlQueryDefinition("getAllProcessInstances", this.dataSourceJNDIname);
        this.query.setExpression("select * from processinstancelog");
        this.queryService.registerQuery(this.query);
        List queries = this.queryService.getQueries(new QueryContext());
        Assert.assertNotNull((Object)queries);
        Assert.assertEquals((long)1L, (long)queries.size());
        QueryDefinition registeredQuery = (QueryDefinition)queries.get(0);
        Assert.assertNotNull((Object)registeredQuery);
        Assert.assertEquals((Object)this.query.getName(), (Object)registeredQuery.getName());
        Assert.assertEquals((Object)this.query.getSource(), (Object)registeredQuery.getSource());
        Assert.assertEquals((Object)this.query.getExpression(), (Object)registeredQuery.getExpression());
        Assert.assertEquals((Object)this.query.getTarget(), (Object)registeredQuery.getTarget());
        registeredQuery = this.queryService.getQuery(this.query.getName());
        Assert.assertNotNull((Object)registeredQuery);
        Assert.assertEquals((Object)this.query.getName(), (Object)registeredQuery.getName());
        Assert.assertEquals((Object)this.query.getSource(), (Object)registeredQuery.getSource());
        Assert.assertEquals((Object)this.query.getExpression(), (Object)registeredQuery.getExpression());
        Assert.assertEquals((Object)this.query.getTarget(), (Object)registeredQuery.getTarget());
        Map resolvedColumns = registeredQuery.getColumns();
        Assert.assertNotNull((Object)resolvedColumns);
        Assert.assertEquals((long)18L, (long)resolvedColumns.size());
        Collection instances = (Collection)this.queryService.query(this.query.getName(), (QueryResultMapper)ProcessInstanceQueryMapper.get(), new QueryContext(), new QueryParam[0]);
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        instances = (Collection)this.queryService.query(this.query.getName(), (QueryResultMapper)ProcessInstanceQueryMapper.get(), new QueryContext(), new QueryParam[0]);
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.size());
        Assert.assertEquals((long)1L, (long)((ProcessInstanceDesc)instances.iterator().next()).getState().intValue());
        instances = (Collection)this.queryService.query(this.query.getName(), (QueryResultMapper)new NamedQueryMapper("ProcessInstances"), new QueryContext(), new QueryParam[0]);
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.size());
        Assert.assertEquals((long)1L, (long)((ProcessInstanceDesc)instances.iterator().next()).getState().intValue());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
        instances = (Collection)this.queryService.query(this.query.getName(), (QueryResultMapper)ProcessInstanceQueryMapper.get(), new QueryContext("PROCESSNAME", false), new QueryParam[0]);
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.size());
        Assert.assertEquals((long)3L, (long)((ProcessInstanceDesc)instances.iterator().next()).getState().intValue());
    }

    @Test
    public void testGetProcessInstancesByState() {
        this.query = new SqlQueryDefinition("getAllProcessInstances", this.dataSourceJNDIname);
        this.query.setExpression("select * from processinstancelog");
        this.queryService.registerQuery(this.query);
        Collection instances = (Collection)this.queryService.query(this.query.getName(), (QueryResultMapper)ProcessInstanceQueryMapper.get(), new QueryContext(), new QueryParam[0]);
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        instances = (Collection)this.queryService.query(this.query.getName(), (QueryResultMapper)ProcessInstanceQueryMapper.get(), new QueryContext(), new QueryParam[]{QueryParam.equalsTo((String)"STATUS", (Comparable[])new Comparable[]{Integer.valueOf(3)})});
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        instances = (Collection)this.queryService.query(this.query.getName(), (QueryResultMapper)ProcessInstanceQueryMapper.get(), new QueryContext(), new QueryParam[]{QueryParam.equalsTo((String)"STATUS", (Comparable[])new Comparable[]{Integer.valueOf(3), Integer.valueOf(1)})});
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.size());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
        instances = (Collection)this.queryService.query(this.query.getName(), (QueryResultMapper)ProcessInstanceQueryMapper.get(), new QueryContext(), new QueryParam[]{QueryParam.equalsTo((String)"STATUS", (Comparable[])new Comparable[]{Integer.valueOf(3)})});
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.size());
        Assert.assertEquals((long)3L, (long)((ProcessInstanceDesc)instances.iterator().next()).getState().intValue());
    }

    @Test
    public void testGetProcessInstancesByProcessId() {
        this.query = new SqlQueryDefinition("getAllProcessInstances", this.dataSourceJNDIname);
        this.query.setExpression("select * from processinstancelog");
        this.queryService.registerQuery(this.query);
        Collection instances = (Collection)this.queryService.query(this.query.getName(), (QueryResultMapper)ProcessInstanceQueryMapper.get(), new QueryContext(), new QueryParam[0]);
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        instances = (Collection)this.queryService.query(this.query.getName(), (QueryResultMapper)ProcessInstanceQueryMapper.get(), new QueryContext(), new QueryParam[]{QueryParam.likeTo((String)"PROCESSID", (boolean)true, (Comparable)((Object)"org.jbpm%"))});
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.size());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
    }

    @Test
    public void testGetProcessInstancesWithVariables() {
        this.query = new SqlQueryDefinition("getAllProcessInstancesWithVariables", this.dataSourceJNDIname);
        this.query.setExpression("select pil.*, v.variableId, v.value from ProcessInstanceLog pil inner join (select vil.processInstanceId ,vil.variableId, MAX(vil.ID) maxvilid  FROM VariableInstanceLog vil GROUP BY vil.processInstanceId, vil.variableId ORDER BY vil.processInstanceId)  x ON (v.variableId = x.variableId  AND v.id = x.maxvilid )INNER JOIN VariableInstanceLog v ON (v.processInstanceId = pil.processInstanceId)");
        this.queryService.registerQuery(this.query);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("approval_document", "initial content");
        params.put("approval_translatedDocument", "translated content");
        params.put("approval_reviewComment", "reviewed content");
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument", params);
        Assert.assertNotNull((Object)this.processInstanceId);
        List processInstanceLogs = (List)this.queryService.query(this.query.getName(), (QueryResultMapper)ProcessInstanceWithVarsQueryMapper.get(), new QueryContext(), new QueryParam[0]);
        Assert.assertNotNull((Object)processInstanceLogs);
        Assert.assertEquals((long)1L, (long)processInstanceLogs.size());
        ProcessInstanceWithVarsDesc instance = (ProcessInstanceWithVarsDesc)processInstanceLogs.get(0);
        Assert.assertEquals((long)3L, (long)instance.getVariables().size());
        processInstanceLogs = (List)this.queryService.query(this.query.getName(), (QueryResultMapper)ProcessInstanceWithVarsQueryMapper.get(), new QueryContext(), new QueryParam[]{QueryParam.likeTo((String)"PROCESSID", (boolean)true, (Comparable)((Object)"org.jbpm%"))});
        Assert.assertNotNull((Object)processInstanceLogs);
        Assert.assertEquals((long)1L, (long)processInstanceLogs.size());
        instance = (ProcessInstanceWithVarsDesc)processInstanceLogs.get(0);
        Assert.assertEquals((long)3L, (long)instance.getVariables().size());
        processInstanceLogs = (List)this.queryService.query(this.query.getName(), (QueryResultMapper)ProcessInstanceWithVarsQueryMapper.get(), new QueryContext(), new QueryParam[]{QueryParam.equalsTo((String)"VARIABLEID", (Comparable[])new Comparable[]{"not existing"})});
        Assert.assertNotNull((Object)processInstanceLogs);
        Assert.assertEquals((long)0L, (long)processInstanceLogs.size());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
    }

    @Test
    public void testGetProcessInstancesCustomWithVars() {
        this.query = new SqlQueryDefinition("jbpmProcessSearchWithVars", this.dataSourceJNDIname);
        this.query.setExpression("select p.PROCESSINSTANCEID, p.PROCESSID, p.PROCESSNAME, p.PROCESSVERSION, p.STATUS, p.EXTERNALID, pr.STARTDATE, p.USER_IDENTITY, p.PROCESSINSTANCEDESCRIPTION, p.CORRELATIONKEY, p.PARENTPROCESSINSTANCEID, pr.LASTMODIFICATIONDATE, var.variableId, var.value from PROCESSINSTANCELOG p inner join PROCESSINSTANCEINFO pr on p.PROCESSINSTANCEID = pr.INSTANCEID inner join (select v.processInstanceId, v.variableId, v.value from VariableInstanceLog v where v.id = (select MAX(vil.id) from VariableInstanceLog vil where v.variableId = vil.variableId and v.processInstanceId = vil.processInstanceId)) var on  p.PROCESSINSTANCEID = var.PROCESSINSTANCEID");
        this.queryService.registerQuery(this.query);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("approval_document", "initial content");
        params.put("approval_translatedDocument", "translated content");
        params.put("approval_reviewComment", "reviewed content");
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument", params);
        Assert.assertNotNull((Object)this.processInstanceId);
        List processInstanceLogs = (List)this.queryService.query(this.query.getName(), (QueryResultMapper)ProcessInstanceCustomQueryMapper.get(), new QueryContext(), new QueryParam[0]);
        Assert.assertNotNull((Object)processInstanceLogs);
        Assert.assertEquals((long)1L, (long)processInstanceLogs.size());
        ProcessInstanceWithVarsDesc instance = (ProcessInstanceWithVarsDesc)processInstanceLogs.get(0);
        Assert.assertEquals((long)3L, (long)instance.getVariables().size());
        processInstanceLogs = (List)this.queryService.query(this.query.getName(), (QueryResultMapper)ProcessInstanceCustomQueryMapper.get(), new QueryContext(), new QueryParam[]{QueryParam.equalsTo((String)"VARIABLEID", (Comparable[])new Comparable[]{"approval_document"})});
        Assert.assertNotNull((Object)processInstanceLogs);
        Assert.assertEquals((long)1L, (long)processInstanceLogs.size());
        processInstanceLogs = (List)this.queryService.query(this.query.getName(), (QueryResultMapper)ProcessInstanceCustomQueryMapper.get(), new QueryContext(), new QueryParam[]{QueryParam.equalsTo((String)"VARIABLEID", (Comparable[])new Comparable[]{"not existing"})});
        Assert.assertNotNull((Object)processInstanceLogs);
        Assert.assertEquals((long)0L, (long)processInstanceLogs.size());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
    }

    @Test
    public void testGetProcessInstancesCustomWithoutVars() {
        this.query = new SqlQueryDefinition("jbpmProcessSearchWithoutVars", this.dataSourceJNDIname);
        this.query.setExpression("select p.PROCESSINSTANCEID, p.PROCESSID, p.PROCESSNAME, p.PROCESSVERSION, p.STATUS, p.EXTERNALID, pr.STARTDATE, p.USER_IDENTITY, p.PROCESSINSTANCEDESCRIPTION, p.CORRELATIONKEY, p.PARENTPROCESSINSTANCEID, pr.LASTMODIFICATIONDATE from PROCESSINSTANCELOG p inner join PROCESSINSTANCEINFO pr on p.PROCESSINSTANCEID = pr.INSTANCEID");
        this.queryService.registerQuery(this.query);
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        List processInstanceLogs = (List)this.queryService.query(this.query.getName(), (QueryResultMapper)ProcessInstanceCustomQueryMapper.get(), new QueryContext(), new QueryParam[0]);
        Assert.assertNotNull((Object)processInstanceLogs);
        Assert.assertEquals((long)1L, (long)processInstanceLogs.size());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
    }

    @Test
    public void testGetTaskInstances() {
        this.query = new SqlQueryDefinition("getAllTaskInstances", this.dataSourceJNDIname);
        this.query.setExpression("select ti.* from AuditTaskImpl ti ");
        this.queryService.registerQuery(this.query);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("approval_document", "initial content");
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument", params);
        Assert.assertNotNull((Object)this.processInstanceId);
        List taskInstanceLogs = (List)this.queryService.query(this.query.getName(), (QueryResultMapper)UserTaskInstanceQueryMapper.get(), new QueryContext(), new QueryParam[0]);
        Assert.assertNotNull((Object)taskInstanceLogs);
        Assert.assertEquals((long)1L, (long)taskInstanceLogs.size());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
    }

    @Test
    public void testGetTaskInstancesWithVariables() {
        this.query = new SqlQueryDefinition("getAllTaskInputInstancesWithVariables", this.dataSourceJNDIname);
        this.query.setExpression("select ti.*, tv.name tvname, tv.value tvvalue from AuditTaskImpl ti inner join (select tv.taskId, tv.name, tv.value from TaskVariableImpl tv where tv.type = 0 ) tv on (tv.taskId = ti.taskId)");
        this.queryService.registerQuery(this.query);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("approval_document", "initial content");
        params.put("approval_translatedDocument", "translated content");
        params.put("approval_reviewComment", "reviewed content");
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument", params);
        Assert.assertNotNull((Object)this.processInstanceId);
        List taskInstanceLogs = (List)this.queryService.query(this.query.getName(), (QueryResultMapper)UserTaskInstanceWithVarsQueryMapper.get(), new QueryContext(), new QueryParam[0]);
        Assert.assertNotNull((Object)taskInstanceLogs);
        Assert.assertEquals((long)1L, (long)taskInstanceLogs.size());
        UserTaskInstanceWithVarsDesc instance = (UserTaskInstanceWithVarsDesc)taskInstanceLogs.get(0);
        Assert.assertEquals((long)3L, (long)instance.getVariables().size());
        taskInstanceLogs = (List)this.queryService.query(this.query.getName(), (QueryResultMapper)UserTaskInstanceWithVarsQueryMapper.get(), new QueryContext(), new QueryParam[]{QueryParam.equalsTo((String)"TVNAME", (Comparable[])new Comparable[]{"Comment"}), QueryParam.equalsTo((String)"TVVALUE", (Comparable[])new Comparable[]{"Write a Document"})});
        Assert.assertNotNull((Object)taskInstanceLogs);
        Assert.assertEquals((long)1L, (long)taskInstanceLogs.size());
        instance = (UserTaskInstanceWithVarsDesc)taskInstanceLogs.get(0);
        Assert.assertEquals((long)1L, (long)instance.getVariables().size());
        taskInstanceLogs = (List)this.queryService.query(this.query.getName(), (QueryResultMapper)UserTaskInstanceWithVarsQueryMapper.get(), new QueryContext(), new QueryParam[]{QueryParam.equalsTo((String)"TVNAME", (Comparable[])new Comparable[]{"Comment"}), QueryParam.equalsTo((String)"TVVALUE", (Comparable[])new Comparable[]{"Wrong Comment"})});
        Assert.assertNotNull((Object)taskInstanceLogs);
        Assert.assertEquals((long)0L, (long)taskInstanceLogs.size());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
    }

    @Test
    public void testGetTaskInstancesAsPotOwners() {
        this.query = new SqlQueryDefinition("getMyTaskInstances", this.dataSourceJNDIname, QueryDefinition.Target.PO_TASK);
        this.query.setExpression(PO_TASK_QUERY);
        this.queryService.registerQuery(this.query);
        List queries = this.queryService.getQueries(new QueryContext());
        Assert.assertNotNull((Object)queries);
        Assert.assertEquals((long)1L, (long)queries.size());
        QueryDefinition registeredQuery = (QueryDefinition)queries.get(0);
        Assert.assertNotNull((Object)registeredQuery);
        Assert.assertEquals((Object)this.query.getName(), (Object)registeredQuery.getName());
        Assert.assertEquals((Object)this.query.getSource(), (Object)registeredQuery.getSource());
        Assert.assertEquals((Object)this.query.getExpression(), (Object)registeredQuery.getExpression());
        Assert.assertEquals((Object)this.query.getTarget(), (Object)registeredQuery.getTarget());
        registeredQuery = this.queryService.getQuery(this.query.getName());
        Assert.assertNotNull((Object)registeredQuery);
        Assert.assertEquals((Object)this.query.getName(), (Object)registeredQuery.getName());
        Assert.assertEquals((Object)this.query.getSource(), (Object)registeredQuery.getSource());
        Assert.assertEquals((Object)this.query.getExpression(), (Object)registeredQuery.getExpression());
        Assert.assertEquals((Object)this.query.getTarget(), (Object)registeredQuery.getTarget());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("approval_document", "initial content");
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument", params);
        Assert.assertNotNull((Object)this.processInstanceId);
        this.identityProvider.setName("notvalid");
        this.identityProvider.setRoles(Collections.emptyList());
        this.userGroupCallback.setUserGroups(this.identityProvider.getName(), Collections.emptyList());
        List taskInstanceLogs = (List)this.queryService.query(this.query.getName(), (QueryResultMapper)UserTaskInstanceQueryMapper.get(), new QueryContext(), new QueryParam[0]);
        Assert.assertNotNull((Object)taskInstanceLogs);
        Assert.assertEquals((long)0L, (long)taskInstanceLogs.size());
        this.identityProvider.setName("salaboy");
        this.identityProvider.setRoles(Collections.emptyList());
        this.userGroupCallback.setUserGroups(this.identityProvider.getName(), Collections.emptyList());
        taskInstanceLogs = (List)this.queryService.query(this.query.getName(), (QueryResultMapper)UserTaskInstanceQueryMapper.get(), new QueryContext(), new QueryParam[0]);
        Assert.assertNotNull((Object)taskInstanceLogs);
        Assert.assertEquals((long)1L, (long)taskInstanceLogs.size());
        List taskSummaries = (List)this.queryService.query(this.query.getName(), (QueryResultMapper)TaskSummaryQueryMapper.get(), new QueryContext(), new QueryParam[0]);
        Assert.assertNotNull((Object)taskSummaries);
        Assert.assertEquals((long)1L, (long)taskSummaries.size());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
    }

    @Test
    public void testGetTaskInstancesAsExcludedOwner() {
        String potentialOwner = "maciej";
        String excludedOwner = "kris";
        List<String> roles = Arrays.asList("admins");
        this.query = new SqlQueryDefinition("getMyTaskInstances", this.dataSourceJNDIname, QueryDefinition.Target.PO_TASK);
        this.query.setExpression(PO_TASK_QUERY);
        this.queryService.registerQuery(this.query);
        List queries = this.queryService.getQueries(new QueryContext());
        Assert.assertNotNull((Object)queries);
        Assert.assertEquals((long)1L, (long)queries.size());
        QueryDefinition registeredQuery = (QueryDefinition)queries.get(0);
        Assert.assertNotNull((Object)registeredQuery);
        Assert.assertEquals((Object)this.query.getName(), (Object)registeredQuery.getName());
        Assert.assertEquals((Object)this.query.getSource(), (Object)registeredQuery.getSource());
        Assert.assertEquals((Object)this.query.getExpression(), (Object)registeredQuery.getExpression());
        Assert.assertEquals((Object)this.query.getTarget(), (Object)registeredQuery.getTarget());
        registeredQuery = this.queryService.getQuery(this.query.getName());
        Assert.assertNotNull((Object)registeredQuery);
        Assert.assertEquals((Object)this.query.getName(), (Object)registeredQuery.getName());
        Assert.assertEquals((Object)this.query.getSource(), (Object)registeredQuery.getSource());
        Assert.assertEquals((Object)this.query.getExpression(), (Object)registeredQuery.getExpression());
        Assert.assertEquals((Object)this.query.getTarget(), (Object)registeredQuery.getTarget());
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.ExcludedOwner", new HashMap());
        Assert.assertNotNull((Object)this.processInstanceId);
        this.identityProvider.setName("maciej");
        this.identityProvider.setRoles(Collections.emptyList());
        this.userGroupCallback.setUserGroups("maciej", roles);
        List taskInstanceLogs = (List)this.queryService.query(this.query.getName(), (QueryResultMapper)UserTaskInstanceQueryMapper.get(), new QueryContext(), new QueryParam[0]);
        Assert.assertNotNull((Object)taskInstanceLogs);
        Assert.assertEquals((long)1L, (long)taskInstanceLogs.size());
        this.identityProvider.setName("kris");
        this.identityProvider.setRoles(Collections.emptyList());
        this.userGroupCallback.setUserGroups("kris", roles);
        taskInstanceLogs = (List)this.queryService.query(this.query.getName(), (QueryResultMapper)UserTaskInstanceQueryMapper.get(), new QueryContext(), new QueryParam[0]);
        Assert.assertNotNull((Object)taskInstanceLogs);
        Assert.assertEquals((long)0L, (long)taskInstanceLogs.size());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
    }

    @Test
    public void testGetTaskInstancesAsBA() {
        this.query = new SqlQueryDefinition("getBATaskInstances", this.dataSourceJNDIname, QueryDefinition.Target.BA_TASK);
        this.query.setExpression("select ti.activationTime, ti.actualOwner, ti.createdBy, ti.createdOn, ti.deploymentId, ti.description, ti.dueDate, ti.name, ti.parentId, ti.priority, ti.processId, ti.processInstanceId, ti.processSessionId, ti.status, ti.taskId, ti.workItemId, oe.id from AuditTaskImpl ti,PeopleAssignments_BAs bas, OrganizationalEntity oe where ti.taskId = bas.task_id and bas.entity_id = oe.id ");
        this.queryService.registerQuery(this.query);
        List queries = this.queryService.getQueries(new QueryContext());
        Assert.assertNotNull((Object)queries);
        Assert.assertEquals((long)1L, (long)queries.size());
        QueryDefinition registeredQuery = (QueryDefinition)queries.get(0);
        Assert.assertNotNull((Object)registeredQuery);
        Assert.assertEquals((Object)this.query.getName(), (Object)registeredQuery.getName());
        Assert.assertEquals((Object)this.query.getSource(), (Object)registeredQuery.getSource());
        Assert.assertEquals((Object)this.query.getExpression(), (Object)registeredQuery.getExpression());
        Assert.assertEquals((Object)this.query.getTarget(), (Object)registeredQuery.getTarget());
        registeredQuery = this.queryService.getQuery(this.query.getName());
        Assert.assertNotNull((Object)registeredQuery);
        Assert.assertEquals((Object)this.query.getName(), (Object)registeredQuery.getName());
        Assert.assertEquals((Object)this.query.getSource(), (Object)registeredQuery.getSource());
        Assert.assertEquals((Object)this.query.getExpression(), (Object)registeredQuery.getExpression());
        Assert.assertEquals((Object)this.query.getTarget(), (Object)registeredQuery.getTarget());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("approval_document", "initial content");
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument", params);
        Assert.assertNotNull((Object)this.processInstanceId);
        List taskInstanceLogs = (List)this.queryService.query(this.query.getName(), (QueryResultMapper)UserTaskInstanceQueryMapper.get(), new QueryContext(), QueryParam.groupBy((String)"TASKID"));
        Assert.assertNotNull((Object)taskInstanceLogs);
        Assert.assertEquals((long)0L, (long)taskInstanceLogs.size());
        this.identityProvider.setName("Administrator");
        this.identityProvider.setRoles(Collections.emptyList());
        this.userGroupCallback.setUserGroups(this.identityProvider.getName(), Collections.emptyList());
        taskInstanceLogs = (List)this.queryService.query(this.query.getName(), (QueryResultMapper)UserTaskInstanceQueryMapper.get(), new QueryContext(), QueryParam.groupBy((String)"TASKID"));
        Assert.assertNotNull((Object)taskInstanceLogs);
        Assert.assertEquals((long)1L, (long)taskInstanceLogs.size());
        this.identityProvider.setName("salaboy");
        this.identityProvider.setRoles(Arrays.asList("Administrators"));
        this.userGroupCallback.setUserGroups("salaboy", Arrays.asList("Administrators"));
        taskInstanceLogs = (List)this.queryService.query(this.query.getName(), (QueryResultMapper)UserTaskInstanceQueryMapper.get(), new QueryContext(), QueryParam.groupBy((String)"TASKID"));
        Assert.assertNotNull((Object)taskInstanceLogs);
        Assert.assertEquals((long)1L, (long)taskInstanceLogs.size());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
    }

    @Test
    public void testGetTaskInstancesWithCustomVariables() throws Exception {
        this.deploymentService.deploy((DeploymentUnit)this.deploymentUnitJPA);
        this.units.add((DeploymentUnit)this.deploymentUnitJPA);
        this.query = new SqlQueryDefinition("getAllTaskInstancesWithCustomVariables", this.dataSourceJNDIname);
        this.query.setExpression("select ti.*,  c.firstname, c.lastname, c.age, c.customerId from AuditTaskImpl ti inner join (select mv.map_var_id, mv.taskid from MappedVariable mv) mv on (mv.taskid = ti.taskId) inner join Customer c on (c.id = mv.map_var_id)");
        this.queryService.registerQuery(this.query);
        RuntimeManager manager = this.deploymentService.getRuntimeManager(this.deploymentUnitJPA.getIdentifier());
        Assert.assertNotNull((Object)manager);
        Class<?> clazz = Class.forName("org.jbpm.test.Customer", true, ((InternalRuntimeManager)manager).getEnvironment().getClassLoader());
        Object cinstance = clazz.newInstance();
        this.setFieldValue(cinstance, "firstName", "john");
        this.setFieldValue(cinstance, "lastName", "doe");
        this.setFieldValue(cinstance, "age", new Integer(45));
        this.setFieldValue(cinstance, "customerId", new Long(1234L));
        HashMap params = new HashMap();
        params.put("customer", cinstance);
        this.processInstanceId = this.processService.startProcess(this.deploymentUnitJPA.getIdentifier(), "persistence-test.customer-evaluation", params);
        Assert.assertNotNull((Object)this.processInstanceId);
        HashMap<String, String> variableMap = new HashMap<String, String>();
        variableMap.put("FIRSTNAME", "string");
        variableMap.put("LASTNAME", "string");
        variableMap.put("AGE", "integer");
        variableMap.put("CUSTOMERID", "long");
        List taskInstanceLogs = (List)this.queryService.query(this.query.getName(), (QueryResultMapper)UserTaskInstanceWithCustomVarsQueryMapper.get(variableMap), new QueryContext(), new QueryParam[0]);
        Assert.assertNotNull((Object)taskInstanceLogs);
        Assert.assertEquals((long)1L, (long)taskInstanceLogs.size());
        UserTaskInstanceWithVarsDesc instance = (UserTaskInstanceWithVarsDesc)taskInstanceLogs.get(0);
        Assert.assertEquals((long)4L, (long)instance.getVariables().size());
        Assert.assertTrue((boolean)instance.getVariables().containsKey("FIRSTNAME"));
        Assert.assertTrue((boolean)instance.getVariables().containsKey("LASTNAME"));
        Assert.assertTrue((boolean)instance.getVariables().containsKey("AGE"));
        Assert.assertTrue((boolean)instance.getVariables().containsKey("CUSTOMERID"));
        Assert.assertEquals((Object)"john", instance.getVariables().get("FIRSTNAME"));
        Assert.assertEquals((Object)"doe", instance.getVariables().get("LASTNAME"));
        Assert.assertEquals((Object)45, instance.getVariables().get("AGE"));
        Assert.assertEquals((Object)1234L, instance.getVariables().get("CUSTOMERID"));
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
    }

    @Test
    public void testGetProcessInstancesWithQueryParamBuilder() {
        this.query = new SqlQueryDefinition("getAllProcessInstances", this.dataSourceJNDIname);
        this.query.setExpression("select * from processinstancelog");
        this.queryService.registerQuery(this.query);
        Collection instances = (Collection)this.queryService.query(this.query.getName(), (QueryResultMapper)ProcessInstanceQueryMapper.get(), new QueryContext(), new QueryParam[0]);
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        TestQueryParamBuilderFactory qbFactory = new TestQueryParamBuilderFactory();
        Assert.assertTrue((boolean)qbFactory.accept("test"));
        HashMap<String, Long> parameters = new HashMap<String, Long>();
        parameters.put("min", this.processInstanceId);
        parameters.put("max", this.processInstanceId + 2L);
        QueryParamBuilder paramBuilder = qbFactory.newInstance(parameters);
        instances = (Collection)this.queryService.query(this.query.getName(), (QueryResultMapper)ProcessInstanceQueryMapper.get(), new QueryContext(), paramBuilder);
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.size());
        parameters = new HashMap();
        parameters.put("min", this.processInstanceId + 2L);
        parameters.put("max", 0L);
        paramBuilder = qbFactory.newInstance(parameters);
        instances = (Collection)this.queryService.query(this.query.getName(), (QueryResultMapper)ProcessInstanceQueryMapper.get(), new QueryContext(), paramBuilder);
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
    }

    @Test
    public void testGetProcessInstancesWithCustomVariables() throws Exception {
        this.deploymentService.deploy((DeploymentUnit)this.deploymentUnitJPA);
        this.units.add((DeploymentUnit)this.deploymentUnitJPA);
        this.query = new SqlQueryDefinition("getAllProcessInstancesWithCustomVariables", this.dataSourceJNDIname);
        this.query.setExpression("select pi.*,  c.firstname, c.lastname, c.age, c.customerId from ProcessInstanceLog pi inner join (select mv.map_var_id, mv.processInstanceId from MappedVariable mv) mv on (mv.processInstanceId = pi.processinstanceId) inner join Customer c on (c.id = mv.map_var_id)");
        this.queryService.registerQuery(this.query);
        RuntimeManager manager = this.deploymentService.getRuntimeManager(this.deploymentUnitJPA.getIdentifier());
        Assert.assertNotNull((Object)manager);
        Class<?> clazz = Class.forName("org.jbpm.test.Customer", true, ((InternalRuntimeManager)manager).getEnvironment().getClassLoader());
        Object cinstance = clazz.newInstance();
        this.setFieldValue(cinstance, "firstName", "john");
        this.setFieldValue(cinstance, "lastName", "doe");
        this.setFieldValue(cinstance, "age", new Integer(45));
        this.setFieldValue(cinstance, "customerId", new Long(1234L));
        HashMap params = new HashMap();
        params.put("customer", cinstance);
        this.processInstanceId = this.processService.startProcess(this.deploymentUnitJPA.getIdentifier(), "persistence-test.customer-evaluation", params);
        Assert.assertNotNull((Object)this.processInstanceId);
        HashMap<String, String> variableMap = new HashMap<String, String>();
        variableMap.put("FIRSTNAME", "string");
        variableMap.put("LASTNAME", "string");
        variableMap.put("AGE", "integer");
        variableMap.put("CUSTOMERID", "long");
        List processInstanceLogs = (List)this.queryService.query(this.query.getName(), (QueryResultMapper)ProcessInstanceWithCustomVarsQueryMapper.get(variableMap), new QueryContext(), new QueryParam[0]);
        Assert.assertNotNull((Object)processInstanceLogs);
        Assert.assertEquals((long)1L, (long)processInstanceLogs.size());
        ProcessInstanceWithVarsDesc instance = (ProcessInstanceWithVarsDesc)processInstanceLogs.get(0);
        Assert.assertEquals((long)4L, (long)instance.getVariables().size());
        Assert.assertTrue((boolean)instance.getVariables().containsKey("FIRSTNAME"));
        Assert.assertTrue((boolean)instance.getVariables().containsKey("LASTNAME"));
        Assert.assertTrue((boolean)instance.getVariables().containsKey("AGE"));
        Assert.assertTrue((boolean)instance.getVariables().containsKey("CUSTOMERID"));
        Assert.assertEquals((Object)"john", instance.getVariables().get("FIRSTNAME"));
        Assert.assertEquals((Object)"doe", instance.getVariables().get("LASTNAME"));
        Assert.assertEquals((Object)45, instance.getVariables().get("AGE"));
        Assert.assertEquals((Object)1234L, instance.getVariables().get("CUSTOMERID"));
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
    }

    @Test
    public void testGetProcessInstancesWithRawMapper() {
        this.query = new SqlQueryDefinition("getAllProcessInstances", this.dataSourceJNDIname);
        this.query.setExpression("select * from processinstancelog");
        this.queryService.registerQuery(this.query);
        List queries = this.queryService.getQueries(new QueryContext());
        Assert.assertNotNull((Object)queries);
        Assert.assertEquals((long)1L, (long)queries.size());
        QueryDefinition registeredQuery = (QueryDefinition)queries.get(0);
        Assert.assertNotNull((Object)registeredQuery);
        Assert.assertEquals((Object)this.query.getName(), (Object)registeredQuery.getName());
        Assert.assertEquals((Object)this.query.getSource(), (Object)registeredQuery.getSource());
        Assert.assertEquals((Object)this.query.getExpression(), (Object)registeredQuery.getExpression());
        Assert.assertEquals((Object)this.query.getTarget(), (Object)registeredQuery.getTarget());
        registeredQuery = this.queryService.getQuery(this.query.getName());
        Assert.assertNotNull((Object)registeredQuery);
        Assert.assertEquals((Object)this.query.getName(), (Object)registeredQuery.getName());
        Assert.assertEquals((Object)this.query.getSource(), (Object)registeredQuery.getSource());
        Assert.assertEquals((Object)this.query.getExpression(), (Object)registeredQuery.getExpression());
        Assert.assertEquals((Object)this.query.getTarget(), (Object)registeredQuery.getTarget());
        List instances = (List)this.queryService.query(this.query.getName(), (QueryResultMapper)RawListQueryMapper.get(), new QueryContext(), new QueryParam[0]);
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        instances = (List)this.queryService.query(this.query.getName(), (QueryResultMapper)RawListQueryMapper.get(), new QueryContext(), new QueryParam[0]);
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.size());
        List firstRow = (List)instances.get(0);
        Assert.assertNotNull((Object)firstRow);
        Assert.assertEquals((long)18L, (long)firstRow.size());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
    }

    @Test
    public void testGetProcessInstancesWithRawMapperMultipleRows() {
        this.query = new SqlQueryDefinition("getAllProcessInstances", this.dataSourceJNDIname);
        this.query.setExpression("select * from processinstancelog");
        this.queryService.registerQuery(this.query);
        List queries = this.queryService.getQueries(new QueryContext());
        Assert.assertNotNull((Object)queries);
        Assert.assertEquals((long)1L, (long)queries.size());
        QueryDefinition registeredQuery = (QueryDefinition)queries.get(0);
        Assert.assertNotNull((Object)registeredQuery);
        Assert.assertEquals((Object)this.query.getName(), (Object)registeredQuery.getName());
        Assert.assertEquals((Object)this.query.getSource(), (Object)registeredQuery.getSource());
        Assert.assertEquals((Object)this.query.getExpression(), (Object)registeredQuery.getExpression());
        Assert.assertEquals((Object)this.query.getTarget(), (Object)registeredQuery.getTarget());
        registeredQuery = this.queryService.getQuery(this.query.getName());
        Assert.assertNotNull((Object)registeredQuery);
        Assert.assertEquals((Object)this.query.getName(), (Object)registeredQuery.getName());
        Assert.assertEquals((Object)this.query.getSource(), (Object)registeredQuery.getSource());
        Assert.assertEquals((Object)this.query.getExpression(), (Object)registeredQuery.getExpression());
        Assert.assertEquals((Object)this.query.getTarget(), (Object)registeredQuery.getTarget());
        List instances = (List)this.queryService.query(this.query.getName(), (QueryResultMapper)RawListQueryMapper.get(), new QueryContext(), new QueryParam[0]);
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        Long processInstanceId2 = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)processInstanceId2);
        instances = (List)this.queryService.query(this.query.getName(), (QueryResultMapper)RawListQueryMapper.get(), new QueryContext(), new QueryParam[0]);
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)2L, (long)instances.size());
        List firstRow = (List)instances.get(0);
        Assert.assertNotNull((Object)firstRow);
        Assert.assertEquals((long)18L, (long)firstRow.size());
        List secondRow = (List)instances.get(1);
        Assert.assertNotNull((Object)secondRow);
        Assert.assertEquals((long)18L, (long)secondRow.size());
        Assert.assertNotEquals((Object)firstRow, (Object)secondRow);
        this.processService.abortProcessInstance(processInstanceId2);
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
    }

    @Test
    public void testGetProcessInstancesCount() {
        this.query = new SqlQueryDefinition("getAllProcessInstances", this.dataSourceJNDIname);
        this.query.setExpression("select * from processinstancelog");
        this.queryService.registerQuery(this.query);
        List queries = this.queryService.getQueries(new QueryContext());
        Assert.assertNotNull((Object)queries);
        Assert.assertEquals((long)1L, (long)queries.size());
        Collection instances = (Collection)this.queryService.query(this.query.getName(), (QueryResultMapper)RawListQueryMapper.get(), new QueryContext(), new QueryParam[]{QueryParam.count((String)"PROCESSINSTANCEID")});
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.size());
        List result = (List)instances.iterator().next();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertTrue((boolean)(result.get(0) instanceof Number));
        Assert.assertEquals((long)0L, (long)((Number)result.get(0)).intValue());
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        instances = (Collection)this.queryService.query(this.query.getName(), (QueryResultMapper)RawListQueryMapper.get(), new QueryContext(), new QueryParam[]{QueryParam.count((String)"PROCESSINSTANCEID")});
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.size());
        result = (List)instances.iterator().next();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertTrue((boolean)(result.get(0) instanceof Number));
        Assert.assertEquals((long)1L, (long)((Number)result.get(0)).intValue());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
    }

    @Test
    public void testGetProcessInstancesCountAndGroup() {
        this.query = new SqlQueryDefinition("getAllProcessInstances", this.dataSourceJNDIname);
        this.query.setExpression("select * from processinstancelog");
        this.queryService.registerQuery(this.query);
        List queries = this.queryService.getQueries(new QueryContext());
        Assert.assertNotNull((Object)queries);
        Assert.assertEquals((long)1L, (long)queries.size());
        QueryParam[] parameters = QueryParam.getBuilder().append(QueryParam.groupBy((String)"PROCESSNAME")).append(new QueryParam[]{QueryParam.count((String)"PROCESSINSTANCEID")}).get();
        Collection instances = (Collection)this.queryService.query(this.query.getName(), (QueryResultMapper)RawListQueryMapper.get(), new QueryContext(), parameters);
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        long processInstanceId2 = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jboss.qa.bpms.HumanTask");
        instances = (Collection)this.queryService.query(this.query.getName(), (QueryResultMapper)RawListQueryMapper.get(), new QueryContext(), parameters);
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)2L, (long)instances.size());
        List result = (List)instances.iterator().next();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertTrue((boolean)(result.get(1) instanceof Number));
        Assert.assertEquals((long)1L, (long)((Number)result.get(1)).intValue());
        result = (List)instances.iterator().next();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertTrue((boolean)(result.get(1) instanceof Number));
        Assert.assertEquals((long)1L, (long)((Number)result.get(1)).intValue());
        this.processService.abortProcessInstance(Long.valueOf(processInstanceId2));
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
    }

    @Test
    public void testGetFilteredProcessInstances() {
        ArrayList<String> roles = new ArrayList<String>();
        roles.add("managers");
        this.identityProvider.setRoles(roles);
        this.query = new SqlQueryDefinition("getAllProcessInstances", this.dataSourceJNDIname, QueryDefinition.Target.FILTERED_PROCESS);
        this.query.setExpression("select * from processinstancelog");
        this.queryService.registerQuery(this.query);
        List queries = this.queryService.getQueries(new QueryContext());
        Assert.assertNotNull((Object)queries);
        Assert.assertEquals((long)1L, (long)queries.size());
        QueryDefinition registeredQuery = this.queryService.getQuery(this.query.getName());
        Assert.assertNotNull((Object)registeredQuery);
        Assert.assertEquals((Object)this.query.getName(), (Object)registeredQuery.getName());
        Assert.assertEquals((Object)this.query.getSource(), (Object)registeredQuery.getSource());
        Assert.assertEquals((Object)this.query.getExpression(), (Object)registeredQuery.getExpression());
        Assert.assertEquals((Object)this.query.getTarget(), (Object)registeredQuery.getTarget());
        Collection instances = (Collection)this.queryService.query(this.query.getName(), (QueryResultMapper)ProcessInstanceQueryMapper.get(), new QueryContext(), new QueryParam[0]);
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        instances = (Collection)this.queryService.query(this.query.getName(), (QueryResultMapper)ProcessInstanceQueryMapper.get(), new QueryContext(), new QueryParam[0]);
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.size());
        Assert.assertEquals((long)1L, (long)((ProcessInstanceDesc)instances.iterator().next()).getState().intValue());
        roles.clear();
        roles.add("employees");
        this.identityProvider.setRoles(roles);
        this.identityProvider.setName("anotherUser2");
        instances = (Collection)this.queryService.query(this.query.getName(), (QueryResultMapper)ProcessInstanceQueryMapper.get(), new QueryContext(), new QueryParam[0]);
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
    }

    @Test
    public void testGetFilteredTaskInstancesAsPotOwners() {
        ArrayList<String> roles = new ArrayList<String>();
        roles.add("managers");
        this.identityProvider.setRoles(Collections.emptyList());
        this.userGroupCallback.setUserGroups(this.identityProvider.getName(), roles);
        this.query = new SqlQueryDefinition("getMyTaskInstances", this.dataSourceJNDIname, QueryDefinition.Target.FILTERED_PO_TASK);
        this.query.setExpression(PO_TASK_QUERY);
        this.queryService.registerQuery(this.query);
        List queries = this.queryService.getQueries(new QueryContext());
        Assert.assertNotNull((Object)queries);
        Assert.assertEquals((long)1L, (long)queries.size());
        QueryDefinition registeredQuery = this.queryService.getQuery(this.query.getName());
        Assert.assertNotNull((Object)registeredQuery);
        Assert.assertEquals((Object)this.query.getName(), (Object)registeredQuery.getName());
        Assert.assertEquals((Object)this.query.getSource(), (Object)registeredQuery.getSource());
        Assert.assertEquals((Object)this.query.getExpression(), (Object)registeredQuery.getExpression());
        Assert.assertEquals((Object)this.query.getTarget(), (Object)registeredQuery.getTarget());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("approval_document", "initial content");
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument", params);
        Assert.assertNotNull((Object)this.processInstanceId);
        this.identityProvider.setName("salaboy");
        this.identityProvider.setRoles(roles);
        this.userGroupCallback.setUserGroups(this.identityProvider.getName(), roles);
        List taskInstanceLogs = (List)this.queryService.query(this.query.getName(), (QueryResultMapper)UserTaskInstanceQueryMapper.get(), new QueryContext(), new QueryParam[0]);
        Assert.assertNotNull((Object)taskInstanceLogs);
        Assert.assertEquals((long)1L, (long)taskInstanceLogs.size());
        List taskSummaries = (List)this.queryService.query(this.query.getName(), (QueryResultMapper)TaskSummaryQueryMapper.get(), new QueryContext(), new QueryParam[0]);
        Assert.assertNotNull((Object)taskSummaries);
        Assert.assertEquals((long)1L, (long)taskSummaries.size());
        roles.clear();
        roles.add("employees");
        this.identityProvider.setName("anotherUser");
        this.identityProvider.setRoles(Collections.emptyList());
        this.userGroupCallback.setUserGroups(this.identityProvider.getName(), roles);
        taskInstanceLogs = (List)this.queryService.query(this.query.getName(), (QueryResultMapper)UserTaskInstanceQueryMapper.get(), new QueryContext(), new QueryParam[0]);
        Assert.assertNotNull((Object)taskInstanceLogs);
        Assert.assertEquals((long)0L, (long)taskInstanceLogs.size());
        taskSummaries = (List)this.queryService.query(this.query.getName(), (QueryResultMapper)TaskSummaryQueryMapper.get(), new QueryContext(), new QueryParam[0]);
        Assert.assertNotNull((Object)taskSummaries);
        Assert.assertEquals((long)0L, (long)taskSummaries.size());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
    }

    @Test
    public void testGetFilteredTaskInstancesAsBA() {
        ArrayList<String> roles = new ArrayList<String>();
        roles.add("managers");
        this.identityProvider.setRoles(roles);
        this.userGroupCallback.setUserGroups(this.identityProvider.getName(), roles);
        this.query = new SqlQueryDefinition("getTaskInstancesAdmin", this.dataSourceJNDIname, QueryDefinition.Target.FILTERED_BA_TASK);
        this.query.setExpression("select ti.activationTime, ti.actualOwner, ti.createdBy, ti.createdOn, ti.deploymentId, ti.description, ti.dueDate, ti.name, ti.parentId, ti.priority, ti.processId, ti.processInstanceId, ti.processSessionId, ti.status, ti.taskId, ti.workItemId, oe.id from  AuditTaskImpl ti left join PeopleAssignments_BAs ba on ti.taskId = ba.task_id left join OrganizationalEntity oe on ba.entity_id = oe.id");
        this.queryService.registerQuery(this.query);
        List queries = this.queryService.getQueries(new QueryContext());
        Assert.assertNotNull((Object)queries);
        Assert.assertEquals((long)1L, (long)queries.size());
        QueryDefinition registeredQuery = this.queryService.getQuery(this.query.getName());
        Assert.assertNotNull((Object)registeredQuery);
        Assert.assertEquals((Object)this.query.getName(), (Object)registeredQuery.getName());
        Assert.assertEquals((Object)this.query.getSource(), (Object)registeredQuery.getSource());
        Assert.assertEquals((Object)this.query.getExpression(), (Object)registeredQuery.getExpression());
        Assert.assertEquals((Object)this.query.getTarget(), (Object)registeredQuery.getTarget());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("approval_document", "initial content");
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument", params);
        Assert.assertNotNull((Object)this.processInstanceId);
        List taskInstanceLogs = (List)this.queryService.query(this.query.getName(), (QueryResultMapper)UserTaskInstanceQueryMapper.get(), new QueryContext(), new QueryParam[0]);
        Assert.assertNotNull((Object)taskInstanceLogs);
        Assert.assertEquals((long)0L, (long)taskInstanceLogs.size());
        this.identityProvider.setName("Administrator");
        this.identityProvider.setRoles(roles);
        this.userGroupCallback.setUserGroups(this.identityProvider.getName(), Collections.emptyList());
        taskInstanceLogs = (List)this.queryService.query(this.query.getName(), (QueryResultMapper)UserTaskInstanceQueryMapper.get(), new QueryContext(), QueryParam.groupBy((String)"TASKID"));
        Assert.assertNotNull((Object)taskInstanceLogs);
        Assert.assertEquals((long)1L, (long)taskInstanceLogs.size());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
    }

    @Test
    public void testGetProcessInstancesWithOrderByClause() {
        this.query = new SqlQueryDefinition("getAllProcessInstances", this.dataSourceJNDIname);
        this.query.setExpression("select * from processinstancelog");
        this.queryService.registerQuery(this.query);
        List queries = this.queryService.getQueries(new QueryContext());
        Assert.assertNotNull((Object)queries);
        Assert.assertEquals((long)1L, (long)queries.size());
        QueryDefinition registeredQuery = (QueryDefinition)queries.get(0);
        Assert.assertNotNull((Object)registeredQuery);
        Assert.assertEquals((Object)this.query.getName(), (Object)registeredQuery.getName());
        Assert.assertEquals((Object)this.query.getSource(), (Object)registeredQuery.getSource());
        Assert.assertEquals((Object)this.query.getExpression(), (Object)registeredQuery.getExpression());
        Assert.assertEquals((Object)this.query.getTarget(), (Object)registeredQuery.getTarget());
        registeredQuery = this.queryService.getQuery(this.query.getName());
        Assert.assertNotNull((Object)registeredQuery);
        Assert.assertEquals((Object)this.query.getName(), (Object)registeredQuery.getName());
        Assert.assertEquals((Object)this.query.getSource(), (Object)registeredQuery.getSource());
        Assert.assertEquals((Object)this.query.getExpression(), (Object)registeredQuery.getExpression());
        Assert.assertEquals((Object)this.query.getTarget(), (Object)registeredQuery.getTarget());
        List instances = (List)this.queryService.query(this.query.getName(), (QueryResultMapper)ProcessInstanceQueryMapper.get(), (QueryContext)new AdvancedQueryContext(), new QueryParam[0]);
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        Long processInstanceId2 = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)processInstanceId2);
        Long processInstanceId3 = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jboss.qa.bpms.HumanTask");
        Assert.assertNotNull((Object)processInstanceId3);
        String orderByClause = "processId asc, processInstanceId desc";
        instances = (List)this.queryService.query(this.query.getName(), (QueryResultMapper)ProcessInstanceQueryMapper.get(), (QueryContext)new AdvancedQueryContext(orderByClause), new QueryParam[0]);
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)3L, (long)instances.size());
        Assert.assertTrue((String)"Testing ORDER BY clause with descending sort order on processInstanceId failed", (((ProcessInstanceDesc)instances.get(2)).getId() < ((ProcessInstanceDesc)instances.get(1)).getId() ? 1 : 0) != 0);
        this.processService.abortProcessInstance(processInstanceId2);
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
    }

    @Test
    public void testRegisterInvalidQuery() {
        this.query = new SqlQueryDefinition("getAllProcessInstances", this.dataSourceJNDIname);
        this.query.setExpression("this is an invalid query");
        try {
            this.queryService.registerQuery(this.query);
            Assert.fail((String)"Should fail as the query is invalid");
        }
        catch (Exception exception) {
            // empty catch block
        }
        List queries = this.queryService.getQueries(new QueryContext());
        Assert.assertNotNull((Object)queries);
        Assert.assertEquals((long)0L, (long)queries.size());
    }

    @Test
    public void testGetProcessInstancesGroupWithInterval() {
        this.query = new SqlQueryDefinition("getAllProcessInstances", this.dataSourceJNDIname);
        this.query.setExpression("select * from processinstancelog");
        this.queryService.registerQuery(this.query);
        List queries = this.queryService.getQueries(new QueryContext());
        Assert.assertNotNull((Object)queries);
        Assert.assertEquals((long)1L, (long)queries.size());
        QueryParam[] parameters = QueryParam.getBuilder().append(QueryParam.groupBy((String)"START_DATE", (String)"DAY", (int)30)).get();
        Collection instances = (Collection)this.queryService.query(this.query.getName(), (QueryResultMapper)RawListQueryMapper.get(), new QueryContext(), parameters);
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        long processInstanceId2 = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jboss.qa.bpms.HumanTask");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String expectedDate = sdf.format(new Date());
        instances = (Collection)this.queryService.query(this.query.getName(), (QueryResultMapper)RawListQueryMapper.get(), new QueryContext(), parameters);
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.size());
        List result = (List)instances.iterator().next();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)expectedDate, result.get(0));
        this.processService.abortProcessInstance(Long.valueOf(processInstanceId2));
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
    }

    @Test
    public void testGetProcessInstancesGroupWithoutInterval() {
        this.query = new SqlQueryDefinition("getAllProcessInstances", this.dataSourceJNDIname);
        this.query.setExpression("select * from processinstancelog");
        this.queryService.registerQuery(this.query);
        List queries = this.queryService.getQueries(new QueryContext());
        Assert.assertNotNull((Object)queries);
        Assert.assertEquals((long)1L, (long)queries.size());
        QueryParam[] parameters = QueryParam.getBuilder().append(QueryParam.groupBy((String)"START_DATE")).get();
        Collection instances = (Collection)this.queryService.query(this.query.getName(), (QueryResultMapper)RawListQueryMapper.get(), new QueryContext(), parameters);
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        long processInstanceId2 = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jboss.qa.bpms.HumanTask");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
        String expectedDate = sdf.format(new Date());
        instances = (Collection)this.queryService.query(this.query.getName(), (QueryResultMapper)RawListQueryMapper.get(), new QueryContext(), parameters);
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.size());
        List result = (List)instances.iterator().next();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)expectedDate, result.get(0));
        this.processService.abortProcessInstance(Long.valueOf(processInstanceId2));
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
    }

    protected void setFieldValue(Object instance, String fieldName, Object value) {
        try {
            Field f = instance.getClass().getDeclaredField(fieldName);
            f.setAccessible(true);
            f.set(instance, value);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

