/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.test;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.appformer.maven.support.AFReleaseId;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.kie.services.test.KModuleDeploymentServiceTest;
import org.jbpm.kie.test.util.AbstractKieServicesBaseTest;
import org.jbpm.kie.test.util.CountDownListenerFactory;
import org.jbpm.runtime.manager.impl.deploy.DeploymentDescriptorImpl;
import org.jbpm.services.api.ProcessInstanceNotFoundException;
import org.jbpm.services.api.model.DeploymentUnit;
import org.jbpm.services.api.model.ProcessInstanceDesc;
import org.jbpm.services.api.model.UserTaskInstanceDesc;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.query.QueryContext;
import org.kie.api.task.model.Status;
import org.kie.internal.query.QueryFilter;
import org.kie.internal.runtime.conf.ObjectModel;
import org.kie.scanner.KieMavenRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuntimeDataServiceImplSecurityTest
extends AbstractKieServicesBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(KModuleDeploymentServiceTest.class);
    private List<DeploymentUnit> units = new ArrayList<DeploymentUnit>();
    protected String correctUser = "testUser";
    protected String wrongUser = "wrongUser";
    private Long processInstanceId = null;
    private KModuleDeploymentUnit deploymentUnit = null;

    @Before
    public void prepare() {
        this.configureServices();
        logger.debug("Preparing kjar");
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.jbpm.test", "test-module", "1.0.0");
        ArrayList<String> processes = new ArrayList<String>();
        processes.add("repo/processes/general/EmptyHumanTask.bpmn");
        processes.add("repo/processes/general/humanTask.bpmn");
        processes.add("repo/processes/general/BPMN2-UserTask.bpmn2");
        processes.add("repo/processes/general/timer-process.bpmn2");
        DeploymentDescriptorImpl customDescriptor = new DeploymentDescriptorImpl("org.jbpm.domain");
        customDescriptor.getBuilder().addEventListener(new ObjectModel("mvel", "org.jbpm.kie.test.util.CountDownListenerFactory.get(\"securityTest\", \"timer\", 1)", new Object[0])).addRequiredRole("view:managers").addRequiredRole("execute:employees");
        HashMap<String, String> resources = new HashMap<String, String>();
        resources.put("src/main/resources/META-INF/kie-deployment-descriptor.xml", customDescriptor.toXml());
        InternalKieModule kJar1 = this.createKieJar(ks, releaseId, processes, resources);
        File pom = new File("target/kmodule", "pom.xml");
        pom.getParentFile().mkdir();
        try {
            FileOutputStream fs = new FileOutputStream(pom);
            fs.write(this.getPom(releaseId, new ReleaseId[0]).getBytes());
            fs.close();
        }
        catch (Exception fs) {
            // empty catch block
        }
        KieMavenRepository repository = KieMavenRepository.getKieMavenRepository();
        repository.deployArtifact((AFReleaseId)releaseId, kJar1, pom);
        Assert.assertNotNull((Object)this.deploymentService);
        this.deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)this.deploymentUnit);
        this.units.add((DeploymentUnit)this.deploymentUnit);
        Assert.assertNotNull((Object)this.processService);
        this.identityProvider.setRoles(Arrays.asList("employees"));
    }

    @After
    public void cleanup() {
        if (this.processInstanceId != null) {
            try {
                this.processService.abortProcessInstance(this.processInstanceId);
                ProcessInstance pi = this.processService.getProcessInstance(this.processInstanceId);
                Assert.assertNull((Object)pi);
            }
            catch (ProcessInstanceNotFoundException processInstanceNotFoundException) {
                // empty catch block
            }
        }
        RuntimeDataServiceImplSecurityTest.cleanupSingletonSessionId();
        if (this.units != null && !this.units.isEmpty()) {
            for (DeploymentUnit unit : this.units) {
                try {
                    this.deploymentService.undeploy(unit);
                }
                catch (Exception exception) {}
            }
            this.units.clear();
        }
        this.close();
        CountDownListenerFactory.clear();
    }

    @Test
    public void testGetProcessInstances() {
        ArrayList<String> roles = new ArrayList<String>();
        roles.add("managers");
        roles.add("employees");
        this.identityProvider.setRoles(roles);
        Collection instances = this.runtimeDataService.getProcessInstances(new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        instances = this.runtimeDataService.getProcessInstances(new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.size());
        Assert.assertEquals((long)1L, (long)((ProcessInstanceDesc)instances.iterator().next()).getState().intValue());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
        instances = this.runtimeDataService.getProcessInstances(new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.size());
        Assert.assertEquals((long)3L, (long)((ProcessInstanceDesc)instances.iterator().next()).getState().intValue());
    }

    @Test
    public void testGetProcessInstancesByState() {
        ArrayList<String> roles = new ArrayList<String>();
        roles.add("managers");
        roles.add("employees");
        this.identityProvider.setRoles(roles);
        Collection instances = this.runtimeDataService.getProcessInstances(new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        ArrayList<Integer> states = new ArrayList<Integer>();
        states.add(3);
        instances = this.runtimeDataService.getProcessInstances(states, null, new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
        instances = this.runtimeDataService.getProcessInstances(states, null, new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.size());
        Assert.assertEquals((long)3L, (long)((ProcessInstanceDesc)instances.iterator().next()).getState().intValue());
    }

    @Test
    public void testGetProcessInstancesByStateAndInitiator() {
        ArrayList<String> roles = new ArrayList<String>();
        roles.add("managers");
        roles.add("employees");
        this.identityProvider.setRoles(roles);
        Collection instances = this.runtimeDataService.getProcessInstances(new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        ArrayList<Integer> states = new ArrayList<Integer>();
        states.add(1);
        instances = this.runtimeDataService.getProcessInstances(states, this.correctUser, new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.size());
        Assert.assertEquals((long)1L, (long)((ProcessInstanceDesc)instances.iterator().next()).getState().intValue());
        instances = this.runtimeDataService.getProcessInstances(states, this.wrongUser, new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
        instances = this.runtimeDataService.getProcessInstances(states, this.correctUser, new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
    }

    @Test
    public void testGetProcessInstancesByDeploymentIdAndState() {
        ArrayList<String> roles = new ArrayList<String>();
        roles.add("managers");
        roles.add("employees");
        this.identityProvider.setRoles(roles);
        Collection instances = this.runtimeDataService.getProcessInstances(new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        ArrayList<Integer> states = new ArrayList<Integer>();
        states.add(3);
        instances = this.runtimeDataService.getProcessInstancesByDeploymentId(this.deploymentUnit.getIdentifier(), states, new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
        instances = this.runtimeDataService.getProcessInstancesByDeploymentId(this.deploymentUnit.getIdentifier(), states, new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.size());
        Assert.assertEquals((long)3L, (long)((ProcessInstanceDesc)instances.iterator().next()).getState().intValue());
    }

    @Test
    public void testGetProcessInstancesByProcessId() {
        ArrayList<String> roles = new ArrayList<String>();
        roles.add("managers");
        roles.add("employees");
        this.identityProvider.setRoles(roles);
        Collection instances = this.runtimeDataService.getProcessInstances(new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        instances = this.runtimeDataService.getProcessInstancesByProcessDefinition("org.jbpm.writedocument", new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.size());
        ProcessInstanceDesc instance = (ProcessInstanceDesc)instances.iterator().next();
        Assert.assertEquals((long)1L, (long)instance.getState().intValue());
        Assert.assertEquals((Object)"org.jbpm.writedocument", (Object)instance.getProcessId());
        List taskSummaries = this.runtimeDataService.getTasksAssignedAsPotentialOwner("salaboy", new QueryFilter(0, 10));
        Assert.assertNotNull((Object)taskSummaries);
        Assert.assertEquals((long)1L, (long)taskSummaries.size());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
        instances = this.runtimeDataService.getProcessInstancesByProcessDefinition("org.jbpm.writedocument", new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.size());
        instance = (ProcessInstanceDesc)instances.iterator().next();
        Assert.assertEquals((long)3L, (long)instance.getState().intValue());
        Assert.assertEquals((Object)"org.jbpm.writedocument", (Object)instance.getProcessId());
    }

    @Test
    public void testGetProcessInstanceById() {
        ArrayList<String> roles = new ArrayList<String>();
        roles.add("managers");
        roles.add("employees");
        this.identityProvider.setRoles(roles);
        Collection instances = this.runtimeDataService.getProcessInstances(new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        ProcessInstanceDesc instance = this.runtimeDataService.getProcessInstanceById(this.processInstanceId.longValue());
        Assert.assertNotNull((Object)instance);
        Assert.assertEquals((long)1L, (long)instance.getState().intValue());
        Assert.assertEquals((Object)"org.jbpm.writedocument", (Object)instance.getProcessId());
        List tasks = instance.getActiveTasks();
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        UserTaskInstanceDesc activeTask = (UserTaskInstanceDesc)tasks.get(0);
        Assert.assertNotNull((Object)activeTask);
        Assert.assertEquals((Object)Status.Reserved.name(), (Object)activeTask.getStatus());
        Assert.assertEquals((Object)instance.getId(), (Object)activeTask.getProcessInstanceId());
        Assert.assertEquals((Object)instance.getProcessId(), (Object)activeTask.getProcessId());
        Assert.assertEquals((Object)"Write a Document", (Object)activeTask.getName());
        Assert.assertEquals((Object)"salaboy", (Object)activeTask.getActualOwner());
        Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)activeTask.getDeploymentId());
        this.processService.abortProcessInstance(this.processInstanceId);
        instance = this.runtimeDataService.getProcessInstanceById(this.processInstanceId.longValue());
        this.processInstanceId = null;
        Assert.assertNotNull((Object)instance);
        Assert.assertEquals((long)3L, (long)instance.getState().intValue());
        Assert.assertEquals((Object)"org.jbpm.writedocument", (Object)instance.getProcessId());
    }

    @Test
    public void testGetProcessInstancesByProcessIdAndState() {
        ArrayList<String> roles = new ArrayList<String>();
        roles.add("managers");
        roles.add("employees");
        this.identityProvider.setRoles(roles);
        Collection instances = this.runtimeDataService.getProcessInstances(new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        ArrayList<Integer> states = new ArrayList<Integer>();
        states.add(3);
        instances = this.runtimeDataService.getProcessInstancesByProcessId(states, "org.jbpm.writedocument", null, new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
        instances = this.runtimeDataService.getProcessInstancesByProcessId(states, "org.jbpm.writedocument", null, new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.size());
        Assert.assertEquals((long)3L, (long)((ProcessInstanceDesc)instances.iterator().next()).getState().intValue());
    }

    @Test
    public void testGetProcessInstancesByPartialProcessIdAndState() {
        ArrayList<String> roles = new ArrayList<String>();
        roles.add("managers");
        roles.add("employees");
        this.identityProvider.setRoles(roles);
        Collection instances = this.runtimeDataService.getProcessInstances(new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        ArrayList<Integer> states = new ArrayList<Integer>();
        states.add(3);
        instances = this.runtimeDataService.getProcessInstancesByProcessId(states, "org.jbpm%", null, new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
        instances = this.runtimeDataService.getProcessInstancesByProcessId(states, "org.jbpm%", null, new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.size());
        Assert.assertEquals((long)3L, (long)((ProcessInstanceDesc)instances.iterator().next()).getState().intValue());
    }

    @Test
    public void testGetProcessInstancesByProcessIdAndStateAndInitiator() {
        ArrayList<String> roles = new ArrayList<String>();
        roles.add("managers");
        roles.add("employees");
        this.identityProvider.setRoles(roles);
        Collection instances = this.runtimeDataService.getProcessInstances(new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        ArrayList<Integer> states = new ArrayList<Integer>();
        states.add(1);
        instances = this.runtimeDataService.getProcessInstancesByProcessId(states, "org.jbpm.writedocument", this.correctUser, new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.size());
        Assert.assertEquals((long)1L, (long)((ProcessInstanceDesc)instances.iterator().next()).getState().intValue());
        instances = this.runtimeDataService.getProcessInstancesByProcessId(states, "org.jbpm.writedocument", this.wrongUser, new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
        instances = this.runtimeDataService.getProcessInstancesByProcessId(states, "org.jbpm.writedocument", this.correctUser, new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
    }

    @Test
    public void testGetProcessInstancesNoAccess() {
        Collection instances = this.runtimeDataService.getProcessInstances(new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        ArrayList<String> roles = new ArrayList<String>();
        roles.add("managers");
        roles.add("employees");
        this.identityProvider.setRoles(roles);
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        instances = this.runtimeDataService.getProcessInstances(new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
        instances = this.runtimeDataService.getProcessInstances(new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
    }

    @Test
    public void testGetProcessInstancesByStateNoAccess() {
        Collection instances = this.runtimeDataService.getProcessInstances(new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        ArrayList<String> roles = new ArrayList<String>();
        roles.add("managers");
        roles.add("employees");
        this.identityProvider.setRoles(roles);
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        ArrayList<Integer> states = new ArrayList<Integer>();
        states.add(3);
        instances = this.runtimeDataService.getProcessInstances(states, null, new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
        instances = this.runtimeDataService.getProcessInstances(states, null, new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
    }

    @Test
    public void testGetProcessInstancesByStateAndInitiatorNoAccess() {
        Collection instances = this.runtimeDataService.getProcessInstances(new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        ArrayList<String> roles = new ArrayList<String>();
        roles.add("managers");
        roles.add("employees");
        this.identityProvider.setRoles(roles);
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        ArrayList<Integer> states = new ArrayList<Integer>();
        states.add(1);
        instances = this.runtimeDataService.getProcessInstances(states, this.correctUser, new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        instances = this.runtimeDataService.getProcessInstances(states, this.wrongUser, new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
        instances = this.runtimeDataService.getProcessInstances(states, this.correctUser, new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
    }

    @Test
    public void testGetProcessInstancesByDeploymentIdAndStateNoAccess() {
        Collection instances = this.runtimeDataService.getProcessInstances(new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        ArrayList<Integer> states = new ArrayList<Integer>();
        states.add(3);
        instances = this.runtimeDataService.getProcessInstancesByDeploymentId(this.deploymentUnit.getIdentifier(), states, new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
        instances = this.runtimeDataService.getProcessInstancesByDeploymentId(this.deploymentUnit.getIdentifier(), states, new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
    }

    @Test
    public void testGetProcessInstancesByProcessIdNoAccess() {
        Collection instances = this.runtimeDataService.getProcessInstances(new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        instances = this.runtimeDataService.getProcessInstancesByProcessDefinition("org.jbpm.writedocument", new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
        instances = this.runtimeDataService.getProcessInstancesByProcessDefinition("org.jbpm.writedocument", new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
    }

    @Test
    public void testGetProcessInstanceByIdNoAccess() {
        Collection instances = this.runtimeDataService.getProcessInstances(new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        ProcessInstanceDesc instance = this.runtimeDataService.getProcessInstanceById(this.processInstanceId.longValue());
        Assert.assertNotNull((Object)instance);
        this.processService.abortProcessInstance(this.processInstanceId);
        instance = this.runtimeDataService.getProcessInstanceById(this.processInstanceId.longValue());
        this.processInstanceId = null;
        Assert.assertNotNull((Object)instance);
    }

    @Test
    public void testGetProcessInstancesByProcessIdAndStateNoAccess() {
        Collection instances = this.runtimeDataService.getProcessInstances(new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        ArrayList<Integer> states = new ArrayList<Integer>();
        states.add(3);
        instances = this.runtimeDataService.getProcessInstancesByProcessId(states, "org.jbpm.writedocument", null, new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
        instances = this.runtimeDataService.getProcessInstancesByProcessId(states, "org.jbpm.writedocument", null, new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
    }

    @Test
    public void testGetProcessInstancesByPartialProcessIdAndStateNoAccess() {
        Collection instances = this.runtimeDataService.getProcessInstances(new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        ArrayList<Integer> states = new ArrayList<Integer>();
        states.add(3);
        instances = this.runtimeDataService.getProcessInstancesByProcessId(states, "org.jbpm%", null, new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
        instances = this.runtimeDataService.getProcessInstancesByProcessId(states, "org.jbpm%", null, new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
    }

    @Test
    public void testGetProcessInstancesByProcessIdAndStateAndInitiatorNoAccess() {
        Collection instances = this.runtimeDataService.getProcessInstances(new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        ArrayList<Integer> states = new ArrayList<Integer>();
        states.add(1);
        instances = this.runtimeDataService.getProcessInstancesByProcessId(states, "org.jbpm.writedocument", this.correctUser, new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        instances = this.runtimeDataService.getProcessInstancesByProcessId(states, "org.jbpm.writedocument", this.wrongUser, new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
        instances = this.runtimeDataService.getProcessInstancesByProcessId(states, "org.jbpm.writedocument", this.correctUser, new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
    }

    @Test(timeout=10000L)
    public void testGetProcessInstancesWithTimer() throws Exception {
        ArrayList<String> roles = new ArrayList<String>();
        roles.add("managers");
        roles.add("employees");
        this.identityProvider.setRoles(roles);
        Collection instances = this.runtimeDataService.getProcessInstances(new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "timerprocess");
        Assert.assertNotNull((Object)this.processInstanceId);
        instances = this.runtimeDataService.getProcessInstances(new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.size());
        Assert.assertEquals((long)1L, (long)((ProcessInstanceDesc)instances.iterator().next()).getState().intValue());
        this.identityProvider.setRoles(new ArrayList<String>());
        CountDownListenerFactory.getExisting("securityTest").waitTillCompleted();
        this.identityProvider.setRoles(roles);
        instances = this.runtimeDataService.getProcessInstances(new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.size());
        Assert.assertEquals((long)2L, (long)((ProcessInstanceDesc)instances.iterator().next()).getState().intValue());
    }
}

