/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.test;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.appformer.maven.support.AFReleaseId;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.kie.services.impl.RuntimeDataServiceImpl;
import org.jbpm.kie.services.test.objects.TestUserGroupCallbackImpl;
import org.jbpm.kie.test.util.AbstractKieServicesBaseTest;
import org.jbpm.services.api.ProcessInstanceNotFoundException;
import org.jbpm.services.api.model.DeploymentUnit;
import org.jbpm.services.api.model.ProcessInstanceDesc;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.query.QueryContext;
import org.kie.api.task.model.Status;
import org.kie.internal.query.QueryFilter;
import org.kie.internal.task.api.AuditTask;
import org.kie.scanner.KieMavenRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuntimeDataServiceImplTaskLookupTest
extends AbstractKieServicesBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(RuntimeDataServiceImplTaskLookupTest.class);
    private List<DeploymentUnit> units = new ArrayList<DeploymentUnit>();
    private Long processInstanceId = null;
    private KModuleDeploymentUnit deploymentUnit = null;
    private static final List<Status> readyStatusOnly = Arrays.asList(Status.Ready);
    private static final List<Status> suspendedStatusOnly = Arrays.asList(Status.Suspended);
    private static final List<String> fakeGroupIds = Arrays.asList("groupone", "grouptwo", "groupthree");

    @Before
    public void prepare() {
        System.setProperty("org.jbpm.ht.callback", "custom");
        System.setProperty("org.jbpm.ht.custom.callback", "org.jbpm.kie.services.test.objects.TestUserGroupCallbackImpl");
        this.configureServices();
        logger.debug("Preparing kjar");
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.jbpm.test", "test-module", "1.0.0");
        ArrayList<String> processes = new ArrayList<String>();
        processes.add("repo/processes/general/BPMN2-UserTasksAssignedToGroup.bpmn2");
        InternalKieModule kJar1 = this.createKieJar(ks, releaseId, processes);
        File pom = new File("target/kmodule", "pom.xml");
        pom.getParentFile().mkdir();
        try {
            FileOutputStream fs = new FileOutputStream(pom);
            fs.write(this.getPom(releaseId, new ReleaseId[0]).getBytes());
            fs.close();
        }
        catch (Exception fs) {
            // empty catch block
        }
        KieMavenRepository repository = KieMavenRepository.getKieMavenRepository();
        repository.deployArtifact((AFReleaseId)releaseId, kJar1, pom);
        Assert.assertNotNull((Object)this.deploymentService);
        this.deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)this.deploymentUnit);
        this.units.add((DeploymentUnit)this.deploymentUnit);
        Assert.assertNotNull((Object)this.processService);
    }

    @After
    public void cleanup() {
        System.clearProperty("org.jbpm.ht.callback");
        System.clearProperty("org.jbpm.ht.custom.callback");
        if (this.processInstanceId != null) {
            try {
                this.processService.abortProcessInstance(this.processInstanceId);
                ProcessInstance pi = this.processService.getProcessInstance(this.processInstanceId);
                Assert.assertNull((Object)pi);
            }
            catch (ProcessInstanceNotFoundException processInstanceNotFoundException) {
                // empty catch block
            }
        }
        RuntimeDataServiceImplTaskLookupTest.cleanupSingletonSessionId();
        if (this.units != null && !this.units.isEmpty()) {
            for (DeploymentUnit unit : this.units) {
                try {
                    this.deploymentService.undeploy(unit);
                }
                catch (Exception exception) {}
            }
            this.units.clear();
        }
        this.close();
    }

    @Test
    public void testGetTasksAssignedAsPotentialOwner() {
        this.asssertProcessInstance();
        List taskSummaries = this.runtimeDataService.getTasksAssignedAsPotentialOwner("maciej", new QueryFilter());
        Assert.assertNotNull((Object)taskSummaries);
        Assert.assertEquals((long)1L, (long)taskSummaries.size());
        taskSummaries = this.runtimeDataService.getTasksAssignedAsPotentialOwner("kris", new QueryFilter());
        Assert.assertNotNull((Object)taskSummaries);
        Assert.assertEquals((long)2L, (long)taskSummaries.size());
        taskSummaries = this.runtimeDataService.getTasksAssignedAsPotentialOwner("tihomir", new QueryFilter());
        Assert.assertNotNull((Object)taskSummaries);
        Assert.assertEquals((long)0L, (long)taskSummaries.size());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
    }

    @Test
    public void testGetTasksAssignedAsPotentialOwnerWithGroups() {
        this.asssertProcessInstance();
        List taskSummaries = this.runtimeDataService.getTasksAssignedAsPotentialOwner("maciej", fakeGroupIds, new QueryFilter());
        Assert.assertNotNull((Object)taskSummaries);
        Assert.assertEquals((long)1L, (long)taskSummaries.size());
        taskSummaries = this.runtimeDataService.getTasksAssignedAsPotentialOwner("kris", fakeGroupIds, new QueryFilter());
        Assert.assertNotNull((Object)taskSummaries);
        Assert.assertEquals((long)2L, (long)taskSummaries.size());
        taskSummaries = this.runtimeDataService.getTasksAssignedAsPotentialOwner("tihomir", fakeGroupIds, new QueryFilter());
        Assert.assertNotNull((Object)taskSummaries);
        Assert.assertEquals((long)0L, (long)taskSummaries.size());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
    }

    @Test
    public void testGetTasksAssignedAsPotentialOwnerWithGroupsAndWrongUserId() {
        this.asssertProcessInstance();
        List<String> managerList = Arrays.asList("managers");
        List taskSummaries = this.runtimeDataService.getTasksAssignedAsPotentialOwner("mcivantos", fakeGroupIds, new QueryFilter());
        Assert.assertNotNull((Object)taskSummaries);
        Assert.assertEquals((long)0L, (long)taskSummaries.size());
        taskSummaries = this.runtimeDataService.getTasksAssignedAsPotentialOwner("mcivantos", managerList, new QueryFilter());
        Assert.assertNotNull((Object)taskSummaries);
        Assert.assertEquals((long)1L, (long)taskSummaries.size());
        List<String> groupsList = Arrays.asList("managers", "admins");
        taskSummaries = this.runtimeDataService.getTasksAssignedAsPotentialOwner("mcivantos", groupsList, new QueryFilter());
        Assert.assertNotNull((Object)taskSummaries);
        Assert.assertEquals((long)2L, (long)taskSummaries.size());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
    }

    @Test
    public void testGetTasksAssignedAsPotentialOwnerWithGroupsAndStatus() {
        this.asssertProcessInstance();
        List taskSummaries = this.runtimeDataService.getTasksAssignedAsPotentialOwner("maciej", null, readyStatusOnly, new QueryFilter());
        Assert.assertNotNull((Object)taskSummaries);
        Assert.assertEquals((long)1L, (long)taskSummaries.size());
        taskSummaries = this.runtimeDataService.getTasksAssignedAsPotentialOwner("kris", null, readyStatusOnly, new QueryFilter());
        Assert.assertNotNull((Object)taskSummaries);
        Assert.assertEquals((long)2L, (long)taskSummaries.size());
        taskSummaries = this.runtimeDataService.getTasksAssignedAsPotentialOwner("tihomir", null, readyStatusOnly, new QueryFilter());
        Assert.assertNotNull((Object)taskSummaries);
        Assert.assertEquals((long)0L, (long)taskSummaries.size());
        taskSummaries = this.runtimeDataService.getTasksAssignedAsPotentialOwner("maciej", fakeGroupIds, readyStatusOnly, new QueryFilter());
        Assert.assertNotNull((Object)taskSummaries);
        Assert.assertEquals((long)1L, (long)taskSummaries.size());
        taskSummaries = this.runtimeDataService.getTasksAssignedAsPotentialOwner("maciej", null, suspendedStatusOnly, new QueryFilter());
        Assert.assertNotNull((Object)taskSummaries);
        Assert.assertEquals((long)0L, (long)taskSummaries.size());
        taskSummaries = this.runtimeDataService.getTasksAssignedAsPotentialOwner("maciej", fakeGroupIds, suspendedStatusOnly, new QueryFilter());
        Assert.assertNotNull((Object)taskSummaries);
        Assert.assertEquals((long)0L, (long)taskSummaries.size());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
    }

    @Test
    public void testGetTasksAssignedAsPotentialOwnerByStatus() {
        this.asssertProcessInstance();
        List taskSummaries = this.runtimeDataService.getTasksAssignedAsPotentialOwnerByStatus("maciej", readyStatusOnly, new QueryFilter());
        Assert.assertNotNull((Object)taskSummaries);
        Assert.assertEquals((long)1L, (long)taskSummaries.size());
        taskSummaries = this.runtimeDataService.getTasksAssignedAsPotentialOwnerByStatus("kris", readyStatusOnly, new QueryFilter());
        Assert.assertNotNull((Object)taskSummaries);
        Assert.assertEquals((long)2L, (long)taskSummaries.size());
        taskSummaries = this.runtimeDataService.getTasksAssignedAsPotentialOwnerByStatus("tihomir", readyStatusOnly, new QueryFilter());
        Assert.assertNotNull((Object)taskSummaries);
        Assert.assertEquals((long)0L, (long)taskSummaries.size());
        taskSummaries = this.runtimeDataService.getTasksAssignedAsPotentialOwnerByStatus("maciej", suspendedStatusOnly, new QueryFilter());
        Assert.assertNotNull((Object)taskSummaries);
        Assert.assertEquals((long)0L, (long)taskSummaries.size());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
    }

    @Test
    public void testGetAllGroupAuditTasks() {
        this.asssertProcessInstance();
        List auditTasks = this.runtimeDataService.getAllGroupAuditTask("maciej", new QueryFilter());
        Assert.assertNotNull((Object)auditTasks);
        Assert.assertEquals((long)1L, (long)auditTasks.size());
        Assert.assertEquals((Object)"AdminsTask", (Object)((AuditTask)auditTasks.get(0)).getName());
        auditTasks = this.runtimeDataService.getAllGroupAuditTask("kris", new QueryFilter());
        Assert.assertNotNull((Object)auditTasks);
        Assert.assertEquals((long)2L, (long)auditTasks.size());
        this.assertAuditTasksContain("AdminsTask", auditTasks);
        this.assertAuditTasksContain("ManagersTask", auditTasks);
        auditTasks = this.runtimeDataService.getAllGroupAuditTask("tihomir", new QueryFilter());
        Assert.assertNotNull((Object)auditTasks);
        Assert.assertEquals((long)0L, (long)auditTasks.size());
    }

    @Test
    public void testGetAllAdminAuditTask() {
        this.asssertProcessInstance();
        List auditTasks = this.runtimeDataService.getAllAdminAuditTask("maciej", new QueryFilter());
        Assert.assertNotNull((Object)auditTasks);
        Assert.assertEquals((long)0L, (long)auditTasks.size());
        auditTasks = this.runtimeDataService.getAllAdminAuditTask("kris", new QueryFilter());
        Assert.assertNotNull((Object)auditTasks);
        Assert.assertEquals((long)0L, (long)auditTasks.size());
        auditTasks = this.runtimeDataService.getAllAdminAuditTask("tihomir", new QueryFilter());
        Assert.assertNotNull((Object)auditTasks);
        Assert.assertEquals((long)0L, (long)auditTasks.size());
    }

    private void asssertProcessInstance() {
        Assert.assertTrue((boolean)(((RuntimeDataServiceImpl)this.runtimeDataService).getUserGroupCallback() instanceof TestUserGroupCallbackImpl));
        Collection instances = this.runtimeDataService.getProcessInstances(new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "UserTask");
        Assert.assertNotNull((Object)this.processInstanceId);
        instances = this.runtimeDataService.getProcessInstancesByProcessDefinition("UserTask", new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.size());
        ProcessInstanceDesc instance = (ProcessInstanceDesc)instances.iterator().next();
        Assert.assertEquals((long)1L, (long)instance.getState().intValue());
        Assert.assertEquals((Object)"UserTask", (Object)instance.getProcessId());
    }

    private void assertAuditTasksContain(String taskName, List<AuditTask> auditTasks) {
        for (AuditTask task : auditTasks) {
            if (!task.getName().equals(taskName)) continue;
            return;
        }
        Assert.fail((String)("Audit tasks do not contain: " + taskName));
    }
}

