/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.test.util;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import javax.persistence.EntityManagerFactory;
import org.dashbuilder.DataSetCore;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.jbpm.kie.services.impl.FormManagerService;
import org.jbpm.kie.services.impl.FormManagerServiceImpl;
import org.jbpm.kie.services.impl.KModuleDeploymentService;
import org.jbpm.kie.services.impl.ProcessServiceImpl;
import org.jbpm.kie.services.impl.RuntimeDataServiceImpl;
import org.jbpm.kie.services.impl.UserTaskServiceImpl;
import org.jbpm.kie.services.impl.bpmn2.BPMN2DataServiceImpl;
import org.jbpm.kie.services.impl.query.QueryServiceImpl;
import org.jbpm.kie.services.test.TestIdentityProvider;
import org.jbpm.kie.services.test.objects.TestUserGroupCallbackImpl;
import org.jbpm.process.instance.impl.util.LoggingPrintStream;
import org.jbpm.runtime.manager.impl.RuntimeManagerFactoryImpl;
import org.jbpm.runtime.manager.impl.deploy.DeploymentDescriptorImpl;
import org.jbpm.runtime.manager.impl.jpa.EntityManagerFactoryManager;
import org.jbpm.services.api.DefinitionService;
import org.jbpm.services.api.DeploymentEventListener;
import org.jbpm.services.api.DeploymentService;
import org.jbpm.services.api.ProcessService;
import org.jbpm.services.api.RuntimeDataService;
import org.jbpm.services.api.UserTaskService;
import org.jbpm.services.api.query.QueryService;
import org.jbpm.services.task.HumanTaskServiceFactory;
import org.jbpm.services.task.audit.TaskAuditServiceFactory;
import org.jbpm.shared.services.impl.TransactionalCommandService;
import org.jbpm.test.util.PoolingDataSource;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.builder.model.KieSessionModel;
import org.kie.api.conf.EqualityBehaviorOption;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.api.runtime.manager.RuntimeManagerFactory;
import org.kie.api.task.TaskService;
import org.kie.api.task.UserGroupCallback;
import org.kie.internal.identity.IdentityProvider;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.conf.DeploymentDescriptorBuilder;
import org.kie.internal.runtime.conf.ObjectModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractKieServicesBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(AbstractKieServicesBaseTest.class);
    protected static final String ARTIFACT_ID = "test-module";
    protected static final String GROUP_ID = "org.jbpm.test";
    protected static final String VERSION = "1.0.0";
    protected PoolingDataSource ds;
    protected EntityManagerFactory emf;
    protected DeploymentService deploymentService;
    protected DefinitionService bpmn2Service;
    protected RuntimeDataService runtimeDataService;
    protected ProcessService processService;
    protected UserTaskService userTaskService;
    protected QueryService queryService;
    protected TestIdentityProvider identityProvider;
    protected TestUserGroupCallbackImpl userGroupCallback;
    protected FormManagerService formManagerService;

    @BeforeClass
    public static void configure() {
        LoggingPrintStream.interceptSysOutSysErr();
    }

    @AfterClass
    public static void reset() {
        LoggingPrintStream.resetInterceptSysOutSysErr();
    }

    protected void close() {
        DataSetCore.set(null);
        if (this.emf != null) {
            this.emf.close();
        }
        EntityManagerFactoryManager.get().clear();
        this.closeDataSource();
    }

    protected void configureServices() {
        this.buildDatasource();
        this.emf = EntityManagerFactoryManager.get().getOrCreate("org.jbpm.domain");
        this.identityProvider = new TestIdentityProvider();
        this.userGroupCallback = new TestUserGroupCallbackImpl();
        this.formManagerService = new FormManagerServiceImpl();
        this.bpmn2Service = new BPMN2DataServiceImpl();
        this.queryService = new QueryServiceImpl();
        ((QueryServiceImpl)this.queryService).setIdentityProvider((IdentityProvider)this.identityProvider);
        ((QueryServiceImpl)this.queryService).setUserGroupCallback((UserGroupCallback)this.userGroupCallback);
        ((QueryServiceImpl)this.queryService).setCommandService(new TransactionalCommandService(this.emf));
        ((QueryServiceImpl)this.queryService).init();
        this.deploymentService = new KModuleDeploymentService();
        ((KModuleDeploymentService)this.deploymentService).setBpmn2Service(this.bpmn2Service);
        ((KModuleDeploymentService)this.deploymentService).setEmf(this.emf);
        ((KModuleDeploymentService)this.deploymentService).setIdentityProvider((IdentityProvider)this.identityProvider);
        ((KModuleDeploymentService)this.deploymentService).setManagerFactory((RuntimeManagerFactory)new RuntimeManagerFactoryImpl());
        ((KModuleDeploymentService)this.deploymentService).setFormManagerService(this.formManagerService);
        TaskService taskService = HumanTaskServiceFactory.newTaskServiceConfigurator().entityManagerFactory(this.emf).getTaskService();
        this.runtimeDataService = new RuntimeDataServiceImpl();
        ((RuntimeDataServiceImpl)this.runtimeDataService).setCommandService(new TransactionalCommandService(this.emf));
        ((RuntimeDataServiceImpl)this.runtimeDataService).setIdentityProvider((IdentityProvider)this.identityProvider);
        ((RuntimeDataServiceImpl)this.runtimeDataService).setTaskService(taskService);
        ((RuntimeDataServiceImpl)this.runtimeDataService).setTaskAuditService(TaskAuditServiceFactory.newTaskAuditServiceConfigurator().setTaskService(taskService).getTaskAuditService());
        ((KModuleDeploymentService)this.deploymentService).setRuntimeDataService(this.runtimeDataService);
        ((KModuleDeploymentService)this.deploymentService).addListener((DeploymentEventListener)((RuntimeDataServiceImpl)this.runtimeDataService));
        ((KModuleDeploymentService)this.deploymentService).addListener((DeploymentEventListener)((BPMN2DataServiceImpl)this.bpmn2Service));
        ((KModuleDeploymentService)this.deploymentService).addListener((DeploymentEventListener)((QueryServiceImpl)this.queryService));
        this.processService = new ProcessServiceImpl();
        ((ProcessServiceImpl)this.processService).setDataService(this.runtimeDataService);
        ((ProcessServiceImpl)this.processService).setDeploymentService(this.deploymentService);
        this.userTaskService = new UserTaskServiceImpl();
        ((UserTaskServiceImpl)this.userTaskService).setDataService(this.runtimeDataService);
        ((UserTaskServiceImpl)this.userTaskService).setDeploymentService(this.deploymentService);
    }

    protected String getPom(ReleaseId releaseId, ReleaseId ... dependencies) {
        String pom = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd\">\n  <modelVersion>4.0.0</modelVersion>\n\n  <groupId>" + releaseId.getGroupId() + "</groupId>\n  <artifactId>" + releaseId.getArtifactId() + "</artifactId>\n  <version>" + releaseId.getVersion() + "</version>\n\n";
        if (dependencies != null && dependencies.length > 0) {
            pom = pom + "<dependencies>\n";
            for (ReleaseId dep : dependencies) {
                pom = pom + "<dependency>\n";
                pom = pom + "  <groupId>" + dep.getGroupId() + "</groupId>\n";
                pom = pom + "  <artifactId>" + dep.getArtifactId() + "</artifactId>\n";
                pom = pom + "  <version>" + dep.getVersion() + "</version>\n";
                pom = pom + "</dependency>\n";
            }
            pom = pom + "</dependencies>\n";
        }
        pom = pom + "</project>";
        return pom;
    }

    protected InternalKieModule createKieJar(KieServices ks, ReleaseId releaseId, List<String> resources) {
        return this.createKieJar(ks, releaseId, resources, null);
    }

    protected InternalKieModule createKieJar(KieServices ks, ReleaseId releaseId, List<String> resources, Map<String, String> extraResources) {
        KieFileSystem kfs = this.createKieFileSystemWithKProject(ks);
        kfs.writePomXML(this.getPom(releaseId, new ReleaseId[0]));
        if (this.createDescriptor()) {
            DeploymentDescriptorImpl customDescriptor = new DeploymentDescriptorImpl("org.jbpm.domain");
            DeploymentDescriptorBuilder deploymentDescriptorBuilder = customDescriptor.getBuilder();
            for (ObjectModel listener : this.getProcessListeners()) {
                deploymentDescriptorBuilder.addEventListener(listener);
            }
            for (ObjectModel listener : this.getTaskListeners()) {
                deploymentDescriptorBuilder.addTaskEventListener(listener);
            }
            if (extraResources == null) {
                extraResources = new HashMap<String, String>();
            }
            extraResources.put("src/main/resources/META-INF/kie-deployment-descriptor.xml", customDescriptor.toXml());
        }
        for (String string : resources) {
            kfs.write("src/main/resources/KBase-test/" + string, ResourceFactory.newClassPathResource((String)string));
        }
        if (extraResources != null) {
            for (Map.Entry entry : extraResources.entrySet()) {
                kfs.write((String)entry.getKey(), ResourceFactory.newByteArrayResource((byte[])((String)entry.getValue()).getBytes()));
            }
        }
        kfs.write("src/main/resources/forms/DefaultProcess.ftl", ResourceFactory.newClassPathResource((String)"repo/globals/forms/DefaultProcess.ftl"));
        kfs.write("src/main/resources/forms/DefaultProcess.form", ResourceFactory.newClassPathResource((String)"repo/globals/forms/DefaultProcess.form"));
        kfs.write("src/main/resources/forms/DefaultProcess.frm", ResourceFactory.newClassPathResource((String)"repo/globals/forms/DefaultProcess.frm"));
        KieBuilder kieBuilder = ks.newKieBuilder(kfs);
        if (!kieBuilder.buildAll().getResults().getMessages().isEmpty()) {
            for (Message message : kieBuilder.buildAll().getResults().getMessages()) {
                logger.error("Error Message: ({}) {}", (Object)message.getPath(), (Object)message.getText());
            }
            throw new RuntimeException("There are errors builing the package, please check your knowledge assets!");
        }
        return (InternalKieModule)kieBuilder.getKieModule();
    }

    protected KieFileSystem createKieFileSystemWithKProject(KieServices ks) {
        KieModuleModel kproj = ks.newKieModuleModel();
        KieBaseModel kieBaseModel1 = kproj.newKieBaseModel("KBase-test").setDefault(true).addPackage("*").setEqualsBehavior(EqualityBehaviorOption.EQUALITY).setEventProcessingMode(EventProcessingOption.STREAM);
        kieBaseModel1.newKieSessionModel("ksession-test").setDefault(true).setType(KieSessionModel.KieSessionType.STATEFUL).setClockType(ClockTypeOption.get((String)"realtime")).newWorkItemHandlerModel("Log", "new org.jbpm.process.instance.impl.demo.SystemOutWorkItemHandler()");
        kieBaseModel1.newKieSessionModel("ksession-test-2").setDefault(false).setType(KieSessionModel.KieSessionType.STATEFUL).setClockType(ClockTypeOption.get((String)"realtime")).newWorkItemHandlerModel("Log", "new org.jbpm.kie.services.test.objects.KieConteinerSystemOutWorkItemHandler(kieContainer)");
        kieBaseModel1.newKieSessionModel("ksession-test2").setDefault(false).setType(KieSessionModel.KieSessionType.STATEFUL).setClockType(ClockTypeOption.get((String)"realtime"));
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.writeKModuleXML(kproj.toXML());
        return kfs;
    }

    protected void buildDatasource() {
        this.ds = new PoolingDataSource();
        this.ds.setUniqueName("jdbc/testDS1");
        this.ds.setClassName("org.h2.jdbcx.JdbcDataSource");
        this.ds.getDriverProperties().put("user", "sa");
        this.ds.getDriverProperties().put("password", "sasa");
        this.ds.getDriverProperties().put("URL", "jdbc:h2:mem:mydb");
        this.ds.init();
    }

    protected void closeDataSource() {
        if (this.ds != null) {
            this.ds.close();
        }
    }

    public static void cleanupSingletonSessionId() {
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        if (tempDir.exists()) {
            String[] jbpmSerFiles;
            for (String file : jbpmSerFiles = tempDir.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith("-jbpmSessionId.ser");
                }
            })) {
                logger.debug("Temp dir to be removed {} file {}", (Object)tempDir, (Object)file);
                new File(tempDir, file).delete();
            }
        }
    }

    protected boolean createDescriptor() {
        return false;
    }

    protected List<ObjectModel> getProcessListeners() {
        return new ArrayList<ObjectModel>();
    }

    protected List<ObjectModel> getTaskListeners() {
        return new ArrayList<ObjectModel>();
    }

    public void setDeploymentService(DeploymentService deploymentService) {
        this.deploymentService = deploymentService;
    }

    public void setBpmn2Service(DefinitionService bpmn2Service) {
        this.bpmn2Service = bpmn2Service;
    }

    public void setRuntimeDataService(RuntimeDataService runtimeDataService) {
        this.runtimeDataService = runtimeDataService;
    }

    public void setProcessService(ProcessService processService) {
        this.processService = processService;
    }

    public void setUserTaskService(UserTaskService userTaskService) {
        this.userTaskService = userTaskService;
    }

    public void setQueryService(QueryService queryService) {
        this.queryService = queryService;
    }

    public void setIdentityProvider(TestIdentityProvider identityProvider) {
        this.identityProvider = identityProvider;
    }

    public void setUserGroupCallback(TestUserGroupCallbackImpl userGroupCallback) {
        this.userGroupCallback = userGroupCallback;
    }

    protected static void waitForTheOtherThreads(CyclicBarrier barrier) {
        try {
            barrier.await();
        }
        catch (InterruptedException e) {
            Assert.fail((String)"Thread 1 was interrupted while waiting for the other threads!");
        }
        catch (BrokenBarrierException e) {
            Assert.fail((String)"Thread 1's barrier was broken while waiting for the other threads!");
        }
    }
}

