/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.test.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jbpm.kie.test.util.CountDownTaskEventListener;
import org.jbpm.test.listener.NodeLeftCountDownProcessEventListener;

public class CountDownListenerFactory {
    private static Map<String, NodeLeftCountDownProcessEventListener> listeners = new ConcurrentHashMap<String, NodeLeftCountDownProcessEventListener>();
    private static Map<String, CountDownTaskEventListener> tasklisteners = new ConcurrentHashMap<String, CountDownTaskEventListener>();

    public static NodeLeftCountDownProcessEventListener get(String id, String nodeName, int threads) {
        if (listeners.containsKey(id)) {
            return listeners.get(id);
        }
        NodeLeftCountDownProcessEventListener listener = new NodeLeftCountDownProcessEventListener(nodeName, threads);
        listeners.put(id, listener);
        return listener;
    }

    public static CountDownTaskEventListener getTask(String id, int threads) {
        if (tasklisteners.containsKey(id)) {
            return tasklisteners.get(id);
        }
        CountDownTaskEventListener listener = new CountDownTaskEventListener(threads, true, true);
        tasklisteners.put(id, listener);
        return listener;
    }

    public static NodeLeftCountDownProcessEventListener getExisting(String id) {
        return listeners.get(id);
    }

    public static NodeLeftCountDownProcessEventListener removeExisting(String id) {
        return listeners.remove(id);
    }

    public static CountDownTaskEventListener getExistingTask(String id) {
        return tasklisteners.get(id);
    }

    public static CountDownTaskEventListener removeExistingTask(String id) {
        return tasklisteners.remove(id);
    }

    public static void clear() {
        listeners.clear();
        tasklisteners.clear();
    }
}

