/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.api.integration;

import java.util.Iterator;
import java.util.ServiceLoader;
import org.jbpm.persistence.api.integration.PersistenceEventManager;
import org.jbpm.persistence.api.integration.base.TransactionalPersistenceEventManager;

public class EventManagerProvider {
    private PersistenceEventManager eventManager;

    private EventManagerProvider() {
        ServiceLoader<PersistenceEventManager> found = ServiceLoader.load(PersistenceEventManager.class);
        Iterator<PersistenceEventManager> it = found.iterator();
        this.eventManager = it.hasNext() ? it.next() : new TransactionalPersistenceEventManager();
    }

    public static EventManagerProvider getInstance() {
        return LazyHolder.INSTANCE;
    }

    public PersistenceEventManager get() {
        return this.eventManager;
    }

    public boolean isActive() {
        return this.eventManager.isActive();
    }

    private static class LazyHolder {
        static final EventManagerProvider INSTANCE = new EventManagerProvider();

        private LazyHolder() {
        }
    }
}

