/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.processinstance;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.drools.common.InternalKnowledgeRuntime;
import org.drools.definition.process.Process;
import org.drools.runtime.process.ProcessInstance;
import org.jbpm.persistence.ProcessPersistenceContext;
import org.jbpm.persistence.ProcessPersistenceContextManager;
import org.jbpm.persistence.processinstance.ProcessInstanceInfo;
import org.jbpm.process.instance.ProcessInstanceManager;
import org.jbpm.process.instance.impl.ProcessInstanceImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPAProcessInstanceManager
implements ProcessInstanceManager {
    private InternalKnowledgeRuntime kruntime;
    private transient Map<Long, ProcessInstance> processInstances;

    public void setKnowledgeRuntime(InternalKnowledgeRuntime kruntime) {
        this.kruntime = kruntime;
    }

    public void addProcessInstance(ProcessInstance processInstance) {
        ProcessInstanceInfo processInstanceInfo = new ProcessInstanceInfo(processInstance, this.kruntime.getEnvironment());
        ProcessPersistenceContext context = ((ProcessPersistenceContextManager)this.kruntime.getEnvironment().get("drools.persistence.PersistenceContextManager")).getProcessPersistenceContext();
        context.persist(processInstanceInfo);
        ((org.jbpm.process.instance.ProcessInstance)processInstance).setId(processInstanceInfo.getId().longValue());
        processInstanceInfo.updateLastReadDate();
        this.internalAddProcessInstance(processInstance);
    }

    public void internalAddProcessInstance(ProcessInstance processInstance) {
        if (this.processInstances == null) {
            this.processInstances = new HashMap<Long, ProcessInstance>();
        }
        this.processInstances.put(processInstance.getId(), processInstance);
    }

    public ProcessInstance getProcessInstance(long id) {
        org.jbpm.process.instance.ProcessInstance processInstance = null;
        if (this.processInstances != null && (processInstance = (org.jbpm.process.instance.ProcessInstance)this.processInstances.get(id)) != null) {
            return processInstance;
        }
        ProcessPersistenceContext context = ((ProcessPersistenceContextManager)this.kruntime.getEnvironment().get("drools.persistence.PersistenceContextManager")).getProcessPersistenceContext();
        ProcessInstanceInfo processInstanceInfo = context.findProcessInstanceInfo(id);
        if (processInstanceInfo == null) {
            return null;
        }
        processInstanceInfo.updateLastReadDate();
        processInstance = (org.jbpm.process.instance.ProcessInstance)processInstanceInfo.getProcessInstance(this.kruntime, this.kruntime.getEnvironment());
        Process process = this.kruntime.getKnowledgeBase().getProcess(processInstance.getProcessId());
        if (process == null) {
            throw new IllegalArgumentException("Could not find process " + processInstance.getProcessId());
        }
        processInstance.setProcess(process);
        if (processInstance.getKnowledgeRuntime() == null) {
            processInstance.setKnowledgeRuntime(this.kruntime);
            ((ProcessInstanceImpl)processInstance).reconnect();
        }
        return processInstance;
    }

    public Collection<ProcessInstance> getProcessInstances() {
        return new ArrayList<ProcessInstance>();
    }

    public void removeProcessInstance(ProcessInstance processInstance) {
        ProcessPersistenceContext context = ((ProcessPersistenceContextManager)this.kruntime.getEnvironment().get("drools.persistence.PersistenceContextManager")).getProcessPersistenceContext();
        ProcessInstanceInfo processInstanceInfo = context.findProcessInstanceInfo(processInstance.getId());
        if (processInstanceInfo != null) {
            context.remove(processInstanceInfo);
        }
        this.internalRemoveProcessInstance(processInstance);
    }

    public void internalRemoveProcessInstance(ProcessInstance processInstance) {
        if (this.processInstances != null) {
            this.processInstances.remove(processInstance.getId());
        }
    }

    public void clearProcessInstances() {
        if (this.processInstances != null) {
            for (ProcessInstance processInstance : new ArrayList<ProcessInstance>(this.processInstances.values())) {
                ((ProcessInstanceImpl)processInstance).disconnect();
            }
        }
    }
}

