/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.marshalling;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import javax.persistence.EntityManagerFactory;
import org.drools.marshalling.util.MarshalledData;
import org.drools.marshalling.util.MarshallingDBUtil;
import org.drools.marshalling.util.MarshallingTestUtil;
import org.drools.persistence.info.WorkItemInfo;
import org.drools.persistence.util.PersistenceUtil;
import org.jbpm.persistence.processinstance.ProcessInstanceInfo;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugJbpmUnmarshallingTest {
    private static Logger logger = LoggerFactory.getLogger(DebugJbpmUnmarshallingTest.class);

    @Test
    @Ignore
    public void checkMarshalledProcessInstanceObjects() {
        HashMap testContext = MarshallingDBUtil.initializeMarshalledDataEMF((String)"org.jbpm.persistence.jpa", this.getClass(), (boolean)true);
        EntityManagerFactory emf = (EntityManagerFactory)testContext.get("drools.persistence.jpa.EntityManagerFactory");
        ArrayList marshalledDataList = MarshallingTestUtil.retrieveMarshallingData((EntityManagerFactory)emf);
        for (MarshalledData marshalledData : marshalledDataList) {
            if (!marshalledData.marshalledObjectClassName.equals(ProcessInstanceInfo.class.getName())) continue;
            String logMsg = marshalledData.marshalledObjectClassName.substring(marshalledData.marshalledObjectClassName.lastIndexOf(46) + 1) + ": " + marshalledData.getTestMethodAndSnapshotNum();
            try {
                MarshallingTestUtil.unmarshallObject((MarshalledData)marshalledData);
                logger.info(".: " + logMsg);
            }
            catch (Exception e) {
                logger.info("X: " + logMsg);
                Assert.fail((String)("Unable to unmarshall ProcessInstanceInfo object: " + logMsg));
            }
        }
        PersistenceUtil.tearDown((HashMap)testContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Ignore
    public void checkMarshalledWorkItemObjects() throws IOException {
        HashMap testContext = MarshallingDBUtil.initializeMarshalledDataEMF((String)"org.jbpm.persistence.jpa", this.getClass(), (boolean)true);
        EntityManagerFactory emf = (EntityManagerFactory)testContext.get("drools.persistence.jpa.EntityManagerFactory");
        ArrayList marshalledDataList = MarshallingTestUtil.retrieveMarshallingData((EntityManagerFactory)emf);
        for (MarshalledData marshalledData : marshalledDataList) {
            if (!marshalledData.marshalledObjectClassName.equals(WorkItemInfo.class.getName())) continue;
            String logMsg = marshalledData.marshalledObjectClassName.substring(marshalledData.marshalledObjectClassName.lastIndexOf(46) + 1) + ": " + marshalledData.getTestMethodAndSnapshotNum();
            try {
                MarshallingTestUtil.unmarshallObject((MarshalledData)marshalledData);
                logger.info(".: " + logMsg);
            }
            catch (Exception e) {
                logger.info("X: " + logMsg);
                Assert.fail((String)("Unable to unmarshall WorkItem object: " + logMsg));
            }
            finally {
                PersistenceUtil.tearDown((HashMap)testContext);
            }
        }
    }

    @Test
    @Ignore
    public void testWriteReadUTF() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream stream = new ObjectOutputStream(baos);
        stream.writeUTF("org.drools.test.TestProcess");
        byte[] resultBytes = baos.toByteArray();
        stream.close();
        resultBytes = baos.toByteArray();
        Assert.assertTrue((resultBytes != null && resultBytes.length > 0 ? 1 : 0) != 0);
        ByteArrayInputStream bais = new ByteArrayInputStream(resultBytes);
        ObjectInputStream inStream = new ObjectInputStream(bais);
        String result = null;
        try {
            result = inStream.readUTF();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)(e.getClass().getSimpleName() + " thrown: " + e.getMessage()));
        }
        System.out.println(": \"" + result + "\"");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Ignore
    public void debugUnmarshallingSpecificMarshalledData() {
        HashSet<String> testMethodAndSnapNumSet = new HashSet<String>();
        testMethodAndSnapNumSet.add("org.jbpm.persistence.session.VariablePersistenceStrategyTest.testWorkItemWithVariablePersistence:2");
        testMethodAndSnapNumSet.add("org.jbpm.persistence.session.PersistentStatefulSessionTest.testPersistenceSubProcess:2");
        HashMap testContext = MarshallingDBUtil.initializeMarshalledDataEMF((String)"org.jbpm.persistence.jpa", this.getClass(), (boolean)true);
        EntityManagerFactory emf = (EntityManagerFactory)testContext.get("drools.persistence.jpa.EntityManagerFactory");
        ArrayList marshalledDataList = MarshallingTestUtil.retrieveMarshallingData((EntityManagerFactory)emf);
        HashSet<MarshalledData> marshalledDataSet = new HashSet<MarshalledData>();
        for (MarshalledData marshalledDataElement : marshalledDataList) {
            if (!testMethodAndSnapNumSet.contains(marshalledDataElement.getTestMethodAndSnapshotNum())) continue;
            marshalledDataSet.add(marshalledDataElement);
            break;
        }
        Assert.assertTrue((String)"No marshalled data retrieved.", (!marshalledDataSet.isEmpty() ? 1 : 0) != 0);
        String logMsg = null;
        try {
            Object unmarshalledObject = null;
            for (MarshalledData marshalledData : marshalledDataSet) {
                logMsg = marshalledData.marshalledObjectClassName.substring(marshalledData.marshalledObjectClassName.lastIndexOf(46) + 1) + ": " + marshalledData.getTestMethodAndSnapshotNum();
                unmarshalledObject = MarshallingTestUtil.unmarshallObject((MarshalledData)marshalledData);
                Assert.assertNotNull((Object)unmarshalledObject);
                logger.info(".: " + logMsg);
            }
        }
        catch (Exception e) {
            logger.info("X: " + logMsg);
            e.printStackTrace();
            Assert.fail((String)("[" + e.getClass().getSimpleName() + "]: " + e.getMessage()));
        }
        finally {
            PersistenceUtil.tearDown((HashMap)testContext);
        }
    }
}

