/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.session;

import java.util.ArrayList;
import java.util.HashMap;
import javax.naming.InitialContext;
import javax.transaction.UserTransaction;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderError;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.event.process.ProcessCompletedEvent;
import org.drools.event.process.ProcessEventListener;
import org.drools.event.process.ProcessNodeLeftEvent;
import org.drools.event.process.ProcessNodeTriggeredEvent;
import org.drools.event.process.ProcessStartedEvent;
import org.drools.event.process.ProcessVariableChangedEvent;
import org.drools.io.Resource;
import org.drools.io.ResourceFactory;
import org.drools.io.impl.ClassPathResource;
import org.drools.persistence.jpa.JPAKnowledgeService;
import org.drools.persistence.util.PersistenceUtil;
import org.drools.runtime.Environment;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.process.ProcessInstance;
import org.drools.runtime.process.WorkItem;
import org.drools.runtime.process.WorkItemHandler;
import org.jbpm.persistence.session.objects.TestWorkItemHandler;
import org.jbpm.process.instance.impl.demo.SystemOutWorkItemHandler;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistentStatefulSessionTest {
    private static Logger logger = LoggerFactory.getLogger(PersistentStatefulSessionTest.class);
    private HashMap<String, Object> context;
    private Environment env;

    @Before
    public void setUp() throws Exception {
        this.context = PersistenceUtil.setupWithPoolingDataSource((String)"org.jbpm.persistence.jpa");
        this.env = PersistenceUtil.createEnvironment(this.context);
    }

    @After
    public void tearDown() throws Exception {
        PersistenceUtil.tearDown(this.context);
    }

    @Test
    public void testLocalTransactionPerStatement() {
        String str = "";
        str = str + "package org.drools.test\n";
        str = str + "global java.util.List list\n";
        str = str + "rule rule1\n";
        str = str + "when\n";
        str = str + "  Integer(intValue > 0)\n";
        str = str + "then\n";
        str = str + "  list.add( 1 );\n";
        str = str + "end\n";
        str = str + "\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = JPAKnowledgeService.newStatefulKnowledgeSession((KnowledgeBase)kbase, null, (Environment)this.env);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)1);
        ksession.insert((Object)2);
        ksession.insert((Object)3);
        ksession.fireAllRules();
        Assert.assertEquals((long)3L, (long)list.size());
    }

    @Test
    public void testUserTransactions() throws Exception {
        String str = "";
        str = str + "package org.drools.test\n";
        str = str + "global java.util.List list\n";
        str = str + "rule rule1\n";
        str = str + "when\n";
        str = str + "  $i : Integer(intValue > 0)\n";
        str = str + "then\n";
        str = str + "  list.add( $i );\n";
        str = str + "end\n";
        str = str + "\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        UserTransaction ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        StatefulKnowledgeSession ksession = JPAKnowledgeService.newStatefulKnowledgeSession((KnowledgeBase)kbase, null, (Environment)this.env);
        ut.commit();
        ArrayList list = new ArrayList();
        ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        ksession.setGlobal("list", list);
        ksession.insert((Object)1);
        ksession.insert((Object)2);
        ut.commit();
        ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        ksession.insert((Object)3);
        ut.rollback();
        ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        ksession.fireAllRules();
        ut.commit();
        Assert.assertEquals((long)2L, (long)list.size());
        ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        ksession.insert((Object)3);
        ksession.insert((Object)4);
        ut.commit();
        ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        ksession.insert((Object)5);
        ksession.insert((Object)6);
        ut.rollback();
        ksession.fireAllRules();
        Assert.assertEquals((long)4L, (long)list.size());
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)ksession.getId(), (KnowledgeBase)kbase, null, (Environment)this.env);
        ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        ksession.insert((Object)7);
        ksession.insert((Object)8);
        ut.commit();
        ksession.fireAllRules();
        Assert.assertEquals((long)6L, (long)list.size());
    }

    @Test
    public void testPersistenceWorkItems() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add((Resource)new ClassPathResource("WorkItemsProcess.rf"), ResourceType.DRF);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = JPAKnowledgeService.newStatefulKnowledgeSession((KnowledgeBase)kbase, null, (Environment)this.env);
        int origNumObjects = ksession.getObjects().size();
        int id = ksession.getId();
        ProcessInstance processInstance = ksession.startProcess("org.drools.test.TestProcess");
        ksession.insert((Object)"TestString");
        logger.debug("Started process instance " + processInstance.getId());
        TestWorkItemHandler handler = TestWorkItemHandler.getInstance();
        WorkItem workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)id, (KnowledgeBase)kbase, null, (Environment)this.env);
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)processInstance);
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)id, (KnowledgeBase)kbase, null, (Environment)this.env);
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)id, (KnowledgeBase)kbase, null, (Environment)this.env);
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)processInstance);
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)id, (KnowledgeBase)kbase, null, (Environment)this.env);
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)id, (KnowledgeBase)kbase, null, (Environment)this.env);
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)processInstance);
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)id, (KnowledgeBase)kbase, null, (Environment)this.env);
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        workItem = handler.getWorkItem();
        Assert.assertNull((Object)workItem);
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)id, (KnowledgeBase)kbase, null, (Environment)this.env);
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assert.assertEquals((long)(origNumObjects + 1), (long)ksession.getObjects().size());
        for (Object o : ksession.getObjects()) {
            logger.debug(o.toString());
        }
        Assert.assertNull((Object)processInstance);
    }

    @Test
    public void testPersistenceWorkItems2() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add((Resource)new ClassPathResource("WorkItemsProcess.rf"), ResourceType.DRF);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = JPAKnowledgeService.newStatefulKnowledgeSession((KnowledgeBase)kbase, null, (Environment)this.env);
        int id = ksession.getId();
        UserTransaction ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        ProcessInstance processInstance = ksession.startProcess("org.drools.test.TestProcess");
        ksession.insert((Object)"TestString");
        logger.debug("Started process instance " + processInstance.getId());
        TestWorkItemHandler handler = TestWorkItemHandler.getInstance();
        WorkItem workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        ut.commit();
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)id, (KnowledgeBase)kbase, null, (Environment)this.env);
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)processInstance);
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)id, (KnowledgeBase)kbase, null, (Environment)this.env);
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)id, (KnowledgeBase)kbase, null, (Environment)this.env);
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)processInstance);
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)id, (KnowledgeBase)kbase, null, (Environment)this.env);
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        workItem = handler.getWorkItem();
        Assert.assertNull((Object)workItem);
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)id, (KnowledgeBase)kbase, null, (Environment)this.env);
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assert.assertEquals((long)1L, (long)ksession.getObjects().size());
        for (Object o : ksession.getObjects()) {
            logger.debug(o.toString());
        }
        Assert.assertNull((Object)processInstance);
    }

    @Test
    public void testPersistenceWorkItems3() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add((Resource)new ClassPathResource("WorkItemsProcess.rf"), ResourceType.DRF);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = JPAKnowledgeService.newStatefulKnowledgeSession((KnowledgeBase)kbase, null, (Environment)this.env);
        ksession.getWorkItemManager().registerWorkItemHandler("MyWork", (WorkItemHandler)new SystemOutWorkItemHandler());
        ProcessInstance processInstance = ksession.startProcess("org.drools.test.TestProcess");
        ksession.insert((Object)"TestString");
        Assert.assertEquals((long)2L, (long)processInstance.getState());
    }

    @Test
    public void testPersistenceState() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add((Resource)new ClassPathResource("StateProcess.rf"), ResourceType.DRF);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = JPAKnowledgeService.newStatefulKnowledgeSession((KnowledgeBase)kbase, null, (Environment)this.env);
        int id = ksession.getId();
        ProcessInstance processInstance = ksession.startProcess("org.drools.test.TestProcess");
        logger.debug("Started process instance " + processInstance.getId());
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)id, (KnowledgeBase)kbase, null, (Environment)this.env);
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)processInstance);
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)id, (KnowledgeBase)kbase, null, (Environment)this.env);
        ksession.insert(new ArrayList());
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)id, (KnowledgeBase)kbase, null, (Environment)this.env);
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assert.assertNull((Object)processInstance);
    }

    @Test
    public void testPersistenceRuleSet() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add((Resource)new ClassPathResource("RuleSetProcess.rf"), ResourceType.DRF);
        kbuilder.add((Resource)new ClassPathResource("RuleSetRules.drl"), ResourceType.DRL);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = JPAKnowledgeService.newStatefulKnowledgeSession((KnowledgeBase)kbase, null, (Environment)this.env);
        int id = ksession.getId();
        ksession.insert(new ArrayList());
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)id, (KnowledgeBase)kbase, null, (Environment)this.env);
        ProcessInstance processInstance = ksession.startProcess("org.drools.test.TestProcess");
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)id, (KnowledgeBase)kbase, null, (Environment)this.env);
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)processInstance);
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)id, (KnowledgeBase)kbase, null, (Environment)this.env);
        ksession.fireAllRules();
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assert.assertNull((Object)processInstance);
    }

    @Test
    public void testPersistenceEvents() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add((Resource)new ClassPathResource("EventsProcess.rf"), ResourceType.DRF);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = JPAKnowledgeService.newStatefulKnowledgeSession((KnowledgeBase)kbase, null, (Environment)this.env);
        int id = ksession.getId();
        ProcessInstance processInstance = ksession.startProcess("org.drools.test.TestProcess");
        logger.debug("Started process instance " + processInstance.getId());
        TestWorkItemHandler handler = TestWorkItemHandler.getInstance();
        WorkItem workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)id, (KnowledgeBase)kbase, null, (Environment)this.env);
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)processInstance);
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)id, (KnowledgeBase)kbase, null, (Environment)this.env);
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)id, (KnowledgeBase)kbase, null, (Environment)this.env);
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)processInstance);
        ksession.signalEvent("MyEvent1", null, processInstance.getId());
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)id, (KnowledgeBase)kbase, null, (Environment)this.env);
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)processInstance);
        ksession.signalEvent("MyEvent2", null, processInstance.getId());
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)id, (KnowledgeBase)kbase, null, (Environment)this.env);
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assert.assertNull((Object)processInstance);
    }

    @Test
    public void testProcessListener() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add((Resource)new ClassPathResource("WorkItemsProcess.rf"), ResourceType.DRF);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = JPAKnowledgeService.newStatefulKnowledgeSession((KnowledgeBase)kbase, null, (Environment)this.env);
        final ArrayList events = new ArrayList();
        ProcessEventListener listener = new ProcessEventListener(){

            public void afterNodeLeft(ProcessNodeLeftEvent event) {
                logger.debug("After node left: " + event.getNodeInstance().getNodeName());
                events.add(event);
            }

            public void afterNodeTriggered(ProcessNodeTriggeredEvent event) {
                logger.debug("After node triggered: " + event.getNodeInstance().getNodeName());
                events.add(event);
            }

            public void afterProcessCompleted(ProcessCompletedEvent event) {
                logger.debug("After process completed");
                events.add(event);
            }

            public void afterProcessStarted(ProcessStartedEvent event) {
                logger.debug("After process started");
                events.add(event);
            }

            public void beforeNodeLeft(ProcessNodeLeftEvent event) {
                logger.debug("Before node left: " + event.getNodeInstance().getNodeName());
                events.add(event);
            }

            public void beforeNodeTriggered(ProcessNodeTriggeredEvent event) {
                logger.debug("Before node triggered: " + event.getNodeInstance().getNodeName());
                events.add(event);
            }

            public void beforeProcessCompleted(ProcessCompletedEvent event) {
                logger.debug("Before process completed");
                events.add(event);
            }

            public void beforeProcessStarted(ProcessStartedEvent event) {
                logger.debug("Before process started");
                events.add(event);
            }

            public void afterVariableChanged(ProcessVariableChangedEvent event) {
                logger.debug("After Variable Changed");
                events.add(event);
            }

            public void beforeVariableChanged(ProcessVariableChangedEvent event) {
                logger.debug("Before Variable Changed");
                events.add(event);
            }
        };
        ksession.addEventListener(listener);
        ProcessInstance processInstance = ksession.startProcess("org.drools.test.TestProcess");
        logger.debug("Started process instance " + processInstance.getId());
        Assert.assertEquals((long)12L, (long)events.size());
        Assert.assertTrue((boolean)(events.get(0) instanceof ProcessStartedEvent));
        Assert.assertTrue((boolean)(events.get(1) instanceof ProcessNodeTriggeredEvent));
        Assert.assertTrue((boolean)(events.get(2) instanceof ProcessNodeLeftEvent));
        Assert.assertTrue((boolean)(events.get(3) instanceof ProcessNodeTriggeredEvent));
        Assert.assertTrue((boolean)(events.get(4) instanceof ProcessNodeLeftEvent));
        Assert.assertTrue((boolean)(events.get(5) instanceof ProcessNodeTriggeredEvent));
        Assert.assertTrue((boolean)(events.get(6) instanceof ProcessNodeTriggeredEvent));
        Assert.assertTrue((boolean)(events.get(7) instanceof ProcessNodeLeftEvent));
        Assert.assertTrue((boolean)(events.get(8) instanceof ProcessNodeTriggeredEvent));
        Assert.assertTrue((boolean)(events.get(9) instanceof ProcessNodeLeftEvent));
        Assert.assertTrue((boolean)(events.get(10) instanceof ProcessNodeTriggeredEvent));
        Assert.assertTrue((boolean)(events.get(11) instanceof ProcessStartedEvent));
        ksession.removeEventListener(listener);
        events.clear();
        processInstance = ksession.startProcess("org.drools.test.TestProcess");
        logger.debug("Started process instance " + processInstance.getId());
        Assert.assertTrue((boolean)events.isEmpty());
    }

    @Test
    public void testPersistenceSubProcess() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add((Resource)new ClassPathResource("SuperProcess.rf"), ResourceType.DRF);
        kbuilder.add((Resource)new ClassPathResource("SubProcess.rf"), ResourceType.DRF);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = JPAKnowledgeService.newStatefulKnowledgeSession((KnowledgeBase)kbase, null, (Environment)this.env);
        int id = ksession.getId();
        ProcessInstance processInstance = ksession.startProcess("com.sample.SuperProcess");
        logger.debug("Started process instance " + processInstance.getId());
        TestWorkItemHandler handler = TestWorkItemHandler.getInstance();
        WorkItem workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)id, (KnowledgeBase)kbase, null, (Environment)this.env);
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)processInstance);
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)id, (KnowledgeBase)kbase, null, (Environment)this.env);
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)id, (KnowledgeBase)kbase, null, (Environment)this.env);
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)processInstance);
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)id, (KnowledgeBase)kbase, null, (Environment)this.env);
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        workItem = handler.getWorkItem();
        Assert.assertNull((Object)workItem);
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)id, (KnowledgeBase)kbase, null, (Environment)this.env);
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assert.assertNull((Object)processInstance);
    }

    @Test
    public void testPersistenceVariables() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add((Resource)new ClassPathResource("VariablesProcess.rf"), ResourceType.DRF);
        for (KnowledgeBuilderError error : kbuilder.getErrors()) {
            logger.debug(error.toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = JPAKnowledgeService.newStatefulKnowledgeSession((KnowledgeBase)kbase, null, (Environment)this.env);
        int id = ksession.getId();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("name", "John Doe");
        ProcessInstance processInstance = ksession.startProcess("org.drools.test.TestProcess", parameters);
        TestWorkItemHandler handler = TestWorkItemHandler.getInstance();
        WorkItem workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        Assert.assertEquals((Object)"John Doe", (Object)workItem.getParameter("name"));
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)id, (KnowledgeBase)kbase, null, (Environment)this.env);
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)processInstance);
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)id, (KnowledgeBase)kbase, null, (Environment)this.env);
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        Assert.assertEquals((Object)"John Doe", (Object)workItem.getParameter("text"));
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)id, (KnowledgeBase)kbase, null, (Environment)this.env);
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)processInstance);
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)id, (KnowledgeBase)kbase, null, (Environment)this.env);
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        workItem = handler.getWorkItem();
        Assert.assertNull((Object)workItem);
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)id, (KnowledgeBase)kbase, null, (Environment)this.env);
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assert.assertNull((Object)processInstance);
    }

    @Test
    public void testSetFocus() {
        String str = "";
        str = str + "package org.drools.test\n";
        str = str + "global java.util.List list\n";
        str = str + "rule rule1\n";
        str = str + "agenda-group \"badfocus\"";
        str = str + "when\n";
        str = str + "  Integer(intValue > 0)\n";
        str = str + "then\n";
        str = str + "  list.add( 1 );\n";
        str = str + "end\n";
        str = str + "\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = JPAKnowledgeService.newStatefulKnowledgeSession((KnowledgeBase)kbase, null, (Environment)this.env);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)1);
        ksession.insert((Object)2);
        ksession.insert((Object)3);
        ksession.getAgenda().getAgendaGroup("badfocus").setFocus();
        ksession.fireAllRules();
        Assert.assertEquals((long)3L, (long)list.size());
    }
}

