/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.session;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderConfiguration;
import org.drools.builder.KnowledgeBuilderError;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.common.AbstractRuleBase;
import org.drools.definition.process.Node;
import org.drools.definition.process.Process;
import org.drools.impl.InternalKnowledgeBase;
import org.drools.io.Resource;
import org.drools.io.impl.ClassPathResource;
import org.drools.marshalling.ObjectMarshallingStrategy;
import org.drools.marshalling.ObjectMarshallingStrategyAcceptor;
import org.drools.marshalling.impl.ClassObjectMarshallingStrategyAcceptor;
import org.drools.marshalling.impl.SerializablePlaceholderResolverStrategy;
import org.drools.persistence.jpa.JPAKnowledgeService;
import org.drools.persistence.jpa.marshaller.JPAPlaceholderResolverStrategy;
import org.drools.persistence.util.PersistenceUtil;
import org.drools.process.core.Work;
import org.drools.process.core.datatype.DataType;
import org.drools.process.core.datatype.impl.type.ObjectDataType;
import org.drools.process.core.impl.WorkImpl;
import org.drools.runtime.Environment;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.process.ProcessContext;
import org.drools.runtime.process.ProcessInstance;
import org.drools.runtime.process.WorkItem;
import org.drools.runtime.process.WorkflowProcessInstance;
import org.jbpm.persistence.JbpmTestCase;
import org.jbpm.persistence.session.objects.MyEntity;
import org.jbpm.persistence.session.objects.MyEntityMethods;
import org.jbpm.persistence.session.objects.MyEntityOnlyFields;
import org.jbpm.persistence.session.objects.MySubEntity;
import org.jbpm.persistence.session.objects.MySubEntityMethods;
import org.jbpm.persistence.session.objects.MyVariableExtendingSerializable;
import org.jbpm.persistence.session.objects.MyVariableSerializable;
import org.jbpm.persistence.session.objects.TestWorkItemHandler;
import org.jbpm.process.core.context.variable.Variable;
import org.jbpm.process.instance.impl.Action;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.workflow.core.DroolsAction;
import org.jbpm.workflow.core.impl.ConnectionImpl;
import org.jbpm.workflow.core.impl.DroolsConsequenceAction;
import org.jbpm.workflow.core.node.ActionNode;
import org.jbpm.workflow.core.node.EndNode;
import org.jbpm.workflow.core.node.StartNode;
import org.jbpm.workflow.core.node.WorkItemNode;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VariablePersistenceStrategyTest
extends JbpmTestCase {
    private static Logger logger = LoggerFactory.getLogger(VariablePersistenceStrategyTest.class);
    private HashMap<String, Object> context;
    private EntityManagerFactory emf;

    @Before
    public void setUp() throws Exception {
        this.context = PersistenceUtil.setupWithPoolingDataSource((String)"org.jbpm.persistence.jpa");
        this.emf = (EntityManagerFactory)this.context.get("drools.persistence.jpa.EntityManagerFactory");
    }

    @After
    public void tearDown() throws Exception {
        PersistenceUtil.tearDown(this.context);
    }

    @Test
    public void testExtendingInterfaceVariablePersistence() throws Exception {
        Environment env = this.createEnvironment();
        String processId = "extendingInterfaceVariablePersistence";
        String variableText = "my extending serializable variable text";
        KnowledgeBase kbase = this.getKnowledgeBaseForExtendingInterfaceVariablePersistence(processId, variableText);
        StatefulKnowledgeSession ksession = this.createSession(kbase, env);
        HashMap<String, MyVariableExtendingSerializable> initialParams = new HashMap<String, MyVariableExtendingSerializable>();
        initialParams.put("x", new MyVariableExtendingSerializable(variableText));
        long processInstanceId = ksession.startProcess(processId, initialParams).getId();
        ksession = this.reloadSession(ksession, kbase, env);
        long workItemId = TestWorkItemHandler.getInstance().getWorkItem().getId();
        ksession.getWorkItemManager().completeWorkItem(workItemId, null);
        junit.framework.Assert.assertNull((Object)ksession.getProcessInstance(processInstanceId));
    }

    private KnowledgeBase getKnowledgeBaseForExtendingInterfaceVariablePersistence(String processId, final String variableText) {
        RuleFlowProcess process = new RuleFlowProcess();
        process.setId(processId);
        ArrayList<Variable> variables = new ArrayList<Variable>();
        Variable variable = new Variable();
        variable.setName("x");
        ObjectDataType extendingSerializableDataType = new ObjectDataType();
        extendingSerializableDataType.setClassName(MyVariableExtendingSerializable.class.getName());
        variable.setType((DataType)extendingSerializableDataType);
        variables.add(variable);
        process.getVariableScope().setVariables(variables);
        StartNode startNode = new StartNode();
        startNode.setName("Start");
        startNode.setId(1L);
        WorkItemNode workItemNode = new WorkItemNode();
        workItemNode.setName("workItemNode");
        workItemNode.setId(2L);
        WorkImpl work = new WorkImpl();
        work.setName("MyWork");
        workItemNode.setWork((Work)work);
        ActionNode actionNode = new ActionNode();
        actionNode.setName("Print");
        DroolsConsequenceAction action = new DroolsConsequenceAction("java", null);
        action.setMetaData("Action", (Object)new Action(){

            public void execute(ProcessContext context) throws Exception {
                junit.framework.Assert.assertEquals((String)variableText, (String)((MyVariableExtendingSerializable)context.getVariable("x")).getText());
            }
        });
        actionNode.setAction((DroolsAction)action);
        actionNode.setId(3L);
        EndNode endNode = new EndNode();
        endNode.setName("EndNode");
        endNode.setId(4L);
        this.connect((org.jbpm.workflow.core.Node)startNode, (org.jbpm.workflow.core.Node)workItemNode);
        this.connect((org.jbpm.workflow.core.Node)workItemNode, (org.jbpm.workflow.core.Node)actionNode);
        this.connect((org.jbpm.workflow.core.Node)actionNode, (org.jbpm.workflow.core.Node)endNode);
        process.addNode((Node)startNode);
        process.addNode((Node)workItemNode);
        process.addNode((Node)actionNode);
        process.addNode((Node)endNode);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        ((AbstractRuleBase)((InternalKnowledgeBase)kbase).getRuleBase()).addProcess((Process)process);
        return kbase;
    }

    @Test
    public void testPersistenceVariables() throws NamingException, NotSupportedException, SystemException, RollbackException, HeuristicMixedException, HeuristicRollbackException {
        EntityManager em = this.emf.createEntityManager();
        UserTransaction utx = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        if (utx.getStatus() == 6) {
            utx.begin();
            em.joinTransaction();
        }
        int origNumMyEntities = em.createQuery("select i from MyEntity i").getResultList().size();
        int origNumMyEntityMethods = em.createQuery("select i from MyEntityMethods i").getResultList().size();
        int origNumMyEntityOnlyFields = em.createQuery("select i from MyEntityOnlyFields i").getResultList().size();
        if (utx.getStatus() == 0) {
            utx.commit();
        }
        MyEntity myEntity = new MyEntity("This is a test Entity with annotation in fields");
        MyEntityMethods myEntityMethods = new MyEntityMethods("This is a test Entity with annotations in methods");
        MyEntityOnlyFields myEntityOnlyFields = new MyEntityOnlyFields("This is a test Entity with annotations in fields and without accesors methods");
        MyVariableSerializable myVariableSerializable = new MyVariableSerializable("This is a test SerializableObject");
        utx = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        utx.begin();
        em.joinTransaction();
        em.persist((Object)myEntity);
        em.persist((Object)myEntityMethods);
        em.persist((Object)myEntityOnlyFields);
        utx.commit();
        em.close();
        Environment env = this.createEnvironment();
        KnowledgeBase kbase = this.createKnowledgeBase("VariablePersistenceStrategyProcess.rf");
        StatefulKnowledgeSession ksession = this.createSession(kbase, env);
        logger.info("### Starting process ###");
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("x", "SomeString");
        parameters.put("y", myEntity);
        parameters.put("m", myEntityMethods);
        parameters.put("f", myEntityOnlyFields);
        parameters.put("z", myVariableSerializable);
        long processInstanceId = ksession.startProcess("com.sample.ruleflow", parameters).getId();
        TestWorkItemHandler handler = TestWorkItemHandler.getInstance();
        WorkItem workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        List result = this.emf.createEntityManager().createQuery("select i from MyEntity i").getResultList();
        Assert.assertEquals((long)(origNumMyEntities + 1), (long)result.size());
        result = this.emf.createEntityManager().createQuery("select i from MyEntityMethods i").getResultList();
        Assert.assertEquals((long)(origNumMyEntityMethods + 1), (long)result.size());
        result = this.emf.createEntityManager().createQuery("select i from MyEntityOnlyFields i").getResultList();
        Assert.assertEquals((long)(origNumMyEntityOnlyFields + 1), (long)result.size());
        logger.info("### Retrieving process instance ###");
        ksession = this.reloadSession(ksession, kbase, env);
        WorkflowProcessInstance processInstance = (WorkflowProcessInstance)ksession.getProcessInstance(processInstanceId);
        Assert.assertNotNull((Object)processInstance);
        Assert.assertEquals((Object)"SomeString", (Object)processInstance.getVariable("x"));
        Assert.assertEquals((Object)"This is a test Entity with annotation in fields", (Object)((MyEntity)processInstance.getVariable("y")).getTest());
        Assert.assertEquals((Object)"This is a test Entity with annotations in methods", (Object)((MyEntityMethods)processInstance.getVariable("m")).getTest());
        Assert.assertEquals((Object)"This is a test Entity with annotations in fields and without accesors methods", (Object)((MyEntityOnlyFields)processInstance.getVariable((String)"f")).test);
        Assert.assertEquals((Object)"This is a test SerializableObject", (Object)((MyVariableSerializable)processInstance.getVariable("z")).getText());
        Assert.assertNull((Object)processInstance.getVariable("a"));
        Assert.assertNull((Object)processInstance.getVariable("b"));
        Assert.assertNull((Object)processInstance.getVariable("c"));
        logger.info("### Completing first work item ###");
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        logger.info("### Retrieving process instance ###");
        ksession = this.reloadSession(ksession, kbase, env);
        processInstance = (WorkflowProcessInstance)ksession.getProcessInstance(processInstanceId);
        Assert.assertNotNull((Object)processInstance);
        Assert.assertEquals((Object)"SomeString", (Object)processInstance.getVariable("x"));
        Assert.assertEquals((Object)"This is a test Entity with annotation in fields", (Object)((MyEntity)processInstance.getVariable("y")).getTest());
        Assert.assertEquals((Object)"This is a test Entity with annotations in methods", (Object)((MyEntityMethods)processInstance.getVariable("m")).getTest());
        Assert.assertEquals((Object)"This is a test Entity with annotations in fields and without accesors methods", (Object)((MyEntityOnlyFields)processInstance.getVariable((String)"f")).test);
        Assert.assertEquals((Object)"This is a test SerializableObject", (Object)((MyVariableSerializable)processInstance.getVariable("z")).getText());
        Assert.assertEquals((Object)"Some new String", (Object)processInstance.getVariable("a"));
        Assert.assertEquals((Object)"This is a new test Entity", (Object)((MyEntity)processInstance.getVariable("b")).getTest());
        Assert.assertEquals((Object)"This is a new test SerializableObject", (Object)((MyVariableSerializable)processInstance.getVariable("c")).getText());
        logger.info("### Completing second work item ###");
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        logger.info("### Retrieving process instance ###");
        ksession = this.reloadSession(ksession, kbase, env);
        processInstance = (WorkflowProcessInstance)ksession.getProcessInstance(processInstanceId);
        Assert.assertNotNull((Object)processInstance);
        Assert.assertEquals((Object)"SomeString", (Object)processInstance.getVariable("x"));
        Assert.assertEquals((Object)"This is a test Entity with annotation in fields", (Object)((MyEntity)processInstance.getVariable("y")).getTest());
        Assert.assertEquals((Object)"This is a test Entity with annotations in methods", (Object)((MyEntityMethods)processInstance.getVariable("m")).getTest());
        Assert.assertEquals((Object)"This is a test Entity with annotations in fields and without accesors methods", (Object)((MyEntityOnlyFields)processInstance.getVariable((String)"f")).test);
        Assert.assertEquals((Object)"This is a test SerializableObject", (Object)((MyVariableSerializable)processInstance.getVariable("z")).getText());
        Assert.assertEquals((Object)"Some changed String", (Object)processInstance.getVariable("a"));
        Assert.assertEquals((Object)"This is a changed test Entity", (Object)((MyEntity)processInstance.getVariable("b")).getTest());
        Assert.assertEquals((Object)"This is a changed test SerializableObject", (Object)((MyVariableSerializable)processInstance.getVariable("c")).getText());
        logger.info("### Completing third work item ###");
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        workItem = handler.getWorkItem();
        Assert.assertNull((Object)workItem);
        ksession = this.reloadSession(ksession, kbase, env);
        processInstance = (WorkflowProcessInstance)ksession.getProcessInstance(processInstanceId);
        Assert.assertNull((Object)processInstance);
    }

    @Test
    public void testPersistenceVariablesWithTypeChange() throws NamingException, NotSupportedException, SystemException, RollbackException, HeuristicMixedException, HeuristicRollbackException {
        MyEntity myEntity = new MyEntity("This is a test Entity with annotation in fields");
        MyEntityMethods myEntityMethods = new MyEntityMethods("This is a test Entity with annotations in methods");
        MyEntityOnlyFields myEntityOnlyFields = new MyEntityOnlyFields("This is a test Entity with annotations in fields and without accesors methods");
        MyVariableSerializable myVariableSerializable = new MyVariableSerializable("This is a test SerializableObject");
        EntityManager em = this.emf.createEntityManager();
        UserTransaction utx = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        int s = utx.getStatus();
        if (utx.getStatus() == 6) {
            utx.begin();
        }
        em.joinTransaction();
        em.persist((Object)myEntity);
        em.persist((Object)myEntityMethods);
        em.persist((Object)myEntityOnlyFields);
        if (utx.getStatus() == 0) {
            utx.commit();
        }
        em.close();
        Environment env = this.createEnvironment();
        KnowledgeBase kbase = this.createKnowledgeBase("VariablePersistenceStrategyProcessTypeChange.rf");
        StatefulKnowledgeSession ksession = this.createSession(kbase, env);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("x", "SomeString");
        parameters.put("y", myEntity);
        parameters.put("m", myEntityMethods);
        parameters.put("f", myEntityOnlyFields);
        parameters.put("z", myVariableSerializable);
        long processInstanceId = ksession.startProcess("com.sample.ruleflow", parameters).getId();
        TestWorkItemHandler handler = TestWorkItemHandler.getInstance();
        WorkItem workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        ksession = this.reloadSession(ksession, kbase, env);
        ProcessInstance processInstance = ksession.getProcessInstance(processInstanceId);
        Assert.assertNotNull((Object)processInstance);
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        ksession = this.reloadSession(ksession, kbase, env);
        processInstance = ksession.getProcessInstance(processInstanceId);
        Assert.assertNotNull((Object)processInstance);
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        workItem = handler.getWorkItem();
        Assert.assertNull((Object)workItem);
        ksession = this.reloadSession(ksession, kbase, env);
        processInstance = ksession.getProcessInstance(processInstanceId);
        Assert.assertNull((Object)processInstance);
    }

    @Test
    public void testPersistenceVariablesSubProcess() throws NamingException, NotSupportedException, SystemException, RollbackException, HeuristicMixedException, HeuristicRollbackException {
        MyEntity myEntity = new MyEntity("This is a test Entity with annotation in fields");
        MyEntityMethods myEntityMethods = new MyEntityMethods("This is a test Entity with annotations in methods");
        MyEntityOnlyFields myEntityOnlyFields = new MyEntityOnlyFields("This is a test Entity with annotations in fields and without accesors methods");
        MyVariableSerializable myVariableSerializable = new MyVariableSerializable("This is a test SerializableObject");
        EntityManager em = this.emf.createEntityManager();
        UserTransaction utx = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        utx.begin();
        em.joinTransaction();
        em.persist((Object)myEntity);
        em.persist((Object)myEntityMethods);
        em.persist((Object)myEntityOnlyFields);
        utx.commit();
        em.close();
        Environment env = this.createEnvironment();
        KnowledgeBase kbase = this.createKnowledgeBase("VariablePersistenceStrategySubProcess.rf");
        StatefulKnowledgeSession ksession = this.createSession(kbase, env);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("x", "SomeString");
        parameters.put("y", myEntity);
        parameters.put("m", myEntityMethods);
        parameters.put("f", myEntityOnlyFields);
        parameters.put("z", myVariableSerializable);
        long processInstanceId = ksession.startProcess("com.sample.ruleflow", parameters).getId();
        TestWorkItemHandler handler = TestWorkItemHandler.getInstance();
        WorkItem workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        ksession = this.reloadSession(ksession, kbase, env);
        ProcessInstance processInstance = ksession.getProcessInstance(processInstanceId);
        Assert.assertNotNull((Object)processInstance);
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        ksession = this.reloadSession(ksession, kbase, env);
        processInstance = ksession.getProcessInstance(processInstanceId);
        Assert.assertNotNull((Object)processInstance);
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        ksession = this.reloadSession(ksession, kbase, env);
        processInstance = ksession.getProcessInstance(processInstanceId);
        Assert.assertNotNull((Object)processInstance);
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        workItem = handler.getWorkItem();
        Assert.assertNull((Object)workItem);
        ksession = this.reloadSession(ksession, kbase, env);
        processInstance = ksession.getProcessInstance(processInstanceId);
        Assert.assertNull((Object)processInstance);
    }

    @Test
    public void testWorkItemWithVariablePersistence() throws Exception {
        MyEntity myEntity = new MyEntity("This is a test Entity");
        MyVariableSerializable myVariableSerializable = new MyVariableSerializable("This is a test SerializableObject");
        EntityManager em = this.emf.createEntityManager();
        UserTransaction utx = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        utx.begin();
        em.joinTransaction();
        em.persist((Object)myEntity);
        utx.commit();
        em.close();
        Environment env = this.createEnvironment();
        KnowledgeBase kbase = this.createKnowledgeBase("VPSProcessWithWorkItems.rf");
        StatefulKnowledgeSession ksession = this.createSession(kbase, env);
        logger.info("### Starting process ###");
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("x", "SomeString");
        parameters.put("y", myEntity);
        parameters.put("z", myVariableSerializable);
        long processInstanceId = ksession.startProcess("com.sample.ruleflow", parameters).getId();
        TestWorkItemHandler handler = TestWorkItemHandler.getInstance();
        WorkItem workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        logger.info("### Retrieving process instance ###");
        ksession = this.reloadSession(ksession, kbase, env);
        WorkflowProcessInstance processInstance = (WorkflowProcessInstance)ksession.getProcessInstance(processInstanceId);
        Assert.assertNotNull((Object)processInstance);
        Assert.assertEquals((Object)"SomeString", (Object)processInstance.getVariable("x"));
        Assert.assertEquals((Object)"This is a test Entity", (Object)((MyEntity)processInstance.getVariable("y")).getTest());
        Assert.assertEquals((Object)"This is a test SerializableObject", (Object)((MyVariableSerializable)processInstance.getVariable("z")).getText());
        Assert.assertNull((Object)processInstance.getVariable("a"));
        Assert.assertNull((Object)processInstance.getVariable("b"));
        Assert.assertNull((Object)processInstance.getVariable("c"));
        logger.info("### Completing first work item ###");
        HashMap<String, Object> results = new HashMap<String, Object>();
        results.put("zeta", processInstance.getVariable("z"));
        results.put("equis", processInstance.getVariable("x") + "->modifiedResult");
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), results);
        workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        logger.info("### Retrieving process instance ###");
        ksession = this.reloadSession(ksession, kbase, env);
        processInstance = (WorkflowProcessInstance)ksession.getProcessInstance(processInstanceId);
        Assert.assertNotNull((Object)processInstance);
        logger.info("######## Getting the already Persisted Variables #########");
        Assert.assertEquals((Object)"SomeString->modifiedResult", (Object)processInstance.getVariable("x"));
        Assert.assertEquals((Object)"This is a test Entity", (Object)((MyEntity)processInstance.getVariable("y")).getTest());
        Assert.assertEquals((Object)"This is a test SerializableObject", (Object)((MyVariableSerializable)processInstance.getVariable("z")).getText());
        Assert.assertEquals((Object)"Some new String", (Object)processInstance.getVariable("a"));
        Assert.assertEquals((Object)"This is a new test Entity", (Object)((MyEntity)processInstance.getVariable("b")).getTest());
        Assert.assertEquals((Object)"This is a new test SerializableObject", (Object)((MyVariableSerializable)processInstance.getVariable("c")).getText());
        logger.info("### Completing second work item ###");
        results = new HashMap();
        results.put("zeta", processInstance.getVariable("z"));
        results.put("equis", processInstance.getVariable("x"));
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), results);
        workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        logger.info("### Retrieving process instance ###");
        ksession = this.reloadSession(ksession, kbase, env);
        processInstance = (WorkflowProcessInstance)ksession.getProcessInstance(processInstanceId);
        Assert.assertNotNull((Object)processInstance);
        Assert.assertEquals((Object)"SomeString->modifiedResult", (Object)processInstance.getVariable("x"));
        Assert.assertEquals((Object)"This is a test Entity", (Object)((MyEntity)processInstance.getVariable("y")).getTest());
        Assert.assertEquals((Object)"This is a test SerializableObject", (Object)((MyVariableSerializable)processInstance.getVariable("z")).getText());
        Assert.assertEquals((Object)"Some changed String", (Object)processInstance.getVariable("a"));
        Assert.assertEquals((Object)"This is a changed test Entity", (Object)((MyEntity)processInstance.getVariable("b")).getTest());
        Assert.assertEquals((Object)"This is a changed test SerializableObject", (Object)((MyVariableSerializable)processInstance.getVariable("c")).getText());
        logger.info("### Completing third work item ###");
        results = new HashMap();
        results.put("zeta", processInstance.getVariable("z"));
        results.put("equis", processInstance.getVariable("x"));
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), results);
        workItem = handler.getWorkItem();
        Assert.assertNull((Object)workItem);
        ksession = this.reloadSession(ksession, kbase, env);
        processInstance = (WorkflowProcessInstance)ksession.getProcessInstance(processInstanceId);
        Assert.assertNull((Object)processInstance);
    }

    @Test
    public void testEntityWithSuperClassAnnotationField() throws Exception {
        MySubEntity subEntity = new MySubEntity();
        subEntity.setId(3L);
        Assert.assertEquals((Object)3L, (Object)JPAPlaceholderResolverStrategy.getClassIdValue((Object)subEntity));
    }

    @Test
    public void testEntityWithSuperClassAnnotationMethod() throws Exception {
        MySubEntityMethods subEntity = new MySubEntityMethods();
        subEntity.setId(3L);
        Assert.assertEquals((Object)3L, (Object)JPAPlaceholderResolverStrategy.getClassIdValue((Object)subEntity));
    }

    private StatefulKnowledgeSession createSession(KnowledgeBase kbase, Environment env) {
        return JPAKnowledgeService.newStatefulKnowledgeSession((KnowledgeBase)kbase, null, (Environment)env);
    }

    private StatefulKnowledgeSession reloadSession(StatefulKnowledgeSession ksession, KnowledgeBase kbase, Environment env) {
        int sessionId = ksession.getId();
        ksession.dispose();
        return JPAKnowledgeService.loadStatefulKnowledgeSession((int)sessionId, (KnowledgeBase)kbase, null, (Environment)env);
    }

    private KnowledgeBase createKnowledgeBase(String flowFile) {
        KnowledgeBuilderConfiguration conf = KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration();
        conf.setProperty("drools.dialect.java.compiler", "JANINO");
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBuilderConfiguration)conf);
        kbuilder.add((Resource)new ClassPathResource(flowFile), ResourceType.DRF);
        if (kbuilder.hasErrors()) {
            StringBuilder errorMessage = new StringBuilder();
            for (KnowledgeBuilderError error : kbuilder.getErrors()) {
                errorMessage.append(error.getMessage());
                errorMessage.append(System.getProperty("line.separator"));
            }
            Assert.fail((String)errorMessage.toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        return kbase;
    }

    private Environment createEnvironment() {
        Environment env = PersistenceUtil.createEnvironment(this.context);
        env.set("drools.marshalling.ObjectMarshallingStrategies", (Object)new ObjectMarshallingStrategy[]{new JPAPlaceholderResolverStrategy(env), new SerializablePlaceholderResolverStrategy((ObjectMarshallingStrategyAcceptor)ClassObjectMarshallingStrategyAcceptor.DEFAULT)});
        return env;
    }

    private void connect(org.jbpm.workflow.core.Node sourceNode, org.jbpm.workflow.core.Node targetNode) {
        new ConnectionImpl((Node)sourceNode, "DROOLS_DEFAULT", (Node)targetNode, "DROOLS_DEFAULT");
    }
}

