/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.map.impl;

import java.util.HashMap;
import javax.persistence.EntityManagerFactory;
import org.drools.KnowledgeBase;
import org.drools.persistence.jpa.JPAKnowledgeService;
import org.drools.persistence.jta.JtaTransactionManager;
import org.drools.persistence.util.PersistenceUtil;
import org.drools.runtime.Environment;
import org.drools.runtime.StatefulKnowledgeSession;
import org.jbpm.persistence.map.impl.MapPersistenceTest;
import org.junit.After;
import org.junit.Before;

public class JpaBasedPersistenceTest
extends MapPersistenceTest {
    private HashMap<String, Object> context;
    private EntityManagerFactory emf;
    private JtaTransactionManager txm;
    private boolean useTransactions = false;

    @Before
    public void setUp() throws Exception {
        this.context = PersistenceUtil.setupWithPoolingDataSource((String)"org.jbpm.persistence.jpa");
        this.emf = (EntityManagerFactory)this.context.get("drools.persistence.jpa.EntityManagerFactory");
        if (PersistenceUtil.useTransactions()) {
            this.useTransactions = true;
            Environment env = PersistenceUtil.createEnvironment(this.context);
            Object tm = env.get("drools.transaction.TransactionManager");
            this.txm = new JtaTransactionManager(env.get("drools.transaction.Transaction"), env.get("drools.transaction.TransactionSynchronizationRegistry"), tm);
        }
    }

    @After
    public void tearDown() throws Exception {
        PersistenceUtil.tearDown(this.context);
    }

    protected StatefulKnowledgeSession createSession(KnowledgeBase kbase) {
        return JPAKnowledgeService.newStatefulKnowledgeSession((KnowledgeBase)kbase, null, (Environment)PersistenceUtil.createEnvironment(this.context));
    }

    protected StatefulKnowledgeSession disposeAndReloadSession(StatefulKnowledgeSession ksession, int ksessionId, KnowledgeBase kbase) {
        ksession.dispose();
        return JPAKnowledgeService.loadStatefulKnowledgeSession((int)ksessionId, (KnowledgeBase)kbase, null, (Environment)PersistenceUtil.createEnvironment(this.context));
    }

    protected int getProcessInstancesCount() {
        boolean txOwner = false;
        if (this.useTransactions) {
            txOwner = this.txm.begin();
        }
        int size = this.emf.createEntityManager().createQuery("FROM ProcessInstanceInfo").getResultList().size();
        if (this.useTransactions) {
            this.txm.commit(txOwner);
        }
        return size;
    }

    protected int getKnowledgeSessionsCount() {
        boolean transactionOwner = false;
        if (this.useTransactions) {
            transactionOwner = this.txm.begin();
        }
        int size = this.emf.createEntityManager().createQuery("FROM SessionInfo").getResultList().size();
        if (this.useTransactions) {
            this.txm.commit(transactionOwner);
        }
        return size;
    }
}

