/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.map.impl;

import java.util.ArrayList;
import org.drools.definition.process.Node;
import org.drools.persistence.map.impl.Buddy;
import org.drools.process.core.Work;
import org.drools.process.core.datatype.DataType;
import org.drools.process.core.datatype.impl.type.ObjectDataType;
import org.drools.process.core.impl.WorkImpl;
import org.jbpm.process.core.context.variable.Variable;
import org.jbpm.process.core.event.EventFilter;
import org.jbpm.process.core.event.EventTypeFilter;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.workflow.core.impl.ConnectionImpl;
import org.jbpm.workflow.core.node.EndNode;
import org.jbpm.workflow.core.node.EventNode;
import org.jbpm.workflow.core.node.StartNode;
import org.jbpm.workflow.core.node.SubProcessNode;
import org.jbpm.workflow.core.node.WorkItemNode;

public class ProcessCreatorForHelp {
    public static RuleFlowProcess newSimpleEventProcess(String processId, String eventType) {
        RuleFlowProcess process = new RuleFlowProcess();
        process.setId(processId);
        StartNode startNode = new StartNode();
        startNode.setName("Start");
        startNode.setId(1L);
        EventNode eventNode = new EventNode();
        eventNode.setName("EventNode");
        eventNode.setId(2L);
        eventNode.setScope("external");
        EventTypeFilter eventFilter = new EventTypeFilter();
        eventFilter.setType(eventType);
        eventNode.addEventFilter((EventFilter)eventFilter);
        EndNode endNode = new EndNode();
        endNode.setName("End");
        endNode.setId(3L);
        ProcessCreatorForHelp.connect((org.jbpm.workflow.core.Node)startNode, (org.jbpm.workflow.core.Node)eventNode);
        ProcessCreatorForHelp.connect((org.jbpm.workflow.core.Node)eventNode, (org.jbpm.workflow.core.Node)endNode);
        process.addNode((Node)startNode);
        process.addNode((Node)eventNode);
        process.addNode((Node)endNode);
        return process;
    }

    public static RuleFlowProcess newProcessWithOneVariableAndOneWork(String processId, String variableName, String workName) {
        RuleFlowProcess process = new RuleFlowProcess();
        process.setId(processId);
        ArrayList<Variable> variables = new ArrayList<Variable>();
        Variable variable = new Variable();
        variable.setName(variableName);
        ObjectDataType extendingSerializableDataType = new ObjectDataType();
        extendingSerializableDataType.setClassName(Buddy.class.getName());
        variable.setType((DataType)extendingSerializableDataType);
        variables.add(variable);
        process.getVariableScope().setVariables(variables);
        StartNode startNode = new StartNode();
        startNode.setName("Start");
        startNode.setId(1L);
        WorkItemNode workItemNode = new WorkItemNode();
        workItemNode.setName("workItemNode");
        workItemNode.setId(2L);
        WorkImpl work = new WorkImpl();
        work.setName(workName);
        workItemNode.setWork((Work)work);
        EndNode endNode = new EndNode();
        endNode.setName("EndNode");
        endNode.setId(4L);
        ProcessCreatorForHelp.connect((org.jbpm.workflow.core.Node)startNode, (org.jbpm.workflow.core.Node)workItemNode);
        ProcessCreatorForHelp.connect((org.jbpm.workflow.core.Node)workItemNode, (org.jbpm.workflow.core.Node)endNode);
        process.addNode((Node)startNode);
        process.addNode((Node)workItemNode);
        process.addNode((Node)endNode);
        return process;
    }

    public static RuleFlowProcess newProcessWithOneWork(String processId, String workName) {
        RuleFlowProcess process = new RuleFlowProcess();
        process.setId(processId);
        StartNode startNode = new StartNode();
        startNode.setName("Start");
        startNode.setId(1L);
        WorkItemNode workItemNode = new WorkItemNode();
        workItemNode.setName("workItemNode");
        workItemNode.setId(2L);
        WorkImpl work = new WorkImpl();
        work.setName(workName);
        workItemNode.setWork((Work)work);
        EndNode endNode = new EndNode();
        endNode.setName("EndNode");
        endNode.setId(4L);
        ProcessCreatorForHelp.connect((org.jbpm.workflow.core.Node)startNode, (org.jbpm.workflow.core.Node)workItemNode);
        ProcessCreatorForHelp.connect((org.jbpm.workflow.core.Node)workItemNode, (org.jbpm.workflow.core.Node)endNode);
        process.addNode((Node)startNode);
        process.addNode((Node)workItemNode);
        process.addNode((Node)endNode);
        return process;
    }

    public static RuleFlowProcess newProcessWithOneSubProcess(String processId, String subProcessId) {
        RuleFlowProcess process = new RuleFlowProcess();
        process.setId(processId);
        StartNode startNode = new StartNode();
        startNode.setName("Start");
        startNode.setId(1L);
        SubProcessNode subProcessNode = new SubProcessNode();
        subProcessNode.setId(2L);
        subProcessNode.setProcessId(subProcessId);
        subProcessNode.setName("subProcess");
        EndNode endNode = new EndNode();
        endNode.setName("EndNode");
        endNode.setId(4L);
        ProcessCreatorForHelp.connect((org.jbpm.workflow.core.Node)startNode, (org.jbpm.workflow.core.Node)subProcessNode);
        ProcessCreatorForHelp.connect((org.jbpm.workflow.core.Node)subProcessNode, (org.jbpm.workflow.core.Node)endNode);
        process.addNode((Node)startNode);
        process.addNode((Node)subProcessNode);
        process.addNode((Node)endNode);
        return process;
    }

    public static RuleFlowProcess newShortestProcess(String processId) {
        StartNode startNode = new StartNode();
        startNode.setName("Start");
        startNode.setId(1L);
        EndNode endNode = new EndNode();
        endNode.setName("EndNode");
        endNode.setId(2L);
        ProcessCreatorForHelp.connect((org.jbpm.workflow.core.Node)startNode, (org.jbpm.workflow.core.Node)endNode);
        RuleFlowProcess process = new RuleFlowProcess();
        process.setId(processId);
        process.addNode((Node)startNode);
        process.addNode((Node)endNode);
        return process;
    }

    private static void connect(org.jbpm.workflow.core.Node sourceNode, org.jbpm.workflow.core.Node targetNode) {
        new ConnectionImpl((Node)sourceNode, "DROOLS_DEFAULT", (Node)targetNode, "DROOLS_DEFAULT");
    }
}

