/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.session;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.drools.WorkItemHandlerNotFoundException;
import org.drools.common.AbstractRuleBase;
import org.drools.impl.InternalKnowledgeBase;
import org.drools.persistence.jta.JtaTransactionManager;
import org.drools.process.core.Work;
import org.drools.process.core.datatype.DataType;
import org.drools.process.core.datatype.impl.type.IntegerDataType;
import org.drools.process.core.datatype.impl.type.ObjectDataType;
import org.drools.process.core.datatype.impl.type.StringDataType;
import org.drools.process.core.impl.ParameterDefinitionImpl;
import org.drools.process.core.impl.WorkImpl;
import org.drools.runtime.process.ProcessRuntimeFactory;
import org.drools.runtime.process.ProcessRuntimeFactoryService;
import org.jbpm.persistence.processinstance.ProcessInstanceInfo;
import org.jbpm.persistence.session.objects.Person;
import org.jbpm.persistence.util.PersistenceUtil;
import org.jbpm.process.core.context.variable.Variable;
import org.jbpm.process.instance.ProcessRuntimeFactoryServiceImpl;
import org.jbpm.process.instance.impl.demo.DoNothingWorkItemHandler;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.workflow.core.impl.ConnectionImpl;
import org.jbpm.workflow.core.node.EndNode;
import org.jbpm.workflow.core.node.HumanTaskNode;
import org.jbpm.workflow.core.node.StartNode;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.KieBase;
import org.kie.KnowledgeBase;
import org.kie.KnowledgeBaseFactory;
import org.kie.builder.KnowledgeBuilder;
import org.kie.builder.KnowledgeBuilderFactory;
import org.kie.builder.ResourceType;
import org.kie.definition.process.Node;
import org.kie.definition.process.Process;
import org.kie.io.ResourceFactory;
import org.kie.persistence.jpa.JPAKnowledgeService;
import org.kie.runtime.Environment;
import org.kie.runtime.StatefulKnowledgeSession;
import org.kie.runtime.process.ProcessInstance;
import org.kie.runtime.process.WorkItemHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkItemPersistenceTest {
    private static Logger logger = LoggerFactory.getLogger(WorkItemPersistenceTest.class);
    private HashMap<String, Object> context;
    private EntityManagerFactory emf;

    @Before
    public void setUp() throws Exception {
        this.context = PersistenceUtil.setupWithPoolingDataSource("org.jbpm.persistence.jpa", false);
        this.emf = (EntityManagerFactory)this.context.get("drools.persistence.jpa.EntityManagerFactory");
    }

    @After
    public void tearDown() throws Exception {
        PersistenceUtil.cleanUp(this.context);
    }

    protected StatefulKnowledgeSession createSession(KnowledgeBase kbase) {
        return JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase, null, (Environment)PersistenceUtil.createEnvironment(this.context));
    }

    @Test
    @Ignore
    public void testCancelNonRegisteredWorkItemHandler() {
        String processId = "org.drools.actions";
        String workName = "Unnexistent Task";
        RuleFlowProcess process = this.getWorkItemProcess(processId, workName);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        ((AbstractRuleBase)((InternalKnowledgeBase)kbase).getRuleBase()).addProcess((Process)process);
        StatefulKnowledgeSession ksession = this.createSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler(workName, (WorkItemHandler)new DoNothingWorkItemHandler());
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("UserName", "John Doe");
        parameters.put("Person", new Person("John Doe"));
        ProcessInstance processInstance = ksession.startProcess("org.drools.actions", parameters);
        long processInstanceId = processInstance.getId();
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        ksession.getWorkItemManager().registerWorkItemHandler(workName, null);
        try {
            ksession.abortProcessInstance(processInstanceId);
            Assert.fail((String)("should fail if WorkItemHandler for" + workName + "is not registered"));
        }
        catch (WorkItemHandlerNotFoundException wihnfe) {
            // empty catch block
        }
        Assert.assertEquals((long)3L, (long)processInstance.getState());
    }

    private RuleFlowProcess getWorkItemProcess(String processId, String workName) {
        RuleFlowProcess process = new RuleFlowProcess();
        process.setId(processId);
        ArrayList<Variable> variables = new ArrayList<Variable>();
        Variable variable = new Variable();
        variable.setName("UserName");
        variable.setType((DataType)new StringDataType());
        variables.add(variable);
        variable = new Variable();
        variable.setName("MyObject");
        variable.setType((DataType)new ObjectDataType());
        variables.add(variable);
        variable = new Variable();
        variable.setName("Number");
        variable.setType((DataType)new IntegerDataType());
        variables.add(variable);
        process.getVariableScope().setVariables(variables);
        StartNode startNode = new StartNode();
        startNode.setName("Start");
        startNode.setId(1L);
        HumanTaskNode workItemNode = new HumanTaskNode();
        workItemNode.setName("workItemNode");
        workItemNode.setId(2L);
        workItemNode.addInMapping("Attachment", "MyObject");
        workItemNode.addOutMapping("Result", "MyObject");
        workItemNode.addOutMapping("Result.length()", "Number");
        WorkImpl work = new WorkImpl();
        work.setName(workName);
        HashSet<ParameterDefinitionImpl> parameterDefinitions = new HashSet<ParameterDefinitionImpl>();
        ParameterDefinitionImpl parameterDefinition = new ParameterDefinitionImpl("ActorId", (DataType)new StringDataType());
        parameterDefinitions.add(parameterDefinition);
        parameterDefinition = new ParameterDefinitionImpl("Content", (DataType)new StringDataType());
        parameterDefinitions.add(parameterDefinition);
        parameterDefinition = new ParameterDefinitionImpl("Comment", (DataType)new StringDataType());
        parameterDefinitions.add(parameterDefinition);
        work.setParameterDefinitions(parameterDefinitions);
        work.setParameter("ActorId", (Object)"#{UserName}");
        work.setParameter("Content", (Object)"#{Person.name}");
        workItemNode.setWork((Work)work);
        EndNode endNode = new EndNode();
        endNode.setName("End");
        endNode.setId(3L);
        this.connect((org.jbpm.workflow.core.Node)startNode, (org.jbpm.workflow.core.Node)workItemNode);
        this.connect((org.jbpm.workflow.core.Node)workItemNode, (org.jbpm.workflow.core.Node)endNode);
        process.addNode((Node)startNode);
        process.addNode((Node)workItemNode);
        process.addNode((Node)endNode);
        return process;
    }

    private void connect(org.jbpm.workflow.core.Node sourceNode, org.jbpm.workflow.core.Node targetNode) {
        new ConnectionImpl((Node)sourceNode, "DROOLS_DEFAULT", (Node)targetNode, "DROOLS_DEFAULT");
    }

    @Test
    public void testHumanTask() {
        ArrayList<ProcessInstanceInfo> procInstInfoList = WorkItemPersistenceTest.retrieveProcessInstanceInfo(this.emf);
        int numProcInstInfos = procInstInfoList.size();
        StringReader source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.humantask\" package-name=\"org.drools\" version=\"1\" >\n\n  <header>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <humanTask id=\"2\" name=\"HumanTask\" >\n      <work name=\"Human Task\" >\n        <parameter name=\"ActorId\" >\n          <type name=\"org.drools.process.core.datatype.impl.type.StringDataType\" />\n          <value>John Doe</value>\n        </parameter>\n        <parameter name=\"TaskName\" >\n          <type name=\"org.drools.process.core.datatype.impl.type.StringDataType\" />\n          <value>Do something</value>\n        </parameter>\n        <parameter name=\"Priority\" >\n          <type name=\"org.drools.process.core.datatype.impl.type.StringDataType\" />\n        </parameter>\n        <parameter name=\"Comment\" >\n          <type name=\"org.drools.process.core.datatype.impl.type.StringDataType\" />\n        </parameter>\n      </work>\n    </humanTask>\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n  </connections>\n\n</process>");
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newReaderResource((Reader)source), ResourceType.DRF);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = this.createSession(kbase);
        DoNothingWorkItemHandler handler = new DoNothingWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)handler);
        ProcessInstance processInstance = ksession.startProcess("org.drools.humantask");
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        int state = processInstance.getState();
        switch (state) {
            case 3: {
                logger.debug("STATE_ABORTED");
                break;
            }
            case 1: {
                logger.debug("STATE_ACTIVE");
                break;
            }
            case 2: {
                logger.debug("STATE_COMPLETED");
                break;
            }
            case 0: {
                logger.debug("STATE_PENDING");
                break;
            }
            case 4: {
                logger.debug("STATE_SUSPENDED");
                break;
            }
            default: {
                logger.debug("Unknown state: " + state);
            }
        }
        procInstInfoList = WorkItemPersistenceTest.retrieveProcessInstanceInfo(this.emf);
        Assert.assertTrue((procInstInfoList.size() - numProcInstInfos == 1 ? 1 : 0) != 0);
        ProcessInstanceInfo processInstanceInfoMadeInThisTest = (ProcessInstanceInfo)procInstInfoList.get(numProcInstInfos);
        Assert.assertNotNull((String)"ByteArray of ProcessInstanceInfo from this test is not filled and null!", (Object)processInstanceInfoMadeInThisTest.getProcessInstanceByteArray());
        Assert.assertTrue((String)"ByteArray of ProcessInstanceInfo from this test is not filled and empty!", (processInstanceInfoMadeInThisTest.getProcessInstanceByteArray().length > 0 ? 1 : 0) != 0);
    }

    public static ArrayList<ProcessInstanceInfo> retrieveProcessInstanceInfo(EntityManagerFactory emf) {
        JtaTransactionManager txm = new JtaTransactionManager(null, null, null);
        boolean txOwner = txm.begin();
        EntityManager em = emf.createEntityManager();
        ArrayList<ProcessInstanceInfo> procInstInfoList = new ArrayList<ProcessInstanceInfo>();
        List mdList = em.createQuery("SELECT p FROM ProcessInstanceInfo p").getResultList();
        for (Object resultObject : mdList) {
            ProcessInstanceInfo procInstInfo = (ProcessInstanceInfo)resultObject;
            procInstInfoList.add(procInstInfo);
            logger.trace("> " + procInstInfo);
        }
        txm.commit(txOwner);
        return procInstInfoList;
    }

    static {
        ProcessRuntimeFactory.setProcessRuntimeFactoryService((ProcessRuntimeFactoryService)new ProcessRuntimeFactoryServiceImpl());
    }
}

