/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.map.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.persistence.info.SessionInfo;
import org.drools.persistence.info.WorkItemInfo;
import org.jbpm.persistence.ProcessStorage;
import org.jbpm.persistence.ProcessStorageEnvironmentBuilder;
import org.jbpm.persistence.map.impl.MapPersistenceTest;
import org.jbpm.persistence.processinstance.ProcessInstanceInfo;
import org.junit.Before;
import org.kie.KieBase;
import org.kie.KnowledgeBase;
import org.kie.KnowledgeBaseFactory;
import org.kie.persistence.jpa.JPAKnowledgeService;
import org.kie.runtime.Environment;
import org.kie.runtime.StatefulKnowledgeSession;

public class MapBasedPersistenceTest
extends MapPersistenceTest {
    private SimpleProcessStorage storage;

    @Before
    public void createStorage() {
        this.storage = new SimpleProcessStorage();
    }

    @Override
    protected StatefulKnowledgeSession createSession(KnowledgeBase kbase) {
        ProcessStorageEnvironmentBuilder envBuilder = new ProcessStorageEnvironmentBuilder((ProcessStorage)this.storage);
        Environment env = KnowledgeBaseFactory.newEnvironment();
        env.set("org.kie.transaction.TransactionManager", (Object)envBuilder.getTransactionManager());
        env.set("org.kie.persistence.PersistenceContextManager", (Object)envBuilder.getPersistenceContextManager());
        return JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase, null, (Environment)env);
    }

    @Override
    protected StatefulKnowledgeSession disposeAndReloadSession(StatefulKnowledgeSession ksession, int ksessionId, KnowledgeBase kbase) {
        ksession.dispose();
        ProcessStorageEnvironmentBuilder envBuilder = new ProcessStorageEnvironmentBuilder((ProcessStorage)this.storage);
        Environment env = KnowledgeBaseFactory.newEnvironment();
        env.set("org.kie.transaction.TransactionManager", (Object)envBuilder.getTransactionManager());
        env.set("org.kie.persistence.PersistenceContextManager", (Object)envBuilder.getPersistenceContextManager());
        return JPAKnowledgeService.loadStatefulKnowledgeSession((int)ksessionId, (KieBase)kbase, null, (Environment)env);
    }

    @Override
    protected int getProcessInstancesCount() {
        return this.storage.processes.size();
    }

    @Override
    protected int getKnowledgeSessionsCount() {
        return this.storage.ksessions.size();
    }

    private static class SimpleProcessStorage
    implements ProcessStorage {
        private Map<Integer, SessionInfo> ksessions = new HashMap<Integer, SessionInfo>();
        private Map<Long, ProcessInstanceInfo> processes = new HashMap<Long, ProcessInstanceInfo>();
        private Map<Long, WorkItemInfo> workItems = new HashMap<Long, WorkItemInfo>();

        private SimpleProcessStorage() {
        }

        public void saveOrUpdate(SessionInfo ksessionInfo) {
            ksessionInfo.update();
            this.ksessions.put(ksessionInfo.getId(), ksessionInfo);
        }

        public SessionInfo findSessionInfo(Integer id) {
            return this.ksessions.get(id);
        }

        public ProcessInstanceInfo findProcessInstanceInfo(Long processInstanceId) {
            ProcessInstanceInfo processInstanceInfo = this.processes.get(processInstanceId);
            if (processInstanceInfo != null) {
                processInstanceInfo.clearProcessInstance();
            }
            return processInstanceInfo;
        }

        public void saveOrUpdate(ProcessInstanceInfo processInstanceInfo) {
            processInstanceInfo.update();
            this.processes.put(processInstanceInfo.getId(), processInstanceInfo);
        }

        public long getNextProcessInstanceId() {
            return this.processes.size() + 1;
        }

        public void removeProcessInstanceInfo(Long id) {
            this.processes.remove(id);
        }

        public List<Long> getProcessInstancesWaitingForEvent(String type) {
            ArrayList<Long> processInstancesWaitingForEvent = new ArrayList<Long>();
            for (ProcessInstanceInfo processInstanceInfo : this.processes.values()) {
                if (!processInstanceInfo.getEventTypes().contains(type)) continue;
                processInstancesWaitingForEvent.add(processInstanceInfo.getId());
            }
            return processInstancesWaitingForEvent;
        }

        public void saveOrUpdate(WorkItemInfo workItemInfo) {
            this.workItems.put(workItemInfo.getId(), workItemInfo);
        }

        public Long getNextWorkItemId() {
            return new Long(this.workItems.size() + 1);
        }

        public WorkItemInfo findWorkItemInfo(Long id) {
            return this.workItems.get(id);
        }

        public void remove(WorkItemInfo workItemInfo) {
            this.workItems.remove(workItemInfo.getId());
        }

        public Integer getNextStatefulKnowledgeSessionId() {
            return this.ksessions.size() + 1;
        }
    }
}

