/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.processinstance;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.jbpm.persistence.util.PersistenceUtil;
import org.jbpm.test.util.AbstractBaseTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.ProcessCompletedEvent;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.Environment;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.persistence.jpa.JPAKnowledgeService;
import org.kie.internal.runtime.StatefulKnowledgeSession;

@RunWith(value=Parameterized.class)
public class ParameterMappingTest
extends AbstractBaseTest {
    private HashMap<String, Object> context;
    private static final String PROCESS_ID = "org.jbpm.processinstance.subprocess";
    private static final String SUBPROCESS_ID = "org.jbpm.processinstance.helloworld";
    private StatefulKnowledgeSession ksession;
    private ProcessListener listener;

    public ParameterMappingTest(boolean locking) {
        this.useLocking = locking;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> persistence() {
        Object[][] data = new Object[][]{{false}, {true}};
        return Arrays.asList(data);
    }

    @Before
    public void before() {
        this.context = PersistenceUtil.setupWithPoolingDataSource("org.jbpm.persistence.jpa");
        Environment env = PersistenceUtil.createEnvironment(this.context);
        if (this.useLocking) {
            env.set("org.kie.api.persistence.pessimistic", (Object)true);
        }
        this.ksession = JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)this.createKnowledgeBase(), null, (Environment)env);
        Assert.assertTrue((String)"Valid KnowledgeSession could not be created.", (this.ksession != null && this.ksession.getId() > 0 ? 1 : 0) != 0);
        this.listener = new ProcessListener();
        this.ksession.addEventListener((ProcessEventListener)this.listener);
    }

    private KnowledgeBase createKnowledgeBase() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"processinstance/Subprocess.rf"), ResourceType.DRF);
        kbuilder.add(ResourceFactory.newClassPathResource((String)"processinstance/HelloWorld.rf"), ResourceType.DRF);
        return kbuilder.newKnowledgeBase();
    }

    @After
    public void after() {
        if (this.ksession != null) {
            this.ksession.dispose();
        }
        PersistenceUtil.cleanUp(this.context);
    }

    @Test
    public void testChangingVariableByScript() throws Exception {
        HashMap<String, String> mapping = new HashMap<String, String>();
        mapping.put("type", "script");
        mapping.put("var", "value");
        this.ksession.startProcess(PROCESS_ID, mapping);
        Assert.assertTrue((boolean)this.listener.isProcessStarted(PROCESS_ID));
        Assert.assertTrue((boolean)this.listener.isProcessStarted(SUBPROCESS_ID));
        Assert.assertTrue((boolean)this.listener.isProcessCompleted(SUBPROCESS_ID));
        Assert.assertTrue((boolean)this.listener.isProcessCompleted(PROCESS_ID));
    }

    @Test
    public void testChangingVariableByEvent() throws Exception {
        HashMap<String, String> mapping = new HashMap<String, String>();
        mapping.put("type", "event");
        mapping.put("var", "value");
        this.ksession.startProcess(PROCESS_ID, mapping).getId();
        this.ksession.signalEvent("pass", (Object)"new value");
        Assert.assertTrue((boolean)this.listener.isProcessStarted(PROCESS_ID));
        Assert.assertTrue((boolean)this.listener.isProcessStarted(SUBPROCESS_ID));
        Assert.assertTrue((boolean)this.listener.isProcessCompleted(SUBPROCESS_ID));
        Assert.assertTrue((boolean)this.listener.isProcessCompleted(PROCESS_ID));
    }

    @Test
    public void testChangingVariableByEventSignalWithProcessId() throws Exception {
        HashMap<String, String> mapping = new HashMap<String, String>();
        mapping.put("type", "event");
        mapping.put("var", "value");
        long processId = this.ksession.startProcess(PROCESS_ID, mapping).getId();
        this.ksession.signalEvent("pass", (Object)"new value", processId);
        Assert.assertTrue((boolean)this.listener.isProcessStarted(PROCESS_ID));
        Assert.assertTrue((boolean)this.listener.isProcessStarted(SUBPROCESS_ID));
        Assert.assertTrue((boolean)this.listener.isProcessCompleted(SUBPROCESS_ID));
        Assert.assertTrue((boolean)this.listener.isProcessCompleted(PROCESS_ID));
    }

    @Test
    public void testNotChangingVariable() throws Exception {
        HashMap<String, String> mapping = new HashMap<String, String>();
        mapping.put("type", "default");
        mapping.put("var", "value");
        this.ksession.startProcess(PROCESS_ID, mapping);
        Assert.assertTrue((boolean)this.listener.isProcessStarted(PROCESS_ID));
        Assert.assertTrue((boolean)this.listener.isProcessStarted(SUBPROCESS_ID));
        Assert.assertTrue((boolean)this.listener.isProcessCompleted(SUBPROCESS_ID));
        Assert.assertTrue((boolean)this.listener.isProcessCompleted(PROCESS_ID));
    }

    @Test
    public void testNotSettingVariable() throws Exception {
        HashMap<String, String> mapping = new HashMap<String, String>();
        mapping.put("type", "default");
        this.ksession.startProcess(PROCESS_ID, mapping);
        Assert.assertTrue((boolean)this.listener.isProcessStarted(PROCESS_ID));
        Assert.assertTrue((boolean)this.listener.isProcessStarted(SUBPROCESS_ID));
        Assert.assertTrue((boolean)this.listener.isProcessCompleted(SUBPROCESS_ID));
        Assert.assertTrue((boolean)this.listener.isProcessCompleted(PROCESS_ID));
    }

    public static class ProcessListener
    extends DefaultProcessEventListener {
        private final List<String> processesStarted = new ArrayList<String>();
        private final List<String> processesCompleted = new ArrayList<String>();

        public void afterProcessStarted(ProcessStartedEvent event) {
            this.processesStarted.add(event.getProcessInstance().getProcessId());
        }

        public void afterProcessCompleted(ProcessCompletedEvent event) {
            this.processesCompleted.add(event.getProcessInstance().getProcessId());
        }

        public boolean isProcessStarted(String processId) {
            return this.processesStarted.contains(processId);
        }

        public boolean isProcessCompleted(String processId) {
            return this.processesCompleted.contains(processId);
        }
    }
}

