/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.map.impl;

import org.jbpm.persistence.map.impl.ProcessCreatorForHelp;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.ruleflow.instance.RuleFlowProcessInstance;
import org.jbpm.test.util.AbstractBaseTest;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.definition.process.Process;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public abstract class MapPersistenceTest
extends AbstractBaseTest {
    @Test
    public void startProcessInPersistentEnvironment() {
        String processId = "minimalProcess";
        KieBase kbase = this.createKieBase(new Process[]{ProcessCreatorForHelp.newShortestProcess(processId)});
        StatefulKnowledgeSession crmPersistentSession = this.createSession(kbase);
        crmPersistentSession.startProcess(processId);
        crmPersistentSession.dispose();
    }

    @Test
    public void createProcessStartItDisposeAndLoadItAgain() {
        String processId = "minimalProcess";
        String workName = "MyWork";
        KieBase kbase = this.createKieBase(new Process[]{ProcessCreatorForHelp.newProcessWithOneWork(processId, workName)});
        StatefulKnowledgeSession ksession = this.createSession(kbase);
        long ksessionId = ksession.getIdentifier();
        DummyWorkItemHandler handler = new DummyWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler(workName, (WorkItemHandler)handler);
        long process1Id = ksession.startProcess(processId).getId();
        ksession = this.disposeAndReloadSession(ksession, ksessionId, kbase);
        ksession.getWorkItemManager().registerWorkItemHandler(workName, (WorkItemHandler)handler);
        long workItemId = handler.getLatestWorkItem().getId();
        ksession.getWorkItemManager().completeWorkItem(workItemId, null);
        Assert.assertNotNull((Object)ksession);
        Assert.assertNull((Object)ksession.getProcessInstance(process1Id));
    }

    @Test
    public void signalEventTest() {
        String processId = "signalProcessTest";
        String eventType = "myEvent";
        RuleFlowProcess process = ProcessCreatorForHelp.newSimpleEventProcess(processId, eventType);
        KieBase kbase = this.createKieBase(new Process[]{process});
        StatefulKnowledgeSession crmPersistentSession = this.createSession(kbase);
        RuleFlowProcessInstance processInstance = (RuleFlowProcessInstance)crmPersistentSession.startProcess(processId);
        long processInstanceId = processInstance.getId();
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        crmPersistentSession = this.createSession(kbase);
        crmPersistentSession.signalEvent(eventType, null);
        processInstance = (RuleFlowProcessInstance)crmPersistentSession.getProcessInstance(processInstanceId);
        Assert.assertNull((Object)processInstance);
    }

    @Test
    public void executeMultipleProcessTest() {
        String processId = "minimalProcess";
        String workName = "MyWork";
        KieBase kbase = this.createKieBase(new Process[]{ProcessCreatorForHelp.newProcessWithOneWork(processId, workName)});
        StatefulKnowledgeSession ksession1 = this.createSession(kbase);
        long ksession1Id = ksession1.getIdentifier();
        StatefulKnowledgeSession ksession2 = this.createSession(kbase);
        long ksession2Id = ksession2.getIdentifier();
        DummyWorkItemHandler handler1 = new DummyWorkItemHandler();
        ksession1.getWorkItemManager().registerWorkItemHandler(workName, (WorkItemHandler)handler1);
        DummyWorkItemHandler handler2 = new DummyWorkItemHandler();
        ksession2.getWorkItemManager().registerWorkItemHandler(workName, (WorkItemHandler)handler2);
        long process1Id = ksession1.startProcess(processId).getId();
        long workItem1Id = handler1.getLatestWorkItem().getId();
        ksession1 = this.disposeAndReloadSession(ksession1, ksession1Id, kbase);
        ksession1.getWorkItemManager().completeWorkItem(workItem1Id, null);
        Assert.assertNull((Object)ksession1.getProcessInstance(process1Id));
        ksession2 = this.disposeAndReloadSession(ksession2, ksession2Id, kbase);
        Assert.assertNotNull((Object)ksession2);
        ksession2.getWorkItemManager().registerWorkItemHandler(workName, (WorkItemHandler)handler2);
        long process2Id = ksession2.startProcess(processId).getId();
        long workItem2Id = handler2.getLatestWorkItem().getId();
        ksession2.getWorkItemManager().completeWorkItem(workItem2Id, null);
        Assert.assertNull((Object)ksession2.getProcessInstance(process2Id));
    }

    @Test
    public void multipleKSessionDifferentIdTest() {
        KnowledgeBase kbase1 = KnowledgeBaseFactory.newKnowledgeBase();
        KnowledgeBase kbase2 = KnowledgeBaseFactory.newKnowledgeBase();
        StatefulKnowledgeSession ksession1 = this.createSession((KieBase)kbase1);
        StatefulKnowledgeSession ksession2 = this.createSession((KieBase)kbase2);
        Assert.assertNotSame((Object)ksession1.getIdentifier(), (Object)ksession2.getIdentifier());
    }

    @Test
    public void multipleSessionsWithSameProcessAndDifferentIdTest() {
        String processId = "signalProcessTest";
        String eventType = "myEvent";
        RuleFlowProcess process1 = ProcessCreatorForHelp.newSimpleEventProcess(processId, eventType);
        RuleFlowProcess process2 = ProcessCreatorForHelp.newSimpleEventProcess(processId, eventType);
        KieBase kbase1 = this.createKieBase(new Process[]{process1});
        KieBase kbase2 = this.createKieBase(new Process[]{process2});
        StatefulKnowledgeSession ksession1 = this.createSession(kbase1);
        StatefulKnowledgeSession ksession2 = this.createSession(kbase2);
        Assert.assertNotSame((Object)ksession1.getIdentifier(), (Object)ksession2.getIdentifier());
        Long processInstance1Id = ksession1.startProcess(processId).getId();
        Long processInstance2Id = ksession2.startProcess(processId).getId();
        Assert.assertNotSame((Object)processInstance1Id, (Object)processInstance2Id);
    }

    @Test
    public void multipleSessionsWithSameProcessAndSameWorkItemAndDifferentIdTest() {
        String processId = "minimalProcess";
        String workName = "MyWork";
        KieBase kbase1 = this.createKieBase(new Process[]{ProcessCreatorForHelp.newProcessWithOneWork(processId, workName)});
        KieBase kbase2 = this.createKieBase(new Process[]{ProcessCreatorForHelp.newProcessWithOneWork(processId, workName)});
        StatefulKnowledgeSession ksession1 = this.createSession(kbase1);
        StatefulKnowledgeSession ksession2 = this.createSession(kbase2);
        DummyWorkItemHandler handler1 = new DummyWorkItemHandler();
        DummyWorkItemHandler handler2 = new DummyWorkItemHandler();
        ksession1.getWorkItemManager().registerWorkItemHandler(workName, (WorkItemHandler)handler1);
        ksession2.getWorkItemManager().registerWorkItemHandler(workName, (WorkItemHandler)handler2);
        ksession1.startProcess(processId);
        ksession2.startProcess(processId);
        long workItem1Id = handler1.getLatestWorkItem().getId();
        long workItem2Id = handler2.getLatestWorkItem().getId();
        Assert.assertNotSame((Object)workItem1Id, (Object)workItem2Id);
    }

    @Test
    public void crashProcessBeforePersisting() {
        String processId = "myProcess";
        String workName = "someWork";
        int knowledgeSessionsCountBeforeTest = this.getKnowledgeSessionsCount();
        int processInstancesBeforeTest = this.getProcessInstancesCount();
        KieBase kbase = this.createKieBase(new Process[]{ProcessCreatorForHelp.newProcessWithOneWork(processId, workName)});
        StatefulKnowledgeSession crmPersistentSession = this.createSession(kbase);
        ChrashingWorkItemHandler handler = new ChrashingWorkItemHandler();
        crmPersistentSession.getWorkItemManager().registerWorkItemHandler(workName, (WorkItemHandler)handler);
        try {
            crmPersistentSession.startProcess(processId);
            Assert.fail();
        }
        catch (RuntimeException re) {
            // empty catch block
        }
        Assert.assertEquals((long)(knowledgeSessionsCountBeforeTest + 1), (long)this.getKnowledgeSessionsCount());
        Assert.assertEquals((long)processInstancesBeforeTest, (long)this.getProcessInstancesCount());
    }

    @Test
    public void processWithSubProcessThatCrashTest() {
        String processId = "minimalProcess";
        String subProcessId = "subProcess";
        String workName = "MyWork";
        int knowledgeSessionsCountBeforeTest = this.getKnowledgeSessionsCount();
        int processInstancesBeforeTest = this.getProcessInstancesCount();
        KieBase kbase = this.createKieBase(new Process[]{ProcessCreatorForHelp.newProcessWithOneWork(subProcessId, workName), ProcessCreatorForHelp.newProcessWithOneSubProcess(processId, subProcessId)});
        StatefulKnowledgeSession ksession = this.createSession(kbase);
        ChrashingWorkItemHandler handler = new ChrashingWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler(workName, (WorkItemHandler)handler);
        try {
            ksession.startProcess(processId);
            Assert.fail();
        }
        catch (RuntimeException re) {
            Assert.assertEquals((long)(knowledgeSessionsCountBeforeTest + 1), (long)this.getKnowledgeSessionsCount());
            Assert.assertEquals((long)processInstancesBeforeTest, (long)this.getProcessInstancesCount());
        }
    }

    protected abstract StatefulKnowledgeSession createSession(KieBase var1);

    protected abstract StatefulKnowledgeSession disposeAndReloadSession(StatefulKnowledgeSession var1, long var2, KieBase var4);

    protected abstract int getProcessInstancesCount();

    protected abstract int getKnowledgeSessionsCount();

    private static class ChrashingWorkItemHandler
    implements org.drools.core.process.instance.WorkItemHandler {
        private ChrashingWorkItemHandler() {
        }

        public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
            throw new RuntimeException("I die");
        }

        public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
        }
    }

    private static class DummyWorkItemHandler
    implements org.drools.core.process.instance.WorkItemHandler {
        private WorkItem latestWorkItem;

        private DummyWorkItemHandler() {
        }

        public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
            this.setLatestWorkItem(workItem);
        }

        public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
        }

        public void setLatestWorkItem(WorkItem latestWorkItem) {
            this.latestWorkItem = latestWorkItem;
        }

        public WorkItem getLatestWorkItem() {
            return this.latestWorkItem;
        }
    }
}

